/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.dev.wizard;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.websvc.api.webservices.WsCompileEditorSupport;
import org.netbeans.modules.websvc.core.jaxws.JaxWsUtils;
import org.netbeans.modules.websvc.dev.dd.gen.wscreation.Bean;
import org.netbeans.modules.websvc.dev.wizard.NewWebServiceWizardIterator;
import org.netbeans.modules.websvc.dev.wizard.NoWSPortDefinedException;
import org.netbeans.modules.websvc.dev.wizard.WSGenerationUtil;
import org.netbeans.modules.websvc.dev.wizard.WebServiceGenerator;
import org.netbeans.modules.websvc.dev.wizard.WebServiceWizard;
import org.netbeans.modules.websvc.dev.wizard.WsdlServiceHandler;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceCreator {
    private Project project;
    private String wsName;
    private int serviceType;
    private WizardDescriptor wiz;
    private int projectType;
    protected static final int JSE_PROJECT_TYPE = 0;
    protected static final int WEB_PROJECT_TYPE = 1;
    protected static final int EJB_PROJECT_TYPE = 2;
    private boolean jwsdpSupported = false;
    private boolean jsr109Supported = false;
    private boolean jsr109oldSupported = false;
    private boolean wsitSupported = false;

    public WebServiceCreator(Project project, WizardDescriptor wiz) {
        this.project = project;
        this.wiz = wiz;
    }

    public WebServiceCreator(Project project) {
        this.project = project;
    }

    public void create() {
        this.serviceType = (Integer)this.wiz.getProperty("webServiceType");
        this.initProjectInfo(this.project);
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(WebServiceCreator.class, (String)"TXT_WebServiceGeneration"));
        handle.start(100);
        Runnable r = new Runnable(){

            public void run() {
                try {
                    WebServiceCreator.this.generateWebService(handle);
                }
                catch (Exception e) {
                    handle.finish();
                    String message = e.getLocalizedMessage();
                    if (message != null) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    }
                    ErrorManager.getDefault().notify(4096, (Throwable)e);
                }
            }
        };
        RequestProcessor.getDefault().post(r);
    }

    public void createFromWSDL() {
        this.initProjectInfo(this.project);
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(WebServiceCreator.class, (String)"TXT_WebServiceGeneration"));
        Runnable r = new Runnable(){

            public void run() {
                try {
                    if (Util.isJavaEE5orHigher((Project)WebServiceCreator.this.project) || !WebServiceCreator.this.jsr109Supported && WebServiceCreator.this.projectType == 1 && !WebServiceCreator.this.jsr109oldSupported || WebServiceCreator.this.wsitSupported || WebServiceCreator.this.jwsdpSupported) {
                        handle.start();
                        WebServiceCreator.this.generateWsFromWsdl15(handle);
                    } else {
                        handle.start(100);
                        WebServiceCreator.this.generateWsFromWsdl14(handle);
                    }
                }
                catch (Exception e) {
                    handle.finish();
                    String message = e.getLocalizedMessage();
                    if (message != null) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    }
                    ErrorManager.getDefault().notify(4096, (Throwable)e);
                }
            }
        };
        RequestProcessor.getDefault().post(r);
    }

    private void initProjectInfo(Project project) {
        J2eePlatform j2eePlatform;
        Map properties;
        String serverInstance;
        JAXWSSupport wss = JAXWSSupport.getJAXWSSupport((FileObject)project.getProjectDirectory());
        if (wss != null && (serverInstance = (String)(properties = wss.getAntProjectHelper().getStandardPropertyEvaluator().getProperties()).get("j2ee.server.instance")) != null && (j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstance)) != null) {
            this.jwsdpSupported = j2eePlatform.isToolSupported("jwsdp");
            this.wsitSupported = j2eePlatform.isToolSupported("wsit");
            this.jsr109Supported = j2eePlatform.isToolSupported("jsr109");
            this.jsr109oldSupported = j2eePlatform.isToolSupported("wscompile");
        }
        WebModule wm = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        EjbJar em = EjbJar.getEjbJar((FileObject)project.getProjectDirectory());
        this.projectType = em != null ? 2 : (wm != null ? 1 : 0);
    }

    private FileObject generateJaxWSImplFromTemplate(FileObject pkg) throws Exception {
        DataFolder df = DataFolder.findFolder((FileObject)pkg);
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wiz);
        if (this.projectType == 2) {
            FileObject templateParent = template.getParent();
            template = templateParent.getFileObject("EjbWebService", "java");
        }
        DataObject dTemplate = DataObject.find((FileObject)template);
        DataObject dobj = dTemplate.createFromTemplate(df, this.wsName);
        FileObject createdFile = dobj.getPrimaryFile();
        this.openFileInEditor(dobj);
        return createdFile;
    }

    private void openFileInEditor(DataObject dobj) {
        final EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                ec.open();
            }
        }, 1000);
    }

    private String uniqueWSName(String origName, List<String> names) {
        int uniquifier = 0;
        String truename = origName;
        while (names.contains(truename)) {
            truename = origName + String.valueOf(++uniquifier);
        }
        return truename;
    }

    private String getUniqueJaxwsName(JAXWSSupport jaxWsSupport, String origName) {
        List webServices = jaxWsSupport.getServices();
        ArrayList<String> serviceNames = new ArrayList<String>(webServices.size());
        for (Service service : webServices) {
            serviceNames.add(service.getName());
        }
        return this.uniqueWSName(origName, serviceNames);
    }

    private String getUniqueJaxrpcName(WebServicesSupport wsSupport, String origName) {
        List webServices = wsSupport.getServices();
        ArrayList<String> serviceNames = new ArrayList<String>(webServices.size());
        for (WsCompileEditorSupport.ServiceSettings service : webServices) {
            serviceNames.add(service.getServiceName());
        }
        return this.uniqueWSName(origName, serviceNames);
    }

    private void generateWebService(ProgressHandle handle) throws Exception {
        JAXWSSupport jaxWsSupport;
        FileObject pkg = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        this.wsName = Templates.getTargetName((WizardDescriptor)this.wiz);
        if (this.serviceType == 0) {
            if (this.projectType == 0 && Util.isSourceLevel16orHigher((Project)this.project) || Util.isJavaEE5orHigher((Project)this.project) && (this.projectType == 1 || this.projectType == 2) || this.jwsdpSupported) {
                JAXWSSupport jaxWsSupport2 = JAXWSSupport.getJAXWSSupport((FileObject)this.project.getProjectDirectory());
                this.wsName = this.getUniqueJaxwsName(jaxWsSupport2, this.wsName);
                handle.progress(NbBundle.getMessage(WebServiceCreator.class, (String)"MSG_GEN_WS"), 50);
                FileObject createdFile = this.generateJaxWSImplFromTemplate(pkg);
                handle.finish();
                return;
            }
            if (!Util.isJavaEE5orHigher((Project)this.project) && (this.projectType == 1 || this.projectType == 2) || this.wsitSupported) {
                if (!this.jsr109Supported && this.projectType == 1 && !this.jsr109oldSupported || this.wsitSupported) {
                    jaxWsSupport = JAXWSSupport.getJAXWSSupport((FileObject)this.project.getProjectDirectory());
                    this.wsName = this.getUniqueJaxwsName(jaxWsSupport, this.wsName);
                    handle.progress(NbBundle.getMessage(WebServiceCreator.class, (String)"MSG_GEN_WS"), 50);
                    this.addJaxws20Library(this.project);
                    this.generateJaxWSImplFromTemplate(pkg);
                    handle.finish();
                } else {
                    WebServicesSupport wsSupport = WebServicesSupport.getWebServicesSupport((FileObject)pkg);
                    assert (wsSupport != null);
                    this.wsName = this.getUniqueJaxrpcName(wsSupport, this.wsName);
                    WebServiceGenerator generator = new WebServiceGenerator(wsSupport, this.wsName, pkg, this.project);
                    handle.progress(NbBundle.getMessage(WebServiceCreator.class, (String)"MSG_GEN_SEI_AND_IMPL"), 50);
                    generator.generateWebService();
                    URI targetNS = null;
                    URI typeNS = null;
                    try {
                        targetNS = generator.getTargetNS();
                        typeNS = generator.getDefaultTypeNS(this.wsName);
                    }
                    catch (URISyntaxException e) {
                        String mes = NbBundle.getMessage(WebServiceCreator.class, (String)"MSG_INVALID_URL_SYNTAX");
                        throw new Exception(mes);
                    }
                    handle.progress(NbBundle.getMessage(WebServiceCreator.class, (String)"MSG_CREATING_WSCOMPILE_ARTIFACTS"));
                    String servantClassName = generator.getServantClassName();
                    String seiClassName = generator.getSEIClassName();
                    FileObject configFile = null;
                    configFile = generator.generateConfigFile(seiClassName, servantClassName, targetNS, typeNS);
                    handle.progress(70);
                    wsSupport.addServiceImpl(this.wsName, configFile, false);
                    handle.progress(90);
                    wsSupport.addServiceEntriesToDD(this.wsName, seiClassName, servantClassName);
                    handle.progress(NbBundle.getMessage(NewWebServiceWizardIterator.class, (String)"MSG_ADDING_DD_ENTRIES"));
                    String portTypeName = null;
                    generator.addWebServiceEntry(seiClassName, portTypeName, targetNS);
                    handle.finish();
                    return;
                }
            }
        }
        if (this.serviceType == 1) {
            if (this.projectType == 0 && Util.isSourceLevel16orHigher((Project)this.project) || Util.isJavaEE5orHigher((Project)this.project) && (this.projectType == 1 || this.projectType == 2)) {
                jaxWsSupport = JAXWSSupport.getJAXWSSupport((FileObject)this.project.getProjectDirectory());
                this.wsName = this.getUniqueJaxwsName(jaxWsSupport, this.wsName);
                WebServicesSupport wsSupport = WebServicesSupport.getWebServicesSupport((FileObject)pkg);
                assert (wsSupport != null);
                WebServiceGenerator generator = new WebServiceGenerator(wsSupport, this.wsName, pkg, this.project);
                handle.progress(NbBundle.getMessage(WebServiceCreator.class, (String)"MSG_GEN_SEI_AND_IMPL"), 50);
                Node[] nodes = (Node[])this.wiz.getProperty("delegateToSessionBean");
                generator.generateWebServiceJavaEE5(nodes);
                handle.progress(70);
                String servantClassName = generator.getServantClassName();
                generator.addReferences(servantClassName, nodes);
                jaxWsSupport.addService(this.wsName, servantClassName, this.jsr109Supported);
                handle.finish();
                return;
            }
            if (this.projectType == 1 || this.projectType == 2) {
                WebServicesSupport wsSupport = WebServicesSupport.getWebServicesSupport((FileObject)pkg);
                assert (wsSupport != null);
                this.wsName = this.getUniqueJaxrpcName(wsSupport, this.wsName);
                WebServiceGenerator generator = new WebServiceGenerator(wsSupport, this.wsName, pkg, this.project);
                handle.progress(NbBundle.getMessage(WebServiceCreator.class, (String)"MSG_GEN_SEI_AND_IMPL"), 50);
                Node[] nodes = (Node[])this.wiz.getProperty("delegateToSessionBean");
                generator.generateWebService(nodes);
                URI targetNS = null;
                URI typeNS = null;
                try {
                    targetNS = generator.getTargetNS();
                    typeNS = generator.getDefaultTypeNS(this.wsName);
                }
                catch (URISyntaxException e) {
                    String mes = NbBundle.getMessage(WebServiceCreator.class, (String)"MSG_INVALID_URL_SYNTAX");
                    throw new Exception(mes);
                }
                handle.progress(NbBundle.getMessage(WebServiceCreator.class, (String)"MSG_CREATING_WSCOMPILE_ARTIFACTS"));
                String servantClassName = generator.getServantClassName();
                String seiClassName = generator.getSEIClassName();
                FileObject configFile = null;
                configFile = generator.generateConfigFile(seiClassName, servantClassName, targetNS, typeNS);
                handle.progress(70);
                wsSupport.addServiceImpl(this.wsName, configFile, false);
                handle.progress(90);
                wsSupport.addServiceEntriesToDD(this.wsName, seiClassName, servantClassName);
                handle.progress(NbBundle.getMessage(NewWebServiceWizardIterator.class, (String)"MSG_ADDING_DD_ENTRIES"));
                String portTypeName = null;
                generator.addWebServiceEntry(seiClassName, portTypeName, targetNS);
                generator.addReferences(servantClassName, nodes);
                handle.finish();
            }
            return;
        }
    }

    private void addJaxws20Library(Project project) throws Exception {
        SourceGroup[] sgs = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        ClassPath classPath = ClassPath.getClassPath((FileObject)sgs[0].getRootFolder(), (String)"classpath/compile");
        FileObject wsimportFO = classPath.findResource("com/sun/tools/ws/ant/WsImport.class");
        if (wsimportFO != null) {
            return;
        }
        ProjectClassPathExtender pce = (ProjectClassPathExtender)project.getLookup().lookup(ProjectClassPathExtender.class);
        Library jaxws20_ext = LibraryManager.getDefault().getLibrary("jaxws20");
        if (pce != null && jaxws20_ext != null) {
            try {
                pce.addLibrary(jaxws20_ext);
            }
            catch (IOException e) {
                throw new Exception("Unable to add JAXWS 2.0 Library. " + e.getMessage());
            }
        } else {
            throw new Exception("Unable to add JAXWS 2.0 Library. ProjectClassPathExtender or library not found");
        }
    }

    private void generateWsFromWsdl14(ProgressHandle handle) throws Exception {
        FileObject pkg = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        this.wsName = Templates.getTargetName((WizardDescriptor)this.wiz);
        WebServicesSupport wsSupport = WebServicesSupport.getWebServicesSupport((FileObject)pkg);
        assert (wsSupport != null);
        WebServiceGenerator generator = new WebServiceGenerator(wsSupport, this.wsName, pkg, this.project);
        FileObject wsDDFolder = wsSupport.getWsDDFolder();
        FileObject wsdlFolder = wsDDFolder.getFileObject("wsdl");
        if (wsdlFolder == null) {
            wsdlFolder = wsDDFolder.createFolder("wsdl");
        }
        handle.progress(NbBundle.getMessage(WebServiceWizard.class, (String)"MSG_PARSING_WSDL"), 30);
        String wsdlFilePath = (String)this.wiz.getProperty("wsdlFilePath");
        File normalizedWsdlFilePath = FileUtil.normalizeFile((File)new File(wsdlFilePath));
        FileObject sourceWsdlFile = FileUtil.toFileObject((File)normalizedWsdlFilePath);
        if (sourceWsdlFile == null) {
            String mes = NbBundle.getMessage(WebServiceWizard.class, (String)"MSG_CANNOT_GET_FILE_OBJECT", (Object)normalizedWsdlFilePath.getAbsolutePath());
            throw new IOException(mes);
        }
        List schemaFiles = WSGenerationUtil.getSchemaNames(sourceWsdlFile, true);
        String changedWsName = null;
        try {
            changedWsName = generator.parseWSDL(sourceWsdlFile.getInputStream());
        }
        catch (NoWSPortDefinedException exc) {
            ErrorManager.getDefault().log(1, "WSDL does not contain any defined ports");
            String mes = NbBundle.getMessage(WebServiceGenerator.class, (String)"ERR_WsdlNoPortDefined");
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            handle.finish();
            return;
        }
        if (changedWsName == null) {
            changedWsName = this.wsName;
        }
        handle.progress(NbBundle.getMessage(WebServiceWizard.class, (String)"MSG_CREATING_NEW_WSDL"), 50);
        FileObject wsdlFO = generator.generateWSDL("/org/netbeans/modules/websvc/dev/wizard/xsl/WSDL.xml", changedWsName, generator.getSoapBinding(), generator.getPortTypeName(), wsdlFolder, sourceWsdlFile.getParent(), this.wsName, new StreamSource(sourceWsdlFile.getInputStream()));
        URI targetNS = null;
        URI typeNS = null;
        try {
            targetNS = generator.getTargetNS();
            typeNS = generator.getDefaultTypeNS(this.wsName);
        }
        catch (URISyntaxException e) {
            String mes = NbBundle.getMessage(WebServiceWizard.class, (String)"MSG_INVALID_URL_SYNTAX");
            throw new Exception(mes);
        }
        handle.progress(NbBundle.getMessage(WebServiceWizard.class, (String)"MSG_CREATING_WSCOMPILE_ARTIFACTS"));
        String servantClassName = generator.getServantClassName();
        String seiClassName = generator.getSEIClassName();
        FileObject configFile = null;
        File wsdlFile = FileUtil.toFile((FileObject)wsdlFO);
        URI wsdlURI = wsdlFile.toURI();
        configFile = generator.generateConfigFile(wsdlURI);
        handle.progress(70);
        wsSupport.addServiceImpl(this.wsName, configFile, true, generator.getWscompileFeatures());
        handle.progress(NbBundle.getMessage(WebServiceWizard.class, (String)"MSG_RUNNING_WSCOMPILE_TARGET"));
        String targetName = this.wsName + "_wscompile";
        ExecutorTask task = ActionUtils.runTarget((FileObject)this.findBuildXml(), (String[])new String[]{targetName}, null);
        task.waitFinished();
        if (task.result() != 0) {
            String mes = NbBundle.getMessage(WebServiceWizard.class, (String)"MSG_WSCOMPILE_UNSUCCESSFUL");
            wsSupport.removeProjectEntries(this.wsName);
            try {
                this.deleteFile(configFile);
                this.deleteFile(wsdlFO);
            }
            catch (IOException e) {
                String message = NbBundle.getMessage(WebServiceWizard.class, (String)"MSG_UNABLE_DELETE_FILES");
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            }
            throw new Exception(mes);
        }
        handle.progress(90);
        this.addHeaderComments(this.wsName, servantClassName, pkg);
        wsSupport.addInfrastructure(servantClassName, pkg);
        String implClassName = servantClassName.substring(servantClassName.lastIndexOf(".") + 1);
        FileObject clz = pkg.getFileObject(implClassName, "java");
        DataObject dobj = DataObject.find((FileObject)clz);
        EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
        ec.open();
        wsSupport.addServiceEntriesToDD(this.wsName, seiClassName, servantClassName);
        handle.progress(NbBundle.getMessage(WebServiceWizard.class, (String)"MSG_ADDING_DD_ENTRIES"));
        String portTypeName = null;
        portTypeName = generator.getPortTypeName();
        generator.addWebServiceEntry(seiClassName, portTypeName, targetNS);
        handle.finish();
    }

    private void generateWsFromWsdl15(final ProgressHandle handle) throws Exception {
        String wsdlFilePath = (String)this.wiz.getProperty("wsdlFilePath");
        File normalizedWsdlFilePath = FileUtil.normalizeFile((File)new File(wsdlFilePath));
        final URL wsdlURL = normalizedWsdlFilePath.toURI().toURL();
        final WsdlService service = (WsdlService)this.wiz.getProperty("wsdlService");
        if (service == null) {
            JAXWSSupport jaxWsSupport = JAXWSSupport.getJAXWSSupport((FileObject)this.project.getProjectDirectory());
            FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)this.wiz);
            String targetName = Templates.getTargetName((WizardDescriptor)this.wiz);
            WsdlServiceHandler handler = (WsdlServiceHandler)this.wiz.getProperty("wsdlServiceHandler");
            JaxWsUtils.generateJaxWsArtifacts((Project)this.project, (FileObject)targetFolder, (String)targetName, (URL)wsdlURL, (String)handler.getServiceName(), (String)handler.getPortName());
            WsdlModeler wsdlModeler = (WsdlModeler)this.wiz.getProperty("wsdlModeler");
            if (wsdlModeler != null && wsdlModeler.getCreationException() != null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebServiceCreator.class, (String)"TXT_CannotGenerateArtifacts", (Object)wsdlModeler.getCreationException().getLocalizedMessage()), 0));
            }
            handle.finish();
        } else {
            final WsdlPort port = (WsdlPort)this.wiz.getProperty("wsdlPort");
            WsdlModeler wsdlModeler = (WsdlModeler)this.wiz.getProperty("wsdlModeler");
            wsdlModeler.generateWsdlModel(new WsdlModelListener(){

                public void modelCreated(WsdlModel model) {
                    WsdlService service1 = model.getServiceByName(service.getName());
                    WsdlPort port1 = service1.getPortByName(port.getName());
                    port1.setSOAPVersion(port.getSOAPVersion());
                    FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)WebServiceCreator.this.wiz);
                    String targetName = Templates.getTargetName((WizardDescriptor)WebServiceCreator.this.wiz);
                    try {
                        JaxWsUtils.generateJaxWsImplementationClass((Project)WebServiceCreator.this.project, (FileObject)targetFolder, (String)targetName, (URL)wsdlURL, (WsdlService)service1, (WsdlPort)port1);
                        handle.finish();
                    }
                    catch (Exception ex) {
                        handle.finish();
                        ErrorManager.getDefault().notify(4096, (Throwable)ex);
                    }
                }
            });
        }
    }

    private void addHeaderComments(String wsName, String servantClassName, FileObject pkg) {
        String comment = NbBundle.getMessage(NewWebServiceWizardIterator.class, (String)"MSG_WS_CLASS_COMMENT", (Object)wsName);
        StringBuffer buffer = new StringBuffer(comment + "\n");
        buffer.append(NbBundle.getMessage(NewWebServiceWizardIterator.class, (String)"MSG_CREATED_COMMENT") + " " + DateFormat.getDateTimeInstance().format(new Date()) + "\n");
        buffer.append("@author " + System.getProperty("user.name"));
        JavaMetamodel.getManager().waitScanFinished();
        JavaClass clazz = JMIUtils.findClass((String)servantClassName);
        if (clazz != null) {
            String javadoc = clazz.getJavadocText();
            clazz.setJavadocText(buffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFile(FileObject file) throws IOException {
        FileLock lock = null;
        try {
            lock = file.lock();
            file.delete(lock);
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }

    private FileObject findBuildXml() {
        return this.project.getProjectDirectory().getFileObject("build.xml");
    }

    public void createMessageHandler() throws IOException {
        this.initProjectInfo(this.project);
        SourceGroup[] sgs = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        ClassPath classPath = ClassPath.getClassPath((FileObject)sgs[0].getRootFolder(), (String)"classpath/compile");
        FileObject wsimportFO = classPath.findResource("com/sun/tools/ws/ant/WsImport.class");
        if (this.projectType == 0 && Util.isSourceLevel16orHigher((Project)this.project) || this.projectType == 0 && Util.getSourceLevel((Project)this.project).equals("1.5") && wsimportFO != null || Util.isJavaEE5orHigher((Project)this.project) && (this.projectType == 1 || this.projectType == 2) || this.jwsdpSupported || !this.jsr109Supported && this.projectType == 1 && !this.jsr109oldSupported || this.wsitSupported) {
            String handlerName = Templates.getTargetName((WizardDescriptor)this.wiz);
            FileObject pkg = Templates.getTargetFolder((WizardDescriptor)this.wiz);
            DataFolder df = DataFolder.findFolder((FileObject)pkg);
            FileObject template = Templates.getTemplate((WizardDescriptor)this.wiz);
            DataObject dTemplate = DataObject.find((FileObject)template);
            DataObject dobj = dTemplate.createFromTemplate(df, handlerName);
            final EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    ec.open();
                }
            }, 1000);
        } else {
            WSGenerationUtil wsgenUtil = new WSGenerationUtil();
            String HANDLER_TEMPLATE = "/org/netbeans/modules/websvc/dev/wizard/xsl/MessageHandler.xml";
            FileObject pkg = Templates.getTargetFolder((WizardDescriptor)this.wiz);
            String handlerName = Templates.getTargetName((WizardDescriptor)this.wiz);
            String pkgName = WSGenerationUtil.getSelectedPackageName(pkg, this.project);
            Bean b = wsgenUtil.getDefaultBean();
            b.setCommentDataWsName(handlerName);
            b.setClassname(true);
            b.setClassnameName(handlerName);
            if (pkgName != null) {
                b.setClassnamePackage(pkgName);
            }
            String handlerClass = wsgenUtil.getFullClassName(pkgName, wsgenUtil.generateClass("/org/netbeans/modules/websvc/dev/wizard/xsl/MessageHandler.xml", b, pkg, true));
        }
    }

    public void createLogicalHandler() throws IOException {
        this.initProjectInfo(this.project);
        SourceGroup[] sgs = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        ClassPath classPath = ClassPath.getClassPath((FileObject)sgs[0].getRootFolder(), (String)"classpath/compile");
        FileObject wsimportFO = classPath.findResource("com/sun/tools/ws/ant/WsImport.class");
        if (this.projectType == 0 && Util.isSourceLevel16orHigher((Project)this.project) || this.projectType == 0 && Util.getSourceLevel((Project)this.project).equals("1.5") && wsimportFO != null || Util.isJavaEE5orHigher((Project)this.project) && (this.projectType == 1 || this.projectType == 2) || this.jwsdpSupported || !this.jsr109Supported && this.projectType == 1 && !this.jsr109oldSupported || this.wsitSupported) {
            String handlerName = Templates.getTargetName((WizardDescriptor)this.wiz);
            FileObject pkg = Templates.getTargetFolder((WizardDescriptor)this.wiz);
            DataFolder df = DataFolder.findFolder((FileObject)pkg);
            FileObject template = Templates.getTemplate((WizardDescriptor)this.wiz);
            DataObject dTemplate = DataObject.find((FileObject)template);
            DataObject dobj = dTemplate.createFromTemplate(df, handlerName);
            final EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    ec.open();
                }
            }, 1000);
        }
    }

    public int getProjectType() {
        this.initProjectInfo(this.project);
        return this.projectType;
    }
}

