/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.dev.wizard;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WsdlServiceHandler
extends DefaultHandler {
    public static final String WSDL_SOAP_URI = "http://schemas.xmlsoap.org/wsdl/";
    private boolean insideService;
    private String serviceName;
    private String portName;

    public static WsdlServiceHandler parse(String wsdlUrl) throws ParserConfigurationException, SAXException, IOException {
        WsdlServiceHandler handler = new WsdlServiceHandler();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(wsdlUrl, (DefaultHandler)handler);
        return handler;
    }

    private WsdlServiceHandler() {
    }

    public void startElement(String uri, String localName, String qname, Attributes attributes) throws SAXException {
        if (WSDL_SOAP_URI.equals(uri) && "service".equals(localName)) {
            this.insideService = true;
            if (this.serviceName == null) {
                this.serviceName = attributes.getValue("name");
            }
        } else if ("port".equals(localName) && this.insideService && this.portName == null) {
            this.portName = attributes.getValue("name");
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (WSDL_SOAP_URI.equals(uri) && "service".equals(localName)) {
            this.insideService = false;
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getPortName() {
        return this.portName;
    }
}

