/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.j2seproject.ui.FoldersListSettings;
import org.netbeans.modules.java.j2seproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.java.j2seproject.ui.wizards.PanelProjectLocationVisual;
import org.netbeans.modules.java.j2seproject.ui.wizards.PanelSourceFolders;
import org.netbeans.modules.java.j2seproject.ui.wizards.SettingsPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class PanelProjectLocationExtSrc
extends SettingsPanel {
    private PanelConfigureProject firer;
    private WizardDescriptor wizardDescriptor;
    private boolean calculatePF;
    private JButton jButton3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField projectLocation;
    private JTextField projectName;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PanelProjectLocationExtSrc(PanelConfigureProject panel) {
        this.firer = panel;
        this.initComponents();
        this.projectName.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.calculateProjectFolder();
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.calculateProjectFolder();
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.calculateProjectFolder();
                PanelProjectLocationExtSrc.this.dataChanged();
            }
        });
        this.projectLocation.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.setCalculateProjectFolder(false);
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.setCalculateProjectFolder(false);
                PanelProjectLocationExtSrc.this.dataChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                PanelProjectLocationExtSrc.this.setCalculateProjectFolder(false);
                PanelProjectLocationExtSrc.this.dataChanged();
            }
        });
    }

    private synchronized void calculateProjectFolder() {
        if (this.calculatePF) {
            File f = ProjectChooser.getProjectsFolder();
            this.projectLocation.setText(f.getAbsolutePath() + File.separator + this.projectName.getText());
            this.calculatePF = true;
        }
    }

    private synchronized void setCalculateProjectFolder(boolean value) {
        this.calculatePF = value;
    }

    private void dataChanged() {
        this.firer.fireChangeEvent();
    }

    void read(WizardDescriptor settings) {
        this.wizardDescriptor = settings;
        Object path = null;
        String projectName = null;
        File projectLocation = (File)settings.getProperty("projdir");
        if (projectLocation == null) {
            File file;
            projectLocation = ProjectChooser.getProjectsFolder();
            int index = FoldersListSettings.getDefault().getNewProjectCount();
            String formater = NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"TXT_JavaProject");
            while ((file = new File(projectLocation, projectName = MessageFormat.format(formater, new Integer(++index)))).exists()) {
            }
            settings.putProperty("nameIndex", (Object)new Integer(index));
            this.projectLocation.setText(projectLocation.getAbsolutePath());
            this.setCalculateProjectFolder(true);
        } else {
            projectName = (String)settings.getProperty("name");
            boolean tmpFlag = this.calculatePF;
            this.projectLocation.setText(projectLocation.getAbsolutePath());
            this.setCalculateProjectFolder(tmpFlag);
        }
        this.projectName.setText(projectName);
        this.projectName.selectAll();
    }

    void store(WizardDescriptor settings) {
        settings.putProperty("name", (Object)this.projectName.getText());
        File projectsDir = new File(this.projectLocation.getText());
        settings.putProperty("projdir", (Object)projectsDir);
    }

    boolean valid(WizardDescriptor settings) {
        String result = PanelProjectLocationExtSrc.checkValidity(this.projectName.getText(), this.projectLocation.getText());
        if (result == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
            return true;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)result);
        return false;
    }

    static String checkValidity(String projectName, String projectLocation) {
        if (projectName.length() == 0 || projectName.indexOf(47) > 0 || projectName.indexOf(92) > 0 || projectName.indexOf(58) > 0) {
            return NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MSG_IllegalProjectName");
        }
        File projLoc = new File(projectLocation).getAbsoluteFile();
        if (PanelProjectLocationVisual.getCanonicalFile(projLoc) == null) {
            return NbBundle.getMessage((Class)PanelProjectLocationVisual.class, (String)"MSG_IllegalProjectLocation");
        }
        while (projLoc != null && !projLoc.exists()) {
            projLoc = projLoc.getParentFile();
        }
        if (projLoc == null || !projLoc.canWrite()) {
            return NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MSG_ProjectFolderReadOnly");
        }
        File destFolder = FileUtil.normalizeFile((File)new File(projectLocation));
        File[] kids = destFolder.listFiles();
        if (destFolder.exists() && kids != null && kids.length > 0) {
            String file = null;
            for (int i = 0; i < kids.length; ++i) {
                String childName = kids[i].getName();
                if ("nbproject".equals(childName)) {
                    file = NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$ui$wizards$PanelSourceFolders == null ? PanelProjectLocationExtSrc.class$("org.netbeans.modules.java.j2seproject.ui.wizards.PanelSourceFolders") : class$org$netbeans$modules$java$j2seproject$ui$wizards$PanelSourceFolders), (String)"TXT_NetBeansProject");
                } else if ("build".equals(childName)) {
                    file = NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$ui$wizards$PanelSourceFolders == null ? PanelProjectLocationExtSrc.class$("org.netbeans.modules.java.j2seproject.ui.wizards.PanelSourceFolders") : class$org$netbeans$modules$java$j2seproject$ui$wizards$PanelSourceFolders), (String)"TXT_BuildFolder");
                } else if ("dist".equals(childName)) {
                    file = NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$ui$wizards$PanelSourceFolders == null ? PanelProjectLocationExtSrc.class$("org.netbeans.modules.java.j2seproject.ui.wizards.PanelSourceFolders") : class$org$netbeans$modules$java$j2seproject$ui$wizards$PanelSourceFolders), (String)"TXT_DistFolder");
                } else if ("build.xml".equals(childName)) {
                    file = NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$ui$wizards$PanelSourceFolders == null ? PanelProjectLocationExtSrc.class$("org.netbeans.modules.java.j2seproject.ui.wizards.PanelSourceFolders") : class$org$netbeans$modules$java$j2seproject$ui$wizards$PanelSourceFolders), (String)"TXT_BuildXML");
                } else if ("manifest.mf".equals(childName)) {
                    file = NbBundle.getMessage((Class)(class$org$netbeans$modules$java$j2seproject$ui$wizards$PanelSourceFolders == null ? PanelProjectLocationExtSrc.class$("org.netbeans.modules.java.j2seproject.ui.wizards.PanelSourceFolders") : class$org$netbeans$modules$java$j2seproject$ui$wizards$PanelSourceFolders), (String)"TXT_Manifest");
                }
                if (file == null) continue;
                String format = NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MSG_ProjectFolderInvalid");
                return MessageFormat.format(format, file);
            }
        }
        if (destFolder.isDirectory()) {
            FileObject destFO = FileUtil.toFileObject((File)destFolder);
            if (!$assertionsDisabled && destFO == null) {
                throw new AssertionError((Object)("No FileObject for " + destFolder));
            }
            boolean clear = false;
            try {
                clear = ProjectManager.getDefault().findProject(destFO) == null;
            }
            catch (IOException e) {
                // empty catch block
            }
            if (!clear) {
                return NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"MSG_ProjectFolderHasDeletedProject");
            }
        }
        return null;
    }

    void validate(WizardDescriptor settings) throws WizardValidationException {
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.projectName = new JTextField();
        this.jLabel6 = new JLabel();
        this.projectLocation = new JTextField();
        this.jButton3 = new JButton();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"ACSN_PanelSourceFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"ACSD_PanelSourceFolders"));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel4.setLabelFor(this.jPanel2);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"LBL_ProjectNameAndLocationLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel4.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"ACSN_jLabel4"));
        this.jLabel4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"ACSD_jLabel4"));
        this.jLabel5.setLabelFor(this.projectName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"LBL_NWP1_ProjectName_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel5.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"ACSN_projectNameLabel"));
        this.jLabel5.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"ACSD_projectNameLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.jPanel2.add((Component)this.projectName, gridBagConstraints);
        this.jLabel6.setDisplayedMnemonic(NbBundle.getBundle((Class)PanelProjectLocationExtSrc.class).getString("LBL_NWP1_CreatedProjectFolder_LablelMnemonic").charAt(0));
        this.jLabel6.setLabelFor(this.projectLocation);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"LBL_NWP1_CreatedProjectFolder_Lablel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel2.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel6.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"ACSN_projectLocationLabel"));
        this.jLabel6.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"ACSD_projectLocationLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.jPanel2.add((Component)this.projectLocation, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton3, (String)NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"LBL_NWP1_BrowseLocation_Button3"));
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PanelProjectLocationExtSrc.this.browseProjectLocation(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.jPanel2.add((Component)this.jButton3, gridBagConstraints);
        this.jButton3.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"ACSN_browseButton"));
        this.jButton3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"ACSD_browseButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"ACSN_jPanel1"));
        this.jPanel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)PanelProjectLocationExtSrc.class, (String)"ACSD_jPanel1"));
    }

    private void browseProjectLocation(ActionEvent evt) {
        File file;
        File f;
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setDialogTitle(NbBundle.getMessage((Class)PanelSourceFolders.class, (String)"LBL_NWP1_SelectProjectLocation"));
        chooser.setFileSelectionMode(1);
        String path = this.projectLocation.getText();
        if (path.length() > 0 && (f = new File(path)).exists()) {
            chooser.setSelectedFile(f);
        }
        if (chooser.showOpenDialog(this) == 0 && (file = chooser.getSelectedFile()) != null) {
            this.projectLocation.setText(FileUtil.normalizeFile((File)file).getAbsolutePath());
        }
    }

    static {
        $assertionsDisabled = !PanelProjectLocationExtSrc.class.desiredAssertionStatus();
    }
}

