/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.management;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.HashSet;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.netbeans.modules.j2ee.sun.bridge.AppServerBridge;
import org.netbeans.modules.j2ee.sun.ide.j2ee.mbmapping.Constants;

public class UtilMEJB
implements Constants {
    private MBeanServerConnection conn = null;

    public UtilMEJB(String host, int port, String username, String password, boolean secure) throws RemoteException {
        ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.conn = AppServerBridge.getJMXConnector(host, port, username, password, secure);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex.getCause());
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
    }

    protected MBeanServerConnection getConnection() {
        return this.conn;
    }

    protected AttributeList updateGetAttributes(ObjectName objName, String[] attributes) {
        AttributeList attList = null;
        try {
            String isResource = objName.getKeyProperty("type");
            HashSet<String> configMods = new HashSet<String>(Arrays.asList(CONFIG_MODULE));
            if (isResource != null && !configMods.contains(isResource)) {
                attList = this.conn.getAttributes(objName, attributes);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return attList;
    }

    protected Object updateGetAttribute(ObjectName objName, String attribute) {
        Object attr = null;
        try {
            String type;
            String isResource = objName.getKeyProperty("type");
            HashSet<String> configMods = new HashSet<String>(Arrays.asList(CONFIG_MODULE));
            if (isResource != null && !configMods.contains(isResource)) {
                attr = this.conn.getAttribute(objName, attribute);
            }
            if ((type = objName.getKeyProperty("j2eeType")).equals("J2EEServer")) {
                attr = this.conn.getAttribute(objName, attribute);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return attr;
    }

    protected Object updateInvoke(ObjectName objName, String operationName, Object[] params, String[] signature) throws RemoteException {
        if (objName.toString().equals("com.sun.appserv:type=resources,category=config")) {
            return this.invokeServerForResource(objName, operationName, params, signature);
        }
        return this.invokeServer(objName, operationName, params, signature);
    }

    private Object invokeServer(ObjectName objName, String operationName, Object[] params, String[] signature) throws RemoteException {
        Object retVal = null;
        try {
            retVal = this.conn.invoke(objName, operationName, params, signature);
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex.getCause());
        }
        return retVal;
    }

    private Object invokeServerForResource(ObjectName objName, String operationName, Object[] params, String[] signature) throws RemoteException {
        Object retVal = null;
        try {
            if (operationName.equals("setProperty")) {
                this.conn.invoke(objName, operationName, params, signature);
            } else {
                retVal = this.conn.invoke(objName, operationName, params, signature);
            }
        }
        catch (Exception ex) {
            throw new RemoteException(ex.getMessage(), ex.getCause());
        }
        return retVal;
    }

    protected MBeanInfo updateMBeanInfo(ObjectName objName) {
        MBeanInfo bnInfo = null;
        try {
            String isResource = objName.getKeyProperty("type");
            HashSet<String> configMods = new HashSet<String>(Arrays.asList(CONFIG_MODULE));
            if (isResource != null && !configMods.contains(isResource)) {
                bnInfo = this.conn.getMBeanInfo(objName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bnInfo;
    }

    protected void updateSetAttribute(ObjectName objName, Attribute attribute) throws RemoteException, InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            String isResource = objName.getKeyProperty("type");
            HashSet<String> configMods = new HashSet<String>(Arrays.asList(CONFIG_MODULE));
            if (isResource != null && !configMods.contains(isResource)) {
                this.conn.setAttribute(objName, attribute);
            }
        }
        catch (IOException ex) {
            throw new RemoteException(ex.getLocalizedMessage(), ex.getCause());
        }
    }
}

