/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.queries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.queries.VisibilityQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public final class VisibilityQuery {
    private static final VisibilityQuery INSTANCE = new VisibilityQuery();
    private static final Lookup.Template TEMPLATE = new Lookup.Template(VisibilityQueryImplementation.class);
    private final ResultListener resultListener = new ResultListener();
    private final VqiChangedListener vqiListener = new VqiChangedListener();
    private final List listeners = Collections.synchronizedList(new ArrayList());
    private Lookup.Result vqiResult = null;
    private Set cachedVqiInstances = null;

    public static final VisibilityQuery getDefault() {
        return INSTANCE;
    }

    private VisibilityQuery() {
    }

    public boolean isVisible(FileObject file) {
        boolean retVal = true;
        Set vqiInstances = this.getVqiInstances();
        Iterator iterator = vqiInstances.iterator();
        while (retVal && iterator.hasNext()) {
            VisibilityQueryImplementation vqi = (VisibilityQueryImplementation)iterator.next();
            retVal = vqi.isVisible(file);
        }
        return retVal;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ChangeListener[] _listeners;
        List list = this.listeners;
        synchronized (list) {
            if (this.listeners.isEmpty()) {
                return;
            }
            _listeners = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        }
        ChangeEvent ev = new ChangeEvent(this);
        for (int i = 0; i < _listeners.length; ++i) {
            _listeners[i].stateChanged(ev);
        }
    }

    private synchronized Set getVqiInstances() {
        if (this.cachedVqiInstances == null) {
            this.vqiResult = Lookup.getDefault().lookup(TEMPLATE);
            this.vqiResult.addLookupListener((LookupListener)this.resultListener);
            this.setupChangeListeners(this.cachedVqiInstances, new LinkedHashSet(this.vqiResult.allInstances()));
        }
        return this.cachedVqiInstances;
    }

    private synchronized void setupChangeListeners(Set oldVqiInstances, Set newVqiInstances) {
        VisibilityQueryImplementation vqi;
        Iterator iterator;
        if (oldVqiInstances != null) {
            HashSet removed = new HashSet(oldVqiInstances);
            removed.removeAll(newVqiInstances);
            iterator = removed.iterator();
            while (iterator.hasNext()) {
                vqi = (VisibilityQueryImplementation)iterator.next();
                vqi.removeChangeListener(this.vqiListener);
            }
        }
        HashSet added = new HashSet(newVqiInstances);
        if (oldVqiInstances != null) {
            added.removeAll(oldVqiInstances);
        }
        iterator = added.iterator();
        while (iterator.hasNext()) {
            vqi = (VisibilityQueryImplementation)iterator.next();
            vqi.addChangeListener(this.vqiListener);
        }
        this.cachedVqiInstances = newVqiInstances;
    }

    private class VqiChangedListener
    implements ChangeListener {
        private VqiChangedListener() {
        }

        public void stateChanged(ChangeEvent e) {
            VisibilityQuery.this.fireChange();
        }
    }

    private class ResultListener
    implements LookupListener {
        private ResultListener() {
        }

        public void resultChanged(LookupEvent ev) {
            VisibilityQuery.this.setupChangeListeners(VisibilityQuery.this.cachedVqiInstances, new LinkedHashSet(VisibilityQuery.this.vqiResult.allInstances()));
            VisibilityQuery.this.fireChange();
        }
    }
}

