/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.metadata;

import java.lang.reflect.Field;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.j2ee.metadata.WeakProxyClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;

public final class ClassPathSupport {
    private ClassPathSupport() {
    }

    public static ClassPath createWeakProxyClassPath(ClassPath[] delegates) {
        if (delegates == null) {
            throw new NullPointerException("The delegates parameter cannot be null");
        }
        ClassPathImplementation[] impls = new ClassPathImplementation[delegates.length];
        for (int i = 0; i < delegates.length; ++i) {
            impls[i] = ClassPathSupport.getClassPathImpl(delegates[i]);
        }
        return ClassPathFactory.createClassPath((ClassPathImplementation)new WeakProxyClassPathImplementation(impls));
    }

    private static ClassPathImplementation getClassPathImpl(ClassPath classPath) {
        try {
            Field field = classPath.getClass().getDeclaredField("impl");
            field.setAccessible(true);
            return (ClassPathImplementation)field.get(classPath);
        }
        catch (SecurityException ex) {
            throw ClassPathSupport.wrapException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw ClassPathSupport.wrapException(ex);
        }
        catch (IllegalAccessException ex) {
            throw ClassPathSupport.wrapException(ex);
        }
        catch (NoSuchFieldException ex) {
            throw ClassPathSupport.wrapException(ex);
        }
    }

    private static Error wrapException(Throwable t) {
        AssertionError e = new AssertionError((Object)t.getMessage());
        ((Throwable)((Object)e)).initCause(t);
        return e;
    }
}

