/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ui.actions.AddServerInstanceAction;
import org.netbeans.modules.j2ee.deployment.plugins.api.StartServer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderLookup;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class ServerRegistryNode
extends AbstractNode
implements ServerRegistry.PluginListener,
InstanceListener {
    static final String SERVERS_ICON = "org/netbeans/modules/j2ee/deployment/impl/ui/resources/Servers.png";
    private transient Map serverNodes = new HashMap();
    private transient HelpCtx helpCtx;
    private boolean expandablePassTargetNode = true;

    public ServerRegistryNode() {
        super((Children)new ServerChildren());
        this.setName("");
        this.setDisplayName(NbBundle.getMessage(ServerRegistryNode.class, (String)"SERVER_REGISTRY_NODE"));
        this.setShortDescription(NbBundle.getMessage(ServerRegistryNode.class, (String)"SERVER_REGISTRY_SHORT_DESCRIPTION"));
        this.setIconBaseWithExtension(SERVERS_ICON);
    }

    public void serverAdded(Server server) {
        this.updateKeys();
    }

    public void serverRemoved(Server server) {
        this.updateKeys();
    }

    public boolean isExpandablePassTargetNode() {
        return this.expandablePassTargetNode;
    }

    public void setExpandablePassTargetNode(boolean v) {
        this.expandablePassTargetNode = v;
        this.setChildren((Children)new ServerChildren());
        this.serverNodes.clear();
    }

    public void instanceAdded(String instance) {
        this.updateKeys();
    }

    public void instanceRemoved(String instance) {
        this.updateKeys();
    }

    public void changeDefaultInstance(String oldInstance, String newInstance) {
    }

    private void updateKeys() {
        ((ServerChildren)this.getChildren()).updateKeys();
    }

    public SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get(AddServerInstanceAction.class)};
    }

    public HelpCtx getHelpCtx() {
        if (this.helpCtx == null) {
            this.helpCtx = new HelpCtx(NbBundle.getBundle(ServerRegistryNode.class).getString("nodes_server_registry_node_html"));
        }
        return this.helpCtx;
    }

    public static ServerRegistryNode getServerRegistryNode() {
        try {
            FileSystem defaultFileSystem = Repository.getDefault().getDefaultFileSystem();
            FileObject fo = defaultFileSystem.findResource("UI/Runtime");
            DataFolder df = (DataFolder)DataObject.find((FileObject)fo);
            Lookup l = new FolderLookup((DataObject.Container)df).getLookup();
            return (ServerRegistryNode)l.lookup(ServerRegistryNode.class);
        }
        catch (DataObjectNotFoundException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return null;
        }
    }

    private static class ServerChildren
    extends Children.Keys {
        private boolean listenersAdded = false;

        protected void addNotify() {
            this.updateKeys();
            if (!this.listenersAdded) {
                ServerRegistryNode parent = (ServerRegistryNode)this.getNode();
                ServerRegistry.getInstance().addPluginListener(parent);
                ServerRegistry.getInstance().addInstanceListener(parent);
                this.listenersAdded = true;
            }
        }

        protected Node[] createNodes(Object obj) {
            ServerInstance instance = (ServerInstance)obj;
            if (instance == null) {
                return new Node[0];
            }
            StartServer startServer = instance.getStartServer();
            if (startServer == null) {
                return new Node[0];
            }
            Node childNode = startServer.isAlsoTargetServer(null) ? instance.getServer().getNodeProvider().createInstanceTargetNode(instance) : instance.getServer().getNodeProvider().createInstanceNode(instance);
            instance.refresh();
            return new Node[]{childNode};
        }

        public void updateKeys() {
            ArrayList<ServerInstance> instances = new ArrayList<ServerInstance>();
            for (Server server : ServerRegistry.getInstance().getServers()) {
                ServerInstance[] serverInstances = server.getInstances();
                for (int i = 0; i < serverInstances.length; ++i) {
                    instances.add(serverInstances[i]);
                }
            }
            Collections.sort(instances);
            this.setKeys(instances);
        }
    }
}

