/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.ui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.ui.RegistryNodeProvider;
import org.netbeans.modules.j2ee.deployment.impl.ui.wizard.AddServerInstanceWizard;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ServersCustomizer
extends JPanel
implements PropertyChangeListener,
VetoableChangeListener,
ExplorerManager.Provider {
    private static final Dimension MINIMUM_SIZE = new Dimension(720, 400);
    private ServerCategoriesChildren children;
    private ExplorerManager manager;
    private ServerInstance initialInstance;
    private JButton addButton;
    private JPanel cards;
    private JPanel clientArea;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel messageArea;
    private JButton removeButton;
    private JTextField serverName;
    private JTextField serverType;
    private BeanTreeView servers;
    private JLabel serversLabel;

    public ServersCustomizer(ServerInstance initialInstance) {
        this.initComponents();
        this.serverName.setColumns(30);
        this.serverType.setColumns(30);
        this.servers.setPreferredSize(new Dimension(200, 200));
        this.initialInstance = initialInstance;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            Node[] nodes = (Node[])evt.getNewValue();
            if (nodes.length != 1) {
                this.selectServer(null);
            } else {
                this.selectServer(nodes[0]);
            }
        }
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        Node[] nodes;
        if ("selectedNodes".equals(evt.getPropertyName()) && (nodes = (Node[])evt.getNewValue()).length > 1) {
            throw new PropertyVetoException("Invalid length", evt);
        }
    }

    public synchronized ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            this.manager = new ExplorerManager();
            this.manager.setRootContext((Node)new AbstractNode((Children)this.getChildren()));
            this.manager.addPropertyChangeListener((PropertyChangeListener)this);
            this.manager.addVetoableChangeListener((VetoableChangeListener)this);
        }
        return this.manager;
    }

    public void addNotify() {
        super.addNotify();
        this.expandServers(this.initialInstance);
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.servers = new PlatformsView();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.cards = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.serverName = new JTextField();
        this.jLabel2 = new JLabel();
        this.serverType = new JTextField();
        this.clientArea = new JPanel();
        this.messageArea = new JPanel();
        this.serversLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/j2ee/deployment/impl/ui/Bundle").getString("ASCN_ServerManager"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCD_ServerCustomizer"));
        this.servers.setBorder(BorderFactory.createEtchedBorder());
        this.servers.setPreferredSize(new Dimension(220, 400));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 6, 6);
        this.add((Component)this.servers, gridBagConstraints);
        this.servers.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCN_InstalledServers"));
        this.servers.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCD_InstalledServers"));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(ServersCustomizer.class, (String)"CTL_AddServer"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServersCustomizer.this.addServer(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 12, 0);
        this.add((Component)this.addButton, gridBagConstraints);
        this.addButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCN_AddServer"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCD_AddServer"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(ServersCustomizer.class, (String)"CTL_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ServersCustomizer.this.removeServer(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 12, 6);
        this.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCN_Remove"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCD_Remove"));
        this.cards.setLayout(new CardLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.serverName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ServersCustomizer.class, (String)"CTL_ServerName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCN_ServerName"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCD_ServerName"));
        this.serverName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.serverName, gridBagConstraints);
        this.serverName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCN_ServerName"));
        this.serverName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCD_ServerName"));
        this.jLabel2.setLabelFor(this.serverType);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ServersCustomizer.class, (String)"CTL_ServerType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 12, 0);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCN_ServerType"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCD_Server Type"));
        this.serverType.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 12, 0);
        this.jPanel1.add((Component)this.serverType, gridBagConstraints);
        this.serverType.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCN_ServerType"));
        this.serverType.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServersCustomizer.class, (String)"ASCD_Server Type"));
        this.clientArea.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.clientArea, gridBagConstraints);
        this.cards.add((Component)this.jPanel1, "card2");
        this.messageArea.setLayout(new GridBagLayout());
        this.cards.add((Component)this.messageArea, "card3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 12);
        this.add((Component)this.cards, gridBagConstraints);
        this.serversLabel.setLabelFor((Component)this.servers);
        Mnemonics.setLocalizedText((JLabel)this.serversLabel, (String)NbBundle.getMessage(ServersCustomizer.class, (String)"CTL_Servers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.serversLabel, gridBagConstraints);
        this.serversLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ServersCustomizer.class, (String)"LBL_Servers"));
        this.serversLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/deployment/impl/ui/Bundle").getString("ACSD_ServerList"));
    }

    private void removeServer(ActionEvent evt) {
        ServerInstance serverInstance;
        Node[] nodes = this.getExplorerManager().getSelectedNodes();
        if (nodes.length != 1) {
            assert (false) : "Illegal number of selected nodes";
            return;
        }
        if (nodes[0] instanceof ServerNode && !(serverInstance = ((ServerNode)nodes[0]).getServerInstance()).isRemoveForbidden()) {
            ServerRegistry.getInstance().removeServerInstance(serverInstance.getUrl());
            this.getChildren().refreshServers();
            this.expandServers(null);
        }
    }

    private void addServer(ActionEvent evt) {
        AddServerInstanceWizard wizard = new AddServerInstanceWizard();
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizard);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServersCustomizer.class, (String)"ACSD_Add_Server_Instance"));
        dialog.setVisible(true);
        if (wizard.getValue() == WizardDescriptor.FINISH_OPTION) {
            this.getChildren().refreshServers();
            ServerInstance servInst = null;
            Set result = wizard.getInstantiatedObjects();
            if (result != null) {
                for (Object instObj : result) {
                    if (!(instObj instanceof InstanceProperties)) continue;
                    InstanceProperties ip = (InstanceProperties)instObj;
                    String url = ip.getProperty("url");
                    servInst = ServerRegistry.getInstance().getServerInstance(url);
                }
            }
            this.expandServers(servInst);
        }
    }

    private synchronized ServerCategoriesChildren getChildren() {
        if (this.children == null) {
            this.children = new ServerCategoriesChildren();
        }
        return this.children;
    }

    private void selectServer(Node aNode) {
        Component component;
        this.clientArea.removeAll();
        if (aNode instanceof ServerNode) {
            ServerInstance serverInstance = ((ServerNode)aNode).getServerInstance();
            this.serverName.setText(serverInstance.getDisplayName());
            this.serverType.setText(serverInstance.getServer().getDisplayName());
            if (serverInstance.isRemoveForbidden()) {
                this.removeButton.setEnabled(false);
            } else {
                this.removeButton.setEnabled(true);
            }
        } else {
            this.removeButton.setEnabled(false);
            ((CardLayout)this.cards.getLayout()).last(this.cards);
            return;
        }
        if (aNode.hasCustomizer() && (component = aNode.getCustomizer()) != null) {
            ServersCustomizer.addComponent(this.clientArea, component);
        }
        int height = this.getHeight();
        int width = this.getWidth();
        this.setPreferredSize(null);
        this.revalidate();
        Dimension prefSize = this.getPreferredSize();
        int prefWidth = (int)(prefSize.getWidth() > MINIMUM_SIZE.getWidth() ? prefSize.getWidth() : MINIMUM_SIZE.getWidth());
        int prefHeight = (int)(prefSize.getHeight() > MINIMUM_SIZE.getHeight() ? prefSize.getHeight() : MINIMUM_SIZE.getHeight());
        if (prefHeight > height || prefWidth > width) {
            this.setPreferredSize(new Dimension(prefWidth > width ? prefWidth : width, prefHeight > height ? prefHeight : height));
            for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof Window)) continue;
                ((Window)parent).pack();
                break;
            }
        }
        CardLayout cl = (CardLayout)this.cards.getLayout();
        cl.first(this.cards);
    }

    private static void addComponent(Container container, Component component) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = -1;
        c.gridx = -1;
        c.gridwidth = 0;
        c.gridheight = 0;
        c.fill = 1;
        c.anchor = 18;
        c.weighty = 1.0;
        c.weightx = 1.0;
        ((GridBagLayout)container.getLayout()).setConstraints(component, c);
        container.add(component);
    }

    private void expandServers(ServerInstance servInst) {
        ExplorerManager mgr = this.getExplorerManager();
        Node node = mgr.getRootContext();
        ServersCustomizer.expandAllNodes(this.servers, node, mgr, servInst);
    }

    private static void expandAllNodes(BeanTreeView btv, Node node, ExplorerManager mgr, ServerInstance servInst) {
        btv.expandNode(node);
        Children ch = node.getChildren();
        if (servInst != null && ch == Children.LEAF && node instanceof ServerNode) {
            try {
                if (((ServerNode)node).getServerInstance() == servInst) {
                    mgr.setSelectedNodes(new Node[]{node});
                }
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
        if (servInst == null && ch == Children.LEAF && mgr.getSelectedNodes().length == 0) {
            try {
                mgr.setSelectedNodes(new Node[]{node});
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
        Node[] nodes = ch.getNodes(true);
        for (int i = 0; i < nodes.length; ++i) {
            ServersCustomizer.expandAllNodes(btv, nodes[i], mgr, servInst);
        }
    }

    private static class ServerCategoriesChildren
    extends Children.Keys {
        private ServerCategoriesChildren() {
        }

        protected void addNotify() {
            super.addNotify();
            this.refreshServers();
        }

        protected void removeNotify() {
            super.removeNotify();
        }

        protected Node[] createNodes(Object key) {
            if (key instanceof ServerCategoriesDescriptor) {
                ServerCategoriesDescriptor desc = (ServerCategoriesDescriptor)key;
                return new Node[]{new ServerCategoryNode(desc)};
            }
            if (key instanceof Node) {
                return new Node[]{new FilterNode((Node)key, Children.LEAF)};
            }
            return new Node[0];
        }

        private void refreshServers() {
            Collection servInstances = ServerRegistry.getInstance().getInstances();
            HashMap<String, ServerCategoriesDescriptor> categories = new HashMap<String, ServerCategoriesDescriptor>();
            String J2EE_SERVERS_CATEGORY = NbBundle.getMessage(ServersCustomizer.class, (String)"LBL_J2eeServersNode");
            ServerCategoriesDescriptor j2eeServers = new ServerCategoriesDescriptor(J2EE_SERVERS_CATEGORY);
            for (ServerInstance serverInstance : servInstances) {
                j2eeServers.add((Node)new ServerNode(serverInstance));
            }
            categories.put(J2EE_SERVERS_CATEGORY, j2eeServers);
            ArrayList keys = new ArrayList(categories.values());
            Collections.sort(keys);
            this.setKeys(keys);
        }
    }

    private static class ServerCategoryNode
    extends AbstractNode {
        private final ServerCategoriesDescriptor desc;
        private Node iconDelegate;

        public ServerCategoryNode(ServerCategoriesDescriptor desc) {
            super((Children)new ServersChildren(desc.getServers()));
            this.desc = desc;
            this.iconDelegate = DataFolder.findFolder((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot()).getNodeDelegate();
        }

        public String getDisplayName() {
            return this.desc.getName();
        }

        public Image getIcon(int type) {
            return this.iconDelegate.getIcon(type);
        }

        public Image getOpenedIcon(int type) {
            return this.iconDelegate.getOpenedIcon(type);
        }
    }

    private static class ServerNode
    extends FilterNode
    implements Comparable {
        private final ServerInstance serverInstance;

        public ServerNode(ServerInstance serverInstance) {
            super(serverInstance.getServer().getRegistryNodeFactory().getManagerNode(RegistryNodeProvider.createLookup(serverInstance)));
            this.disableDelegation(15);
            this.serverInstance = serverInstance;
            this.setChildren(FilterNode.Children.LEAF);
            this.setDisplayName(serverInstance.getDisplayName());
            this.setName(serverInstance.getUrl());
        }

        public ServerInstance getServerInstance() {
            return this.serverInstance;
        }

        public int compareTo(Object other) {
            if (!(other instanceof ServerNode)) {
                throw new IllegalArgumentException();
            }
            return this.serverInstance.compareTo(((ServerNode)other).serverInstance);
        }
    }

    private static class ServersChildren
    extends Children.Keys {
        private List servers;

        public ServersChildren(List servers) {
            this.servers = servers;
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(this.servers);
        }

        protected void removeNotify() {
            super.removeNotify();
            this.setKeys(new Object[0]);
        }

        protected Node[] createNodes(Object key) {
            return new Node[]{(Node)key};
        }
    }

    private static class ServerCategoriesDescriptor
    implements Comparable {
        private final String categoryName;
        private final List servers;

        public ServerCategoriesDescriptor(String categoryName) {
            assert (categoryName != null);
            this.categoryName = categoryName;
            this.servers = new ArrayList();
        }

        public String getName() {
            return this.categoryName;
        }

        public List getServers() {
            Collections.sort(this.servers);
            return Collections.unmodifiableList(this.servers);
        }

        public void add(Node node) {
            this.servers.add(node);
        }

        public int hashCode() {
            return this.categoryName.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof ServerCategoriesDescriptor) {
                ServerCategoriesDescriptor desc = (ServerCategoriesDescriptor)other;
                return this.categoryName.equals(desc.categoryName) && this.servers.size() == desc.servers.size();
            }
            return false;
        }

        public int compareTo(Object other) {
            if (!(other instanceof ServerCategoriesDescriptor)) {
                throw new IllegalArgumentException();
            }
            ServerCategoriesDescriptor desc = (ServerCategoriesDescriptor)other;
            return this.categoryName.compareTo(desc.categoryName);
        }
    }

    private static class PlatformsView
    extends BeanTreeView {
        public PlatformsView() {
            this.setPopupAllowed(false);
            this.setDefaultActionAllowed(false);
            this.setRootVisible(false);
            this.tree.setEditable(false);
            this.tree.setShowsRootHandles(false);
        }
    }
}

