/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarFile;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.db.explorer.DatabaseDriver;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.util.DriverListUtil;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.options.SystemOption;
import org.openide.util.NbBundle;

public class DatabaseOption
extends SystemOption {
    private static boolean debugMode;
    private static Vector drivers;
    private static Vector connections;
    private static int fetchlimit;
    private static int fetchstep;
    private static boolean autoConn;
    public static final String PROP_DEBUG_MODE = "debugMode";
    static final long serialVersionUID = -13629330831657810L;

    public DatabaseOption() {
        drivers = new Vector();
        connections = new Vector();
        debugMode = false;
        this.deleteAdaptorsFolder();
    }

    public Vector getAvailableDrivers() {
        if (drivers.size() == 0) {
            Map xxx = (Map)DatabaseNodeInfo.getGlobalNodeInfo("driverlist");
            drivers = this.createDrivers(xxx);
        }
        return drivers;
    }

    public boolean getDebugMode() {
        return debugMode;
    }

    public void setDebugMode(boolean flag) {
        if (debugMode == flag) {
            return;
        }
        debugMode = flag;
        this.firePropertyChange(PROP_DEBUG_MODE, !debugMode ? Boolean.TRUE : Boolean.FALSE, debugMode ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setAvailableDrivers(Vector c) {
        drivers = c;
    }

    Vector getConnections() {
        if (connections == null) {
            connections = new Vector();
        }
        return connections;
    }

    public void save() {
        this.firePropertyChange(null, null, null);
    }

    public String displayName() {
        return NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("OptionName");
    }

    public String toString() {
        return (drivers != null ? drivers.size() : 0) + " drivers, " + (connections != null ? connections.size() : 0) + " connections";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(null);
        out.writeObject(this.getConnections());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        drivers = (Vector)in.readObject();
        if (drivers != null) {
            this.lookForDrivers();
        }
        connections = (Vector)in.readObject();
    }

    private Vector createDrivers(Map drvMap) {
        Vector def = (Vector)drvMap.get("defaultdriverlist");
        Vector rvec = null;
        if (def != null && def.size() > 0) {
            rvec = new Vector(def.size());
            Enumeration defe = def.elements();
            while (defe.hasMoreElements()) {
                String adaptor;
                String prefix;
                String drv;
                Object rit = defe.nextElement();
                String name = (String)((Map)rit).get("name");
                if ((rit = new DatabaseDriver(name, drv = (String)((Map)rit).get("driver"), prefix = (String)((Map)rit).get("prefix"), adaptor = (String)((Map)rit).get("adaptor"))) == null) continue;
                rvec.add(rit);
            }
        } else {
            rvec = new Vector();
        }
        return rvec;
    }

    private void lookForDrivers() {
        StringBuffer sb = new StringBuffer();
        sb.append(File.separator);
        sb.append("lib");
        sb.append(File.separator);
        sb.append("ext");
        String libext = sb.toString();
        String nbhome = System.getProperty("netbeans.home");
        this.preinstallDrivers(nbhome + libext);
    }

    private void preinstallDrivers(String dirPath) {
        File dir = new File(dirPath);
        if (!dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".jar") || f.getName().endsWith(".zip");
            }
        });
        for (int i = 0; i < files.length; ++i) {
            try {
                JarFile jf = new JarFile(files[i]);
                Set drvs = DriverListUtil.getDrivers();
                Iterator it = drvs.iterator();
                while (it.hasNext()) {
                    String drv = (String)it.next();
                    if (jf.getEntry(drv.replace('.', '/') + ".class") == null) continue;
                    String driverName = DriverListUtil.findFreeName(DriverListUtil.getName(drv));
                    JDBCDriver driver = JDBCDriver.create(driverName, driverName, drv, new URL[]{files[i].toURL()});
                    try {
                        JDBCDriverManager.getDefault().addDriver(driver);
                    }
                    catch (DatabaseException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
                jf.close();
                continue;
            }
            catch (IOException exc) {
                // empty catch block
            }
        }
    }

    private void deleteAdaptorsFolder() {
        FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("Database");
        try {
            if (fo != null) {
                fo.delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        fetchlimit = 100;
        fetchstep = 200;
        autoConn = true;
    }
}

