/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.modules.db.util.DataComboBoxModel;

public final class DataComboBoxSupport {
    private final DataComboBoxModel dataModel;
    private final boolean allowAdding;
    private Object previousItem = null;
    private Object previousNonSpecialItem = null;
    private int previousIndex = -1;
    private boolean performingNewItemAction = false;
    static final Separator SEPARATOR_ITEM = new Separator();
    final Object NEW_ITEM = new Object(){

        public String toString() {
            return DataComboBoxSupport.this.dataModel.getNewItemDisplayName();
        }
    };

    DataComboBoxSupport(JComboBox comboBox, DataComboBoxModel dataModel, boolean allowAdding) {
        this.dataModel = dataModel;
        this.allowAdding = allowAdding;
        comboBox.setEditable(false);
        comboBox.setModel(new ItemComboBoxModel());
        comboBox.setRenderer(new ItemListCellRenderer());
        comboBox.addKeyListener(new ItemKeyListener());
        comboBox.addActionListener(new ItemActionListener());
        comboBox.addPopupMenuListener(new ItemPopupMenuListener());
    }

    public static void connect(JComboBox comboBox, DataComboBoxModel dataModel) {
        DataComboBoxSupport.connect(comboBox, dataModel, true);
    }

    public static void connect(JComboBox comboBox, DataComboBoxModel dataModel, boolean allowAdding) {
        new DataComboBoxSupport(comboBox, dataModel, allowAdding);
    }

    private boolean isSpecialItem(Object item) {
        return item == SEPARATOR_ITEM || item == this.NEW_ITEM;
    }

    private void setPreviousNonSpecialItem(JComboBox comboBox) {
        if (comboBox.getSelectedItem() == this.NEW_ITEM) {
            comboBox.setSelectedItem(this.previousNonSpecialItem);
        }
    }

    private final class ItemPopupMenuListener
    implements PopupMenuListener {
        private ItemPopupMenuListener() {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (!DataComboBoxSupport.this.performingNewItemAction) {
                DataComboBoxSupport.this.setPreviousNonSpecialItem((JComboBox)e.getSource());
            }
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
            if (!DataComboBoxSupport.this.performingNewItemAction) {
                DataComboBoxSupport.this.setPreviousNonSpecialItem((JComboBox)e.getSource());
            }
        }
    }

    private final class ItemActionListener
    implements ActionListener {
        private ItemActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            final JComboBox comboBox = (JComboBox)e.getSource();
            Object selectedItem = comboBox.getSelectedItem();
            if (selectedItem == SEPARATOR_ITEM) {
                int newIndex = -1;
                if (DataComboBoxSupport.this.previousIndex != -1) {
                    int selectedIndex = comboBox.getSelectedIndex();
                    newIndex = selectedIndex > DataComboBoxSupport.this.previousIndex ? selectedIndex + 1 : selectedIndex - 1;
                }
                comboBox.setSelectedIndex(newIndex);
            } else if ((e.getModifiers() & 0x10) != 0 && selectedItem == DataComboBoxSupport.this.NEW_ITEM) {
                DataComboBoxSupport.this.performingNewItemAction = true;
                try {
                    comboBox.setPopupVisible(false);
                    DataComboBoxSupport.this.dataModel.newItemActionPerformed();
                }
                finally {
                    DataComboBoxSupport.this.performingNewItemAction = false;
                }
                DataComboBoxSupport.this.setPreviousNonSpecialItem(comboBox);
                final Object newSelectedItem = comboBox.getSelectedItem();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        comboBox.setSelectedItem(newSelectedItem);
                    }
                });
            }
        }
    }

    private final class ItemKeyListener
    extends KeyAdapter {
        private ItemKeyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyPressed(KeyEvent e) {
            Object selectedItem;
            JComboBox comboBox = (JComboBox)e.getSource();
            int keyCode = e.getKeyCode();
            if (10 == keyCode && (selectedItem = comboBox.getSelectedItem()) == DataComboBoxSupport.this.NEW_ITEM) {
                DataComboBoxSupport.this.performingNewItemAction = true;
                try {
                    comboBox.setPopupVisible(false);
                    e.consume();
                    DataComboBoxSupport.this.dataModel.newItemActionPerformed();
                }
                finally {
                    DataComboBoxSupport.this.performingNewItemAction = false;
                }
                DataComboBoxSupport.this.setPreviousNonSpecialItem(comboBox);
            }
        }
    }

    private class ItemListCellRenderer
    extends DefaultListCellRenderer {
        private ItemListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            JLabel label = (JLabel)component;
            if (value != null && !DataComboBoxSupport.this.isSpecialItem(value)) {
                String displayName = DataComboBoxSupport.this.dataModel.getItemDisplayName(value);
                label.setText(DataComboBoxSupport.this.dataModel.getItemDisplayName(value));
                label.setToolTipText(DataComboBoxSupport.this.dataModel.getItemTooltipText(value));
            } else {
                if (value == SEPARATOR_ITEM) {
                    return SEPARATOR_ITEM;
                }
                if (value != null) {
                    label.setText(value.toString());
                    label.setToolTipText(null);
                }
            }
            return label;
        }
    }

    private class ItemComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    ListDataListener {
        public ItemComboBoxModel() {
            this.getDelegate().addListDataListener(this);
        }

        public Object getElementAt(int index) {
            if (DataComboBoxSupport.this.allowAdding) {
                if (this.getSize() == 1) {
                    if (index == 0) {
                        return DataComboBoxSupport.this.NEW_ITEM;
                    }
                    throw new IllegalStateException("Index out of bounds: " + index);
                }
                if (index >= 0 && index < this.getDelegate().getSize()) {
                    return this.getDelegate().getElementAt(index);
                }
                if (index == this.getSize() - 2) {
                    return SEPARATOR_ITEM;
                }
                if (index == this.getSize() - 1) {
                    return DataComboBoxSupport.this.NEW_ITEM;
                }
                throw new IllegalStateException("Index out of bounds: " + index);
            }
            return this.getDelegate().getElementAt(index);
        }

        public int getSize() {
            if (DataComboBoxSupport.this.allowAdding) {
                return this.getDelegate().getSize() == 0 ? 1 : this.getDelegate().getSize() + 2;
            }
            return this.getDelegate().getSize();
        }

        public void setSelectedItem(Object anItem) {
            DataComboBoxSupport.this.previousItem = this.getDelegate().getSelectedItem();
            DataComboBoxSupport.this.previousIndex = this.getItemIndex(DataComboBoxSupport.this.previousItem);
            if (!DataComboBoxSupport.this.isSpecialItem(DataComboBoxSupport.this.previousItem)) {
                DataComboBoxSupport.this.previousNonSpecialItem = DataComboBoxSupport.this.previousItem;
            }
            this.getDelegate().setSelectedItem(anItem);
        }

        public Object getSelectedItem() {
            return this.getDelegate().getSelectedItem();
        }

        public Object getPreviousItem() {
            return DataComboBoxSupport.this.previousItem;
        }

        private ComboBoxModel getDelegate() {
            return DataComboBoxSupport.this.dataModel.getListModel();
        }

        private int getItemIndex(Object item) {
            if (item == null) {
                return -1;
            }
            for (int i = 0; i < this.getSize(); ++i) {
                if (!this.getElementAt(i).equals(item)) continue;
                return i;
            }
            return -1;
        }

        public void intervalRemoved(ListDataEvent e) {
            throw new UnsupportedOperationException("This is currently not supported.");
        }

        public void intervalAdded(ListDataEvent e) {
            throw new UnsupportedOperationException("This is currently not supported.");
        }

        public void contentsChanged(ListDataEvent e) {
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    private static final class Separator
    extends JSeparator {
        Separator() {
            this.setForeground(Color.BLACK);
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(size.width, 1);
        }
    }
}

