/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.earproject.EarActionProvider;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOperationImplementation {
    private final EarProject project;

    public EarProjectOperations(EarProject project) {
        this.project = project;
    }

    private static void addFile(FileObject projectDirectory, String fileName, List<FileObject> result) {
        FileObject file = projectDirectory.getFileObject(fileName);
        if (file != null) {
            result.add(file);
        }
    }

    public List getMetadataFiles() {
        FileObject projectDirectory = this.project.getProjectDirectory();
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        EarProjectOperations.addFile(projectDirectory, "nbproject", files);
        EarProjectOperations.addFile(projectDirectory, "build.xml", files);
        EarProjectOperations.addFile(projectDirectory, "src", files);
        EarProjectOperations.addFile(projectDirectory, ".cvsignore", files);
        return files;
    }

    public List<FileObject> getDataFiles() {
        return Collections.emptyList();
    }

    public void notifyDeleting() throws IOException {
        EarActionProvider ap = (EarActionProvider)this.project.getLookup().lookup(EarActionProvider.class);
        assert (ap != null);
        Lookup context = Lookups.fixed((Object[])new Object[0]);
        Properties p = new Properties();
        String[] targetNames = ap.getTargetNames("clean", context, p);
        FileObject buildXML = this.project.getProjectDirectory().getFileObject("build.xml");
        assert (targetNames != null);
        assert (targetNames.length > 0);
        ActionUtils.runTarget((FileObject)buildXML, (String[])targetNames, (Properties)p).waitFinished();
    }

    public void notifyDeleted() throws IOException {
        this.project.getAntProjectHelper().notifyDeleted();
    }

    public void notifyCopying() {
    }

    public void notifyCopied(Project original, File originalPath, String nueName) {
        if (original == null) {
            return;
        }
        this.project.setName(nueName);
    }

    public void notifyMoving() throws IOException {
        this.notifyDeleting();
    }

    public void notifyMoved(Project original, File originalPath, final String newName) {
        if (original == null) {
            this.project.getAntProjectHelper().notifyDeleted();
            return;
        }
        final String oldProjectName = this.project.getName();
        this.project.setName(newName);
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                AntProjectHelper helper = EarProjectOperations.this.project.getAntProjectHelper();
                EditableProperties projectProps = helper.getProperties("nbproject/project.properties");
                String earName = (String)projectProps.get((Object)"jar.name");
                String oldName = earName.substring(0, earName.length() - 4);
                if (earName.endsWith(".ear") && oldName.equals(oldProjectName)) {
                    projectProps.put((Object)"jar.name", (Object)(newName + ".ear"));
                }
                helper.putProperties("nbproject/project.properties", projectProps);
            }
        });
    }
}

