/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.customizer;

import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.j2ee.earproject.ui.customizer.VisualClasspathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class VisualClassPathItem {
    public static final String PATH_IN_WAR_LIB = "WEB-INF/lib";
    public static final String PATH_IN_EAR = "/";
    public static final String PATH_IN_EAR_NONE = null;
    private static final String RESOURCE_ICON_JAR = "org/netbeans/modules/j2ee/earproject/ui/resources/jar.gif";
    private static final String RESOURCE_ICON_LIBRARY = "org/netbeans/modules/j2ee/earproject/ui/resources/libraries.gif";
    private static final String RESOURCE_ICON_ARTIFACT = "org/netbeans/modules/j2ee/earproject/ui/resources/projectDependencies.gif";
    private static final String RESOURCE_ICON_CLASSPATH = "org/netbeans/modules/j2ee/earproject/ui/resources/referencedClasspath.gif";
    private static final Icon ICON_JAR = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/j2ee/earproject/ui/resources/jar.gif"));
    private static Icon iconFolder;
    private static final Icon ICON_LIBRARY;
    private static final Icon ICON_ARTIFACT;
    private static final Icon ICON_CLASSPATH;
    private final Type type;
    private final Object cpElement;
    private String raw;
    private final String eval;
    private String pathInEAR;
    private String origPathInEAR;

    VisualClassPathItem(Object cpElement, Type type, String raw, String eval, String pathInEAR) {
        this.cpElement = cpElement;
        this.type = type;
        this.raw = raw;
        this.eval = eval;
        this.pathInEAR = pathInEAR;
        this.origPathInEAR = pathInEAR;
        if (cpElement != null) {
            switch (this.getType()) {
                case JAR: {
                    if (cpElement instanceof File) break;
                    throw new IllegalArgumentException("File instance must be passed as object for Type.JAR. Was: " + cpElement.getClass());
                }
                case LIBRARY: {
                    if (cpElement instanceof Library) break;
                    throw new IllegalArgumentException("Library instance must be passed as object for Type.LIBRARY. Was: " + cpElement.getClass());
                }
                case ARTIFACT: {
                    if (cpElement instanceof AntArtifact) break;
                    throw new IllegalArgumentException("AntArtifact instance must be passed as object for Type.ARTIFACT. Was: " + cpElement.getClass());
                }
                case CLASSPATH: {
                    if (cpElement instanceof String) break;
                    throw new IllegalArgumentException("String instance must be passed as object for Type.CLASSPATH. Was: " + cpElement.getClass());
                }
                default: {
                    throw new IllegalArgumentException("Unknown type passed. Was: " + (Object)((Object)this.getType()));
                }
            }
        }
    }

    public String getPathInEAR() {
        return this.pathInEAR;
    }

    public void setPathInEAR(String path) {
        this.pathInEAR = path;
    }

    public String getOrigPathInEAR() {
        return this.origPathInEAR;
    }

    public Object getObject() {
        return this.cpElement;
    }

    public Type getType() {
        return this.type;
    }

    public void setRaw(String raw) {
        this.raw = raw;
    }

    public String getRaw() {
        return this.raw;
    }

    public String getEvaluated() {
        return this.eval == null ? this.getRaw() : this.eval;
    }

    public boolean canDelete() {
        return this.getType() != Type.CLASSPATH;
    }

    public Icon getIcon() {
        if (this.getObject() == null) {
            return null;
        }
        switch (this.getType()) {
            case JAR: {
                if (((File)this.getObject()).isDirectory()) {
                    return VisualClassPathItem.getFolderIcon();
                }
                return ICON_JAR;
            }
            case LIBRARY: {
                return ICON_LIBRARY;
            }
            case ARTIFACT: {
                return ICON_ARTIFACT;
            }
            case CLASSPATH: {
                return ICON_CLASSPATH;
            }
        }
        return null;
    }

    public String toString() {
        switch (this.getType()) {
            case JAR: {
                if (this.getObject() != null) {
                    return this.getEvaluated();
                }
                return NbBundle.getMessage(VisualClassPathItem.class, (String)"LBL_MISSING_FILE", (Object)this.getFileRefName(this.getEvaluated()));
            }
            case LIBRARY: {
                if (this.getObject() != null) {
                    return ((Library)this.getObject()).getDisplayName();
                }
                return NbBundle.getMessage(VisualClassPathItem.class, (String)"LBL_MISSING_LIBRARY", (Object)this.getLibraryName(this.getRaw()));
            }
            case ARTIFACT: {
                if (this.getObject() != null) {
                    return this.getEvaluated();
                }
                return NbBundle.getMessage(VisualClassPathItem.class, (String)"LBL_MISSING_PROJECT", (Object)this.getProjectName(this.getEvaluated()));
            }
            case CLASSPATH: {
                return this.getEvaluated();
            }
        }
        return this.getEvaluated();
    }

    private String getProjectName(String id) {
        return id.matches("\\$\\{reference\\..*\\.id\\}") ? id.substring(12, id.indexOf(46, 12)) : id;
    }

    private String getLibraryName(String id) {
        return id.substring(7, id.indexOf(".classpath"));
    }

    private String getFileRefName(String id) {
        return id.substring(17, id.length() - 1);
    }

    public int hashCode() {
        int hash = this.getType().ordinal();
        switch (this.getType()) {
            case ARTIFACT: {
                if (this.getObject() != null) {
                    AntArtifact aa = (AntArtifact)this.getObject();
                    hash += aa.getType().hashCode();
                    hash += aa.getScriptLocation().hashCode();
                    hash += aa.getArtifactLocations()[0].hashCode();
                    break;
                }
                hash += this.getRaw().hashCode();
                break;
            }
            default: {
                if (this.getObject() != null) {
                    hash += this.getObject().hashCode();
                    break;
                }
                hash += this.getRaw().hashCode();
            }
        }
        return hash;
    }

    public boolean equals(Object object) {
        if (!(object instanceof VisualClassPathItem)) {
            return false;
        }
        VisualClassPathItem vcpi = (VisualClassPathItem)object;
        if (this.getType() != vcpi.getType()) {
            return false;
        }
        switch (this.getType()) {
            case ARTIFACT: {
                AntArtifact aa2 = (AntArtifact)vcpi.getObject();
                AntArtifact aa1 = (AntArtifact)this.getObject();
                if (aa1 != null && aa2 != null) {
                    if (aa1.getType() != aa2.getType()) {
                        return false;
                    }
                    if (!aa1.getScriptLocation().equals(aa2.getScriptLocation())) {
                        return false;
                    }
                    return aa1.getArtifactLocations()[0].equals(aa2.getArtifactLocations()[0]);
                }
                return this.getRaw().equals(vcpi.getRaw());
            }
        }
        if (this.getObject() != null) {
            return this.getObject().equals(vcpi.getObject());
        }
        return this.getRaw().equals(vcpi.getRaw());
    }

    static VisualClassPathItem createArtifact(AntArtifact artifact, String raw, String pathInEAR, String eval) {
        return new VisualClassPathItem(artifact, Type.ARTIFACT, raw, eval, pathInEAR);
    }

    static VisualClassPathItem createArtifact(AntArtifact artifact, String raw, String pathInEAR) {
        String eval = artifact != null ? artifact.getArtifactLocations()[0].toString() : null;
        return VisualClassPathItem.createArtifact(artifact, raw, pathInEAR, eval);
    }

    static VisualClassPathItem createArtifact(AntArtifact antArtifact) {
        return VisualClassPathItem.createArtifact(antArtifact, null, PATH_IN_EAR);
    }

    static VisualClassPathItem createJAR(File jarFile, String raw, String pathInEAR, String eval) {
        return new VisualClassPathItem(jarFile, Type.JAR, raw, eval, pathInEAR);
    }

    static VisualClassPathItem createJAR(File jarFile, String raw, String pathInEAR) {
        return VisualClassPathItem.createJAR(jarFile, raw, pathInEAR, jarFile.getPath());
    }

    static VisualClassPathItem createJAR(File jarFile) {
        return VisualClassPathItem.createJAR(jarFile, null, PATH_IN_EAR);
    }

    static VisualClassPathItem createLibrary(Library library) {
        return VisualClassPathItem.createLibrary(library, PATH_IN_EAR);
    }

    static VisualClassPathItem createLibrary(Library library, String pathInEar) {
        String libraryName = library.getName();
        return new VisualClassPathItem(library, Type.LIBRARY, "${libs." + libraryName + ".classpath}", libraryName, pathInEar);
    }

    public static VisualClassPathItem createClassPath(String wellKnownPath, String eval) {
        return new VisualClassPathItem(wellKnownPath, Type.CLASSPATH, wellKnownPath, eval, PATH_IN_EAR_NONE);
    }

    private static Icon getFolderIcon() {
        if (iconFolder == null) {
            FileObject root = Repository.getDefault().getDefaultFileSystem().getRoot();
            DataFolder dataFolder = DataFolder.findFolder((FileObject)root);
            iconFolder = new ImageIcon(dataFolder.getNodeDelegate().getIcon(1));
        }
        return iconFolder;
    }

    public String getToolTipText() {
        String toolTipText = null;
        switch (this.getType()) {
            case JAR: {
                toolTipText = ((File)this.cpElement).getAbsolutePath();
                break;
            }
            case LIBRARY: {
                toolTipText = VisualClasspathSupport.getLibraryString((Library)this.cpElement);
                break;
            }
            case ARTIFACT: {
                AntArtifact artifact = (AntArtifact)this.cpElement;
                FileObject[] fos = artifact.getArtifactFiles();
                if (fos.length <= 0) break;
                FileObject f = fos[0];
                toolTipText = f == null ? artifact.getArtifactLocations()[0].getPath() : f.getPath();
                break;
            }
            case CLASSPATH: {
                toolTipText = (String)this.cpElement;
                break;
            }
            default: {
                toolTipText = null;
            }
        }
        return toolTipText;
    }

    public String getCompletePathInArchive(boolean original) {
        String full = this.getEvaluated();
        int lastSlash = full.lastIndexOf(47);
        String trimmed = null;
        trimmed = lastSlash != -1 ? full.substring(lastSlash + 1) : full;
        String path = original ? this.getOrigPathInEAR() : this.getPathInEAR();
        return null != path && path.length() > 1 ? path + '/' + trimmed : trimmed;
    }

    public String getCompletePathInArchive() {
        return this.getCompletePathInArchive(false);
    }

    static {
        ICON_LIBRARY = new ImageIcon(Utilities.loadImage((String)RESOURCE_ICON_LIBRARY));
        ICON_ARTIFACT = new ImageIcon(Utilities.loadImage((String)RESOURCE_ICON_ARTIFACT));
        ICON_CLASSPATH = new ImageIcon(Utilities.loadImage((String)RESOURCE_ICON_CLASSPATH));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        JAR,
        LIBRARY,
        ARTIFACT,
        CLASSPATH;

    }
}

