/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core;

import org.openide.ErrorManager;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;

public final class Background {
    private static boolean loaded = false;
    private static boolean loadfailed = false;
    private Thread peer;
    private Cancellable cancel;

    private Background(Thread peer, Cancellable c) {
        this.peer = peer;
        this.cancel = c;
    }

    public static Background execute(Runnable run) {
        Cancellable cancel = (Cancellable)(run instanceof Cancellable ? run : null);
        if (Background.useHack()) {
            Thread t = new Thread((Runnable)new Wrapper(run), "Background");
            t.setPriority(1);
            t.setDaemon(true);
            t.start();
            return new Background(t, cancel);
        }
        ThreadExtractor extractor = new ThreadExtractor(run);
        RequestProcessor.getDefault().post((Runnable)extractor, 0, 1);
        return new Background(extractor.getThread(), cancel);
    }

    public final void interrupt() {
        if (this.peer != null) {
            this.peer.interrupt();
            this.peer.interrupt();
        }
        if (this.cancel != null) {
            this.cancel.cancel();
        }
    }

    private static boolean useHack() {
        String os = System.getProperty("os.name");
        if (!"Linux".equals(os)) {
            return false;
        }
        String osversion = "" + System.getProperty("os.version");
        if (!osversion.startsWith("2.4")) {
            return false;
        }
        String vendor = "" + System.getProperty("java.vm.vendor");
        if (!vendor.startsWith("Sun")) {
            return false;
        }
        String version = "" + System.getProperty("java.vm.version");
        if (!version.startsWith("1.4")) {
            return false;
        }
        String hw = System.getProperty("os.arch");
        if (!"i386".equals(hw)) {
            return false;
        }
        Background.loadLibrary();
        return loaded;
    }

    private static void loadLibrary() {
        if (loadfailed) {
            return;
        }
        if (!loaded) {
            try {
                System.loadLibrary("tasklist_bgthreads");
                loaded = true;
            }
            catch (Throwable t) {
                ErrorManager.getDefault().notify(1, t);
                loadfailed = true;
            }
        }
    }

    private static native void native_nice();

    public static void main(String[] args) throws Exception {
        if (Background.useHack()) {
            Background.native_nice();
            System.out.println("I'm niced for 1 minute. Check it by top utility.");
            Thread.sleep(60000L);
        }
    }

    private static class ThreadExtractor
    implements Runnable {
        private final Runnable peer;
        private Thread thread;

        ThreadExtractor(Runnable run) {
            this.peer = run;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread.currentThread();
            Thread.interrupted();
            ThreadExtractor threadExtractor = this;
            synchronized (threadExtractor) {
                this.thread = Thread.currentThread();
                this.notifyAll();
            }
            this.peer.run();
        }

        public synchronized Thread getThread() {
            while (this.thread == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.thread;
        }
    }

    private static class Wrapper
    implements Runnable {
        private final Runnable peer;

        public Wrapper(Runnable run) {
            this.peer = run;
        }

        public void run() {
            Background.native_nice();
            this.peer.run();
        }
    }
}

