/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core;

import java.awt.Toolkit;
import javax.swing.SwingUtilities;
import org.netbeans.modules.tasklist.core.Task;
import org.netbeans.modules.tasklist.core.TaskListView;
import org.netbeans.modules.tasklist.core.TaskNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class GoToTaskAction
extends NodeAction {
    private static final long serialVersionUID = 1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] nodes) {
        final TaskListView tlv = TaskListView.getCurrent();
        if (tlv != null) {
            final Task item = TaskNode.getTask(nodes[0]);
            if (!$assertionsDisabled && item == null) {
                throw new AssertionError();
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    tlv.showTaskInEditor(item, null);
                }
            });
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    protected boolean enable(Node[] nodes) {
        if (nodes == null || nodes.length != 1) {
            return false;
        }
        Task item = TaskNode.getTask(nodes[0]);
        if (item == null) {
            return false;
        }
        return item.getLine() != null;
    }

    public String getName() {
        return NbBundle.getMessage((Class)GoToTaskAction.class, (String)"LBL_Goto");
    }

    protected String iconResource() {
        return "org/netbeans/modules/tasklist/core/showSource.gif";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    static {
        $assertionsDisabled = !GoToTaskAction.class.desiredAssertionStatus();
    }
}

