/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.tasklist.core.Task;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;

public final class TLUtils {
    public static final Logger LOGGER = TLUtils.getLogger(TLUtils.class);

    public static String toHTML(String text) {
        StringBuffer sb = new StringBuffer(2 * text.length());
        int n = text.length();
        block7: for (int i = 0; i < n; ++i) {
            switch (text.charAt(i)) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\n': {
                    sb.append("<br>");
                    continue block7;
                }
                default: {
                    sb.append(text.charAt(i));
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createBackup(File f) throws IOException {
        File dir = f.getParentFile();
        File backup = new File(dir, f.getName() + "~");
        if (backup.exists() && !backup.delete()) {
            throw new IOException("Cannot delete the file");
        }
        FileInputStream fis = new FileInputStream(f);
        try {
            FileOutputStream fos = new FileOutputStream(backup);
            try {
                FileChannel ic = fis.getChannel();
                FileChannel oc = fos.getChannel();
                ByteBuffer bb = ByteBuffer.allocateDirect(16384);
                bb.clear();
                while (ic.read(bb) >= 0 || bb.hasRemaining()) {
                    bb.flip();
                    oc.write(bb);
                    bb.compact();
                }
            }
            finally {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    public static Line getLineByNumber(DataObject dobj, int lineno) {
        try {
            Line.Set ls;
            LineCookie lc = (LineCookie)dobj.getCookie(LineCookie.class);
            if (lc != null && (ls = lc.getLineSet()) != null) {
                Line l = ls.getCurrent(lineno - 1);
                return l;
            }
        }
        catch (IndexOutOfBoundsException ex) {
        }
        catch (Exception e) {
            ErrorManager.getDefault().log(16, "getLineByNumber - file " + dobj + " and lineno=" + lineno);
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return null;
    }

    public static void appendSurroundingLine(StringBuffer sb, Line line, int offset) {
        DataObject dobj = DataEditorSupport.findDataObject((Line)line);
        try {
            LineCookie lc = (LineCookie)dobj.getCookie(LineCookie.class);
            if (lc == null) {
                return;
            }
            Line.Set ls = lc.getLineSet();
            if (ls == null) {
                return;
            }
            int lineno = line.getLineNumber();
            if (lineno + offset < 0) {
                return;
            }
            Line before = ls.getCurrent(lineno + offset);
            TLUtils.appendHTMLString(sb, before.getText());
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
    }

    public static int firstDiff(String s1, String s2) {
        int n2;
        int n1 = s1.length();
        int n = n1 < (n2 = s2.length()) ? n1 : n2;
        for (int i = 0; i < n; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return i;
        }
        return n;
    }

    public static int lastDiff(String s1, String s2) {
        int n1 = s1.length() - 1;
        int n2 = s2.length() - 1;
        int i = 0;
        while (n2 >= 0 && n1 >= 0) {
            if (s1.charAt(n1) != s2.charAt(n2)) {
                return i;
            }
            --n2;
            --n1;
            ++i;
        }
        return i;
    }

    public static void appendHTMLChar(StringBuffer sb, char c) {
        switch (c) {
            case '<': {
                sb.append("&lt;");
                break;
            }
            case '>': {
                sb.append("&gt;");
                break;
            }
            case '&': {
                sb.append("&amp;");
                break;
            }
            case '\"': {
                sb.append("&quot;");
                break;
            }
            case ' ': {
                sb.append("&nbsp;");
                break;
            }
            case '\n': {
                sb.append("<br>");
                break;
            }
            default: {
                sb.append(c);
            }
        }
    }

    public static void appendHTMLString(StringBuffer sb, String s) {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            TLUtils.appendHTMLChar(sb, s.charAt(i));
        }
    }

    public static void appendAttributed(StringBuffer sb, String text, int begin, int end, boolean underline, boolean bold) {
        if (begin != -1) {
            int i;
            for (i = 0; i < begin; ++i) {
                TLUtils.appendHTMLChar(sb, text.charAt(i));
            }
            if (underline) {
                sb.append("<u>");
            }
            if (bold) {
                sb.append("<b>");
            }
            for (i = begin; i < end; ++i) {
                TLUtils.appendHTMLChar(sb, text.charAt(i));
            }
            if (underline) {
                sb.append("</u>");
            }
            if (bold) {
                sb.append("</b>");
            }
            int nl = text.length();
            for (int i2 = end; i2 < nl; ++i2) {
                TLUtils.appendHTMLChar(sb, text.charAt(i2));
            }
        } else {
            TLUtils.appendHTMLString(sb, text);
        }
    }

    public static Element getElement(Document d, Line line) {
        if (d == null) {
            ErrorManager.getDefault().log(256, "d was null");
            return null;
        }
        if (!(d instanceof StyledDocument)) {
            ErrorManager.getDefault().log(256, "Not a styleddocument");
            return null;
        }
        StyledDocument doc = (StyledDocument)d;
        Element e = doc.getParagraphElement(0).getParentElement();
        if (e == null) {
            e = doc.getDefaultRootElement();
        }
        int lineNumber = line.getLineNumber();
        Element elm = e.getElement(lineNumber);
        return elm;
    }

    public static Document getDocument(Line line) {
        DataObject dao = DataEditorSupport.findDataObject((Line)line);
        if (!dao.isValid()) {
            return null;
        }
        return TLUtils.getDocument(dao);
    }

    public static Document getDocument(DataObject dao) {
        EditorCookie edit = (EditorCookie)dao.getCookie(EditorCookie.class);
        if (edit == null) {
            return null;
        }
        StyledDocument d = edit.getDocument();
        return d;
    }

    public static boolean deleteLine(Line line, String prefix) {
        Document doc = TLUtils.getDocument(line);
        Element elm = TLUtils.getElement(doc, line);
        if (elm == null) {
            return false;
        }
        int offset = elm.getStartOffset();
        int endOffset = elm.getEndOffset();
        try {
            String text = doc.getText(offset, endOffset - offset);
            if (!text.startsWith(prefix)) {
                return false;
            }
            doc.remove(offset, endOffset - offset);
        }
        catch (BadLocationException ex) {
            ErrorManager.getDefault().notify(16, (Throwable)ex);
        }
        return false;
    }

    public static boolean commentLine(Line line, String prefix) {
        Document doc = TLUtils.getDocument(line);
        Element elm = TLUtils.getElement(doc, line);
        if (elm == null) {
            return false;
        }
        int offset = elm.getStartOffset();
        int endOffset = elm.getEndOffset();
        try {
            String text = doc.getText(offset, endOffset - offset);
            if (!text.startsWith(prefix)) {
                return false;
            }
            doc.insertString(offset, "// ", null);
        }
        catch (BadLocationException ex) {
            ErrorManager.getDefault().notify(16, (Throwable)ex);
        }
        return false;
    }

    public static String toURL(FileObject fo) {
        return URLMapper.findURL((FileObject)fo, (int)0).toExternalForm();
    }

    public static FileObject[] fromURL(String urlString) {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            return null;
        }
        return URLMapper.findFileObjects((URL)url);
    }

    public static int getChildrenCountRecursively(Node node) {
        if (node == null) {
            return 0;
        }
        Children children = node.getChildren();
        if (children.getNodesCount() == 0) {
            return 0;
        }
        int n = 0;
        Node[] nodes = children.getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            n += TLUtils.getChildrenCountRecursively(nodes[i]) + 1;
        }
        return n;
    }

    public static Node.Property getProperty(Node n, String prop) {
        Node.PropertySet[] propsets = n.getPropertySets();
        for (int j = 0; j < propsets.length; ++j) {
            Node.Property[] props = propsets[j].getProperties();
            for (int k = 0; k < props.length; ++k) {
                if (!props[k].getName().equals(prop)) continue;
                return props[k];
            }
        }
        return null;
    }

    public static Logger getLogger(Class clazz) {
        Logger logger = Logger.getLogger(clazz.getName());
        logger.setUseParentHandlers(false);
        ConsoleHandler ch = new ConsoleHandler();
        ch.setLevel(Level.FINE);
        logger.addHandler(ch);
        logger.setLevel(Level.WARNING);
        return logger;
    }

    public static void traceFocus(final Container c) {
        c.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                System.err.println("Component " + c + " gained focus.");
                Thread.dumpStack();
            }

            public void focusLost(FocusEvent e) {
                System.err.println("Component " + c + " lost focus.");
                Thread.dumpStack();
            }
        });
        Component[] cs = c.getComponents();
        if (cs != null) {
            for (int i = 0; i < cs.length; ++i) {
                if (!(cs[i] instanceof Container)) continue;
                TLUtils.traceFocus((Container)cs[i]);
            }
        }
    }

    public static int recursiveCount(Iterator tasks) {
        if (tasks == null) {
            return 0;
        }
        int count = 0;
        while (tasks.hasNext()) {
            Task next = (Task)tasks.next();
            count += next.getSubtaskCountRecursively() + 1;
        }
        return count;
    }

    public static void nodeRecursivePrint(Node node, int depth) {
        if (depth > 20) {
            Thread.dumpStack();
            return;
        }
        for (int i = 0; i < depth; ++i) {
            System.err.print("   ");
        }
        System.err.println(node.getDisplayName());
        if (node.getChildren() != null && node.getChildren().getNodes() != null) {
            Node[] nodes = node.getChildren().getNodes();
            for (int i = 0; i < nodes.length; ++i) {
                TLUtils.nodeRecursivePrint(nodes[i], depth + 1);
            }
        }
    }

    static {
        LOGGER.setLevel(Level.FINE);
    }
}

