/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet.editors;

import java.awt.Component;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditorSupport;
import java.util.Locale;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.EnhancedPropertyEditor;
import org.openide.src.Type;
import org.openide.util.NbBundle;

public class TypeEditor
extends PropertyEditorSupport
implements EnhancedPropertyEditor,
ExPropertyEditor {
    private static final String[] LVALUE_TYPES = new String[]{"boolean", "int", "char", "byte", "short", "long", "float", "double", "Object", "String"};
    private static final String[] RVALUE_TYPES = new String[]{"void", "boolean", "int", "char", "byte", "short", "long", "float", "double", "Object", "String"};
    static final long serialVersionUID = 1423443523462351952L;
    private boolean acceptsVoid;

    public String getAsText() {
        Object val = this.getValue();
        return val == null ? "" : val.toString();
    }

    public void setAsText(String string) throws IllegalArgumentException {
        Type t;
        try {
            t = Type.parse(string);
        }
        catch (IllegalArgumentException ex) {
            ErrorManager.getDefault().annotate((Throwable)ex, 256, null, TypeEditor.getString("MSG_InvalidTypeDecl"), null, null);
            throw ex;
        }
        if (!this.acceptsVoid && t == Type.VOID) {
            ex = new IllegalArgumentException("Void not allowed");
            ErrorManager.getDefault().annotate((Throwable)ex, 256, null, TypeEditor.getString("MSG_VoidTypeNotPermitted"), null, null);
            throw ex;
        }
        this.setValue(t);
    }

    public void setValue(Object v) {
        if (v != null && !(v instanceof Type)) {
            throw new IllegalArgumentException();
        }
        super.setValue(v);
    }

    public String getJavaInitializationString() {
        return this.getAsText();
    }

    public String[] getTags() {
        return this.acceptsVoid ? RVALUE_TYPES : LVALUE_TYPES;
    }

    public Component getInPlaceCustomEditor() {
        return null;
    }

    public boolean hasInPlaceCustomEditor() {
        return false;
    }

    public boolean supportsEditingTaggedValues() {
        return true;
    }

    public void attachEnv(PropertyEnv env) {
        FeatureDescriptor desc = env.getFeatureDescriptor();
        Object o = desc.getValue("acceptVoidType");
        this.acceptsVoid = o instanceof Boolean ? (Boolean)o : true;
    }

    private static String getString(String key) {
        return NbBundle.getBundle((String)"org.openide.explorer.propertysheet.editors.Bundle2", (Locale)Locale.getDefault(), (ClassLoader)TypeEditor.class.getClassLoader()).getString(key);
    }
}

