/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src.nodes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.nodes.Node;
import org.openide.src.ConstructorElement;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.SourceException;
import org.openide.src.Type;
import org.openide.src.nodes.ElementBeanModel;
import org.openide.src.nodes.SourceEditSupport;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class MethodCustomizer
extends JPanel {
    static ResourceBundle bundle = NbBundle.getBundle((Class)MethodCustomizer.class);
    private static final String[] COMMON_TYPES = new String[]{"void", "String", "boolean", "char", "int", "long", "byte", "short", "float", "double"};
    ConstructorElement element;
    MethodElement method;
    boolean isOK = true;
    private JPanel methodPanel;
    private JLabel jLabel1;
    private JTextField nameTextField;
    private JLabel jLabel2;
    private JComboBox returnCombo;
    private JPanel jPanel1;
    private JPanel modifierPanel;
    private JPanel paramsPanel;
    private JPanel exceptionsPanel;

    public MethodCustomizer(ConstructorElement element) {
        this.element = element;
        this.method = element instanceof MethodElement ? (MethodElement)element : null;
        this.initComponents();
        this.methodPanel.setBorder(new CompoundBorder(new TitledBorder(bundle.getString("CTL_MethodFrame")), new EmptyBorder(new Insets(5, 5, 5, 5))));
        this.modifierPanel.setBorder(new TitledBorder(bundle.getString("CTL_Modifiers")));
        this.paramsPanel.setBorder(new TitledBorder(bundle.getString("CTL_Parameters")));
        this.exceptionsPanel.setBorder(new TitledBorder(bundle.getString("CTL_Exceptions")));
        PropertyPanel modifEditor = ElementBeanModel.createModifiersPanel(element);
        Node.Property fd = modifEditor.getProperty();
        String mnc = String.valueOf('\uffff');
        fd.setValue("ModifierPanel_Modifier_Abstract_Mnemonic", mnc);
        fd.setValue("ModifierPanel_Modifier_Final_Mnemonic", mnc);
        fd.setValue("ModifierPanel_Modifier_Static_Mnemonic", mnc);
        fd.setValue("ModifierPanel_Modifier_Synchronized_Mnemonic", mnc);
        fd.setValue("ModifierPanel_Modifier_Transient_Mnemonic", mnc);
        fd.setValue("ModifierPanel_Modifier_Volatile_Mnemonic", mnc);
        fd.setValue("ModifierPanel_Modifier_Native_Mnemonic", mnc);
        this.modifierPanel.add((Component)modifEditor, "Center");
        this.nameTextField.setText(element.getName().toString());
        if (this.method == null) {
            this.nameTextField.setEnabled(false);
            this.returnCombo.setEnabled(false);
        } else {
            this.returnCombo.setSelectedItem(this.method.getReturn().toString());
        }
        PropertyPanel paramsEditor = ElementBeanModel.createPropertyPanel(element, "parameters");
        fd = paramsEditor.getProperty();
        fd.setValue("mnemonic_Add", bundle.getString("CTL_Parameters_Mnemonic_Add"));
        fd.setValue("mnemonic_Remove", bundle.getString("CTL_Parameters_Mnemonic_Remove"));
        fd.setValue("mnemonic_Up", bundle.getString("CTL_Parameters_Mnemonic_Up"));
        fd.setValue("mnemonic_Down", bundle.getString("CTL_Parameters_Mnemonic_Down"));
        fd.setValue("mnemonic_Edit", bundle.getString("CTL_Parameters_Mnemonic_Edit"));
        this.paramsPanel.add((Component)paramsEditor, "Center");
        PropertyPanel exceptionsEditor = ElementBeanModel.createPropertyPanel(element, "exceptions");
        fd = exceptionsEditor.getProperty();
        fd.setValue("mnemonic_Add", bundle.getString("CTL_Exceptions_Mnemonic_Add"));
        fd.setValue("mnemonic_Remove", bundle.getString("CTL_Exceptions_Mnemonic_Remove"));
        fd.setValue("mnemonic_Up", bundle.getString("CTL_Exceptions_Mnemonic_Up"));
        fd.setValue("mnemonic_Down", bundle.getString("CTL_Exceptions_Mnemonic_Down"));
        fd.setValue("mnemonic_Edit", bundle.getString("CTL_Exceptions_Mnemonic_Edit"));
        this.exceptionsPanel.add((Component)exceptionsEditor, "Center");
        this.jLabel1.setDisplayedMnemonic(bundle.getString("CTL_Name_Mnemonic").charAt(0));
        this.jLabel2.setDisplayedMnemonic(bundle.getString("CTL_MethodType_Mnemonic").charAt(0));
        this.initAccessibility();
    }

    public void addNotify() {
        super.addNotify();
        int len = this.nameTextField.getText().length();
        this.nameTextField.setCaretPosition(0);
        this.nameTextField.moveCaretPosition(len);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MethodCustomizer.this.nameTextField.requestFocus();
            }
        });
    }

    private void initComponents() {
        this.methodPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.nameTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.returnCombo = new JComboBox<String>(COMMON_TYPES);
        this.jPanel1 = new JPanel();
        this.modifierPanel = new JPanel();
        this.paramsPanel = new JPanel();
        this.exceptionsPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(6, 6, 6, 6)));
        this.methodPanel.setLayout(new GridBagLayout());
        this.jLabel1.setText(bundle.getString("CTL_Name"));
        this.jLabel1.setLabelFor(this.nameTextField);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(10, 0, 8, 8);
        gridBagConstraints2.anchor = 13;
        this.methodPanel.add((Component)this.jLabel1, gridBagConstraints2);
        this.nameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                MethodCustomizer.this.nameTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(10, 0, 8, 0);
        gridBagConstraints2.weightx = 1.0;
        this.methodPanel.add((Component)this.nameTextField, gridBagConstraints2);
        this.jLabel2.setText(bundle.getString("CTL_ReturnType"));
        this.jLabel2.setLabelFor(this.returnCombo);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(0, 0, 0, 8);
        gridBagConstraints2.anchor = 13;
        this.methodPanel.add((Component)this.jLabel2, gridBagConstraints2);
        this.returnCombo.setEditable(true);
        this.returnCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MethodCustomizer.this.returnComboActionPerformed(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 1.0;
        this.methodPanel.add((Component)this.returnCombo, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 3;
        gridBagConstraints2.weighty = 1.0;
        this.methodPanel.add((Component)this.jPanel1, gridBagConstraints2);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weightx = 1.0;
        this.add((Component)this.methodPanel, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.modifierPanel, gridBagConstraints1);
        this.paramsPanel.setLayout(new BorderLayout());
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.add((Component)this.paramsPanel, gridBagConstraints1);
        this.exceptionsPanel.setLayout(new BorderLayout());
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.add((Component)this.exceptionsPanel, gridBagConstraints1);
    }

    private void returnComboActionPerformed(ActionEvent evt) {
        boolean ok;
        Type oldValue;
        block8: {
            if (this.method == null) {
                return;
            }
            Object selItem = this.returnCombo.getSelectedItem();
            oldValue = this.method.getReturn();
            ok = false;
            if (selItem != null) {
                try {
                    final Type newValue = Type.parse(selItem.toString());
                    if (!oldValue.equals(newValue)) {
                        try {
                            SourceEditSupport.runAsUser(this.method, new SourceEditSupport.ExceptionalRunnable(){

                                public void run() throws SourceException {
                                    MethodCustomizer.this.method.setReturn(newValue);
                                }
                            });
                            ok = true;
                        }
                        catch (SourceException e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                        break block8;
                    }
                    return;
                }
                catch (IllegalArgumentException e) {
                    ErrorManager.getDefault().annotate((Throwable)e, 256, null, bundle.getString("MSG_Not_Valid_Type"), null, null);
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        }
        this.isOK = ok;
        if (!ok) {
            this.returnCombo.setSelectedItem(oldValue.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void nameTextFieldFocusLost(FocusEvent evt) {
        if (evt != null && evt.isTemporary() || this.method == null) {
            return;
        }
        String newName = this.nameTextField.getText();
        String oldName = this.method.getName().toString();
        boolean ok = false;
        IllegalArgumentException x = null;
        if (Utilities.isJavaIdentifier((String)newName)) {
            if (oldName.equals(newName)) return;
            final Identifier id = Identifier.create(newName);
            try {
                SourceEditSupport.runAsUser(this.method, new SourceEditSupport.ExceptionalRunnable(){

                    public void run() throws SourceException {
                        MethodCustomizer.this.method.setName(id);
                    }
                });
                ok = true;
            }
            catch (SourceException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        } else {
            x = new IllegalArgumentException("Invalid name");
            ErrorManager.getDefault().annotate((Throwable)x, 256, null, bundle.getString("MSG_Not_Valid_Identifier"), null, null);
        }
        this.isOK = ok;
        if (!ok) {
            this.nameTextField.setText(oldName);
        }
        if (x == null) return;
        ErrorManager.getDefault().notify((Throwable)x);
    }

    private void initAccessibility() {
        this.nameTextField.getAccessibleContext().setAccessibleName(bundle.getString("ACS_MethodNameTextField"));
        this.nameTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_MethodNameTextField"));
        this.getAccessibleContext().setAccessibleDescription("ACSD_MethodCustomizerDialog");
    }

    public boolean isOK() {
        this.nameTextFieldFocusLost(null);
        this.returnComboActionPerformed(null);
        return this.isOK;
    }
}

