/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.palette.items;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.VariableAccess;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigUtilities;
import org.netbeans.modules.web.jsf.palette.JSFPaletteUtilities;
import org.netbeans.modules.web.jsf.palette.items.JsfFormCustomizer;
import org.netbeans.modules.web.jsf.palette.items.JsfTable;
import org.netbeans.modules.web.jsf.wizards.JSFClinetGenerator;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.ActiveEditorDrop;

public class JsfForm
implements ActiveEditorDrop {
    public static final int FORM_TYPE_EMPTY = 0;
    public static final int FORM_TYPE_DETAIL = 1;
    public static final int FORM_TYPE_NEW = 2;
    public static final int FORM_TYPE_EDIT = 3;
    private static String[] BEGIN = new String[]{"<h:form>\n", "<h2>Detail</h2>\n <h:form>\n<h:panelGrid columns=\"2\">\n", "<h2>Create</h2>\n <h:form>\n<h:panelGrid columns=\"2\">\n", "<h2>Edit</h2>\n <h:form>\n<h:panelGrid columns=\"2\">\n"};
    private static String[] END = new String[]{"</h:form>\n", "</h:panelGrid>\n </h:form>\n", "</h:panelGrid>\n </h:form>\n", "</h:panelGrid>\n </h:form>\n"};
    private static String[] ITEM = new String[]{"", "<h:outputText value=\"{0}:\"/>\n <h:outputText value=\"#'{'{1}.{2}}\" title=\"{0}\" />\n", "<h:outputText value=\"{0}:\"/>\n <h:inputText id=\"{2}\" value=\"#'{'{1}.{2}}\" title=\"{0}\" />\n", "<h:outputText value=\"{0}:\"/>\n <h:inputText id=\"{2}\" value=\"#'{'{1}.{2}}\" title=\"{0}\" />\n", "<h:outputText value=\"{0}:\"/>\n <h:selectOneMenu id=\"{2}\" value=\"#'{'{1}.{2}}\" title=\"{0}\">\n <f:selectItems value=\"#'{'{3}.{2}s'}'\"/>\n </h:selectOneMenu>\n", "<h:outputText value=\"{0} ({4}):\"/>\n <h:inputText id=\"{2}\" value=\"#'{'{1}.{2}}\" title=\"{0}\" >\n <f:convertDateTime type=\"{3}\" pattern=\"{4}\" />\n</h:inputText>\n", "<h:outputText value=\"{0}:\" rendered=\"#'{'{1}.{2} == null}\"/>\n <h:selectOneMenu id=\"{2}\" value=\"#'{'{1}.{2}}\" title=\"{0}\" rendered=\"#'{'{1}.{2} == null}\">\n <f:selectItems value=\"#'{'{3}.{2}s'}'\"/>\n </h:selectOneMenu>\n"};
    private String variable = "";
    private String bean = "";
    private int formType = 0;
    public static final int REL_NONE = 0;
    public static final int REL_TO_ONE = 1;
    public static final int REL_TO_MANY = 2;

    public boolean handleTransfer(JTextComponent targetComponent) {
        JsfFormCustomizer c = new JsfFormCustomizer(this, targetComponent);
        boolean accept = c.showDialog();
        if (accept) {
            try {
                Caret caret = targetComponent.getCaret();
                int p0 = Math.min(caret.getDot(), caret.getMark());
                int p1 = Math.max(caret.getDot(), caret.getMark());
                int len = targetComponent.getDocument().getLength() - p1;
                boolean containsFView = targetComponent.getText(0, p0).contains("<f:view>") && targetComponent.getText(p1, len).contains("</f:view>");
                String body = this.createBody(targetComponent, !containsFView);
                JSFPaletteUtilities.insert(body, targetComponent);
            }
            catch (BadLocationException ble) {
                accept = false;
            }
        }
        return accept;
    }

    private String createBody(JTextComponent target, boolean surroundWithFView) {
        StringBuffer sb = new StringBuffer();
        if (surroundWithFView) {
            sb.append("<f:view>\n");
        }
        sb.append(MessageFormat.format(BEGIN[this.formType], this.variable));
        JavaClass jc = JsfForm.resolveJavaClass(target, this.bean);
        if (jc != null) {
            JsfForm.createForm(jc, this.formType, this.variable, sb, false);
        }
        sb.append(END[this.formType]);
        if (surroundWithFView) {
            sb.append("</f:view>\n");
        }
        return sb.toString();
    }

    public static int isRelationship(Method m, boolean isFieldAccess) {
        Method f;
        Object object = f = isFieldAccess ? JsfForm.guessField(m) : m;
        if (f != null) {
            for (Annotation an : f.getAnnotations()) {
                if ("javax.persistence.OneToOne".equals(an.getType().getName()) || "javax.persistence.ManyToOne".equals(an.getType().getName())) {
                    return 1;
                }
                if (!"javax.persistence.OneToMany".equals(an.getType().getName()) && !"javax.persistence.ManyToMany".equals(an.getType().getName())) continue;
                return 2;
            }
        }
        return 0;
    }

    public static Method getOtherSideOfRelation(Method m, boolean isFieldAccess) {
        Type type = m.getType();
        if (type instanceof ParameterizedType) {
            MultipartId id = (MultipartId)m.getTypeName();
            for (MultipartId param : id.getTypeArguments()) {
                NamedElement parType = param.getElement();
                if (!(param instanceof JavaClass)) continue;
                type = (JavaClass)param;
            }
        }
        if (type instanceof JavaClass) {
            JavaClass jc = (JavaClass)type;
            for (Method method : JsfForm.getEntityMethods(jc)) {
                Type t = method.getType();
                if (t instanceof ParameterizedType) {
                    MultipartId id = (MultipartId)method.getTypeName();
                    for (MultipartId param : id.getTypeArguments()) {
                        NamedElement parType = param.getElement();
                        if (!(param instanceof JavaClass)) continue;
                        t = (JavaClass)param;
                        break;
                    }
                }
                if (!(t instanceof JavaClass) || !m.getDeclaringClass().getName().equals(t.getName())) continue;
                return method;
            }
        }
        return null;
    }

    public static Method[] getEntityMethods(JavaClass clazz) {
        LinkedList<Method> result = new LinkedList<Method>();
        for (JavaClass jc = clazz; jc != null; jc = jc.getSuperClass()) {
            boolean isEntityOrMapped = false;
            for (Annotation ann : jc.getAnnotations()) {
                String annName;
                if (ann == null || ann.getType() == null || !"javax.persistence.Entity".equals(annName = ann.getType().getName()) && !"javax.persistence.MappedSuperclass".equals(annName)) continue;
                isEntityOrMapped = true;
                break;
            }
            if (!isEntityOrMapped) continue;
            List features = jc.getFeatures();
            for (Object o : features) {
                if (!(o instanceof Method)) continue;
                result.add((Method)o);
            }
        }
        return result.toArray(new Method[result.size()]);
    }

    static boolean isId(Method m, boolean isFieldAccess) {
        Method f;
        Object object = f = isFieldAccess ? JsfForm.guessField(m) : m;
        if (f != null) {
            for (Annotation an : f.getAnnotations()) {
                String annName = an.getType().getName();
                if (!"javax.persistence.Id".equals(annName) && !"javax.persistence.EmbeddedId".equals(annName)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isGenerated(Method m, boolean isFieldAccess) {
        Method f;
        Object object = f = isFieldAccess ? JsfForm.guessField(m) : m;
        if (f != null) {
            for (Annotation an : f.getAnnotations()) {
                if (!"javax.persistence.GeneratedValue".equals(an.getType().getName())) continue;
                return true;
            }
        }
        return false;
    }

    static String getTemporal(Method m, boolean isFieldAccess) {
        Method f;
        Object object = f = isFieldAccess ? JsfForm.guessField(m) : m;
        if (f != null) {
            for (Annotation an : f.getAnnotations()) {
                AttributeValue temporalValue;
                if (!"javax.persistence.Temporal".equals(an.getType().getName()) || (temporalValue = (AttributeValue)an.getAttributeValues().get(0)) == null) continue;
                VariableAccess va = (VariableAccess)temporalValue.getValue();
                String temporal = va.getElement().getName();
                return temporal;
            }
        }
        return null;
    }

    static FileObject getFO(JTextComponent target) {
        DataObject dobj;
        Document doc = target.getDocument();
        if (doc != null && (dobj = NbEditorUtilities.getDataObject((Document)doc)) != null) {
            return dobj.getPrimaryFile();
        }
        return null;
    }

    static ClassPath getFullClasspath(FileObject fo) {
        ArrayList entries = new ArrayList();
        ArrayList<URL> urls = new ArrayList<URL>();
        entries.addAll(ClassPath.getClassPath((FileObject)fo, (String)"classpath/source").entries());
        entries.addAll(ClassPath.getClassPath((FileObject)fo, (String)"classpath/boot").entries());
        entries.addAll(ClassPath.getClassPath((FileObject)fo, (String)"classpath/compile").entries());
        for (ClassPath.Entry e : entries) {
            urls.add(e.getURL());
        }
        return ClassPathSupport.createClassPath((URL[])urls.toArray(new URL[urls.size()]));
    }

    public static JavaClass resolveJavaClass(FileObject foInClassPath, String bean) {
        JavaClass clazzAnywhere;
        JavaClass jc = JMIUtils.findClass((String)bean, (ClassPath)JsfForm.getFullClasspath(foInClassPath));
        if (jc == null && (clazzAnywhere = JMIUtils.findClass((String)bean)) != null) {
            Project projectWithEntity = FileOwnerQuery.getOwner((FileObject)JavaModel.getFileObject((Resource)clazzAnywhere.getResource()));
            Project project = FileOwnerQuery.getOwner((FileObject)foInClassPath);
            ProjectClassPathExtender pcpe = (ProjectClassPathExtender)project.getLookup().lookup(ProjectClassPathExtender.class);
            AntArtifact[] artifact = AntArtifactQuery.findArtifactsByType((Project)projectWithEntity, (String)"jar");
            try {
                if (artifact.length > 0) {
                    pcpe.addAntArtifact(artifact[0], artifact[0].getArtifactLocations()[0]);
                }
                jc = JMIUtils.findClass((String)bean, (ClassPath)JsfForm.getFullClasspath(foInClassPath));
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return jc;
    }

    static JavaClass resolveJavaClass(JTextComponent target, String bean) {
        DataObject dobj;
        Document doc = target.getDocument();
        if (doc != null && (dobj = NbEditorUtilities.getDataObject((Document)doc)) != null) {
            return JsfForm.resolveJavaClass(dobj.getPrimaryFile(), bean);
        }
        return null;
    }

    static boolean hasModuleJsf(JTextComponent target) {
        FileObject f = JsfForm.getFO(target);
        if (f != null) {
            WebModule wm = WebModule.getWebModule((FileObject)f);
            String[] configFiles = JSFConfigUtilities.getConfigFiles(wm.getDeploymentDescriptor());
            return configFiles != null && configFiles.length > 0;
        }
        return false;
    }

    public static boolean isEntityClass(JavaClass jc) {
        for (Annotation ann : jc.getAnnotations()) {
            if (!"javax.persistence.Entity".equals(ann.getType().getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmbeddableClass(JavaClass jc) {
        for (Annotation ann : jc.getAnnotations()) {
            if (!"javax.persistence.Embeddable".equals(ann.getType().getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isFieldAccess(JavaClass clazz) {
        boolean fieldAccess = false;
        boolean accessTypeDetected = false;
        for (JavaClass jc = clazz; jc != null; jc = jc.getSuperClass()) {
            List features = jc.getFeatures();
            Iterator featuresIter = features.iterator();
            while (featuresIter.hasNext() && !accessTypeDetected) {
                Feature feature = (Feature)featuresIter.next();
                Iterator it = feature.getAnnotations().iterator();
                while (it.hasNext() && !accessTypeDetected) {
                    String annName;
                    Annotation ann = (Annotation)it.next();
                    if (ann == null || ann.getType() == null || !"javax.persistence.Id".equals(annName = ann.getType().getName()) && !"javax.persistence.EmbeddedId".equals(annName)) continue;
                    if (feature instanceof Field) {
                        fieldAccess = true;
                    }
                    accessTypeDetected = true;
                }
            }
            if (accessTypeDetected) continue;
            ErrorManager.getDefault().log(16, "Failed to detect correct access type for class:" + jc.getName());
        }
        return fieldAccess;
    }

    public static Field guessField(Method getter) {
        String name = getter.getName().substring(3);
        String guessFieldName = name.substring(0, 1).toLowerCase() + name.substring(1);
        for (Feature feature : getter.getDeclaringClass().getFeatures()) {
            if (!guessFieldName.equals(feature.getName()) || !(feature instanceof Field)) continue;
            return (Field)feature;
        }
        ErrorManager.getDefault().log(16, "Cannot detect the field associated with property: " + guessFieldName);
        return null;
    }

    public static boolean isReadOnly(Method getter) {
        String setterName = "set" + getter.getName().substring(3);
        Type propertyType = getter.getType();
        for (Feature feature : getter.getDeclaringClass().getFeatures()) {
            Parameter firstParam;
            Method setter;
            if (!setterName.equals(feature.getName()) || !(feature instanceof Method) || (setter = (Method)feature).getParameters().size() != 1 || !(firstParam = (Parameter)setter.getParameters().get(0)).getType().equals(propertyType)) continue;
            return false;
        }
        return true;
    }

    static String getDateTimeFormat(String temporal) {
        if ("DATE".equals(temporal)) {
            return "MM/dd/yyyy";
        }
        if ("TIME".equals(temporal)) {
            return "hh:mm:ss";
        }
        return "MM/dd/yyyy, hh:mm:ss";
    }

    public static void createForm(JavaClass bean, int formType, String variable, StringBuffer sb, boolean createSelectForRel) {
        Method[] methods = JsfForm.getEntityMethods(bean);
        boolean fieldAccess = JsfForm.isFieldAccess(bean);
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().startsWith("get")) continue;
            int isRelationship = JsfForm.isRelationship(methods[i], fieldAccess);
            String name = methods[i].getName().substring(3);
            String propName = JSFClinetGenerator.getPropNameFromMethod(methods[i].getName());
            if (formType == 2 && (JsfForm.isId(methods[i], fieldAccess) && JsfForm.isGenerated(methods[i], fieldAccess) || JsfForm.isReadOnly(methods[i]))) continue;
            if (formType == 3 && (JsfForm.isId(methods[i], fieldAccess) || JsfForm.isReadOnly(methods[i]))) {
                sb.append(MessageFormat.format(ITEM[1], name, variable, propName));
                continue;
            }
            if ((formType == 2 || formType == 3) && "java.util.Date".equals(methods[i].getType().getName())) {
                String temporal = JsfForm.getTemporal(methods[i], fieldAccess);
                if (temporal == null) {
                    sb.append(MessageFormat.format(ITEM[formType], name, variable, propName));
                    continue;
                }
                sb.append(MessageFormat.format(ITEM[5], name, variable, propName, temporal, JsfForm.getDateTimeFormat(temporal)));
                continue;
            }
            if (formType == 1 && isRelationship == 1 || isRelationship == 0) {
                sb.append(MessageFormat.format(ITEM[formType], name, variable, propName));
                continue;
            }
            if (isRelationship != 1) continue;
            sb.append(MessageFormat.format(formType == 3 ? ITEM[4] : ITEM[6], name, variable, propName, variable.substring(0, variable.lastIndexOf(46))));
        }
    }

    public static void createTablesForRelated(JavaClass bean, int formType, String variable, String idProperty, boolean isInjection, StringBuffer sb) {
        Method[] methods = JsfForm.getEntityMethods(bean);
        String simpleClass = JSFClinetGenerator.simpleClassName(bean.getName());
        String managedBean = JSFClinetGenerator.getManagedBeanName(simpleClass);
        boolean fieldAccess = JsfForm.isFieldAccess(bean);
        if (formType == 1) {
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().startsWith("get")) continue;
                int isRelationship = JsfForm.isRelationship(methods[i], fieldAccess);
                String name = methods[i].getName().substring(3);
                String methodName = methods[i].getName();
                String propName = JSFClinetGenerator.getPropNameFromMethod(methodName);
                if (isRelationship != 2) continue;
                Method otherSide = JsfForm.getOtherSideOfRelation(methods[i], fieldAccess);
                int otherSideMultiplicity = 1;
                if (otherSide != null) {
                    JavaClass relClass = (JavaClass)otherSide.getDeclaringClass();
                    boolean isRelFieldAccess = JsfForm.isFieldAccess(relClass);
                    otherSideMultiplicity = JsfForm.isRelationship(otherSide, isRelFieldAccess);
                }
                MultipartId id = (MultipartId)methods[i].getTypeName();
                JavaClass jc = null;
                for (MultipartId param : id.getTypeArguments()) {
                    NamedElement parType = param.getElement();
                    if (!(param instanceof JavaClass)) continue;
                    jc = (JavaClass)param;
                    break;
                }
                if (jc != null) {
                    boolean relatedIsFieldAccess = JsfForm.isFieldAccess(jc);
                    String relatedIdProperty = JSFClinetGenerator.getPropNameFromMethod(JsfForm.getIdGetter(relatedIsFieldAccess, jc).getName());
                    String relatedClass = JSFClinetGenerator.simpleClassName(jc.getName());
                    String relatedManagedBean = JSFClinetGenerator.getManagedBeanName(relatedClass);
                    String detailManagedBean = JSFClinetGenerator.simpleClassName(bean.getName());
                    sb.append("<h2>List of " + name + "</h2>\n");
                    sb.append("<h:outputText rendered=\"#{not " + relatedManagedBean + ".detail" + relatedClass + "s.rowAvailable}\" value=\"No " + name + "\"/><br>\n");
                    sb.append("<h:dataTable value=\"#{" + relatedManagedBean + ".detail" + relatedClass + "s}\" var=\"item\" \n");
                    sb.append("border=\"1\" cellpadding=\"2\" cellspacing=\"0\" \n rendered=\"#{not empty " + relatedManagedBean + ".detail" + relatedClass + "s}\">\n");
                    String removeItems = "remove" + methodName.substring(3);
                    String commands = " <h:column>\n <h:commandLink value=\"Destroy\" action=\"#'{'" + relatedManagedBean + ".destroyFrom" + detailManagedBean + "'}'\">\n" + "<f:param name=\"" + relatedIdProperty + "\" value=\"#'{'{0}." + relatedIdProperty + "'}'\"/>\n" + "<f:param name=\"relatedId\" value=\"#'{'" + variable + "." + idProperty + "'}'\"/>\n" + "</h:commandLink>\n  <h:outputText value=\" \"/>\n" + " <h:commandLink value=\"Edit\" action=\"#'{'" + relatedManagedBean + ".editSetup'}'\">\n" + "<f:param name=\"" + relatedIdProperty + "\" value=\"#'{'{0}." + relatedIdProperty + "'}'\"/>\n" + "<h:outputText value=\" \"/>\n </h:commandLink>\n" + (otherSideMultiplicity == 2 ? "<h:commandLink value=\"Remove\" action=\"#'{'" + managedBean + "." + removeItems + "'}'\"/>" : "") + "</h:column>\n";
                    JsfTable.createTable(jc, variable + "." + propName, sb, commands, "detailSetup");
                    sb.append("</h:dataTable>\n");
                    if (otherSideMultiplicity == 2) {
                        sb.append("<br>\n Add " + relatedClass + "s:\n <br>\n");
                        String itemsToAdd = JSFClinetGenerator.getPropNameFromMethod(methodName + "ToAdd");
                        sb.append("<h:selectManyListbox id=\"add" + relatedClass + "s\" value=\"#{" + managedBean + "." + itemsToAdd + "}\" title=\"Add " + name + ":\">\n");
                        String availableItems = JSFClinetGenerator.getPropNameFromMethod(methodName + "Available");
                        sb.append("<f:selectItems value=\"#{" + managedBean + "." + availableItems + "}\"/>\n");
                        sb.append("</h:selectManyListbox>\n");
                        String addItems = "add" + methodName.substring(3);
                        sb.append("<h:commandButton value=\"Add\" action=\"#{" + managedBean + "." + addItems + "}\"/>\n <br>\n");
                    }
                    sb.append("<h:commandLink value=\"New " + name + "\" action=\"#{" + relatedManagedBean + ".createFrom" + detailManagedBean + "Setup}\">\n");
                    sb.append("<f:param name=\"relatedId\" value=\"#{" + variable + "." + idProperty + "}\"/>\n");
                    sb.append("</h:commandLink>\n <br>\n <br>\n");
                    continue;
                }
                ErrorManager.getDefault().log(1, "cannot find referenced class: " + methods[i].getType().getName());
            }
        }
    }

    public static Method getIdGetter(boolean isFieldAccess, JavaClass jc) {
        Method[] m = JsfForm.getEntityMethods(jc);
        for (int j = 0; j < m.length; ++j) {
            Method f;
            if (!m[j].getName().startsWith("get")) continue;
            Object object = f = isFieldAccess ? JsfForm.guessField(m[j]) : m[j];
            if (f == null) continue;
            for (Annotation ann : f.getAnnotations()) {
                String annName;
                if (ann == null || !"javax.persistence.Id".equals(annName = ann.getType().getName()) && !"javax.persistence.EmbeddedId".equals(annName)) continue;
                return m[j];
            }
        }
        ErrorManager.getDefault().log(16, "Cannot find ID getter in class: " + jc.getName());
        return null;
    }

    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public String getBean() {
        return this.bean;
    }

    public void setBean(String collection) {
        this.bean = collection;
    }

    public int getFormType() {
        return this.formType;
    }

    public void setFormType(int formType) {
        this.formType = formType;
    }
}

