/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.refactoring;

import java.util.List;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.netbeans.modules.web.jsf.refactoring.Occurrences;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;

public class JSFSafeDeletePlugin
implements RefactoringPlugin {
    private static ThreadLocal semafor = new ThreadLocal();
    private SafeDeleteRefactoring refactoring;
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.web.jsf.refactoring");

    public JSFSafeDeletePlugin(SafeDeleteRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        if (semafor.get() == null) {
            semafor.set(new Object());
            Element[] elements = this.refactoring.getElementsToDelete();
            for (int i = 0; i < elements.length; ++i) {
                if (!(elements[i] instanceof JavaClass)) continue;
                JavaClass jClass = (JavaClass)elements[i];
                List<Occurrences.OccurrenceItem> items = Occurrences.getAllOccurrences(jClass, "");
                for (Occurrences.OccurrenceItem item : items) {
                    refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new JSFSafeDeleteClassElement(item));
                }
            }
            semafor.set(null);
        }
        return null;
    }

    public static class JSFSafeDeleteClassElement
    extends SimpleRefactoringElementImpl
    implements ExternalChange {
        private Occurrences.OccurrenceItem item;

        JSFSafeDeleteClassElement(Occurrences.OccurrenceItem item) {
            this.item = item;
        }

        public String getText() {
            return this.getDisplayText();
        }

        public String getDisplayText() {
            return this.item.getRenameMessage();
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            this.item.performSafeDelete();
        }

        public void undoExternalChange() {
            this.item.undoSafeDelete();
        }

        public Element getJavaElement() {
            return null;
        }

        public FileObject getParentFile() {
            return this.item.getConfigDO().getPrimaryFile();
        }

        public PositionBounds getPosition() {
            return this.item.getElementDefinitionPosition();
        }
    }
}

