/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.history;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.ui.actions.log.SearchHistoryAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.GetCleanAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.history.RevisionNode;
import org.netbeans.modules.versioning.system.cvss.ui.history.SearchHistoryPanel;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.ErrorManager;
import org.openide.cookies.ViewCookie;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class SummaryView
implements MouseListener,
ComponentListener,
MouseMotionListener {
    private final SearchHistoryPanel master;
    private JList resultsList;
    private JScrollPane scrollPane;
    private final List dispResults;
    private String message;
    private AttributeSet searchHiliteAttrs;

    public SummaryView(SearchHistoryPanel master, List results) {
        this.master = master;
        this.dispResults = this.expandResults(results);
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getMimeLookup((String)"text/x-java").lookup(FontColorSettings.class);
        this.searchHiliteAttrs = fcs.getFontColors("highlight-search");
        this.message = master.getCriteria().getCommitMessage();
        this.resultsList = new JList(new SummaryListModel());
        this.resultsList.setFixedCellHeight(-1);
        this.resultsList.addMouseListener(this);
        this.resultsList.addMouseMotionListener(this);
        this.resultsList.setCellRenderer(new SummaryCellRenderer());
        this.resultsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)SummaryView.class, (String)"ACSN_SummaryView_List"));
        this.resultsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)SummaryView.class, (String)"ACSD_SummaryView_List"));
        this.scrollPane = new JScrollPane(this.resultsList, 22, 31);
        master.addComponentListener(this);
    }

    public void componentResized(ComponentEvent e) {
        int[] selection = this.resultsList.getSelectedIndices();
        this.resultsList.setModel(new SummaryListModel());
        this.resultsList.setSelectedIndices(selection);
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    private List expandResults(List results) {
        ArrayList newResults = new ArrayList(results.size());
        Iterator i = results.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof SearchHistoryPanel.ResultsContainer) {
                SearchHistoryPanel.DispRevision revision;
                newResults.add(o);
                SearchHistoryPanel.ResultsContainer container = (SearchHistoryPanel.ResultsContainer)o;
                Iterator j = container.getRevisions().iterator();
                while (j.hasNext()) {
                    revision = (SearchHistoryPanel.DispRevision)j.next();
                    newResults.add(revision);
                }
                j = container.getRevisions().iterator();
                while (j.hasNext()) {
                    revision = (SearchHistoryPanel.DispRevision)j.next();
                    this.addResults(newResults, revision, 1);
                }
                continue;
            }
            newResults.add(o);
            this.addResults(newResults, (SearchHistoryPanel.DispRevision)o, 0);
        }
        return newResults;
    }

    private void addResults(ArrayList newResults, SearchHistoryPanel.DispRevision dispRevision, int indentation) {
        dispRevision.setIndentation(indentation);
        List children = dispRevision.getChildren();
        if (children != null) {
            SearchHistoryPanel.DispRevision revision;
            Iterator i = children.iterator();
            while (i.hasNext()) {
                revision = (SearchHistoryPanel.DispRevision)i.next();
                newResults.add(revision);
            }
            i = children.iterator();
            while (i.hasNext()) {
                revision = (SearchHistoryPanel.DispRevision)i.next();
                this.addResults(newResults, revision, indentation + 1);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        int idx = this.resultsList.locationToIndex(e.getPoint());
        if (idx == -1) {
            return;
        }
        Rectangle rect = this.resultsList.getCellBounds(idx, idx);
        Point p = new Point(e.getX() - rect.x, e.getY() - rect.y);
        Rectangle diffBounds = (Rectangle)this.resultsList.getClientProperty("Summary-Diff-" + idx);
        if (diffBounds != null && diffBounds.contains(p)) {
            this.diffPrevious(idx);
        }
        if ((diffBounds = (Rectangle)this.resultsList.getClientProperty("Summary-Acp-" + idx)) != null && diffBounds.contains(p)) {
            this.associatedChangesInProject(idx);
        }
        if ((diffBounds = (Rectangle)this.resultsList.getClientProperty("Summary-Acop-" + idx)) != null && diffBounds.contains(p)) {
            this.associatedChangesInOpenProjects(idx);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.onPopup(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.onPopup(e);
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        int idx = this.resultsList.locationToIndex(e.getPoint());
        if (idx == -1) {
            return;
        }
        Rectangle rect = this.resultsList.getCellBounds(idx, idx);
        Point p = new Point(e.getX() - rect.x, e.getY() - rect.y);
        Rectangle diffBounds = (Rectangle)this.resultsList.getClientProperty("Summary-Diff-" + idx);
        if (diffBounds != null && diffBounds.contains(p)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        diffBounds = (Rectangle)this.resultsList.getClientProperty("Summary-Acp-" + idx);
        if (diffBounds != null && diffBounds.contains(p)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        diffBounds = (Rectangle)this.resultsList.getClientProperty("Summary-Acop-" + idx);
        if (diffBounds != null && diffBounds.contains(p)) {
            this.resultsList.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        this.resultsList.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void onPopup(MouseEvent e) {
        int[] sel = this.resultsList.getSelectedIndices();
        if (sel.length == 0) {
            int idx = this.resultsList.locationToIndex(e.getPoint());
            if (idx == -1) {
                return;
            }
            this.resultsList.setSelectedIndex(idx);
            sel = new int[]{idx};
        }
        final int[] selection = sel;
        JPopupMenu menu = new JPopupMenu();
        String previousRevision = null;
        SearchHistoryPanel.ResultsContainer container = null;
        SearchHistoryPanel.DispRevision drev = null;
        Object revCon = this.dispResults.get(selection[0]);
        if (revCon instanceof SearchHistoryPanel.ResultsContainer) {
            container = (SearchHistoryPanel.ResultsContainer)this.dispResults.get(selection[0]);
        } else {
            drev = (SearchHistoryPanel.DispRevision)this.dispResults.get(selection[0]);
            previousRevision = Utils.previousRevision(drev.getRevision().getNumber().trim());
        }
        if (container != null) {
            String eldest = container.getEldestRevision();
            if (eldest == null) {
                eldest = ((SearchHistoryPanel.DispRevision)container.getRevisions().get(container.getRevisions().size() - 1)).getRevision().getNumber();
            }
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage((Class)SummaryView.class, (String)"CTL_SummaryView_Diff", (Object)eldest, (Object)container.getNewestRevision())){

                public void actionPerformed(ActionEvent e) {
                    SummaryView.this.diffPrevious(selection[0]);
                }
            }));
        } else if (previousRevision != null) {
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage((Class)SummaryView.class, (String)"CTL_SummaryView_DiffToPrevious", (Object)previousRevision)){
                {
                    super(x0);
                    this.setEnabled(selection.length == 1 && SummaryView.this.dispResults.get(selection[0]) instanceof SearchHistoryPanel.DispRevision);
                }

                public void actionPerformed(ActionEvent e) {
                    SummaryView.this.diffPrevious(selection[0]);
                }
            }));
        }
        menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage((Class)SummaryView.class, (String)"CTL_SummaryView_RollbackChange")){
            {
                super(x0);
                this.setEnabled(SummaryView.this.someRevisions(selection));
            }

            public void actionPerformed(ActionEvent e) {
                SummaryView.this.rollbackChange(selection);
            }
        }));
        if (drev != null) {
            Project prj;
            if (!"dead".equals(drev.getRevision().getState())) {
                menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage((Class)SummaryView.class, (String)"CTL_SummaryView_RollbackTo", (Object)drev.getRevision().getNumber())){
                    {
                        super(x0);
                        this.setEnabled(selection.length == 1 && SummaryView.this.dispResults.get(selection[0]) instanceof SearchHistoryPanel.DispRevision);
                    }

                    public void actionPerformed(ActionEvent e) {
                        SummaryView.this.rollback(selection[0]);
                    }
                }));
                menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage((Class)SummaryView.class, (String)"CTL_SummaryView_View", (Object)drev.getRevision().getNumber())){
                    {
                        super(x0);
                        this.setEnabled(selection.length == 1 && SummaryView.this.dispResults.get(selection[0]) instanceof SearchHistoryPanel.DispRevision);
                    }

                    public void actionPerformed(ActionEvent e) {
                        RequestProcessor.getDefault().post(new Runnable(){

                            public void run() {
                                SummaryView.this.view(selection[0]);
                            }
                        });
                    }
                }));
            }
            if ((prj = Utils.getProject(drev.getRevision().getLogInfoHeader().getFile())) != null) {
                String prjName = ProjectUtils.getInformation((Project)prj).getDisplayName();
                menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage((Class)SummaryView.class, (String)"CTL_Action_AssociateChangesInProject", (Object)prjName)){
                    {
                        super(x0);
                        this.setEnabled(selection.length == 1 && SummaryView.this.dispResults.get(selection[0]) instanceof SearchHistoryPanel.DispRevision);
                    }

                    public void actionPerformed(ActionEvent e) {
                        SummaryView.this.associatedChangesInProject(selection[0]);
                    }
                }));
            }
            menu.add(new JMenuItem(new AbstractAction(NbBundle.getMessage((Class)SummaryView.class, (String)"CTL_Action_AssociateChangesInOpenProjects")){
                {
                    super(x0);
                    this.setEnabled(selection.length == 1 && SummaryView.this.dispResults.get(selection[0]) instanceof SearchHistoryPanel.DispRevision);
                }

                public void actionPerformed(ActionEvent e) {
                    SummaryView.this.associatedChangesInOpenProjects(selection[0]);
                }
            }));
        }
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    private boolean someRevisions(int[] selection) {
        for (int i = 0; i < selection.length; ++i) {
            Object revCon = this.dispResults.get(selection[i]);
            if (!(revCon instanceof SearchHistoryPanel.DispRevision)) continue;
            return true;
        }
        return false;
    }

    private void rollbackChange(int[] selection) {
        ArrayList<LogInformation.Revision> changes = new ArrayList<LogInformation.Revision>();
        for (int i = 0; i < selection.length; ++i) {
            int idx = selection[i];
            Object o = this.dispResults.get(idx);
            if (!(o instanceof SearchHistoryPanel.DispRevision)) continue;
            SearchHistoryPanel.DispRevision drev = (SearchHistoryPanel.DispRevision)o;
            changes.add(drev.getRevision());
        }
        SummaryView.rollbackChanges(changes.toArray(new LogInformation.Revision[changes.size()]));
    }

    private static void rollbackChange(LogInformation.Revision change, ExecutorGroup group) {
        UpdateCommand cmd = new UpdateCommand();
        cmd.setFiles(new File[]{change.getLogInfoHeader().getFile()});
        cmd.setMergeRevision1(change.getNumber());
        cmd.setMergeRevision2(Utils.previousRevision(change.getNumber()));
        group.addExecutors(UpdateExecutor.splitCommand(cmd, CvsVersioningSystem.getInstance(), null));
    }

    static void rollbackChanges(LogInformation.Revision[] changes) {
        ExecutorGroup group = new ExecutorGroup(NbBundle.getMessage((Class)SummaryView.class, (String)"MSG_SummaryView_RollingBackChange"));
        for (int i = 0; i < changes.length; ++i) {
            SummaryView.rollbackChange(changes[i], group);
        }
        group.execute();
    }

    private void rollback(int idx) {
        Object o = this.dispResults.get(idx);
        if (o instanceof SearchHistoryPanel.DispRevision) {
            SearchHistoryPanel.DispRevision drev = (SearchHistoryPanel.DispRevision)o;
            String revision = drev.getRevision().getNumber().trim();
            File file = drev.getRevision().getLogInfoHeader().getFile();
            GetCleanAction.rollback(file, revision);
        }
    }

    private void view(int idx) {
        Object o = this.dispResults.get(idx);
        if (o instanceof SearchHistoryPanel.DispRevision) {
            SearchHistoryPanel.DispRevision drev = (SearchHistoryPanel.DispRevision)o;
            String revision = drev.getRevision().getNumber().trim();
            ViewCookie view = (ViewCookie)new RevisionNode(drev).getCookie(ViewCookie.class);
            if (view != null) {
                view.view();
            }
        }
    }

    private void diffPrevious(int idx) {
        Object o = this.dispResults.get(idx);
        if (o instanceof SearchHistoryPanel.DispRevision) {
            SearchHistoryPanel.DispRevision drev = (SearchHistoryPanel.DispRevision)o;
            this.master.showDiff(drev);
        } else {
            SearchHistoryPanel.ResultsContainer container = (SearchHistoryPanel.ResultsContainer)o;
            this.master.showDiff(container);
        }
    }

    private void associatedChangesInOpenProjects(int idx) {
        Object o = this.dispResults.get(idx);
        if (o instanceof SearchHistoryPanel.DispRevision) {
            SearchHistoryPanel.DispRevision drev = (SearchHistoryPanel.DispRevision)o;
            Project[] projects = OpenProjects.getDefault().getOpenProjects();
            int n = projects.length;
            SearchHistoryAction.openSearch(n == 1 ? ProjectUtils.getInformation((Project)projects[0]).getDisplayName() : NbBundle.getMessage((Class)SummaryView.class, (String)"CTL_FindAssociateChanges_OpenProjects_Title", (Object)Integer.toString(n)), drev.getRevision().getMessage().trim(), drev.getRevision().getAuthor(), drev.getRevision().getDate());
        }
    }

    private void associatedChangesInProject(int idx) {
        Object o = this.dispResults.get(idx);
        if (o instanceof SearchHistoryPanel.DispRevision) {
            SearchHistoryPanel.DispRevision drev = (SearchHistoryPanel.DispRevision)o;
            File file = drev.getRevision().getLogInfoHeader().getFile();
            Project project = Utils.getProject(file);
            Context context = Utils.getProjectsContext(new Project[]{Utils.getProject(file)});
            SearchHistoryAction.openSearch(context, ProjectUtils.getInformation((Project)project).getDisplayName(), drev.getRevision().getMessage().trim(), drev.getRevision().getAuthor(), drev.getRevision().getDate());
        }
    }

    public JComponent getComponent() {
        return this.scrollPane;
    }

    private static class HyperlinkLabel
    extends JLabel {
        public HyperlinkLabel(String text, Color foreground, Color background) {
            if (foreground.equals(UIManager.getColor("List.foreground"))) {
                this.setText("<html><a href=\"\">" + text + "</a></html>");
            } else {
                String clr = "rgb(" + foreground.getRed() + "," + foreground.getGreen() + "," + foreground.getBlue() + ")";
                this.setText("<html><a href=\"\" style=\"color:" + clr + "\">" + text + "</a></html>");
            }
            this.setBackground(background);
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    private class SummaryCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final String FIELDS_SEPARATOR = "        ";
        private static final double DARKEN_FACTOR = 0.95;
        private Style selectedStyle;
        private Style normalStyle;
        private Style filenameStyle;
        private Style indentStyle;
        private Style noindentStyle;
        private Style hiliteStyle;
        private JTextPane textPane = new JTextPane();
        private JPanel actionsPane = new JPanel();
        private DateFormat defaultFormat;
        private int index;
        private HyperlinkLabel diffLink;
        private HyperlinkLabel acpLink;
        private HyperlinkLabel acopLink;

        public SummaryCellRenderer() {
            this.selectedStyle = this.textPane.addStyle("selected", null);
            StyleConstants.setForeground(this.selectedStyle, UIManager.getColor("List.selectionForeground"));
            this.normalStyle = this.textPane.addStyle("normal", null);
            StyleConstants.setForeground(this.normalStyle, UIManager.getColor("List.foreground"));
            this.filenameStyle = this.textPane.addStyle("filename", this.normalStyle);
            StyleConstants.setBold(this.filenameStyle, true);
            this.indentStyle = this.textPane.addStyle("indent", null);
            StyleConstants.setLeftIndent(this.indentStyle, 50.0f);
            this.noindentStyle = this.textPane.addStyle("noindent", null);
            StyleConstants.setLeftIndent(this.noindentStyle, 0.0f);
            this.defaultFormat = DateFormat.getDateTimeInstance();
            this.hiliteStyle = this.textPane.addStyle("hilite", this.normalStyle);
            StyleConstants.setBackground(this.hiliteStyle, (Color)SummaryView.this.searchHiliteAttrs.getAttribute(StyleConstants.Background));
            StyleConstants.setForeground(this.hiliteStyle, (Color)SummaryView.this.searchHiliteAttrs.getAttribute(StyleConstants.Foreground));
            this.setLayout(new BorderLayout());
            this.add(this.textPane);
            this.add((Component)this.actionsPane, "Last");
            this.actionsPane.setLayout(new FlowLayout(4, 2, 5));
            this.textPane.setBorder(null);
        }

        public Color darker(Color c) {
            return new Color(Math.max((int)((double)c.getRed() * 0.95), 0), Math.max((int)((double)c.getGreen() * 0.95), 0), Math.max((int)((double)c.getBlue() * 0.95), 0));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof SearchHistoryPanel.ResultsContainer) {
                this.renderContainer(list, (SearchHistoryPanel.ResultsContainer)value, index, isSelected);
            } else {
                this.renderRevision(list, (SearchHistoryPanel.DispRevision)value, index, isSelected);
            }
            return this;
        }

        private void renderContainer(JList list, SearchHistoryPanel.ResultsContainer container, int index, boolean isSelected) {
            Style style;
            StyledDocument sd = this.textPane.getStyledDocument();
            if (isSelected) {
                this.textPane.setBackground(UIManager.getColor("List.selectionBackground"));
                this.actionsPane.setBackground(UIManager.getColor("List.selectionBackground"));
                style = this.selectedStyle;
            } else {
                Color c = UIManager.getColor("List.background");
                this.textPane.setBackground((index & 1) == 0 ? c : this.darker(c));
                this.actionsPane.setBackground((index & 1) == 0 ? c : this.darker(c));
                style = this.normalStyle;
            }
            try {
                sd.remove(0, sd.getLength());
                sd.setCharacterAttributes(0, Integer.MAX_VALUE, style, true);
                sd.insertString(0, container.getName(), null);
                sd.setCharacterAttributes(0, sd.getLength(), this.filenameStyle, false);
                sd.insertString(sd.getLength(), FIELDS_SEPARATOR + container.getPath(), null);
                sd.setCharacterAttributes(0, sd.getLength(), style, false);
                sd.setParagraphAttributes(0, sd.getLength(), this.noindentStyle, false);
            }
            catch (BadLocationException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            this.actionsPane.removeAll();
            this.actionsPane.revalidate();
        }

        private void renderRevision(JList list, SearchHistoryPanel.DispRevision dispRevision, int index, boolean isSelected) {
            int width;
            Style style;
            Color backgroundColor;
            Color foregroundColor;
            StyledDocument sd = this.textPane.getStyledDocument();
            this.index = index;
            if (isSelected) {
                foregroundColor = UIManager.getColor("List.selectionForeground");
                backgroundColor = UIManager.getColor("List.selectionBackground");
                style = this.selectedStyle;
            } else {
                foregroundColor = UIManager.getColor("List.foreground");
                backgroundColor = UIManager.getColor("List.background");
                backgroundColor = (index & 1) == 0 ? backgroundColor : this.darker(backgroundColor);
                style = this.normalStyle;
            }
            this.textPane.setBackground(backgroundColor);
            this.actionsPane.setBackground(backgroundColor);
            LogInformation.Revision revision = dispRevision.getRevision();
            String commitMessage = revision.getMessage();
            if (commitMessage.endsWith("\n")) {
                commitMessage = commitMessage.substring(0, commitMessage.length() - 1);
            }
            int indentation = dispRevision.getIndentation();
            try {
                int idx;
                sd.remove(0, sd.getLength());
                sd.setCharacterAttributes(0, Integer.MAX_VALUE, style, true);
                if (indentation == 0) {
                    sd.insertString(0, dispRevision.getRevision().getLogInfoHeader().getFile().getName(), null);
                    sd.setCharacterAttributes(0, sd.getLength(), this.filenameStyle, false);
                    sd.insertString(sd.getLength(), FIELDS_SEPARATOR + dispRevision.getName().substring(0, dispRevision.getName().lastIndexOf(47)) + "\n", null);
                }
                sd.insertString(sd.getLength(), revision.getNumber() + FIELDS_SEPARATOR, null);
                sd.insertString(sd.getLength(), this.defaultFormat.format(revision.getDate()) + FIELDS_SEPARATOR, null);
                sd.insertString(sd.getLength(), revision.getAuthor(), null);
                if ("dead".equalsIgnoreCase(dispRevision.getRevision().getState())) {
                    sd.insertString(sd.getLength(), FIELDS_SEPARATOR + NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView = SummaryView.class$("org.netbeans.modules.versioning.system.cvss.ui.history.SummaryView")) : class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView), (String)"MSG_SummaryView_DeadState"), null);
                }
                sd.insertString(sd.getLength(), "\n", null);
                sd.insertString(sd.getLength(), commitMessage, null);
                if (SummaryView.this.message != null && !isSelected && (idx = revision.getMessage().indexOf(SummaryView.this.message)) != -1) {
                    int len = commitMessage.length();
                    int doclen = sd.getLength();
                    sd.setCharacterAttributes(doclen - len + idx, SummaryView.this.message.length(), this.hiliteStyle, false);
                }
                sd.setCharacterAttributes(0, Integer.MAX_VALUE, style, false);
                if (indentation > 0) {
                    sd.setParagraphAttributes(0, sd.getLength(), this.indentStyle, false);
                } else {
                    sd.setParagraphAttributes(0, sd.getLength(), this.noindentStyle, false);
                }
            }
            catch (BadLocationException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            if (commitMessage != null && (width = SummaryView.this.master.getWidth()) > 0) {
                FontMetrics fm = list.getFontMetrics(list.getFont());
                Rectangle2D rect = fm.getStringBounds(commitMessage, this.textPane.getGraphics());
                int nlc = -1;
                int i = 0;
                while (i != -1) {
                    i = commitMessage.indexOf(10, i + 1);
                    ++nlc;
                }
                if (indentation == 0) {
                    ++nlc;
                }
                int lines = (int)(rect.getWidth() / (double)(width - 80) + 1.0);
                int ph = fm.getHeight() * (lines + nlc + 1) + 0;
                this.textPane.setPreferredSize(new Dimension(width - 50, ph));
            }
            this.actionsPane.removeAll();
            String prev = Utils.previousRevision(dispRevision.getRevision().getNumber());
            if (prev != null) {
                JLabel l1 = new JLabel(NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView = SummaryView.class$("org.netbeans.modules.versioning.system.cvss.ui.history.SummaryView")) : class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView), (String)"CTL_Action_DiffTo"));
                l1.setForeground(foregroundColor);
                this.actionsPane.add(l1);
                this.diffLink = new HyperlinkLabel(prev, foregroundColor, backgroundColor);
                this.diffLink.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
                this.actionsPane.add(this.diffLink);
            } else {
                this.diffLink = null;
            }
            Project[] projects = OpenProjects.getDefault().getOpenProjects();
            this.acopLink = projects.length > 0 ? new HyperlinkLabel(NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView = SummaryView.class$("org.netbeans.modules.versioning.system.cvss.ui.history.SummaryView")) : class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView), (String)"CTL_Action_FindCommitInOpenProjects"), foregroundColor, backgroundColor) : null;
            Project prj = Utils.getProject(dispRevision.getRevision().getLogInfoHeader().getFile());
            if (prj != null) {
                String prjName = ProjectUtils.getInformation((Project)prj).getDisplayName();
                this.acpLink = new HyperlinkLabel("\"" + prjName + "\"", foregroundColor, backgroundColor);
            } else {
                this.acpLink = null;
            }
            if (this.acpLink != null || this.acopLink != null) {
                JLabel l1 = new JLabel(NbBundle.getMessage((Class)(class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView == null ? (class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView = SummaryView.class$("org.netbeans.modules.versioning.system.cvss.ui.history.SummaryView")) : class$org$netbeans$modules$versioning$system$cvss$ui$history$SummaryView), (String)"CTL_Action_FindCommitIn"));
                l1.setForeground(foregroundColor);
                this.actionsPane.add(l1);
                if (this.acpLink != null) {
                    this.actionsPane.add(this.acpLink);
                }
                if (this.acopLink != null) {
                    if (this.acpLink != null) {
                        JLabel l2 = new JLabel(",");
                        l2.setForeground(foregroundColor);
                        this.actionsPane.add(l2);
                    }
                    this.actionsPane.add(this.acopLink);
                }
            }
            this.actionsPane.revalidate();
        }

        protected void paintComponent(Graphics g) {
            Rectangle bounds;
            super.paintComponent(g);
            Rectangle apb = this.actionsPane.getBounds();
            if (this.diffLink != null) {
                bounds = this.diffLink.getBounds();
                bounds.setBounds(bounds.x, bounds.y + apb.y, bounds.width, bounds.height);
                SummaryView.this.resultsList.putClientProperty("Summary-Diff-" + this.index, bounds);
            }
            if (this.acpLink != null) {
                bounds = this.acpLink.getBounds();
                bounds.setBounds(bounds.x, bounds.y + apb.y, bounds.width, bounds.height);
                SummaryView.this.resultsList.putClientProperty("Summary-Acp-" + this.index, bounds);
            }
            if (this.acopLink != null) {
                bounds = this.acopLink.getBounds();
                bounds.setBounds(bounds.x, bounds.y + apb.y, bounds.width, bounds.height);
                SummaryView.this.resultsList.putClientProperty("Summary-Acop-" + this.index, bounds);
            }
        }
    }

    private class SummaryListModel
    extends AbstractListModel {
        private SummaryListModel() {
        }

        public int getSize() {
            return SummaryView.this.dispResults.size();
        }

        public Object getElementAt(int index) {
            return SummaryView.this.dispResults.get(index);
        }
    }
}

