/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.children;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.masterfs.filebasedfs.children.ChildrenCache;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileName;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.netbeans.modules.masterfs.providers.ProvidedExtensions;

public final class ChildrenSupport {
    private static final int NO_CHILDREN_CACHED = 0;
    private static final int SOME_CHILDREN_CACHED = 1;
    private static final int ALL_CHILDREN_CACHED = 2;
    private Set childrenCache;
    private int status = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public synchronized Set getChildren(FileNaming folderName, boolean rescan) {
        if (rescan) {
            switch (this.getStatus()) {
                case 0: 
                case 1: {
                    boolean isUNCHack;
                    Set newChildrenCache = ChildrenSupport.rescanChildren(folderName);
                    boolean bl = isUNCHack = this.getStatus() == 1 && newChildrenCache.isEmpty() && new FileInfo(folderName.getFile()).isUNCFolder();
                    if (isUNCHack) break;
                    this.setChildrenCache(newChildrenCache);
                }
            }
            this.status = 2;
        }
        return this.childrenCache != null ? this.getChildrenCache() : new HashSet();
    }

    public synchronized FileNaming getChild(String childName, FileNaming folderName, boolean rescan) {
        FileNaming retVal = null;
        switch (this.getStatus()) {
            case 2: {
                retVal = this.lookupChildInCache(folderName, childName);
                if (!rescan) break;
            }
            case 1: {
                if (this.getStatus() != 2) {
                    retVal = this.lookupChildInCache(folderName, childName);
                }
            }
            case 0: {
                if (retVal == null || rescan) {
                    FileName original = retVal;
                    retVal = ChildrenSupport.rescanChild(folderName, childName);
                    if (retVal != null) {
                        this.getChildrenCache().add(retVal);
                    } else {
                        this.getChildrenCache().remove(original);
                    }
                }
                if (retVal == null || this.getStatus() != 0) break;
                this.status = 1;
            }
        }
        return retVal;
    }

    public boolean existsldInCache(FileNaming folder, String childName) {
        return this.lookupChildInCache(folder, childName) != null;
    }

    public void removeChild(FileNaming folderName, String childName) {
        FileName fName = this.lookupChildInCache(folderName, childName);
        if (fName != null) {
            this.getChildrenCache().remove(fName);
        }
    }

    private FileName lookupChildInCache(FileNaming folder, String childName) {
        File f = new File(folder.getFile(), childName);
        Integer id = NamingFactory.createID(f);
        class FakeNaming
        implements FileNaming {
            public FileName lastEqual;
            static final /* synthetic */ boolean $assertionsDisabled;
            private final /* synthetic */ String val$childName;
            private final /* synthetic */ FileNaming val$folder;
            private final /* synthetic */ File val$f;
            private final /* synthetic */ Integer val$id;

            FakeNaming(String string, FileNaming fileNaming, File file, Integer n) {
                this.val$childName = string;
                this.val$folder = fileNaming;
                this.val$f = file;
                this.val$id = n;
            }

            public String getName() {
                return this.val$childName;
            }

            public FileNaming getParent() {
                return this.val$folder;
            }

            public boolean isRoot() {
                return false;
            }

            public File getFile() {
                return this.val$f;
            }

            public Integer getId() {
                return this.val$id;
            }

            public boolean rename(String name) {
                throw new IllegalStateException();
            }

            public boolean rename(String name, ProvidedExtensions.IOHandler h) {
                throw new IllegalStateException();
            }

            public boolean equals(Object obj) {
                if (this.hashCode() == obj.hashCode()) {
                    if (!$assertionsDisabled && this.lastEqual != null) {
                        throw new AssertionError((Object)"Just one can be there");
                    }
                    this.lastEqual = (FileName)obj;
                    return true;
                }
                return false;
            }

            public int hashCode() {
                return this.val$id;
            }

            public Integer getId(boolean recompute) {
                return this.val$id;
            }

            public boolean isFile() {
                return this.getFile().isFile();
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$modules$masterfs$filebasedfs$children$ChildrenSupport == null ? (class$org$netbeans$modules$masterfs$filebasedfs$children$ChildrenSupport = ChildrenSupport.class$("org.netbeans.modules.masterfs.filebasedfs.children.ChildrenSupport")) : class$org$netbeans$modules$masterfs$filebasedfs$children$ChildrenSupport).desiredAssertionStatus();
            }
        }
        FakeNaming fake = new FakeNaming(childName, folder, f, id);
        Set cache = this.getChildrenCache();
        if (cache.contains(fake)) {
            if (!$assertionsDisabled && fake.lastEqual == null) {
                throw new AssertionError((Object)"If cache contains the object, we set lastEqual");
            }
            return fake.lastEqual;
        }
        return null;
    }

    private static FileNaming rescanChild(FileNaming folderName, String childName) {
        File folder = folderName.getFile();
        File child = new File(folder, childName);
        FileInfo fInfo = new FileInfo(child);
        return fInfo.isConvertibleToFileObject() ? NamingFactory.fromFile(folderName, child) : null;
    }

    private static Set rescanChildren(FileNaming folderName) {
        LinkedHashSet<FileNaming> retVal = new LinkedHashSet<FileNaming>();
        File folder = folderName.getFile();
        if (!$assertionsDisabled && !folderName.getFile().getAbsolutePath().equals(folderName.toString())) {
            throw new AssertionError();
        }
        File[] childs = folder.listFiles();
        if (childs != null) {
            for (int i = 0; i < childs.length; ++i) {
                FileInfo fInfo = new FileInfo(childs[i]);
                if (!fInfo.isConvertibleToFileObject()) continue;
                FileNaming child = NamingFactory.fromFile(folderName, childs[i]);
                if (!$assertionsDisabled && child.getParent() != folderName) {
                    throw new AssertionError();
                }
                retVal.add(child);
            }
        }
        return retVal;
    }

    private synchronized Set getChildrenCache() {
        if (this.childrenCache == null) {
            this.setChildrenCache(new LinkedHashSet());
        }
        return this.childrenCache;
    }

    private void setChildrenCache(Set childrenCache) {
        this.childrenCache = childrenCache;
    }

    public Map refresh(FileNaming folderName) {
        Set newChildren;
        HashMap<FileName, Integer> retVal = new HashMap<FileName, Integer>();
        HashSet oldChildren = new HashSet(this.getChildrenCache());
        Set set = newChildren = this.getStatus() == 2 ? ChildrenSupport.rescanChildren(folderName) : ChildrenSupport.getSubsetOfExisting(oldChildren);
        if (this.status == 1 && newChildren.size() < oldChildren.size()) {
            this.setChildrenCache(ChildrenSupport.rescanChildren(folderName));
            this.status = 2;
        } else {
            this.setChildrenCache(newChildren);
        }
        HashSet removed = new HashSet(oldChildren);
        removed.removeAll(newChildren);
        Iterator iterator = removed.iterator();
        while (iterator.hasNext()) {
            FileName removedItem = (FileName)iterator.next();
            retVal.put(removedItem, ChildrenCache.REMOVED_CHILD);
        }
        if (this.getStatus() == 2) {
            HashSet added = new HashSet(newChildren);
            added.removeAll(oldChildren);
            Iterator iterator2 = added.iterator();
            while (iterator2.hasNext()) {
                FileName addedItem = (FileName)iterator2.next();
                retVal.put(addedItem, ChildrenCache.ADDED_CHILD);
            }
        }
        return retVal;
    }

    private static Set getSubsetOfExisting(Set oldChildren) {
        HashSet<FileName> retVal = new HashSet<FileName>();
        Iterator iterator = oldChildren.iterator();
        while (iterator.hasNext()) {
            FileName fileName = (FileName)iterator.next();
            File f = fileName.getFile();
            if (!f.exists()) continue;
            retVal.add(fileName);
        }
        return retVal;
    }

    public String toString() {
        return this.childrenCache.toString();
    }

    private int getStatus() {
        return this.status;
    }

    static {
        $assertionsDisabled = !ChildrenSupport.class.desiredAssertionStatus();
    }
}

