/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FolderObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.RootObj;
import org.netbeans.modules.masterfs.filebasedfs.naming.FileNaming;
import org.netbeans.modules.masterfs.filebasedfs.naming.NamingFactory;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.openide.filesystems.FileObject;

public final class FileObjectFactory {
    private final Map allInstances = Collections.synchronizedMap(new WeakHashMap());
    private RootObj root;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static FileObjectFactory getInstance(FileInfo fInfo) {
        return new FileObjectFactory(fInfo);
    }

    public final RootObj getRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        Map map = this.allInstances;
        synchronized (map) {
            return this.allInstances.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileObject findFileObject(FileInfo fInfo) {
        FileObject retVal = null;
        File f = fInfo.getFile();
        Map map = this.allInstances;
        synchronized (map) {
            retVal = this.get(f);
            if (retVal == null || !retVal.isValid()) {
                File parent = f.getParentFile();
                retVal = parent != null ? this.create(fInfo) : this.getRoot();
            }
            if (!$assertionsDisabled && retVal != null && !retVal.isValid()) {
                throw new AssertionError((Object)retVal.toString());
            }
            return retVal;
        }
    }

    private BaseFileObj create(FileInfo fInfo) {
        if (fInfo.isWindowsFloppy()) {
            return null;
        }
        if (!fInfo.isConvertibleToFileObject()) {
            return null;
        }
        File file = fInfo.getFile();
        FileNaming name = fInfo.getFileNaming();
        FileNaming fileNaming = name = name == null ? NamingFactory.fromFile(file) : name;
        if (name == null) {
            return null;
        }
        if (name.isFile()) {
            if (!$assertionsDisabled && (name.getFile() == null || !name.getFile().isFile() && name.getFile().isDirectory())) {
                throw new AssertionError(name);
            }
            FileObj realRoot = new FileObj(file, name);
            return this.putInCache(realRoot, realRoot.getFileName().getId());
        }
        if (!name.isFile() || fInfo.isUNCFolder()) {
            if (!$assertionsDisabled && (name.getFile() == null || name.getFile().isFile() && !name.getFile().isDirectory())) {
                throw new AssertionError(name);
            }
            FolderObj realRoot = new FolderObj(file, name);
            return this.putInCache(realRoot, realRoot.getFileName().getId());
        }
        if (fInfo.isUnixSpecialFile()) {
            if (!($assertionsDisabled || name.getFile() != null && name.getFile().isFile() == name.getFile().isDirectory())) {
                throw new AssertionError(name);
            }
            FileObj realRoot = new FileObj(file, name);
            return this.putInCache(realRoot, realRoot.getFileName().getId());
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refreshAll(boolean expected) {
        HashSet<BaseFileObj> all2Refresh = new HashSet<BaseFileObj>();
        Map map = this.allInstances;
        synchronized (map) {
            Iterator it = this.allInstances.values().iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (obj instanceof List) {
                    Iterator iterator = ((List)obj).iterator();
                    while (iterator.hasNext()) {
                        WeakReference ref = (WeakReference)iterator.next();
                        BaseFileObj fo = ref != null ? ref.get() : null;
                        if (fo == null) continue;
                        all2Refresh.add(fo);
                    }
                    continue;
                }
                WeakReference ref = (WeakReference)obj;
                BaseFileObj fo = ref != null ? ref.get() : null;
                if (fo == null) continue;
                all2Refresh.add(fo);
            }
        }
        Iterator iterator = all2Refresh.iterator();
        while (iterator.hasNext()) {
            BaseFileObj fo = (BaseFileObj)((Object)iterator.next());
            fo.refresh(expected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void rename() {
        HashMap<Integer, Object> toRename = new HashMap<Integer, Object>();
        Map map = this.allInstances;
        synchronized (map) {
            Integer key;
            Iterator it = this.allInstances.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object obj = entry.getValue();
                key = (Integer)entry.getKey();
                if (!(obj instanceof List)) {
                    Integer computedId;
                    WeakReference ref = (WeakReference)obj;
                    BaseFileObj fo = ref != null ? ref.get() : null;
                    if (fo == null || key.equals(computedId = fo.getFileName().getId())) continue;
                    toRename.put(key, (Object)fo);
                    continue;
                }
                Iterator iterator = ((List)obj).iterator();
                while (iterator.hasNext()) {
                    Integer computedId;
                    WeakReference ref = (WeakReference)iterator.next();
                    BaseFileObj fo = ref != null ? ref.get() : null;
                    if (fo == null || key.equals(computedId = fo.getFileName().getId())) continue;
                    toRename.put(key, ref);
                }
            }
            Iterator iterator = toRename.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                key = entry.getKey();
                Object previous = this.allInstances.remove(key);
                if (previous instanceof List) {
                    List list = (List)previous;
                    list.remove(entry.getValue());
                    this.allInstances.put(key, previous);
                    continue;
                }
                BaseFileObj bfo = (BaseFileObj)((Object)entry.getValue());
                this.putInCache(bfo, bfo.getFileName().getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BaseFileObj get(File file) {
        Object o;
        Map map = this.allInstances;
        synchronized (map) {
            Object value = this.allInstances.get(NamingFactory.createID(file));
            Reference ref = null;
            ref = (Reference)(value instanceof Reference ? value : null);
            ref = ref == null && value instanceof List ? FileObjectFactory.getReference((List)value, file) : ref;
            Object v0 = o = ref != null ? ref.get() : null;
            if (!$assertionsDisabled && o != null && !(o instanceof BaseFileObj)) {
                throw new AssertionError();
            }
        }
        return o;
    }

    private static Reference getReference(List list, File file) {
        Reference retVal = null;
        for (int i = 0; retVal == null && i < list.size(); ++i) {
            BaseFileObj cachedElement;
            Reference ref = (Reference)list.get(i);
            BaseFileObj baseFileObj = cachedElement = ref != null ? (BaseFileObj)((Object)ref.get()) : null;
            if (cachedElement == null || cachedElement.getFileName().getFile().compareTo(file) != 0) continue;
            retVal = ref;
        }
        return retVal;
    }

    private FileObjectFactory(FileInfo fInfo) {
        File rootFile = fInfo.getFile();
        if (!$assertionsDisabled && rootFile.getParentFile() != null) {
            throw new AssertionError();
        }
        BaseFileObj realRoot = this.create(fInfo);
        this.root = new RootObj(realRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseFileObj putInCache(BaseFileObj newValue, Integer id) {
        Map map = this.allInstances;
        synchronized (map) {
            WeakReference<BaseFileObj> newRef = new WeakReference<BaseFileObj>(newValue);
            WeakReference<BaseFileObj> listOrReference = this.allInstances.put(id, newRef);
            if (listOrReference != null) {
                if (listOrReference instanceof List) {
                    ((List)((Object)listOrReference)).add(newRef);
                    this.allInstances.put(id, listOrReference);
                } else {
                    BaseFileObj oldValue;
                    if (!$assertionsDisabled && !(listOrReference instanceof WeakReference)) {
                        throw new AssertionError();
                    }
                    Reference oldRef = listOrReference;
                    BaseFileObj baseFileObj = oldValue = oldRef != null ? (BaseFileObj)((Object)oldRef.get()) : null;
                    if (oldValue != null && !newValue.getFileName().equals(oldValue.getFileName())) {
                        ArrayList<Reference> l = new ArrayList<Reference>();
                        l.add(oldRef);
                        l.add(newRef);
                        this.allInstances.put(id, l);
                    }
                }
            }
        }
        return newValue;
    }

    static {
        $assertionsDisabled = !FileObjectFactory.class.desiredAssertionStatus();
    }
}

