/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.KeyComparator;
import org.netbeans.modules.properties.PresentableFileEntry;
import org.netbeans.modules.properties.PropertiesDataNode;
import org.netbeans.modules.properties.PropertiesEditorSupport;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesOpen;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;

public final class PropertiesDataObject
extends MultiDataObject
implements CookieSet.Factory {
    static final long serialVersionUID = 4795737295255253334L;
    public static final String MIME_PROPERTIES = "text/x-properties";
    private transient BundleStructure bundleStructure;
    private transient PropertiesOpen openSupport;
    private final transient Object OPEN_SUPPORT_LOCK = new Object();
    private transient String pasteSuffix;

    public PropertiesDataObject(FileObject primaryFile, MultiFileLoader loader) throws DataObjectExistsException {
        super(primaryFile, loader);
        this.initialize();
    }

    private void initialize() {
        this.bundleStructure = null;
        this.getCookieSet().add(new Class[]{PropertiesOpen.class, PropertiesEditorSupport.class}, (CookieSet.Factory)this);
    }

    public Node.Cookie createCookie(Class clazz) {
        if (clazz.isAssignableFrom(PropertiesOpen.class)) {
            return this.getOpenSupport();
        }
        if (clazz.isAssignableFrom(PropertiesEditorSupport.class)) {
            return ((PropertiesFileEntry)this.getPrimaryEntry()).getPropertiesEditor();
        }
        return null;
    }

    CookieSet getCookieSet0() {
        return this.getCookieSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized DataObject handleCopy(DataFolder df) throws IOException {
        try {
            this.pasteSuffix = this.createPasteSuffix(df);
            DataObject dataObject = super.handleCopy(df);
            return dataObject;
        }
        finally {
            this.pasteSuffix = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject handleMove(DataFolder df) throws IOException {
        try {
            this.pasteSuffix = this.createPasteSuffix(df);
            FileObject fileObject = super.handleMove(df);
            return fileObject;
        }
        finally {
            this.pasteSuffix = null;
        }
    }

    String getPasteSuffix() {
        return this.pasteSuffix;
    }

    void removeSecondaryEntry2(MultiDataObject.Entry fe) {
        this.removeSecondaryEntry(fe);
    }

    private String createPasteSuffix(DataFolder folder) {
        String basicName = this.getPrimaryFile().getName();
        DataObject[] children = folder.getChildren();
        int i = 0;
        while (true) {
            String newName = i == 0 ? basicName : basicName + i;
            boolean exist = false;
            for (int j = 0; j < children.length; ++j) {
                if (!(children[j] instanceof PropertiesDataObject) || !newName.equals(children[j].getName())) continue;
                exist = true;
                break;
            }
            if (!exist) {
                if (i == 0) {
                    return "";
                }
                return "" + i;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesOpen getOpenSupport() {
        Object object = this.OPEN_SUPPORT_LOCK;
        synchronized (object) {
            if (this.openSupport == null) {
                this.openSupport = new PropertiesOpen(this);
            }
            return this.openSupport;
        }
    }

    void updateModificationStatus() {
        boolean modif = false;
        if (((PresentableFileEntry)this.getPrimaryEntry()).isModified()) {
            modif = true;
        } else {
            Iterator it = this.secondaryEntries().iterator();
            while (it.hasNext()) {
                if (!((PresentableFileEntry)((Object)it.next())).isModified()) continue;
                modif = true;
                break;
            }
        }
        super.setModified(modif);
    }

    protected Node createNodeDelegate() {
        PropertiesChildren pc = new PropertiesChildren();
        PropertiesDataNode dn = new PropertiesDataNode((DataObject)this, (Children)pc);
        return dn;
    }

    public BundleStructure getBundleStructure() {
        if (this.bundleStructure == null) {
            this.bundleStructure = new BundleStructure(this);
        }
        return this.bundleStructure;
    }

    public static Comparator getSecondaryFilesComparator() {
        return new KeyComparator();
    }

    void fireNameChange() {
        this.firePropertyChange("name", null, null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initialize();
    }

    private class PropertiesChildren
    extends Children.Keys {
        private PropertyChangeListener propertyListener = null;

        PropertiesChildren() {
        }

        protected void mySetKeys() {
            TreeSet<String> newKeys = new TreeSet<String>(new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    if (o1 instanceof String) {
                        return ((String)o1).compareTo((String)o2);
                    }
                    return -1;
                }
            });
            newKeys.add(PropertiesDataObject.this.getPrimaryEntry().getFile().getName());
            Iterator it = PropertiesDataObject.this.secondaryEntries().iterator();
            while (it.hasNext()) {
                FileEntry fe = (FileEntry)it.next();
                newKeys.add(fe.getFile().getName());
            }
            this.setKeys(newKeys);
        }

        protected void addNotify() {
            this.mySetKeys();
            if (this.propertyListener == null) {
                this.propertyListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("files".equals(evt.getPropertyName())) {
                            PropertiesChildren.this.mySetKeys();
                        }
                    }
                };
                PropertiesDataObject.this.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propertyListener, (Object)((Object)PropertiesDataObject.this)));
            }
        }

        protected void removeNotify() {
            this.setKeys(new ArrayList());
        }

        protected Node[] createNodes(Object key) {
            if (key == null) {
                return null;
            }
            if (!(key instanceof String)) {
                return null;
            }
            String entryName = (String)key;
            PropertiesFileEntry entry = (PropertiesFileEntry)PropertiesDataObject.this.getPrimaryEntry();
            if (entryName.equals(entry.getFile().getName())) {
                return new Node[]{entry.getNodeDelegate()};
            }
            Iterator it = PropertiesDataObject.this.secondaryEntries().iterator();
            while (it.hasNext()) {
                entry = (PropertiesFileEntry)((Object)it.next());
                if (!entryName.equals(entry.getFile().getName())) continue;
                return new Node[]{entry.getNodeDelegate()};
            }
            return null;
        }
    }
}

