/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.bridge;

import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Import;
import org.netbeans.jmi.javamodel.Initializer;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.modules.java.ElementFactory;
import org.netbeans.modules.java.JavaDataObject;
import org.netbeans.modules.java.bridge.Binding;
import org.netbeans.modules.java.bridge.BindingFactory;
import org.netbeans.modules.java.bridge.ClassElementImpl;
import org.netbeans.modules.java.bridge.CommitListener;
import org.netbeans.modules.java.bridge.ConstructorElementImpl;
import org.netbeans.modules.java.bridge.DefaultInsertStrategy;
import org.netbeans.modules.java.bridge.ElementImpl;
import org.netbeans.modules.java.bridge.EventQueue;
import org.netbeans.modules.java.bridge.ExceptionRunnable;
import org.netbeans.modules.java.bridge.FieldElementImpl;
import org.netbeans.modules.java.bridge.ImportImpl;
import org.netbeans.modules.java.bridge.InitializerElementImpl;
import org.netbeans.modules.java.bridge.LangEnvImpl;
import org.netbeans.modules.java.bridge.LangModel;
import org.netbeans.modules.java.bridge.MethodElementImpl;
import org.netbeans.modules.java.bridge.Positioner;
import org.netbeans.modules.java.bridge.SourceElementImpl;
import org.netbeans.modules.java.bridge.WrapperFactory;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.Element;
import org.openide.src.Identifier;
import org.openide.src.SourceElement;
import org.openide.src.SourceException;
import org.openide.src.Type;

public class DefaultLangModel
implements LangModel,
LangModel.Updater,
Runnable {
    private static boolean initialized;
    private static Class CLASS_MEMBER_IMPL;
    private static Class CLASS_INITIALIZER_IMPL;
    static final Positioner DEFAULT_POSITIONER;
    private Object locked;
    private LangModel.Env env;
    private Object writerNotify;
    private Thread writingThread;
    private int readerCount;
    private Thread reader;
    private BindingFactory bindingFactory;
    private WrapperFactory wrapperFactory;
    private EventQueue eventQueue;
    private int writeLocks;
    private int masterLocks;
    private boolean transactionCommited;
    private boolean transactionConstrained;
    private boolean eventDispatch;
    Collection preCommitListeners;
    Collection postCommitListeners;
    LinkedList outputQueue;
    boolean firingEvents;
    private JavaDataObject javaDataObject;

    public DefaultLangModel(JavaDataObject jdo) {
        this(new LangEnvImpl(jdo), jdo);
    }

    public DefaultLangModel(LangModel.Env env, JavaDataObject jdo) {
        this.env = env;
        this.javaDataObject = jdo;
        this.writerNotify = new Object();
        this.eventQueue = new EventQueue(null);
    }

    public JavaDataObject getJavaDataObject() {
        return this.javaDataObject;
    }

    private static void initializeClasses() {
        if (initialized) {
            return;
        }
        try {
            CLASS_MEMBER_IMPL = Class.forName("org.netbeans.modules.java.bridge.MemberElementImpl");
            CLASS_INITIALIZER_IMPL = Class.forName("org.netbeans.modules.java.bridge.InitializerElementImpl");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        initialized = true;
    }

    public Object clone() {
        return null;
    }

    public ClassElementImpl createTopClass(SourceElement src, JavaClass javaClass) {
        ClassElementImpl c = new ClassElementImpl(this, javaClass);
        this.getWrapper().wrapClass(c, (Element)src);
        c.setParent((Element)src);
        return c;
    }

    public ClassElementImpl createInnerClass(ClassElement parent, JavaClass javaClass) {
        ClassElementImpl c = new ClassElementImpl(this, javaClass);
        this.getWrapper().wrapClass(c, (Element)parent);
        c.setParent((Element)parent);
        return c;
    }

    public FieldElementImpl createField(ClassElement parent, Field field) {
        FieldElementImpl impl = new FieldElementImpl(this, field);
        this.getWrapper().wrapField(impl, (Element)parent);
        impl.setParent((Element)parent);
        return impl;
    }

    public ConstructorElementImpl createConstructor(ClassElement parent, Constructor constructor) {
        ConstructorElementImpl impl = new ConstructorElementImpl(this, constructor);
        this.getWrapper().wrapConstructor(impl, (Element)parent);
        impl.setParent((Element)parent);
        return impl;
    }

    public MethodElementImpl createMethod(ClassElement parent, Method method) {
        MethodElementImpl impl = new MethodElementImpl(this, method);
        this.getWrapper().wrapMethod(impl, (Element)parent);
        impl.setParent((Element)parent);
        return impl;
    }

    public ImportImpl createImport(SourceElement parent, Import imp) {
        ImportImpl impl = new ImportImpl(this, imp);
        this.getWrapper().wrapImport(impl, (Element)parent);
        impl.setParent((Element)parent);
        return impl;
    }

    public InitializerElementImpl createInitializer(ClassElement parent, Initializer initializer) {
        InitializerElementImpl impl = new InitializerElementImpl(this, initializer);
        this.getWrapper().wrapInitializer(impl, (Element)parent);
        impl.setParent((Element)parent);
        return impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceElementImpl createSource() {
        MDRepository repo = JavaMetamodel.getDefaultRepository();
        repo.beginTrans(false);
        try {
            SourceElementImpl sourceElementImpl = new SourceElementImpl(this, null, null);
            return sourceElementImpl;
        }
        finally {
            repo.endTrans();
        }
    }

    public ClassElementImpl createTopClass(SourceElement src) {
        ClassElementImpl c = new ClassElementImpl(this, null);
        this.getWrapper().wrapClass(c, (Element)src);
        c.setParent((Element)src);
        return c;
    }

    public ClassElementImpl createInnerClass(ClassElement parent) {
        ClassElementImpl c = new ClassElementImpl(this, null);
        this.getWrapper().wrapClass(c, (Element)parent);
        c.setParent((Element)parent);
        return c;
    }

    public FieldElementImpl createField(ClassElement parent) {
        FieldElementImpl impl = new FieldElementImpl(this, null);
        this.getWrapper().wrapField(impl, (Element)parent);
        impl.setParent((Element)parent);
        return impl;
    }

    public ConstructorElementImpl createConstructor(ClassElement parent) {
        ConstructorElementImpl impl = new ConstructorElementImpl(this, null);
        this.getWrapper().wrapConstructor(impl, (Element)parent);
        impl.setParent((Element)parent);
        return impl;
    }

    public MethodElementImpl createMethod(ClassElement parent) {
        MethodElementImpl impl = new MethodElementImpl(this, null);
        this.getWrapper().wrapMethod(impl, (Element)parent);
        impl.setParent((Element)parent);
        return impl;
    }

    public ImportImpl createImport(SourceElement parent) {
        ImportImpl impl = new ImportImpl(this, null);
        this.getWrapper().wrapImport(impl, (Element)parent);
        impl.setParent((Element)parent);
        return impl;
    }

    public InitializerElementImpl createInitializer(ClassElement parent) {
        InitializerElementImpl impl = new InitializerElementImpl(this, null);
        this.getWrapper().wrapInitializer(impl, (Element)parent);
        impl.setParent((Element)parent);
        return impl;
    }

    final Identifier resolveIdent(Element context, Identifier original) {
        return this.env.resolveTypeIdent(context, original);
    }

    final Type resolveType(Element context, Type t) {
        return this.env.resolveType(context, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPreCommitListener(CommitListener l) {
        Object object = this;
        synchronized (object) {
            if (this.preCommitListeners == null) {
                this.preCommitListeners = new LinkedList();
            }
        }
        object = this.preCommitListeners;
        synchronized (object) {
            this.preCommitListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPostCommitListener(CommitListener l) {
        Object object = this;
        synchronized (object) {
            if (this.postCommitListeners == null) {
                this.postCommitListeners = new LinkedList();
            }
        }
        object = this.postCommitListeners;
        synchronized (object) {
            this.postCommitListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePreCommitListener(CommitListener l) {
        if (this.preCommitListeners == null) {
            return;
        }
        Collection collection = this.preCommitListeners;
        synchronized (collection) {
            this.preCommitListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePostCommitListener(CommitListener l) {
        if (this.postCommitListeners == null) {
            return;
        }
        Collection collection = this.postCommitListeners;
        synchronized (collection) {
            this.postCommitListeners.remove(l);
        }
    }

    final void notifyEventsDispatched(boolean dispatchOn) {
        this.eventDispatch = dispatchOn;
    }

    public final Object writeLock() {
        return null;
    }

    private void createEventQueue() {
        this.eventQueue = new EventQueue(this.eventQueue);
    }

    final Object masterWriteLock() {
        return null;
    }

    public Object tryWriteLock() {
        return this.tryWriteLock(false);
    }

    private Object tryWriteLock(boolean master) {
        return null;
    }

    public final Object doWriteLock() {
        return null;
    }

    public final void releaseWriteLock(Object handle) {
        this.releaseWriteLock(handle, false);
    }

    final void releaseWriteLock(Object handle, boolean forkThread) {
    }

    private void enqueue(EventQueue q) {
    }

    public void run() {
    }

    private void processOutputQueue() {
    }

    private void firePreCommitEvents(EventQueue q) {
        this.fireCommitEvents(this.preCommitListeners, q);
    }

    private void firePostCommitEvents(EventQueue what) {
        this.fireCommitEvents(this.postCommitListeners, what);
    }

    private void fireCommitEvents(Collection origListeners, EventQueue data) {
    }

    private EventQueue mergeEventQueues() {
        return null;
    }

    public void commitChanges() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAtomic(Runnable r) throws SourceException {
        Object token = this.writeLock();
        try {
            r.run();
            this.commitChanges();
        }
        finally {
            this.releaseWriteLock(token);
        }
    }

    protected boolean isConstrained() {
        return this.transactionConstrained;
    }

    protected final Node.Cookie findElementCookie(Element el, Class clazz) {
        return this.env.findCookie(el, clazz);
    }

    public boolean runUpdate(Runnable r, boolean disableConstraints) throws SourceException {
        Object token = this.tryWriteLock(true);
        if (token == null) {
            return false;
        }
        boolean saveConstraint = this.transactionConstrained;
        try {
            this.transactionConstrained = !disableConstraints;
            r.run();
            this.commitChanges();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SourceException("Unexpected implementation error");
        }
        finally {
            this.transactionConstrained = saveConstraint;
            this.releaseWriteLock(token, true);
        }
    }

    private void doRunAtomic(ExceptionRunnable r) throws SourceException {
        try {
            r.run();
        }
        catch (SourceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SourceException("Unexpected implementation error.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAtomic(ExceptionRunnable r) throws SourceException {
        boolean fire = false;
        boolean ok = false;
        Object token = null;
        token = this.writeLock();
        try {
            this.doRunAtomic(r);
            this.commitChanges();
        }
        finally {
            this.releaseWriteLock(token);
        }
    }

    public Object getManagementLock() {
        return this.writerNotify;
    }

    public final void readLock() {
    }

    public final void releaseReadLock() {
    }

    protected EventQueue getEventQueue() {
        return this.eventQueue;
    }

    public boolean isWriteLocked() {
        return this.writingThread != null;
    }

    public ElementFactory.Item createImport(Import im, int from, int to) {
        return null;
    }

    public void notifyElementChanged(Element ref, Element old) {
        this.eventQueue.elementChanged(ref, old);
    }

    public void notifyElementCreated(Element ref) {
        this.eventQueue.elementCreated(ref);
    }

    public void notifyElementRemoved(Element ref) {
        this.eventQueue.elementRemoved(ref);
    }

    public void fireModelElementChange(ElementImpl bean, PropertyChangeEvent evt) {
        this.queuePropertyChange(bean, evt.getPropertyName(), evt);
    }

    public void fireModelElementChange(Element.Impl bean, PropertyChangeEvent evt) {
        this.queuePropertyChange((ElementImpl)bean, evt.getPropertyName(), evt);
    }

    protected BindingFactory getBindingFactory() {
        if (this.bindingFactory != null) {
            return this.bindingFactory;
        }
        this.bindingFactory = this.env.getBindingFactory();
        return this.bindingFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WrapperFactory getWrapper() {
        if (this.wrapperFactory != null) {
            return this.wrapperFactory;
        }
        DefaultLangModel defaultLangModel = this;
        synchronized (defaultLangModel) {
            if (this.wrapperFactory == null) {
                this.wrapperFactory = this.env.getWrapperFactory();
            }
            return this.wrapperFactory;
        }
    }

    private void queuePropertyChange(ElementImpl bean, String name, PropertyChangeEvent evt) {
        this.eventQueue.addPropertyChange(bean, evt);
    }

    private ElementImpl getElementImpl(Element el) {
        return (ElementImpl)el.getCookie(ElementImpl.class);
    }

    public void updateMembers(Element target, String propertyName, Element[] els, int[] orderIndices, int[] optMap) {
        if (target instanceof ClassElement) {
            ClassElementImpl impl = (ClassElementImpl)this.getElementImpl(target);
            impl.updateMembers(propertyName, els, orderIndices, optMap);
        } else {
            SourceElementImpl impl = (SourceElementImpl)this.getElementImpl(target);
            impl.updateMembers(propertyName, els, optMap);
        }
    }

    public void updateMemberOrder(Element target, String id, Element[] orderedMembers) {
        ClassElementImpl impl = (ClassElementImpl)this.getElementImpl(target);
        impl.updateMemberOrder(orderedMembers);
    }

    public void activate(Element target) {
        ElementImpl impl = this.getElementImpl(target);
        impl.notifyCreate();
    }

    public Binding getElementBinding(Element target) {
        ElementImpl impl = this.getElementImpl(target);
        return impl.getRawBinding();
    }

    public boolean isSameContext(Element context, Identifier id) {
        ElementImpl impl = this.getElementImpl(context);
        if (impl == null) {
            return false;
        }
        return impl.checkIdentifierContext(id);
    }

    public Identifier createLocalIdentifier(Element context, Identifier id, int status) {
        ElementImpl impl = this.getElementImpl(context);
        if (impl == null) {
            throw new IllegalArgumentException("Unknown context class: " + context.getClass());
        }
        return impl.createLocalIdentifier(id, status);
    }

    public Identifier createLocalIdentifier(Element context, String full, String source, int status) {
        Identifier id = Identifier.create((String)full, (String)source);
        return this.createLocalIdentifier(context, id, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFire(Set removed, Set created, Map changed) {
        if (this.postCommitListeners != null) {
            Collection collection = this.postCommitListeners;
            synchronized (collection) {
                Iterator it = this.postCommitListeners.iterator();
                while (it.hasNext()) {
                    CommitListener l = (CommitListener)it.next();
                    l.changesCommited(created, removed, changed);
                }
            }
        }
    }

    public void fireElementChanged(Element oldElem, Element newElem) {
        HashMap<Element, Element[]> changed = new HashMap<Element, Element[]>();
        changed.put(newElem, new Element[]{oldElem, newElem});
        this.doFire(new HashSet(), new HashSet(), changed);
    }

    public void fireElementRemoved(Element elem) {
        HashSet<Element> removed = new HashSet<Element>();
        removed.add(elem);
        this.doFire(removed, new HashSet(), new HashMap());
    }

    public void fireElementAdded(Element elem) {
        HashSet<Element> created = new HashSet<Element>();
        created.add(elem);
        this.doFire(new HashSet(), created, new HashMap());
    }

    public void fireElementSet(Element oldElem, Element newElem) {
        HashSet<Element> removed = new HashSet<Element>();
        removed.add(oldElem);
        HashSet<Element> created = new HashSet<Element>();
        created.add(newElem);
        this.doFire(removed, created, new HashMap());
    }

    public Element findElement(Element.Impl impl) {
        if (!(impl instanceof ElementImpl)) {
            return null;
        }
        return ((ElementImpl)impl).getElement();
    }

    public void firePropertyChange(Element el, PropertyChangeEvent evt) {
        ElementImpl impl = this.getElementImpl(el);
        if (impl == null) {
            JMManager.getLog().log(1, "DefaultLangModel.firePropertyChange(): impl == null");
            return;
        }
        impl.fireOwnPropertyChange(evt);
    }

    public void updateBody(Element el, String bodyContent) throws UnsupportedOperationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateModel(SourceElement el) {
        SourceElementImpl impl = (SourceElementImpl)this.getElementImpl((Element)el);
        Object token = this.writeLock();
        try {
            if (impl == null) {
                return;
            }
            impl.notifyRemove();
            this.commitChanges();
        }
        finally {
            this.releaseWriteLock(token);
        }
    }

    static {
        DEFAULT_POSITIONER = new DefaultInsertStrategy();
    }
}

