/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.editors;

import java.awt.Component;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditorSupport;
import javax.swing.JPanel;
import org.netbeans.modules.java.ui.editors.ClassChooserPanel;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.src.ClassElement;
import org.openide.src.Identifier;
import org.openide.src.Type;

public class TypeIdentPE
extends PropertyEditorSupport
implements ExPropertyEditor {
    private static final String ATTR_CUSTOM_TITLE = "title";
    private static final String ATTR_CUSTOM_INPUT = "userInput";
    private static final String ATTR_CLASSPATH_ROOTS = "classPathRoots";
    private static final String ATTR_ACCEPT_CLASSES = "acceptClasses";
    private static final String ATTR_ACCEPT_INTERFACES = "acceptInterfaces";
    private static final String ATTR_DATA_FILTER = "dataFilter";
    PropertyEnv environment;
    boolean acceptClasses = true;
    boolean acceptInterfaces = true;
    boolean validNamesOnly = false;
    PropertyChangeSupport supp;
    ClassChooserPanel customEditor;
    Identifier identifier;

    public String getAsText() {
        if (this.identifier == null) {
            return "";
        }
        return this.identifier.getSourceName();
    }

    public void setAsText(String str) throws IllegalArgumentException {
        Identifier i;
        if (str == null || "".equals(str)) {
            i = null;
        } else {
            Type t = Type.parse((String)str);
            if (t.isPrimitive()) {
                this.denyPrimitiveType(t);
            } else if (t.isArray()) {
                this.denyArrayType(t);
            }
            ClassElement c = this.loadRepresentation(str);
            this.checkInputConstraints(str, c);
            i = t.getClassName();
        }
        super.setValue(i);
    }

    public void setValue(Object obj) throws IllegalArgumentException {
        if (!(obj instanceof Identifier)) {
            throw new IllegalArgumentException("Invalid value type: " + obj.getClass());
        }
        super.setValue(obj);
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void attachEnv(PropertyEnv env) {
        FeatureDescriptor fd = env.getFeatureDescriptor();
        Boolean b = (Boolean)fd.getValue(ATTR_ACCEPT_CLASSES);
        if (b != null) {
            this.setAcceptClasses(b);
        }
        if ((b = (Boolean)fd.getValue(ATTR_ACCEPT_INTERFACES)) != null) {
            this.setAcceptInterfaces(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener l) {
        Object object;
        super.addPropertyChangeListener(l);
        if (this.supp == null) {
            object = this;
            synchronized (object) {
                if (this.supp == null) {
                    this.supp = new PropertyChangeSupport(this);
                }
            }
        }
        object = this.supp;
        synchronized (object) {
            this.supp.addPropertyChangeListener(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.supp != null) {
            PropertyChangeSupport propertyChangeSupport = this.supp;
            synchronized (propertyChangeSupport) {
                this.supp.removePropertyChangeListener(l);
            }
        }
        super.removePropertyChangeListener(l);
    }

    void enableOK(boolean enable) {
        if (this.supp == null) {
            return;
        }
        this.supp.firePropertyChange("propertyValueValid", null, enable ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setAcceptClasses(boolean accept) {
        this.acceptClasses = accept;
    }

    public void setAcceptInterfaces(boolean accept) {
        this.acceptInterfaces = accept;
    }

    public void setValidNamesOnly(boolean accept) {
        this.validNamesOnly = accept;
    }

    public boolean getAcceptClasses() {
        return this.acceptClasses;
    }

    public boolean getAcceptInterfaces() {
        return this.acceptInterfaces;
    }

    public boolean getValidNamesOnly() {
        return this.validNamesOnly;
    }

    private ClassElement loadRepresentation(String className) {
        return ClassElement.forName((String)className);
    }

    private void denyPrimitiveType(Type t) {
        throw new IllegalArgumentException(t.toString() + " is a primitive type. Simple class or interface is required");
    }

    private void denyArrayType(Type t) {
        throw new IllegalArgumentException(t.toString() + " is an array. Simple class or interface is required");
    }

    void checkInputConstraints(String input, ClassElement result) throws IllegalArgumentException {
        if (result == null) {
            if (!this.getValidNamesOnly()) {
                return;
            }
            throw new IllegalArgumentException("Cannot find class or interface " + input);
        }
        boolean properClass = result.isClassOrInterface();
        if (properClass && !this.getAcceptClasses()) {
            throw new IllegalArgumentException("Class name is not permitted here");
        }
        if (!properClass && !this.getAcceptInterfaces()) {
            throw new IllegalArgumentException("Interface name is not permitted here");
        }
    }

    public Component getCustomEditor() {
        Thread.dumpStack();
        return new JPanel();
    }
}

