/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.ui.nodes.elements;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.jmi.reflect.JmiException;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.Attribute;
import org.netbeans.jmi.javamodel.ClassMember;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.java.ui.nodes.editors.TypeEditor;
import org.netbeans.modules.java.ui.nodes.elements.ElementFormat;
import org.netbeans.modules.java.ui.nodes.elements.SourceEditSupport;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class AnnotationTypeMethodCustomizer
extends JPanel {
    private static final String[] COMMON_TYPES = TypeEditor.ANNTYPE_VALUE_TYPES;
    private final AnnotationType jclass;
    private final Attribute element;
    private boolean isOK = true;
    private JPanel accessPanel;
    private JTextField defValueTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel modifierPanel;
    private JTextField nameTextField;
    private JComboBox returnCombo;

    public AnnotationTypeMethodCustomizer(AnnotationType jclass, Attribute element) {
        this.jclass = jclass;
        this.element = element;
        this.initComponents();
        int mask = 1025;
        this.accessPanel.add((Component)SourceEditSupport.createAccessModifiersPanel((ClassMember)element, mask), "Center");
        this.modifierPanel.add((Component)SourceEditSupport.createOtherModifiersPanel((ClassMember)element, mask), "Center");
        this.nameTextField.setText(element.getName());
        this.returnCombo.setSelectedItem(element.getType().getName());
        this.defValueTextField.setText(element.getDefaultValueText());
        HelpCtx.setHelpIDString((JComponent)this, (String)"java.annotationTypeMethod.customizer");
        this.jLabel1.setDisplayedMnemonic(AnnotationTypeMethodCustomizer.getString("CTL_Name_Mnemonic").charAt(0));
        this.jLabel2.setDisplayedMnemonic(AnnotationTypeMethodCustomizer.getString("CTL_MethodType_Mnemonic").charAt(0));
        this.jLabel3.setDisplayedMnemonic(AnnotationTypeMethodCustomizer.getString("CTL_DefaultValue_Mnemonic").charAt(0));
        this.initAccessibility();
    }

    public void addNotify() {
        super.addNotify();
        int len = this.nameTextField.getText().length();
        this.nameTextField.setCaretPosition(0);
        this.nameTextField.moveCaretPosition(len);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AnnotationTypeMethodCustomizer.this.nameTextField.requestFocus();
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.nameTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.returnCombo = new JComboBox<String>(COMMON_TYPES);
        this.jLabel3 = new JLabel();
        this.defValueTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.accessPanel = new JPanel();
        this.jLabel5 = new JLabel();
        this.modifierPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(6, 6, 6, 6)));
        this.jLabel1.setLabelFor(this.nameTextField);
        this.jLabel1.setText(NbBundle.getMessage((Class)AnnotationTypeMethodCustomizer.class, (String)"CTL_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.nameTextField.setColumns(25);
        this.nameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                AnnotationTypeMethodCustomizer.this.nameTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 8, 0, 0);
        this.add((Component)this.nameTextField, gridBagConstraints);
        this.jLabel2.setLabelFor(this.returnCombo);
        this.jLabel2.setText(NbBundle.getMessage((Class)AnnotationTypeMethodCustomizer.class, (String)"CTL_ReturnType"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.returnCombo.setEditable(true);
        this.returnCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnnotationTypeMethodCustomizer.this.returnComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.returnCombo, gridBagConstraints);
        this.jLabel3.setLabelFor(this.defValueTextField);
        this.jLabel3.setText(NbBundle.getMessage((Class)AnnotationTypeMethodCustomizer.class, (String)"CTL_DefaultValue"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.defValueTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                AnnotationTypeMethodCustomizer.this.defValueTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.defValueTextField, gridBagConstraints);
        this.jLabel4.setLabelFor(this.accessPanel);
        this.jLabel4.setText(NbBundle.getMessage((Class)AnnotationTypeMethodCustomizer.class, (String)"CTL_AccessRights"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.accessPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.accessPanel, gridBagConstraints);
        this.jLabel5.setLabelFor(this.modifierPanel);
        this.jLabel5.setText(NbBundle.getMessage((Class)AnnotationTypeMethodCustomizer.class, (String)"CTL_Modifiers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jLabel5, gridBagConstraints);
        this.modifierPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)this.modifierPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void defValueTextFieldFocusLost(FocusEvent evt) {
        if (evt != null && (evt.isTemporary() || !this.isAncestorOf(evt.getOppositeComponent()))) {
            return;
        }
        String newName = this.defValueTextField.getText().trim();
        newName = newName.length() > 0 ? newName : null;
        String oldName = this.element.getDefaultValueText();
        boolean ok = false;
        try {
            if (newName != null && newName.equals(oldName) || newName == oldName) {
                return;
            }
            this.element.setDefaultValueText(newName);
            ok = true;
        }
        catch (JmiException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        this.isOK = ok;
        if (!ok) {
            oldName = oldName == null ? "" : oldName;
            this.defValueTextField.setText(oldName);
        }
    }

    private void returnComboActionPerformed(ActionEvent evt) {
        Object selItem = this.returnCombo.getSelectedItem();
        if (selItem == null) {
            return;
        }
        String selItemTxt = selItem.toString().trim();
        Type oldValue = this.element.getType();
        boolean ok = false;
        try {
            Type newValue = this.getJModel().getType().resolve(selItemTxt);
            if (oldValue.equals(newValue)) {
                return;
            }
            if (!TypeEditor.isValidTypeSyntax(selItemTxt)) {
                AnnotationTypeMethodCustomizer.notifyUserWarning("MSG_Not_Valid_Type", "invalid type");
            } else if (!TypeEditor.isValidTypeOfAnnTypeMethod(newValue)) {
                AnnotationTypeMethodCustomizer.notifyUserWarning("MSG_Not_Valid_Type", "invalid type");
            } else {
                this.element.setType(newValue);
                ok = true;
            }
        }
        catch (JmiException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        this.isOK = ok;
        if (!ok) {
            this.returnCombo.setSelectedItem(ElementFormat.elementName((NamedElement)oldValue));
        }
    }

    private void nameTextFieldFocusLost(FocusEvent evt) {
        if (evt != null && (evt.isTemporary() || !this.isAncestorOf(evt.getOppositeComponent()))) {
            return;
        }
        String newName = this.nameTextField.getText().trim();
        String oldName = this.element.getName();
        boolean ok = false;
        try {
            if (!Utilities.isJavaIdentifier((String)newName)) {
                AnnotationTypeMethodCustomizer.notifyUserWarning("MSG_Not_Valid_Type", "invalid type");
            } else {
                if (oldName.equals(newName)) {
                    return;
                }
                if (SourceEditSupport.findAttribute(this.jclass, newName) != null) {
                    AnnotationTypeMethodCustomizer.notifyUserWarning("MSG_Used_Identifier", newName, "invalid name");
                } else {
                    this.element.setName(newName);
                    ok = true;
                }
            }
        }
        catch (JmiException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        this.isOK = ok;
        if (!ok) {
            this.nameTextField.setText(oldName);
        }
    }

    private void initAccessibility() {
        this.nameTextField.getAccessibleContext().setAccessibleName(AnnotationTypeMethodCustomizer.getString("ACS_MethodNameTextField"));
        this.nameTextField.getAccessibleContext().setAccessibleDescription(AnnotationTypeMethodCustomizer.getString("ACS_MethodNameTextField"));
        this.defValueTextField.getAccessibleContext().setAccessibleName(AnnotationTypeMethodCustomizer.getString("ACSN_DefaultValue"));
        this.defValueTextField.getAccessibleContext().setAccessibleDescription(AnnotationTypeMethodCustomizer.getString("ACSD_DefaultValue"));
        this.getAccessibleContext().setAccessibleDescription(AnnotationTypeMethodCustomizer.getString("ACSD_AnnotationTypeMethodCustomizer"));
    }

    public boolean isOK() {
        this.nameTextFieldFocusLost(null);
        if (this.isOK) {
            this.returnComboActionPerformed(null);
        }
        if (this.isOK) {
            this.defValueTextFieldFocusLost(null);
        }
        return this.isOK;
    }

    private JavaModelPackage getJModel() {
        return JavaMetamodel.getManager().getJavaExtent((Element)this.jclass);
    }

    private static String getString(String key) {
        return NbBundle.getMessage((Class)AnnotationTypeMethodCustomizer.class, (String)key);
    }

    private static void notifyUserWarning(String bundleKey, String msg) {
        IllegalArgumentException e = new IllegalArgumentException(msg);
        ErrorManager.getDefault().annotate((Throwable)e, 256, null, AnnotationTypeMethodCustomizer.getString(bundleKey), null, null);
        ErrorManager.getDefault().notify((Throwable)e);
    }

    private static void notifyUserWarning(String bundleKey, String param, String msg) {
        IllegalArgumentException e = new IllegalArgumentException(msg);
        ErrorManager.getDefault().annotate((Throwable)e, 256, null, NbBundle.getMessage((Class)AnnotationTypeMethodCustomizer.class, (String)bundleKey, (Object)param), null, null);
        ErrorManager.getDefault().notify((Throwable)e);
    }
}

