/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.schema2beans.BaseAttribute;
import org.netbeans.modules.schema2beans.Common;

public class AttrProp
implements BaseAttribute {
    public static final int MASK_KIND = 255;
    public static final int CDATA = 1;
    public static final int ENUM = 2;
    public static final int NMTOKEN = 3;
    public static final int ID = 4;
    public static final int IDREF = 5;
    public static final int IDREFS = 6;
    public static final int ENTITY = 7;
    public static final int ENTITIES = 8;
    public static final int NOTATION = 9;
    static final String[] kinds = new String[]{"CDATA", "ENUM", "NMTOKEN", "ID", "IDREF", "IDREFS", "ENTITY", "ENTITIES", "NOTATION"};
    static final int[] kindValues = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    public static final int MASK_OPTION = 3840;
    public static final int REQUIRED = 256;
    public static final int IMPLIED = 512;
    public static final int FIXED = 768;
    public static final int TRANSIENT = 4096;
    static final String[] options = new String[]{"#REQUIRED", "#IMPLIED", "#FIXED"};
    static final int[] optionValues = new int[]{256, 512, 768};
    String propertyName;
    String name;
    String dtdName;
    String namespace;
    int type;
    String javaType;
    ArrayList values;
    String defaultValue;
    private int state;
    private int enumMode;
    private List extraData;
    private static final int NEED_NAME = 0;
    private static final int NEED_TYPE = 1;
    private static final int NEED_ENUM = 2;
    private static final int NEED_OPTION = 3;
    private static final int NEED_DEFVAL = 4;
    private static final int NEED_VALUE = 5;
    private static final int DONE = 6;

    public AttrProp() {
        this.values = null;
        this.state = 0;
        this.type = 0;
        this.enumMode = 0;
    }

    public AttrProp(String propName) {
        this();
        this.propertyName = propName;
    }

    public AttrProp(String propName, String dtdName, String name, int type, String[] values, String defValue) {
        this.dtdName = dtdName;
        this.name = name;
        this.propertyName = propName;
        if (values != null && values.length > 0) {
            this.values = new ArrayList();
            for (int i = 0; i < values.length; ++i) {
                this.values.add(values[i]);
            }
        }
        this.defaultValue = defValue;
        this.state = 6;
        this.type = type;
    }

    public int getInstance() {
        if (this.defaultValue != null) {
            return 32;
        }
        switch (this.type & 0xF00) {
            case 256: 
            case 768: {
                return 32;
            }
        }
        return 16;
    }

    public void setEnum(boolean enume) {
        this.enumMode += enume ? 1 : -1;
        if (this.enumMode == 1) {
            if (this.values == null) {
                this.values = new ArrayList();
            }
            this.type = 2;
            this.state = 2;
        } else if (this.enumMode == 0) {
            this.state = 3;
        } else {
            this.failed(Common.getMessage("WrongEnumDecl_msg"));
        }
    }

    public void addValue(String value) {
        this.addValue(value, null);
    }

    public void addValue(String value, String namespace) {
        int valueLen = value.length();
        if (value.charAt(0) == '\"') {
            if (valueLen == 1) {
                this.failed(Common.getMessage("TooLittleDeclaration_msg", value));
            }
            value = value.substring(1, value.length() - 1);
        } else if (value.charAt(0) == '\'') {
            if (valueLen == 1) {
                this.failed(Common.getMessage("TooLittleDeclaration_msg", value));
            }
            value = value.substring(1, value.length() - 1);
        }
        switch (this.state) {
            case 0: {
                this.dtdName = value;
                this.namespace = namespace;
                this.name = Common.convertName(value);
                this.state = 1;
                break;
            }
            case 1: {
                this.type = this.stringToInt(value, kinds, kindValues);
                this.state = 3;
                if (this.type != -1) break;
                this.failed(Common.getMessage("UnknownType_msg", value));
                break;
            }
            case 2: {
                this.values.add(value);
                break;
            }
            case 3: {
                int opt = this.stringToInt(value, options, optionValues);
                if (opt != -1) {
                    this.type |= opt;
                    if (opt == 768) {
                        this.state = 5;
                        break;
                    }
                    this.state = 6;
                    break;
                }
            }
            case 5: {
                this.defaultValue = value;
                this.state = 6;
                break;
            }
            case 6: {
                this.failed(Common.getMessage("TooMuchDeclaration_msg"));
            }
        }
    }

    public boolean isTransient() {
        return (this.type & 0x1000) == 4096;
    }

    public boolean isComplete() {
        return this.state == 6;
    }

    public boolean hasName(String name) {
        return name.equals(this.name) || name.equals(this.dtdName);
    }

    public String[] getValues() {
        int size = 0;
        if (this.values != null) {
            size = this.values.size();
        }
        String[] ret = new String[size];
        if (size > 0) {
            return this.values.toArray(ret);
        }
        return ret;
    }

    public void setDefaultValue(String d) {
        this.defaultValue = d;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getDtdName() {
        return this.dtdName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String typeAsString() {
        String str = "AttrProp." + this.intToString(this.type & 0xFF, kinds, kindValues);
        int opt = this.type & 0xF00;
        if (opt != 0) {
            str = str + " | AttrProp." + this.intToString(opt, options, optionValues).substring(1);
        }
        return str;
    }

    String enumsToString() {
        String[] e = this.getValues();
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < e.length; ++i) {
            ret.append(e[i]);
            ret.append(" ");
        }
        return ret.toString();
    }

    public void validate() {
        if (this.state != 6) {
            this.failed(Common.getMessage("BadAttributeDecl_msg"));
        }
    }

    public void checkEnum() {
        if (this.enumMode == 0) {
            this.failed(Common.getMessage("UseCharORWithEnum_msg"));
        }
    }

    public boolean isEnum() {
        return (this.type & 0xFF) == 2;
    }

    public boolean isFixed() {
        return (this.type & 0xF00) == 768;
    }

    public int getType() {
        return this.type & 0xFF;
    }

    public int getOption() {
        return this.type & 0xF00;
    }

    public String getJavaType() {
        return this.javaType;
    }

    public void setJavaType(String jt) {
        this.javaType = jt;
    }

    int stringToInt(String str, String[] map, int[] val) {
        for (int i = 0; i < map.length; ++i) {
            if (!str.equals(map[i])) continue;
            return val[i];
        }
        return -1;
    }

    String intToString(int id, String[] map, int[] val) {
        for (int i = 0; i < val.length; ++i) {
            if (id != val[i]) continue;
            return map[i];
        }
        return "?";
    }

    private void failed(String err) {
        throw new RuntimeException(Common.getMessage("ATTLISTParseError_msg", this.name, err));
    }

    public void addExtraData(Object data) {
        if (this.extraData == null) {
            this.extraData = new ArrayList();
        }
        this.extraData.add(data);
    }

    public List getExtraData() {
        if (this.extraData == null) {
            return Collections.EMPTY_LIST;
        }
        return this.extraData;
    }

    public String toString() {
        String str = this.dtdName + " " + this.intToString(this.type & 0xFF, kinds, kindValues) + " ";
        int opt = this.type & 0xF00;
        if (opt != 0) {
            str = str + this.intToString(opt, options, optionValues) + " ";
        }
        if (this.values != null) {
            int size = this.values.size();
            str = str + "( ";
            for (int i = 0; i < size; ++i) {
                str = str + this.values.get(i) + " ";
            }
            str = str + ") ";
        }
        if (this.defaultValue != null) {
            str = str + this.defaultValue;
        }
        if (this.isTransient()) {
            str = str + " (transient)";
        }
        if (this.javaType != null) {
            str = str + " : " + this.javaType;
        }
        return str;
    }
}

