/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.Collector;
import org.apache.jasper.compiler.ELFunctionMapper;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.Generator;
import org.apache.jasper.compiler.JavacErrorDetail;
import org.apache.jasper.compiler.JspConfig;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.ScriptingVariabler;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.compiler.SmapUtil;
import org.apache.jasper.compiler.TagFileProcessor;
import org.apache.jasper.compiler.TagPluginManager;
import org.apache.jasper.compiler.TextOptimizer;
import org.apache.jasper.compiler.Validator;
import org.apache.jasper.servlet.JspServletWrapper;
import org.apache.jasper.util.SystemLogHandler;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;

public class Compiler {
    private static Log log = LogFactory.getLog(Compiler.class);
    static Object javacLock = new Object();
    protected JspCompilationContext ctxt;
    private ErrorDispatcher errDispatcher;
    private PageInfo pageInfo;
    private JspServletWrapper jsw;
    private JasperAntLogger logger;
    private TagFileProcessor tfp;
    protected Project project = null;
    protected Options options;
    protected Node.Nodes pageNodes;

    public Compiler(JspCompilationContext ctxt) {
        this(ctxt, null);
    }

    public Compiler(JspCompilationContext ctxt, JspServletWrapper jsw) {
        this.jsw = jsw;
        this.ctxt = ctxt;
        this.options = ctxt.getOptions();
    }

    private Project getProject() {
        if (this.project != null) {
            return this.project;
        }
        this.project = new Project();
        this.logger = new JasperAntLogger();
        this.logger.setOutputPrintStream(System.out);
        this.logger.setErrorPrintStream(System.err);
        this.logger.setMessageOutputLevel(2);
        this.project.addBuildListener((BuildListener)this.logger);
        if (System.getProperty("catalina.home") != null) {
            this.project.setBasedir(System.getProperty("catalina.home"));
        }
        if (this.options.getCompiler() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Compiler " + this.options.getCompiler()));
            }
            this.project.setProperty("build.compiler", this.options.getCompiler());
        }
        this.project.init();
        return this.project;
    }

    private String[] generateJava() throws Exception {
        String[] smapStr = null;
        long t4 = 0L;
        long t3 = 0L;
        long t2 = 0L;
        long t1 = 0L;
        if (log.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        this.pageInfo = new PageInfo(new BeanRepository(this.ctxt.getClassLoader(), this.errDispatcher), this.ctxt.getJspFile());
        JspConfig jspConfig = this.options.getJspConfig();
        JspConfig.JspProperty jspProperty = jspConfig.findJspProperty(this.ctxt.getJspFile());
        this.pageInfo.setELIgnored(JspUtil.booleanValue(jspProperty.isELIgnored()));
        this.pageInfo.setScriptingInvalid(JspUtil.booleanValue(jspProperty.isScriptingInvalid()));
        this.pageInfo.setTrimDirectiveWhitespaces(JspUtil.booleanValue(jspProperty.getTrimSpaces()));
        this.pageInfo.setDeferredSyntaxAllowedAsLiteral(JspUtil.booleanValue(jspProperty.getPoundAllowed()));
        if (jspProperty.getIncludePrelude() != null) {
            this.pageInfo.setIncludePrelude(jspProperty.getIncludePrelude());
        }
        if (jspProperty.getIncludeCoda() != null) {
            this.pageInfo.setIncludeCoda(jspProperty.getIncludeCoda());
        }
        String javaFileName = this.ctxt.getServletJavaFileName();
        ServletWriter writer = null;
        try {
            String javaEncoding = this.ctxt.getOptions().getJavaEncoding();
            OutputStreamWriter osw = null;
            try {
                osw = new OutputStreamWriter((OutputStream)new FileOutputStream(javaFileName), javaEncoding);
            }
            catch (UnsupportedEncodingException ex) {
                this.errDispatcher.jspError("jsp.error.needAlternateJavaEncoding", javaEncoding);
            }
            writer = new ServletWriter(new PrintWriter(osw));
            this.ctxt.setWriter(writer);
            JspUtil.resetTemporaryVariableName();
            ParserController parserCtl = new ParserController(this.ctxt, this);
            this.pageNodes = parserCtl.parse(this.ctxt.getJspFile());
            if (this.ctxt.isPrototypeMode()) {
                Generator.generate(writer, this, this.pageNodes);
                writer.close();
                writer = null;
                String[] stringArray = null;
                return stringArray;
            }
            Validator.validate(this, this.pageNodes);
            if (log.isDebugEnabled()) {
                t2 = System.currentTimeMillis();
            }
            Collector.collect(this, this.pageNodes);
            this.tfp = new TagFileProcessor();
            this.tfp.loadTagFiles(this, this.pageNodes);
            if (log.isDebugEnabled()) {
                t3 = System.currentTimeMillis();
            }
            ScriptingVariabler.set(this.pageNodes, this.errDispatcher);
            TagPluginManager tagPluginManager = this.options.getTagPluginManager();
            tagPluginManager.apply(this.pageNodes, this.errDispatcher, this.pageInfo);
            TextOptimizer.concatenate(this, this.pageNodes);
            ELFunctionMapper.map(this, this.pageNodes);
            Generator.generate(writer, this, this.pageNodes);
            writer.close();
            writer = null;
            this.ctxt.setWriter(null);
            if (log.isDebugEnabled()) {
                t4 = System.currentTimeMillis();
                log.debug((Object)("Generated " + javaFileName + " total=" + (t4 - t1) + " generate=" + (t4 - t3) + " validate=" + (t2 - t1)));
            }
        }
        catch (Exception e) {
            if (writer != null) {
                try {
                    writer.close();
                    writer = null;
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            new File(javaFileName).delete();
            throw e;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e2) {}
            }
        }
        if (!this.options.isSmapSuppressed()) {
            smapStr = SmapUtil.generateSmap(this.ctxt, this.pageNodes);
        }
        this.tfp.removeProtoTypeFiles(this.ctxt.getClassFileName());
        return smapStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateClass(String[] smap) throws FileNotFoundException, JasperException, Exception {
        BuildException be;
        StringBuffer errorReport;
        String javaFileName;
        long t1;
        block22: {
            t1 = 0L;
            if (log.isDebugEnabled()) {
                t1 = System.currentTimeMillis();
            }
            String javaEncoding = this.ctxt.getOptions().getJavaEncoding();
            javaFileName = this.ctxt.getServletJavaFileName();
            String classpath = this.ctxt.getClassPath();
            String sep = System.getProperty("path.separator");
            errorReport = new StringBuffer();
            StringBuffer info = new StringBuffer();
            info.append("Compile: javaFileName=" + javaFileName + "\n");
            info.append("    classpath=" + classpath + "\n");
            SystemLogHandler.setThread();
            this.getProject();
            Javac javac = (Javac)this.project.createTask("javac");
            Path path = new Path(this.project);
            String sysClassPath = this.options.getSystemClassPath();
            path.setPath(sysClassPath);
            info.append("    cp=" + sysClassPath + "\n");
            StringTokenizer tokenizer = new StringTokenizer(classpath, sep);
            while (tokenizer.hasMoreElements()) {
                String pathElement = tokenizer.nextToken();
                File repository = new File(pathElement);
                path.setLocation(repository);
                info.append("    cp=" + repository + "\n");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using classpath: " + sysClassPath + sep + classpath));
            }
            Path srcPath = new Path(this.project);
            srcPath.setLocation(this.options.getScratchDir());
            info.append("    work dir=" + this.options.getScratchDir() + "\n");
            String exts = System.getProperty("java.ext.dirs");
            if (exts != null) {
                Path extdirs = new Path(this.project);
                extdirs.setPath(exts);
                javac.setExtdirs(extdirs);
                info.append("    extension dir=" + exts + "\n");
            }
            javac.setEncoding(javaEncoding);
            javac.setClasspath(path);
            javac.setDebug(this.ctxt.getOptions().getClassDebugInfo());
            javac.setSrcdir(srcPath);
            javac.setOptimize(!this.ctxt.getOptions().getClassDebugInfo());
            javac.setFork(this.ctxt.getOptions().getFork());
            info.append("    srcDir=" + srcPath + "\n");
            if (this.options.getCompiler() != null) {
                javac.setCompiler(this.options.getCompiler());
                info.append("    compiler=" + this.options.getCompiler() + "\n");
            }
            if (this.options.getCompilerTargetVM() != null) {
                javac.setTarget(this.options.getCompilerTargetVM());
                info.append("   compilerTargetVM=" + this.options.getCompilerTargetVM() + "\n");
            }
            if (this.options.getCompilerSourceVM() != null) {
                javac.setSource(this.options.getCompilerSourceVM());
                info.append("   compilerSourceVM=" + this.options.getCompilerSourceVM() + "\n");
            }
            PatternSet.NameEntry includes = javac.createInclude();
            includes.setName(this.ctxt.getJavaPath());
            info.append("    include=" + this.ctxt.getJavaPath() + "\n");
            be = null;
            try {
                if (this.ctxt.getOptions().getFork()) {
                    javac.execute();
                    break block22;
                }
                Object object = javacLock;
                synchronized (object) {
                    javac.execute();
                }
            }
            catch (BuildException e) {
                be = e;
                log.error((Object)"Javac exception ", (Throwable)e);
                log.error((Object)("Env: " + info.toString()));
            }
        }
        errorReport.append(this.logger.getReport());
        String errorCapture = SystemLogHandler.unsetThread();
        if (errorCapture != null) {
            errorReport.append(System.getProperty("line.separator"));
            errorReport.append(errorCapture);
        }
        if (!this.ctxt.keepGenerated()) {
            File javaFile = new File(javaFileName);
            javaFile.delete();
        }
        if (be != null) {
            String errorReportString = errorReport.toString();
            log.error((Object)("Error compiling file: " + javaFileName + " " + errorReportString));
            JavacErrorDetail[] javacErrors = ErrorDispatcher.parseJavacErrors(errorReportString, javaFileName, this.pageNodes);
            if (javacErrors != null) {
                this.errDispatcher.javacError(javacErrors);
            } else {
                this.errDispatcher.javacError(errorReportString, (Exception)((Object)be));
            }
        }
        if (log.isDebugEnabled()) {
            long t2 = System.currentTimeMillis();
            log.debug((Object)("Compiled " + javaFileName + " " + (t2 - t1) + "ms"));
        }
        if (this.ctxt.isPrototypeMode()) {
            return;
        }
        if (!this.options.isSmapSuppressed()) {
            SmapUtil.installSmap(smap);
        }
        if (this.jsw != null && this.jsw.getServletClassLastModifiedTime() <= 0L) {
            File targetFile = new File(this.ctxt.getClassFileName());
            this.jsw.setServletClassLastModifiedTime(targetFile.lastModified());
        }
    }

    public void compile() throws FileNotFoundException, JasperException, Exception {
        this.compile(true);
    }

    public void compile(boolean compileClass) throws FileNotFoundException, JasperException, Exception {
        this.compile(compileClass, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void compile(boolean compileClass, boolean jspcMode) throws FileNotFoundException, JasperException, Exception {
        if (this.errDispatcher == null) {
            this.errDispatcher = new ErrorDispatcher(jspcMode);
        }
        try {
            String[] smap = this.generateJava();
            if (compileClass) {
                this.generateClass(smap);
            }
            Object var5_4 = null;
            if (this.tfp != null) {
                this.tfp.removeProtoTypeFiles(null);
            }
            this.tfp = null;
            this.errDispatcher = null;
            this.logger = null;
            this.project = null;
            this.pageInfo = null;
            this.pageNodes = null;
            if (this.ctxt.getWriter() == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.tfp != null) {
                this.tfp.removeProtoTypeFiles(null);
            }
            this.tfp = null;
            this.errDispatcher = null;
            this.logger = null;
            this.project = null;
            this.pageInfo = null;
            this.pageNodes = null;
            if (this.ctxt.getWriter() == null) throw throwable;
            this.ctxt.getWriter().close();
            this.ctxt.setWriter(null);
            throw throwable;
        }
        this.ctxt.getWriter().close();
        this.ctxt.setWriter(null);
    }

    public boolean isOutDated() {
        return this.isOutDated(true);
    }

    public boolean isOutDated(boolean checkClass) {
        String jsp = this.ctxt.getJspFile();
        if (this.jsw != null && this.ctxt.getOptions().getModificationTestInterval() > 0) {
            if (this.jsw.getLastModificationTest() + (long)(this.ctxt.getOptions().getModificationTestInterval() * 1000) > System.currentTimeMillis()) {
                return false;
            }
            this.jsw.setLastModificationTest(System.currentTimeMillis());
        }
        long jspRealLastModified = 0L;
        try {
            URL jspUrl = this.ctxt.getResource(jsp);
            if (jspUrl == null) {
                this.ctxt.incrementRemoved();
                return false;
            }
            URLConnection uc = jspUrl.openConnection();
            jspRealLastModified = uc.getLastModified();
            uc.getInputStream().close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
        long targetLastModified = 0L;
        File targetFile = checkClass ? new File(this.ctxt.getClassFileName()) : new File(this.ctxt.getServletJavaFileName());
        if (!targetFile.exists()) {
            return true;
        }
        targetLastModified = targetFile.lastModified();
        if (checkClass && this.jsw != null) {
            this.jsw.setServletClassLastModifiedTime(targetLastModified);
        }
        if (targetLastModified < jspRealLastModified) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Compiler: outdated: " + targetFile + " " + targetLastModified));
            }
            return true;
        }
        if (this.jsw == null) {
            return false;
        }
        List depends = this.jsw.getDependants();
        if (depends == null) {
            return false;
        }
        for (String include : depends) {
            try {
                URL includeUrl = this.ctxt.getResource(include);
                if (includeUrl == null) {
                    return true;
                }
                URLConnection includeUconn = includeUrl.openConnection();
                long includeLastModified = includeUconn.getLastModified();
                includeUconn.getInputStream().close();
                if (includeLastModified <= targetLastModified) continue;
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }
        return false;
    }

    public ErrorDispatcher getErrorDispatcher() {
        return this.errDispatcher;
    }

    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    public JspCompilationContext getCompilationContext() {
        return this.ctxt;
    }

    public void removeGeneratedFiles() {
        try {
            String classFileName = this.ctxt.getClassFileName();
            if (classFileName != null) {
                File classFile = new File(classFileName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting " + classFile));
                }
                classFile.delete();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String javaFileName = this.ctxt.getServletJavaFileName();
            if (javaFileName != null) {
                File javaFile = new File(javaFileName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting " + javaFile));
                }
                javaFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeGeneratedClassFiles() {
        try {
            String classFileName = this.ctxt.getClassFileName();
            if (classFileName != null) {
                File classFile = new File(classFileName);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deleting " + classFile));
                }
                classFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class JasperAntLogger
    extends DefaultLogger {
        private StringBuffer reportBuf = new StringBuffer();

        JasperAntLogger() {
        }

        protected void printMessage(String message, PrintStream stream, int priority) {
        }

        protected void log(String message) {
            this.reportBuf.append(message);
            this.reportBuf.append(System.getProperty("line.separator"));
        }

        protected String getReport() {
            String report = this.reportBuf.toString();
            this.reportBuf.setLength(0);
            return report;
        }
    }
}

