/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Set;
import java.util.regex.Pattern;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.util.Enumerations;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class Copy {
    private int maxItems;
    private int items;
    private int timeDev;
    static final /* synthetic */ boolean $assertionsDisabled;

    Copy() {
    }

    public static void copyDeep(FileObject source, FileObject target, Set thoseToCopy) throws IOException {
        Copy.copyDeep(source, target, thoseToCopy, null);
    }

    private static void copyDeep(FileObject source, FileObject target, Set thoseToCopy, String prefix) throws IOException {
        FileObject src = prefix == null ? source : FileUtil.createFolder((FileObject)source, (String)prefix);
        FileObject[] arr = src.getChildren();
        for (int i = 0; i < arr.length; ++i) {
            String fullname = prefix == null ? arr[i].getNameExt() : prefix + "/" + arr[i].getNameExt();
            if (arr[i].isData() && !thoseToCopy.contains(fullname)) continue;
            if (arr[i].isFolder()) {
                Copy.copyDeep(source, target, thoseToCopy, fullname);
                if (!thoseToCopy.contains(fullname) || !arr[i].getAttributes().hasMoreElements()) continue;
                FileObject tg = FileUtil.createFolder((FileObject)target, (String)fullname);
                FileUtil.copyAttributes((FileObject)arr[i], (FileObject)tg);
                continue;
            }
            FileObject folder = prefix == null ? target : FileUtil.createFolder((FileObject)target, (String)prefix);
            FileObject tg = folder.getFileObject(arr[i].getNameExt());
            try {
                if (tg == null) {
                    tg = FileUtil.copyFile((FileObject)arr[i], (FileObject)folder, (String)arr[i].getName(), (String)arr[i].getExt());
                }
            }
            catch (IOException ex) {
                if (arr[i].getNameExt().endsWith("_hidden")) continue;
                throw ex;
            }
            FileUtil.copyAttributes((FileObject)arr[i], (FileObject)tg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void appendSelectedLines(File sourceFile, File targetFolder, String[] regexForSelection) throws IOException {
        if (!sourceFile.exists()) {
            return;
        }
        linePattern = new Pattern[regexForSelection.length];
        for (i = 0; i < linePattern.length; ++i) {
            linePattern[i] = Pattern.compile(regexForSelection[i]);
        }
        bos = new ByteArrayOutputStream();
        targetFile = new File(targetFolder, sourceFile.getName());
        if (!targetFolder.exists()) {
            targetFolder.mkdirs();
        }
        if (!Copy.$assertionsDisabled && !targetFolder.exists()) {
            throw new AssertionError();
        }
        if (!targetFile.exists()) {
            targetFile.createNewFile();
        } else {
            targetIS = new FileInputStream(targetFile);
            try {
                FileUtil.copy((InputStream)targetIS, (OutputStream)bos);
            }
            finally {
                targetIS.close();
            }
        }
        if (!Copy.$assertionsDisabled && !targetFile.exists()) {
            throw new AssertionError();
        }
        line = null;
        sourceReader = new BufferedReader(new FileReader(sourceFile));
lbl30:
        // 2 sources

        try {
            block10: while ((line = sourceReader.readLine()) != null) {
                block21: {
                    if (linePattern == null) break block21;
                    for (i = 0; i < linePattern.length; ++i) {
                        m = linePattern[i].matcher(line);
                        if (!m.matches()) continue;
                        bos.write(line.getBytes());
                        bos.write(10);
                        continue block10;
                    }
                    ** GOTO lbl30
                }
                bos.write(line.getBytes());
                bos.write(10);
            }
        }
        finally {
            sourceReader.close();
        }
        bin = new ByteArrayInputStream(bos.toByteArray());
        targetOS = new FileOutputStream(targetFile);
        try {
            FileUtil.copy((InputStream)bin, (OutputStream)targetOS);
        }
        finally {
            bin.close();
            targetOS.close();
        }
    }

    private void recursiveCopy(FileObject sourceFolder, FileObject destFolder) throws IOException {
        FileObject[] childrens = sourceFolder.getChildren();
        for (int i = 0; i < childrens.length; ++i) {
            FileObject subSourceFo = childrens[i];
            FileObject subTargetFo = null;
            if (subSourceFo.isFolder()) {
                subTargetFo = destFolder.getFileObject(subSourceFo.getName());
                if (subTargetFo == null) {
                    subTargetFo = destFolder.createFolder(subSourceFo.getName());
                }
                Copy.copyAttributes(subSourceFo, subTargetFo);
                this.recursiveCopy(subSourceFo, subTargetFo);
                continue;
            }
            subTargetFo = destFolder.getFileObject(subSourceFo.getNameExt());
            if (subTargetFo == null) {
                subTargetFo = Utilities.getOperatingSystem() == 16384 && subSourceFo.getNameExt().equalsIgnoreCase("_nbattrs.") ? FileUtil.copyFile((FileObject)subSourceFo, (FileObject)destFolder, (String)subSourceFo.getNameExt(), (String)subSourceFo.getExt()) : FileUtil.copyFile((FileObject)subSourceFo, (FileObject)destFolder, (String)subSourceFo.getName(), (String)subSourceFo.getExt());
            }
            Copy.copyAttributes(subSourceFo, subTargetFo);
        }
    }

    private void message(String s) {
    }

    private void progress(int x, int y) {
    }

    private void recursiveCopyWithFilter(FileObject source, FileObject dest, Object[] filter, long basicTime) throws IOException {
        FileObject[] childrens = source.getChildren();
        if (!source.isFolder()) {
            this.message(Copy.getString("MSG_IS_NOT_FOLDER", source.getName()));
        }
        this.maxItems += childrens.length;
        for (int i = 0; i < childrens.length; ++i) {
            FileObject subSourceFo = childrens[i];
            ++this.items;
            this.progress(this.items, this.maxItems);
            if (!this.canCopy(subSourceFo, filter, basicTime)) continue;
            FileObject subTargetFo = null;
            if (subSourceFo.isFolder()) {
                subTargetFo = dest.getFileObject(subSourceFo.getNameExt());
                if (subTargetFo == null) {
                    subTargetFo = dest.createFolder(subSourceFo.getNameExt());
                }
                Copy.copyAttributes(subSourceFo, subTargetFo);
                this.recursiveCopyWithFilter(subSourceFo, subTargetFo, filter, basicTime);
                continue;
            }
            subTargetFo = dest.getFileObject(subSourceFo.getName(), subSourceFo.getExt());
            if (subTargetFo != null) {
                FileLock lock = subTargetFo.lock();
                subTargetFo.delete(lock);
                lock.releaseLock();
            }
            subTargetFo = Utilities.getOperatingSystem() == 16384 && subSourceFo.getNameExt().equalsIgnoreCase("_nbattrs.") ? this.copyFile(subSourceFo, dest, subSourceFo.getNameExt()) : this.copyFile(subSourceFo, dest, subSourceFo.getName());
            Copy.copyAttributes(subSourceFo, subTargetFo);
        }
    }

    private FileObject copyFile(FileObject src, FileObject trg, String newName) throws IOException {
        return FileUtil.copyFile((FileObject)src, (FileObject)trg, (String)newName);
    }

    private static void copyAttributes(FileObject source, FileObject dest) throws IOException {
        Enumeration attrKeys = source.getAttributes();
        while (attrKeys.hasMoreElements()) {
            String key = (String)attrKeys.nextElement();
            Object value = source.getAttribute(key);
            if (value == null) continue;
            dest.setAttribute(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canCopy(FileObject fo, Object[] filter, long basicTime) throws IOException {
        boolean canCopy;
        Object[] nonCopiedFiles = (String[])filter[0];
        String[] wildcards = (String[])filter[1];
        String name = fo.getPath();
        if (fo.isFolder()) {
            return Arrays.binarySearch(nonCopiedFiles, name + "/*") < 0;
        }
        for (int i = 0; i < wildcards.length; ++i) {
            if (!name.endsWith(wildcards[i])) continue;
            return false;
        }
        long time = fo.lastModified().getTime();
        boolean bl = canCopy = Arrays.binarySearch(nonCopiedFiles, name) < 0 && basicTime + (long)this.timeDev <= time;
        if (!canCopy) {
            return false;
        }
        if (fo.getExt().equals("settings")) {
            boolean tag1 = false;
            boolean tag2 = false;
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(fo.getInputStream()));
                while (null != (line = reader.readLine())) {
                    if (line.indexOf("<module name=") != -1) {
                        if (line.indexOf("<module name=\"org.netbeans.modules.java/1\"") == -1) break;
                        tag1 = true;
                    }
                    if (line.indexOf("<serialdata class=") == -1) continue;
                    if (line.indexOf("<serialdata class=\"org.netbeans.modules.java.FastJavacCompilerType\">") != -1) {
                        tag2 = true;
                        if (!tag1) continue;
                    }
                    break;
                }
            }
            catch (IOException ex) {
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            if (tag1 && tag2) {
                return false;
            }
        }
        return true;
    }

    public static String getIdeVersion(File dir) {
        Object version = null;
        Object dirType = null;
        Object branding = null;
        if (new File(dir, "system").exists()) {
            return "3.6";
        }
        return null;
    }

    protected static String getString(String key) {
        return NbBundle.getMessage((Class)Copy.class, (String)key);
    }

    protected static String getString(String key, String param) {
        return NbBundle.getMessage((Class)Copy.class, (String)key, (Object)param);
    }

    static {
        $assertionsDisabled = !Copy.class.desiredAssertionStatus();
    }

    private static class AttrslessLocalFileSystem
    extends AbstractFileSystem
    implements AbstractFileSystem.Attr {
        public AttrslessLocalFileSystem(LocalFileSystem fs) {
            this.change = new LocalFileSystem.Impl(fs);
            this.info = (AbstractFileSystem.Info)this.change;
            this.list = (AbstractFileSystem.List)this.change;
            this.attr = this;
        }

        public boolean isReadOnly() {
            return false;
        }

        public String getDisplayName() {
            return ((Object)((Object)this)).getClass().toString();
        }

        public void deleteAttributes(String name) {
        }

        public Enumeration attributes(String name) {
            return Enumerations.empty();
        }

        public void renameAttributes(String oldName, String newName) {
        }

        public void writeAttribute(String name, String attrName, Object value) throws IOException {
        }

        public Object readAttribute(String name, String attrName) {
            return null;
        }
    }
}

