/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.jmi.reflect.ConstraintViolationException;
import org.netbeans.jmi.javamodel.BehavioralFeature;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaDoc;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.Token;
import org.netbeans.mdr.storagemodel.StorableObject;
import org.netbeans.modules.javacore.jmiimpl.javamodel.DiffElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.FeatureImpl;
import org.netbeans.modules.javacore.jmiimpl.javamodel.IndentUtil;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.StatementBlockImpl;
import org.netbeans.modules.javacore.parser.ElementInfo;
import org.netbeans.modules.javacore.parser.FeatureInfo;
import org.netbeans.modules.javacore.parser.MDRParser;

public abstract class BehavioralFeatureImpl
extends FeatureImpl
implements BehavioralFeature {
    protected String bodyText;
    private BodyReference body;
    protected boolean bodyInited = false;
    private StatementBlock hardBody;

    public BehavioralFeatureImpl(StorableObject s) {
        super(s);
    }

    protected void matchElementInfo(ElementInfo newInfo) {
        super.matchElementInfo(newInfo);
        this.resetBody();
    }

    protected void uninitialize() {
        super.uninitialize();
        this.hardBody = null;
        this.retrieveBody();
    }

    protected void resetBody() {
        StatementBlock temp = this.retrieveBody();
        if (temp != null) {
            this.body = null;
            this.hardBody = null;
            this.changeChild((Element)temp, null);
            temp.refDelete();
        }
        this.bodyInited = false;
    }

    protected void objectChanged(int mask) {
        StatementBlock body;
        super.objectChanged(mask);
        if ((mask | 1) == mask && (body = this.retrieveBody()) != null) {
            this.hardBody = body;
        }
    }

    protected StatementBlock retrieveBody() {
        if (this.body == null) {
            return null;
        }
        StatementBlock result = (StatementBlock)this.body.get();
        return result;
    }

    protected abstract ASTree getBodyAST();

    public String getBodyText() {
        this.checkUpToDate();
        if (this.isChanged(32)) {
            if (this.hardBody != null) {
                throw new ConstraintViolationException(null, null, "Cannot ask for body text after the body was changed.");
            }
            return this.bodyText;
        }
        MDRParser parser = this.getParser();
        if (parser == null) {
            return null;
        }
        ASTree body = this.getBodyAST();
        if (body.getType() == 313) {
            return null;
        }
        Token firstToken = parser.getToken(body.getFirstToken());
        Token lastToken = parser.getToken(body.getLastToken());
        return parser.getSourceText().substring(firstToken.getEndOffset(), lastToken.getStartOffset());
    }

    public void setBodyText(String newValue) {
        if (!this.childrenInited) {
            this.initChildren();
        }
        StatementBlock temp = this.retrieveBody();
        if (this.bodyInited && temp != null) {
            this.resetBody();
        }
        this.objectChanged(32);
        this.bodyInited = true;
        this.bodyText = newValue;
    }

    public StatementBlock getBody() {
        this.checkUpToDate();
        if (this.isChanged(32) && this.bodyText != null) {
            throw new ConstraintViolationException(null, null, "Cannot ask for body after the body text was changed.");
        }
        StatementBlock body = this.retrieveBody();
        if (!this.bodyInited) {
            body = this.initBody();
        }
        return body;
    }

    protected void resetChildren() {
        super.resetChildren();
        this.resetBody();
    }

    public StatementBlock initBody() {
        this.bodyInited = false;
        if (!this.childrenInited) {
            this.initChildren();
        }
        StatementBlock body = this.retrieveBody();
        FeatureInfo info = (FeatureInfo)this.getElementInfo();
        if (this.getASTree() != null) {
            ASTree bodyAST = this.getBodyAST();
            if (bodyAST.getType() == 313) {
                body = null;
            } else {
                info.doAttribution(this);
                body = (StatementBlock)this.initOrCreate((Element)body, bodyAST);
            }
        }
        this.body = body == null ? null : new BodyReference(body);
        this.bodyInited = true;
        return body;
    }

    protected void setData(List annotations, String javadocText, JavaDoc javadoc, StatementBlock body, String bodyText) {
        super.setData(annotations, javadocText, javadoc);
        if (bodyText == null) {
            this.changeChild(null, (Element)body);
            this.hardBody = body;
            this.body = body == null ? null : new BodyReference(body);
        } else {
            if (body != null) {
                throw new ConstraintViolationException(null, null, "Cannot set both bodyText and body.");
            }
            this.bodyText = bodyText;
        }
        this.bodyInited = true;
    }

    public void setBody(StatementBlock newValue) {
        StatementBlock body = this.retrieveBody();
        if (!this.bodyInited) {
            body = this.initBody();
        }
        this.changeChild((Element)body, (Element)newValue);
        this.hardBody = newValue;
        this.body = newValue == null ? null : new BodyReference(newValue);
        this.bodyText = null;
        this.objectChanged(32);
    }

    public List getChildren() {
        ArrayList list = new ArrayList();
        if (!this.isChanged(32) || this.bodyText == null) {
            BehavioralFeatureImpl.addIfNotNull(list, this.getBody());
        }
        return list;
    }

    public void fixImports(Element scope, Element original) {
        BehavioralFeature bhFeature = (BehavioralFeature)original;
        StatementBlockImpl newBody = (StatementBlockImpl)this.getBody();
        StatementBlock oldBody = bhFeature.getBody();
        if (newBody != null && oldBody != null) {
            newBody.fixImports(scope, (Element)oldBody);
        }
        super.fixImports(scope, original);
    }

    protected List getInitedChildren() {
        List list = super.getInitedChildren();
        StatementBlock body = this.retrieveBody();
        if (this.bodyInited && (!this.isChanged(32) || this.bodyText == null)) {
            BehavioralFeatureImpl.addIfNotNull(list, body);
        }
        return list;
    }

    public void replaceChild(Element oldElement, Element newElement) {
        StatementBlock body = this.retrieveBody();
        if (this.bodyInited && oldElement.equals(body)) {
            this.setBody((StatementBlock)newElement);
            return;
        }
        super.replaceChild(oldElement, newElement);
    }

    protected String indentBody(String oldBody) {
        StringBuffer sb = new StringBuffer();
        int state = 0;
        StringBuffer line = new StringBuffer();
        int level = 0;
        int raiseLevel = 0;
        int bracket = 0;
        boolean isStatement = false;
        boolean previousStatement = false;
        int questionMark = 0;
        Stack<String> stack = new Stack<String>();
        block24: for (int i = 0; i < oldBody.length(); ++i) {
            char ch = oldBody.charAt(i);
            if (ch == '\n') {
                if (i != 0) {
                    sb.append(this.getBodyIndentation()).append(BehavioralFeatureImpl.getInnerIndentation(level)).append(line).append(ch);
                } else {
                    sb.append(ch);
                }
                line = new StringBuffer();
                if (state != 8) {
                    state = 0;
                }
                level += raiseLevel;
                if (isStatement && !previousStatement) {
                    ++level;
                } else if (!isStatement && previousStatement) {
                    --level;
                }
                previousStatement = isStatement;
                raiseLevel = 0;
                continue;
            }
            switch (state) {
                case 0: {
                    if (Character.isWhitespace(ch)) continue block24;
                    state = 1;
                }
                case 1: {
                    switch (ch) {
                        case '/': {
                            state = 2;
                            break;
                        }
                        case '\"': {
                            state = 10;
                            isStatement = true;
                            break;
                        }
                        case '\'': {
                            state = 4;
                            isStatement = true;
                            break;
                        }
                        case '{': {
                            if (bracket == 0 && questionMark == 0) {
                                if (!stack.isEmpty()) {
                                    stack.push("bracket");
                                }
                                isStatement = false;
                                ++raiseLevel;
                                break;
                            }
                            isStatement = true;
                            break;
                        }
                        case '}': {
                            if (bracket == 0 && questionMark == 0) {
                                if (!stack.isEmpty() && "colon".equals(stack.pop())) {
                                    --level;
                                }
                                isStatement = false;
                                if (line.length() == 0) {
                                    --level;
                                    break;
                                }
                                --raiseLevel;
                                break;
                            }
                            isStatement = true;
                            break;
                        }
                        case ';': {
                            isStatement = bracket != 0;
                            questionMark = 0;
                            break;
                        }
                        case '?': {
                            ++questionMark;
                            isStatement = true;
                            break;
                        }
                        case '(': {
                            ++bracket;
                            isStatement = true;
                            break;
                        }
                        case ')': {
                            --bracket;
                            isStatement = true;
                            break;
                        }
                        case ':': {
                            if (questionMark > 0) {
                                --questionMark;
                            } else {
                                if (!stack.isEmpty() && stack.peek().equals("colon")) {
                                    --level;
                                    ++raiseLevel;
                                } else {
                                    stack.push("colon");
                                    ++raiseLevel;
                                }
                                isStatement = false;
                                break;
                            }
                            isStatement = true;
                            break;
                        }
                        default: {
                            if (Character.isWhitespace(ch)) break;
                            isStatement = true;
                        }
                    }
                    if (ch == '\n') continue block24;
                    line.append(ch);
                    continue block24;
                }
                case 2: {
                    if (ch == '/') {
                        state = 3;
                    } else if (ch == '*') {
                        state = 8;
                    } else {
                        isStatement = true;
                        state = 1;
                    }
                    line.append(ch);
                    continue block24;
                }
                case 3: {
                    line.append(ch);
                    continue block24;
                }
                case 8: {
                    if (ch == '*') {
                        state = 9;
                    }
                    line.append(ch);
                    continue block24;
                }
                case 9: {
                    if (ch == '/') {
                        state = 1;
                    } else if (ch != '*') {
                        state = 8;
                    }
                    line.append(ch);
                    continue block24;
                }
                case 4: {
                    if (ch == '\\') {
                        state = 11;
                    } else if (ch == '\'') {
                        state = 1;
                    }
                    line.append(ch);
                    continue block24;
                }
                case 11: {
                    state = 4;
                    line.append(ch);
                    continue block24;
                }
                case 10: {
                    if (ch == '\\') {
                        state = 12;
                    } else if (ch == '\"') {
                        state = 1;
                    }
                    line.append(ch);
                    continue block24;
                }
                case 12: {
                    state = 10;
                    line.append(ch);
                }
            }
        }
        if (line.length() > 0) {
            sb.append(this.getBodyIndentation()).append(BehavioralFeatureImpl.getInnerIndentation(level)).append(line).append('\n');
        }
        return sb.toString();
    }

    protected void generateBody(StringBuffer buf) {
        StatementBlock body = this.retrieveBody();
        if (!this.bodyInited) {
            body = this.initBody();
        }
        if (this.bodyText != null && this.bodyText.length() > 0 && !this.bodyText.equals("\n")) {
            if (this.bodyText.startsWith("\n") || this.bodyText.startsWith("\r\n")) {
                buf.append(this.getElementPrefix(1)).append('{');
            } else {
                this.formatElementPart(1, buf);
            }
            buf.append(this.indentBody(this.bodyText));
            this.formatElementPart(2, buf);
        } else if (body != null) {
            buf.append(((StatementBlockImpl)body).getSourceText());
        } else {
            this.formatElementPart(1, buf);
            this.formatElementPart(2, buf);
        }
    }

    protected void createBodyDiffs(List diffList) {
        MDRParser parser = this.getParser();
        if (this.hardBody == null) {
            if (this.isChanged(32)) {
                int startOffset;
                Token bodyStart;
                StringBuffer buf = new StringBuffer();
                if (this.bodyText == null) {
                    bodyStart = parser.getToken(this.getBodyAST().getFirstToken() - 1);
                    startOffset = bodyStart.getEndOffset();
                    buf.append(';');
                } else {
                    bodyStart = parser.getToken(this.getBodyAST().getFirstToken());
                    startOffset = bodyStart.getStartOffset();
                    if (this.bodyText.startsWith("\n") || this.bodyText.startsWith("\r\n")) {
                        buf.append('{');
                    } else {
                        buf.append(IndentUtil.leftTrim(this.formatElementPart(1)));
                    }
                    buf.append(this.indentBody(this.bodyText));
                    this.formatElementPart(2, buf);
                }
                Token bodyEnd = parser.getToken(this.getBodyAST().getLastToken());
                int endOffset = bodyEnd.getEndOffset();
                diffList.add(new DiffElement(startOffset, endOffset, buf.toString()));
            }
        } else {
            this.getChildDiff(diffList, parser, this.getBodyAST(), (MetadataElement)this.getBody(), 32);
        }
    }

    protected void _delete() {
        if (this.bodyInited && this.body != null) {
            this.deleteChild((Element)((StatementBlock)this.body.get()));
        }
        super._delete();
    }

    private class BodyReference
    extends WeakReference {
        BodyReference(StatementBlock body) {
            super(body);
        }

        public Object get() {
            Object result = super.get();
            if (result == null) {
                BehavioralFeatureImpl.this.body = null;
                BehavioralFeatureImpl.this.bodyInited = false;
            }
            return result;
        }
    }
}

