/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.EnumConstant;
import org.netbeans.jmi.javamodel.Expression;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.FieldGroup;
import org.netbeans.jmi.javamodel.ForStatement;
import org.netbeans.jmi.javamodel.LocalVarDeclaration;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Statement;
import org.netbeans.jmi.javamodel.StatementBlock;
import org.netbeans.lib.java.parser.ASTree;
import org.netbeans.lib.java.parser.Token;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.javacore.parser.MDRParser;

public final class IndentUtil {
    static final /* synthetic */ boolean $assertionsDisabled;

    static String leftTrim(String s) {
        int pos;
        int len = s.length();
        char[] val = s.toCharArray();
        for (pos = 0; pos < len && val[pos] <= ' '; ++pos) {
        }
        return pos == 0 ? s : s.substring(pos, len);
    }

    static String getOriginalIndentation(String s, int[] origPos) {
        int pos;
        int len = s.length();
        char[] val = s.toCharArray();
        StringBuffer result = new StringBuffer();
        for (pos = 0; pos < len && val[pos] <= ' '; ++pos) {
        }
        while (pos > 0 && (val[--pos] == ' ' || val[pos] == '\t')) {
            if (val[pos] != ' ' && val[pos] != '\t') continue;
            result.append(val[pos]);
        }
        origPos[0] = pos;
        return result.reverse().toString();
    }

    static String indentExistingElement(MetadataElement element, String src) {
        StringBuffer result = new StringBuffer(80);
        if (element instanceof EnumConstant || element instanceof Field && element.refImmediateComposite() instanceof FieldGroup) {
            return src;
        }
        if (element instanceof Statement || element instanceof Feature || element instanceof FieldGroup) {
            int[] oP = new int[1];
            String origInd = IndentUtil.getOriginalIndentation(src, oP);
            String[] statementLines = src.split("\\n");
            for (int i = 0; i < statementLines.length; ++i) {
                String line = statementLines[i];
                if (IndentUtil.leftTrim(line).length() == 0) {
                    result.append('\n');
                    continue;
                }
                if (line.endsWith("\r")) {
                    line = line.substring(0, line.length() - 1);
                }
                result.append(element.getIndentation());
                if (line.indexOf(origInd) > -1) {
                    result.append(line.substring(origInd.length()));
                } else {
                    result.append(line);
                }
                if (i >= statementLines.length - 1) continue;
                result.append('\n');
            }
            return result.toString();
        }
        return src;
    }

    static String indentNewElement(MetadataElement e) {
        StringBuffer sb = new StringBuffer(1024);
        String sourceText = e.getRawText();
        MetadataElement parent = (MetadataElement)e.refImmediateComposite();
        if (e instanceof StatementBlock) {
            sb.append(e.getElementPrefix(32));
            sb.append(sourceText);
        } else if (e instanceof Annotation || e instanceof EnumConstant) {
            sb.append(sourceText);
        } else if (e instanceof Statement || e instanceof Feature || e instanceof FieldGroup) {
            if (e instanceof LocalVarDeclaration && parent instanceof ForStatement || e instanceof Field && parent instanceof FieldGroup) {
                sb.append(sourceText);
            } else {
                sb.append('\n');
                sb.append(e.getIndentation());
                sb.append(sourceText);
            }
        } else {
            sb.append(sourceText);
        }
        return sb.toString();
    }

    static int getElementStart(Element el) {
        MetadataElement e = (MetadataElement)el;
        int result = e.getStartOffset(e.getParser(), e.getASTree(), true);
        if (e instanceof Resource) {
            result = 0;
        } else if (e instanceof Expression) {
            result = e.getStartOffset(e.getParser(), e.getASTree(), false);
        } else if (e instanceof Annotation) {
            result = e.getParser().getToken(e.getASTree().getFirstToken()).getStartOffset();
        }
        return result;
    }

    static int getElementEnd(Element el) {
        MetadataElement e = (MetadataElement)el;
        int result = MetadataElement.getEndOffset(e.getParser(), e.getASTree());
        if (e instanceof Resource) {
            result = e.getParser().getSourceText().length();
        }
        return result;
    }

    static final void printTokenWithAllAround(int token, int origToken, MetadataElement element, StringBuffer buf) {
        if (!$assertionsDisabled && element.isNew()) {
            throw new AssertionError((Object)"Cannot call it for the new element!");
        }
        MDRParser parser = element.getParser();
        Token t = parser.getToken(token - 1);
        int begin = t.getEndOffset();
        t = parser.getToken(token + 1);
        int end = t.getStartOffset();
        String s = parser.getSourceText().substring(begin, end);
        StringBuffer tempInd = new StringBuffer();
        if (!IndentUtil.getOriginalIndentation(origToken, element, tempInd)) {
            buf.append(s);
        } else {
            buf.append(IndentUtil.reformat(s, element.getIndentation(), tempInd.toString()));
        }
    }

    static final void printTailGarbage(MetadataElement element, StringBuffer buf) {
        if (!$assertionsDisabled && element.isNew()) {
            throw new AssertionError((Object)"Cannot call it for new elements!");
        }
        ASTree tree = element.getASTree();
        MDRParser parser = element.getParser();
        buf.append(IndentUtil.getGarbage(tree.getLastToken() + 1, parser, true));
    }

    static final void printHeadGarbage(MetadataElement element, StringBuffer buf) {
        if (!$assertionsDisabled && element.isNew()) {
            throw new AssertionError((Object)"Cannot call it for new elements!");
        }
        ASTree tree = element.getASTree();
        MDRParser parser = element.getParser();
        buf.append(IndentUtil.getGarbage(tree.getFirstToken(), parser, false));
    }

    static String getGarbage(int tokenId, MDRParser p, boolean tail) {
        StringBuffer buf = new StringBuffer(15);
        int startOffset = tokenId == 0 ? 0 : p.getToken(tokenId - 1).getEndOffset();
        int endOffset = p.getToken(tokenId).getStartOffset();
        Token[] pad = p.getToken(tokenId).getPadding();
        if (pad.length > 0) {
            for (int i = 0; i < pad.length; ++i) {
                if (pad[i].getType() != 366) continue;
                if (tail) {
                    endOffset = pad[i].getStartOffset();
                    break;
                }
                startOffset = pad[i].getStartOffset();
                break;
            }
        }
        return p.getSourceText().substring(startOffset, endOffset);
    }

    static String printTokenWithPads(int tokenId, MDRParser p) {
        String startPads = IndentUtil.getGarbage(tokenId, p, false);
        String endPads = IndentUtil.getGarbage(tokenId + 1, p, true);
        Token token = p.getToken(tokenId);
        return startPads + p.getText(token) + endPads;
    }

    static final String reformatTokenWithPads(MetadataElement element, int tokenId) {
        MDRParser p = element.getParser();
        String startPads = IndentUtil.getGarbage(tokenId, p, false);
        String endPads = IndentUtil.getGarbage(tokenId + 1, p, true);
        return IndentUtil.indentExistingElement(element, startPads, tokenId) + p.getText(p.getToken(tokenId)) + endPads;
    }

    static final void reformatHeadGarbage(MetadataElement element, int tokenId, StringBuffer buf) {
        MDRParser p = element.getParser();
        String startPads = IndentUtil.getGarbage(tokenId, p, false);
        buf.append(IndentUtil.indentExistingElement(element, startPads, tokenId));
    }

    static void reformatHeadGarbage(MetadataElement element, StringBuffer buf) {
        StringBuffer sb = new StringBuffer(80);
        IndentUtil.printHeadGarbage(element, sb);
        buf.append(IndentUtil.indentExistingElement2(element, sb.toString()));
    }

    static String indentExistingElement2(MetadataElement element, String src) {
        StringBuffer result = new StringBuffer(80);
        if (element instanceof EnumConstant || element instanceof Field && element.refImmediateComposite() instanceof FieldGroup) {
            return src;
        }
        if (element instanceof Statement || element instanceof Feature || element instanceof FieldGroup) {
            int[] oP = new int[1];
            String origInd = IndentUtil.getOriginalIndentation(src, oP);
            String[] statementLines = src.split("\\n");
            for (int i = 0; i < statementLines.length; ++i) {
                String line = statementLines[i];
                if (line.endsWith("\r")) {
                    line = line.substring(0, line.length() - 1);
                }
                if (line.indexOf(origInd) > -1) {
                    result.append(element.getIndentation());
                    result.append(line.substring(origInd.length()));
                } else {
                    result.append(line);
                }
                if (i >= statementLines.length - 1) continue;
                result.append('\n');
            }
            return result.toString();
        }
        return src;
    }

    private static boolean getOriginalIndentation(int tokenId, MetadataElement element, StringBuffer buf) {
        if (!$assertionsDisabled && element.isNew()) {
            throw new AssertionError((Object)"Cannot call it for the new element!");
        }
        MDRParser p = element.getParser();
        Token[] pad = p.getToken(tokenId).getPadding();
        int startOffset = -1;
        if (pad.length > 0) {
            int endOffset = p.getToken(tokenId).getStartOffset();
            for (int i = 0; i < pad.length; ++i) {
                if (pad[i].getType() != 366) continue;
                startOffset = pad[i].getEndOffset();
            }
            if (startOffset != -1) {
                buf.append(p.getSourceText().substring(startOffset, endOffset));
                return true;
            }
        }
        return false;
    }

    static String indentExistingElement(MetadataElement element, String src, int tokenId) {
        if (!$assertionsDisabled && element.isNew()) {
            throw new AssertionError((Object)"Cannot call it for the new element!");
        }
        if (element instanceof EnumConstant || element instanceof Field && element.refImmediateComposite() instanceof FieldGroup) {
            return src;
        }
        if (element instanceof Statement || element instanceof Feature || element instanceof FieldGroup) {
            StringBuffer tempInd = new StringBuffer();
            if (!IndentUtil.getOriginalIndentation(tokenId, element, tempInd)) {
                return src;
            }
            return IndentUtil.reformat(src, element.getIndentation(), tempInd.toString());
        }
        return src;
    }

    private static String reformat(String src, String newInd, String origInd) {
        StringBuffer result = new StringBuffer(80);
        String[] statementLines = src.split("\\n");
        for (int i = 0; i < statementLines.length; ++i) {
            String line = statementLines[i];
            if (line.endsWith("\r")) {
                line = line.substring(0, line.length() - 1);
            }
            if (line.indexOf(origInd) == 0) {
                result.append(newInd);
                result.append(line.substring(origInd.length()));
            } else {
                result.append(line);
            }
            if (i >= statementLines.length - 1) continue;
            result.append('\n');
        }
        return result.toString();
    }

    static {
        $assertionsDisabled = !IndentUtil.class.desiredAssertionStatus();
    }
}

