/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class InstanceMap
extends HashMap {
    private final ReferenceQueue queue = new ReferenceQueue();

    private void cleanUp() {
        InstanceReference reference;
        while ((reference = (InstanceReference)this.queue.poll()) != null) {
            Object key = reference.getKey();
            Reference currentRef = (Reference)super.remove(key);
            if (currentRef == null || currentRef == reference || currentRef.get() == null) continue;
            super.put(key, currentRef);
        }
    }

    public Object put(Object key, Object value) {
        this.cleanUp();
        InstanceReference result = super.put(key, new InstanceReference(key, value));
        if (result != null) {
            return result.get();
        }
        return result;
    }

    public Object get(Object key) {
        this.cleanUp();
        Object result = super.get(key);
        if (result != null) {
            return ((InstanceReference)result).get();
        }
        return result;
    }

    public Collection values() {
        ArrayList result = new ArrayList();
        this.cleanUp();
        Iterator it = super.values().iterator();
        while (it.hasNext()) {
            result.add(((InstanceReference)it.next()).get());
        }
        return result;
    }

    private class InstanceReference
    extends WeakReference {
        private Object key;

        public InstanceReference(Object key, Object instance) {
            super(instance, InstanceMap.this.queue);
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }
    }
}

