/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.netbeans.spi.project.ant.AntArtifactQueryImplementation;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class AntArtifactQuery {
    private AntArtifactQuery() {
    }

    public static AntArtifact findArtifactFromFile(File file) {
        if (!file.equals(FileUtil.normalizeFile((File)file))) {
            throw new IllegalArgumentException("Parameter file was not normalized. Was " + file + " instead of " + FileUtil.normalizeFile((File)file));
        }
        Iterator it = Lookup.getDefault().lookup(new Lookup.Template(AntArtifactQueryImplementation.class)).allInstances().iterator();
        while (it.hasNext()) {
            AntArtifactQueryImplementation aaqi = (AntArtifactQueryImplementation)it.next();
            AntArtifact artifact = aaqi.findArtifact(file);
            if (artifact == null) continue;
            return artifact;
        }
        return null;
    }

    public static AntArtifact findArtifactByID(Project p, String id) {
        AntArtifactProvider prov = (AntArtifactProvider)p.getLookup().lookup(AntArtifactProvider.class);
        if (prov == null) {
            return null;
        }
        AntArtifact[] artifacts = prov.getBuildArtifacts();
        for (int i = 0; i < artifacts.length; ++i) {
            if (!artifacts[i].getID().equals(id)) continue;
            return artifacts[i];
        }
        return null;
    }

    public static AntArtifact[] findArtifactsByType(Project p, String type) {
        AntArtifactProvider prov = (AntArtifactProvider)p.getLookup().lookup(AntArtifactProvider.class);
        if (prov == null) {
            return new AntArtifact[0];
        }
        AntArtifact[] artifacts = prov.getBuildArtifacts();
        ArrayList<AntArtifact> l = new ArrayList<AntArtifact>(artifacts.length);
        for (int i = 0; i < artifacts.length; ++i) {
            if (!artifacts[i].getType().equals(type)) continue;
            l.add(artifacts[i]);
        }
        return l.toArray(new AntArtifact[l.size()]);
    }
}

