/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.project.ant.AntBasedProjectFactorySingleton;
import org.netbeans.modules.project.ant.FileChangeSupport;
import org.netbeans.modules.project.ant.FileChangeSupportEvent;
import org.netbeans.modules.project.ant.FileChangeSupportListener;
import org.netbeans.spi.project.support.GenericSources;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;

public final class SourcesHelper {
    private final AntProjectHelper project;
    private final PropertyEvaluator evaluator;
    private final List principalSourceRoots = new ArrayList();
    private final List nonSourceRoots = new ArrayList();
    private final List typedSourceRoots = new ArrayList();
    private int registeredRootAlgorithm;
    private Set lastRegisteredRoots;
    private PropertyChangeListener propChangeL;
    static /* synthetic */ Class class$org$netbeans$spi$project$support$ant$SourcesHelper;

    public SourcesHelper(AntProjectHelper project, PropertyEvaluator evaluator) {
        this.project = project;
        this.evaluator = evaluator;
    }

    public void addPrincipalSourceRoot(String location, String displayName, Icon icon, Icon openedIcon) throws IllegalStateException {
        if (this.lastRegisteredRoots != null) {
            throw new IllegalStateException("registerExternalRoots was already called");
        }
        this.principalSourceRoots.add(new SourceRoot(location, displayName, icon, openedIcon));
    }

    public void addNonSourceRoot(String location) throws IllegalStateException {
        if (this.lastRegisteredRoots != null) {
            throw new IllegalStateException("registerExternalRoots was already called");
        }
        this.nonSourceRoots.add(new Root(location));
    }

    public void addTypedSourceRoot(String location, String type, String displayName, Icon icon, Icon openedIcon) throws IllegalStateException {
        if (this.lastRegisteredRoots != null) {
            throw new IllegalStateException("registerExternalRoots was already called");
        }
        this.typedSourceRoots.add(new TypedSourceRoot(type, location, displayName, icon, openedIcon));
    }

    private Project getProject() {
        return AntBasedProjectFactorySingleton.getProjectFor(this.project);
    }

    public void registerExternalRoots(int algorithm) throws IllegalArgumentException, IllegalStateException {
        if (this.lastRegisteredRoots != null) {
            throw new IllegalStateException("registerExternalRoots was already called before");
        }
        this.registeredRootAlgorithm = algorithm;
        this.remarkExternalRoots();
    }

    private void remarkExternalRoots() throws IllegalArgumentException {
        FileObject loc;
        HashSet<FileObject> newRootsToRegister;
        ArrayList allRoots = new ArrayList(this.principalSourceRoots);
        allRoots.addAll(this.nonSourceRoots);
        Project p = this.getProject();
        FileObject pdir = this.project.getProjectDirectory();
        if (this.lastRegisteredRoots == null) {
            newRootsToRegister = null;
            this.lastRegisteredRoots = new HashSet();
            this.propChangeL = new PropChangeL();
            this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propChangeL, (Object)this.evaluator));
        } else {
            newRootsToRegister = new HashSet<FileObject>();
        }
        Iterator it = allRoots.iterator();
        while (it.hasNext()) {
            Root r = (Root)it.next();
            File locF = r.getActualLocation();
            loc = locF != null ? FileUtil.toFileObject((File)locF) : null;
            if (loc == null || !loc.isFolder() || FileUtil.getRelativePath((FileObject)pdir, (FileObject)loc) != null) continue;
            try {
                Project other = ProjectManager.getDefault().findProject(loc);
                if (other != null) {
                }
            }
            catch (IOException e) {}
            continue;
            if (newRootsToRegister != null) {
                newRootsToRegister.add(loc);
                continue;
            }
            this.lastRegisteredRoots.add(loc);
            FileOwnerQuery.markExternalOwner((FileObject)loc, (Project)p, (int)this.registeredRootAlgorithm);
        }
        if (newRootsToRegister != null) {
            HashSet toUnregister = new HashSet(this.lastRegisteredRoots);
            toUnregister.removeAll(newRootsToRegister);
            Iterator rootIt = toUnregister.iterator();
            while (rootIt.hasNext()) {
                loc = (FileObject)rootIt.next();
                FileOwnerQuery.markExternalOwner((FileObject)loc, null, (int)this.registeredRootAlgorithm);
            }
            newRootsToRegister.removeAll(this.lastRegisteredRoots);
            rootIt = newRootsToRegister.iterator();
            while (rootIt.hasNext()) {
                loc = (FileObject)rootIt.next();
                FileOwnerQuery.markExternalOwner((FileObject)loc, (Project)p, (int)this.registeredRootAlgorithm);
            }
        }
    }

    public Sources createSources() {
        return new SourcesImpl();
    }

    private final class PropChangeL
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            SourcesHelper.this.remarkExternalRoots();
        }
    }

    private final class SourcesImpl
    implements Sources,
    PropertyChangeListener,
    FileChangeSupportListener {
        private final List listeners = new ArrayList();
        private final Set rootsListenedTo = new WeakSet();
        private final Map lastComputedRoots = new HashMap();
        static final /* synthetic */ boolean $assertionsDisabled;

        public SourcesImpl() {
            SourcesHelper.this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)SourcesHelper.this.evaluator));
        }

        public SourceGroup[] getSourceGroups(String type) {
            FileObject loc;
            Iterator<Object> it;
            ArrayList<SourceGroup> groups = new ArrayList<SourceGroup>();
            if (type.equals("generic")) {
                ArrayList<SourceRoot> roots = new ArrayList<SourceRoot>(SourcesHelper.this.principalSourceRoots);
                roots.add(new SourceRoot("", ProjectUtils.getInformation((Project)SourcesHelper.this.getProject()).getDisplayName(), null, null));
                it = roots.iterator();
                LinkedHashMap<FileObject, SourceRoot> rootsByDir = new LinkedHashMap<FileObject, SourceRoot>();
                while (it.hasNext()) {
                    SourceRoot r = (SourceRoot)it.next();
                    File locF = r.getActualLocation();
                    if (locF == null) continue;
                    this.listen(locF);
                    FileObject loc2 = FileUtil.toFileObject((File)locF);
                    if (loc2 == null || rootsByDir.containsKey(loc2)) continue;
                    rootsByDir.put(loc2, r);
                }
                it = rootsByDir.keySet().iterator();
                block3: while (it.hasNext()) {
                    FileObject loc3 = (FileObject)it.next();
                    for (FileObject parent = loc3.getParent(); parent != null; parent = parent.getParent()) {
                        if (!rootsByDir.containsKey(parent)) continue;
                        it.remove();
                        continue block3;
                    }
                }
                it = rootsByDir.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    loc = (FileObject)entry.getKey();
                    SourceRoot r = (SourceRoot)entry.getValue();
                    groups.add(r.toGroup(loc));
                }
            } else {
                Iterator it2 = SourcesHelper.this.typedSourceRoots.iterator();
                HashSet<FileObject> dirs = new HashSet<FileObject>();
                while (it2.hasNext()) {
                    File locF;
                    TypedSourceRoot r = (TypedSourceRoot)it2.next();
                    if (!r.getType().equals(type) || (locF = r.getActualLocation()) == null) continue;
                    this.listen(locF);
                    loc = FileUtil.toFileObject((File)locF);
                    if (loc == null || !dirs.add(loc)) continue;
                    groups.add(r.toGroup(loc));
                }
            }
            ArrayList<URL> rootURLs = new ArrayList<URL>(groups.size());
            it = groups.iterator();
            while (it.hasNext()) {
                SourceGroup g = (SourceGroup)it.next();
                try {
                    rootURLs.add(g.getRootFolder().getURL());
                }
                catch (FileStateInvalidException e) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)e);
                    }
                }
            }
            this.lastComputedRoots.put(type, rootURLs);
            return groups.toArray(new SourceGroup[groups.size()]);
        }

        private void listen(File rootLocation) {
            if (this.rootsListenedTo.add(rootLocation)) {
                FileChangeSupport.DEFAULT.addListener(this, rootLocation);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener listener) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener listener) {
            List list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ChangeListener[] _listeners;
            List list = this.listeners;
            synchronized (list) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                _listeners = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            }
            ChangeEvent ev = new ChangeEvent(this);
            for (int i = 0; i < _listeners.length; ++i) {
                _listeners[i].stateChanged(ev);
            }
        }

        private void maybeFireChange() {
            boolean change = false;
            Iterator it = new HashSet(this.lastComputedRoots.keySet()).iterator();
            while (it.hasNext()) {
                String type = (String)it.next();
                ArrayList previous = new ArrayList((List)this.lastComputedRoots.get(type));
                this.getSourceGroups(type);
                List nue = (List)this.lastComputedRoots.get(type);
                if (((Object)nue).equals(previous)) continue;
                change = true;
                break;
            }
            if (change) {
                this.fireChange();
            }
        }

        public void fileCreated(FileChangeSupportEvent event) {
            this.maybeFireChange();
        }

        public void fileDeleted(FileChangeSupportEvent event) {
            this.maybeFireChange();
        }

        public void fileModified(FileChangeSupportEvent event) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.maybeFireChange();
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$spi$project$support$ant$SourcesHelper == null ? (class$org$netbeans$spi$project$support$ant$SourcesHelper = SourcesHelper.class$("org.netbeans.spi.project.support.ant.SourcesHelper")) : class$org$netbeans$spi$project$support$ant$SourcesHelper).desiredAssertionStatus();
        }
    }

    private final class TypedSourceRoot
    extends SourceRoot {
        private final String type;

        public TypedSourceRoot(String type, String location, String displayName, Icon icon, Icon openedIcon) {
            super(location, displayName, icon, openedIcon);
            this.type = type;
        }

        public final String getType() {
            return this.type;
        }
    }

    private class SourceRoot
    extends Root {
        private final String displayName;
        private final Icon icon;
        private final Icon openedIcon;
        static final /* synthetic */ boolean $assertionsDisabled;

        public SourceRoot(String location, String displayName, Icon icon, Icon openedIcon) {
            super(location);
            this.displayName = displayName;
            this.icon = icon;
            this.openedIcon = openedIcon;
        }

        public final SourceGroup toGroup(FileObject loc) {
            if (!$assertionsDisabled && loc == null) {
                throw new AssertionError();
            }
            return GenericSources.group((Project)SourcesHelper.this.getProject(), (FileObject)loc, (String)(this.location.length() > 0 ? this.location : "generic"), (String)this.displayName, (Icon)this.icon, (Icon)this.openedIcon);
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$spi$project$support$ant$SourcesHelper == null ? (class$org$netbeans$spi$project$support$ant$SourcesHelper = SourcesHelper.class$("org.netbeans.spi.project.support.ant.SourcesHelper")) : class$org$netbeans$spi$project$support$ant$SourcesHelper).desiredAssertionStatus();
        }
    }

    private class Root {
        protected final String location;

        public Root(String location) {
            this.location = location;
        }

        public final File getActualLocation() {
            String val = SourcesHelper.this.evaluator.evaluate(this.location);
            if (val == null) {
                return null;
            }
            return SourcesHelper.this.project.resolveFile(val);
        }
    }
}

