/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.URI;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.ant.freeform.spi.ProjectPropertiesPanel;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.java.freeform.JavaProjectGenerator;
import org.netbeans.modules.java.freeform.ui.ProjectModel;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SourceFoldersPanel
extends JPanel
implements HelpCtx.Provider,
ListSelectionListener {
    private SourcesModel sourceFoldersModel;
    private SourcesModel testFoldersModel;
    private ChangeListener listener;
    private boolean isWizard;
    private PropertyEvaluator evaluator;
    private ProjectModel model;
    private AntProjectHelper projectHelper;
    private JButton addFolder;
    private JButton addTestFolder;
    private JTextField buildScript;
    private JLabel buildScriptLabel;
    private JTextField contentFolder;
    private JButton downFolder;
    private JButton downTestFolder;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel projectContentLabel;
    private JTextField projectFolder;
    private JLabel projectFolderLabel;
    private JButton removeFolder;
    private JButton removeTestFolder;
    private JTable sourceFolders;
    private JComboBox sourceLevel;
    private JTable testFolders;
    private JButton upFolder;
    private JButton upTestFolder;
    static /* synthetic */ Class class$org$netbeans$modules$java$freeform$ui$ClasspathPanel;

    public SourceFoldersPanel() {
        this(true);
    }

    public SourceFoldersPanel(boolean isWizard) {
        this.isWizard = isWizard;
        this.initComponents();
        this.sourceFoldersModel = new SourcesModel(false);
        this.sourceFolders.setModel(this.sourceFoldersModel);
        this.sourceFolders.getSelectionModel().addListSelectionListener(this);
        this.testFoldersModel = new SourcesModel(true);
        this.testFolders.setModel(this.testFoldersModel);
        this.testFolders.getSelectionModel().addListSelectionListener(this);
        this.sourceFolders.getTableHeader().setReorderingAllowed(false);
        this.sourceFolders.setDefaultRenderer(String.class, new ToolTipRenderer());
        this.testFolders.getTableHeader().setReorderingAllowed(false);
        this.testFolders.setDefaultRenderer(String.class, new ToolTipRenderer());
        this.initSourceLevel();
        this.jLabel1.setVisible(isWizard);
        this.projectFolderLabel.setVisible(!isWizard);
        this.projectContentLabel.setVisible(!isWizard);
        this.buildScriptLabel.setVisible(!isWizard);
        this.projectFolder.setVisible(!isWizard);
        this.contentFolder.setVisible(!isWizard);
        this.buildScript.setVisible(!isWizard);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(SourceFoldersPanel.class);
    }

    public void setChangeListener(ChangeListener listener) {
        this.listener = listener;
    }

    private void initSourceLevel() {
        this.sourceLevel.addItem(NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"LBL_SourceFoldersPanel_JDK13"));
        this.sourceLevel.addItem(NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"LBL_SourceFoldersPanel_JDK14"));
        this.sourceLevel.addItem(NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"LBL_SourceFoldersPanel_JDK15"));
    }

    private void updateButtons() {
        this.removeFolder.setEnabled(this.sourceFolders.getSelectedRowCount() > 0);
        this.removeTestFolder.setEnabled(this.testFolders.getSelectedRowCount() > 0);
        this.updateUpDownButtons();
    }

    public void valueChanged(ListSelectionEvent e) {
        this.updateButtons();
    }

    private void updateUpDownButtons() {
        int first = this.sourceFolders.getSelectionModel().getMinSelectionIndex();
        int last = this.sourceFolders.getSelectionModel().getMaxSelectionIndex();
        this.upFolder.setEnabled(first > 0);
        this.downFolder.setEnabled(last > -1 && last < this.sourceFoldersModel.getRowCount() - 1);
        first = this.testFolders.getSelectionModel().getMinSelectionIndex();
        last = this.testFolders.getSelectionModel().getMaxSelectionIndex();
        this.upTestFolder.setEnabled(first > 0);
        this.downTestFolder.setEnabled(last > -1 && last < this.testFoldersModel.getRowCount() - 1);
    }

    private void updateSourceLevelCombo(String sourceLevelValue) {
        if (sourceLevelValue.equals("1.3")) {
            this.sourceLevel.setSelectedIndex(0);
        } else if (sourceLevelValue.equals("1.4")) {
            this.sourceLevel.setSelectedIndex(1);
        } else if (sourceLevelValue.equals("1.5")) {
            this.sourceLevel.setSelectedIndex(2);
        } else {
            this.sourceLevel.addItem(sourceLevelValue);
            this.sourceLevel.setSelectedIndex(3);
        }
    }

    private String getSourceLevelValue(int index) {
        switch (index) {
            case 0: {
                return "1.3";
            }
            case 1: {
                return "1.4";
            }
            case 2: {
                return "1.5";
            }
        }
        return null;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.sourceLevel = new JComboBox();
        this.addFolder = new JButton();
        this.removeFolder = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.sourceFolders = new JTable();
        this.jScrollPane2 = new JScrollPane();
        this.testFolders = new JTable();
        this.jLabel4 = new JLabel();
        this.addTestFolder = new JButton();
        this.removeTestFolder = new JButton();
        this.upFolder = new JButton();
        this.downFolder = new JButton();
        this.downTestFolder = new JButton();
        this.upTestFolder = new JButton();
        this.projectFolderLabel = new JLabel();
        this.projectContentLabel = new JLabel();
        this.buildScriptLabel = new JLabel();
        this.projectFolder = new JTextField();
        this.contentFolder = new JTextField();
        this.buildScript = new JTextField();
        this.setLayout(new GridBagLayout());
        this.setMinimumSize(new Dimension(200, 100));
        this.setPreferredSize(new Dimension(247, 251));
        this.jLabel1.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"LBL_SourceFoldersPanel_jLabel1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"ACSD_SourceFoldersPanel_jLabel1"));
        this.jLabel2.setLabelFor(this.sourceFolders);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"LBL_SourceFoldersPanel_jLabel2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"ACSD_SourceFoldersPanel_jLabel2"));
        this.jLabel3.setLabelFor(this.sourceLevel);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"LBL_SourceFoldersPanel_jLabel3"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"ACSD_SourceFoldersPanel_jLabel3"));
        this.sourceLevel.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SourceFoldersPanel.this.sourceLevelItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.sourceLevel, gridBagConstraints);
        this.sourceLevel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/freeform/ui/Bundle").getString("AD_SourceFoldersPanel_sourceLevel"));
        Mnemonics.setLocalizedText((AbstractButton)this.addFolder, (String)NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"BTN_SourceFoldersPanel_addFolder"));
        this.addFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SourceFoldersPanel.this.addFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.addFolder, gridBagConstraints);
        this.addFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"ACSD_SourceFoldersPanel_addFolder"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeFolder, (String)NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"BTN_SourceFoldersPanel_removeFolder"));
        this.removeFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SourceFoldersPanel.this.removeFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.removeFolder, gridBagConstraints);
        this.removeFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"ACSD_SourceFoldersPanel_removeFolder"));
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setViewportView(this.sourceFolders);
        this.sourceFolders.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"ACSD_SourceFoldersPanel_sourceFolders"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jScrollPane1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"ACSD_SourceFoldersPanel_jScrollPanel1"));
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jScrollPane2.setViewportView(this.testFolders);
        this.testFolders.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/freeform/ui/Bundle").getString("ACSD_SourceFoldersPanel_testFolders"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jScrollPane2.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/freeform/ui/Bundle").getString("AD_SourceFoldersPanel_jScrollPane2"));
        this.jLabel4.setLabelFor(this.testFolders);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"LBL_TestSourceFoldersPanel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel4, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addTestFolder, (String)NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"BTN_SourceFoldersPanel_addTestFolder"));
        this.addTestFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SourceFoldersPanel.this.addTestFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.addTestFolder, gridBagConstraints);
        this.addTestFolder.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/freeform/ui/Bundle").getString("AD_SourceFoldersPanel_addTestFolder"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeTestFolder, (String)NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"BTN_SourceFoldersPanel_removeTestFolder"));
        this.removeTestFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SourceFoldersPanel.this.removeTestFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.removeTestFolder, gridBagConstraints);
        this.removeTestFolder.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/freeform/ui/Bundle").getString("AD_SourceFoldersPanel_removeTestFolder"));
        Mnemonics.setLocalizedText((AbstractButton)this.upFolder, (String)NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"BTN_SourceFoldersPanel_upFolder"));
        this.upFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SourceFoldersPanel.this.upFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.upFolder, gridBagConstraints);
        this.upFolder.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/freeform/ui/Bundle").getString("AD_SourceFoldersPanel_upFolder"));
        Mnemonics.setLocalizedText((AbstractButton)this.downFolder, (String)NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"BTN_SourceFoldersPanel_downFolder"));
        this.downFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SourceFoldersPanel.this.downFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.downFolder, gridBagConstraints);
        this.downFolder.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/freeform/ui/Bundle").getString("AD_SourceFoldersPanel_downFolder"));
        Mnemonics.setLocalizedText((AbstractButton)this.downTestFolder, (String)NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"BTN_SourceFoldersPanel_downTestFolder"));
        this.downTestFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SourceFoldersPanel.this.downTestFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.downTestFolder, gridBagConstraints);
        this.downTestFolder.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/freeform/ui/Bundle").getString("AD_SourceFoldersPanel_downTestFolder"));
        Mnemonics.setLocalizedText((AbstractButton)this.upTestFolder, (String)NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"BTN_SourceFoldersPanel_upTestFolder"));
        this.upTestFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SourceFoldersPanel.this.upTestFolderActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.upTestFolder, gridBagConstraints);
        this.upTestFolder.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/freeform/ui/Bundle").getString("AD_SourceFoldersPanel_upTestFolder"));
        this.projectFolderLabel.setLabelFor(this.projectFolder);
        Mnemonics.setLocalizedText((JLabel)this.projectFolderLabel, (String)NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"LBL_SourceFoldersPanel_ProjFolderLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.projectFolderLabel, gridBagConstraints);
        this.projectContentLabel.setLabelFor(this.contentFolder);
        Mnemonics.setLocalizedText((JLabel)this.projectContentLabel, (String)NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"LBL_SourceFoldersPanel_ProjContentLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 6);
        this.add((Component)this.projectContentLabel, gridBagConstraints);
        this.buildScriptLabel.setLabelFor(this.buildScript);
        Mnemonics.setLocalizedText((JLabel)this.buildScriptLabel, (String)NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"LBL_SourceFoldersPanel_BuildScriptLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 6);
        this.add((Component)this.buildScriptLabel, gridBagConstraints);
        this.projectFolder.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.projectFolder, gridBagConstraints);
        this.projectFolder.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/freeform/ui/Bundle").getString("ACSD_SourceFoldersPanel_projectFolder"));
        this.contentFolder.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.contentFolder, gridBagConstraints);
        this.contentFolder.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/freeform/ui/Bundle").getString("ACSD_SourceFoldersPanel_contentFolder"));
        this.buildScript.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.buildScript, gridBagConstraints);
        this.buildScript.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/freeform/ui/Bundle").getString("ACSD_SourceFoldersPanel_buildScript"));
    }

    private void downTestFolderActionPerformed(ActionEvent evt) {
        int i;
        int[] indeces = this.testFolders.getSelectedRows();
        if (indeces.length == 0) {
            return;
        }
        for (i = indeces.length - 1; i >= 0; --i) {
            int fromIndex = this.calcRealSourceIndex(indeces[i], true);
            this.model.moveSourceFolder(fromIndex, fromIndex + 1);
        }
        this.testFoldersModel.fireTableDataChanged();
        this.testFolders.getSelectionModel().clearSelection();
        for (i = 0; i < indeces.length; ++i) {
            this.testFolders.getSelectionModel().addSelectionInterval(indeces[i] + 1, indeces[i] + 1);
        }
    }

    private void upTestFolderActionPerformed(ActionEvent evt) {
        int i;
        int[] indeces = this.testFolders.getSelectedRows();
        if (indeces.length == 0) {
            return;
        }
        for (i = 0; i < indeces.length; ++i) {
            int fromIndex = this.calcRealSourceIndex(indeces[i], true);
            this.model.moveSourceFolder(fromIndex, fromIndex - 1);
        }
        this.testFoldersModel.fireTableDataChanged();
        this.testFolders.getSelectionModel().clearSelection();
        for (i = 0; i < indeces.length; ++i) {
            this.testFolders.getSelectionModel().addSelectionInterval(indeces[i] - 1, indeces[i] - 1);
        }
    }

    private void downFolderActionPerformed(ActionEvent evt) {
        int i;
        int[] indeces = this.sourceFolders.getSelectedRows();
        if (indeces.length == 0) {
            return;
        }
        for (i = indeces.length - 1; i >= 0; --i) {
            int fromIndex = this.calcRealSourceIndex(indeces[i], false);
            this.model.moveSourceFolder(fromIndex, fromIndex + 1);
        }
        this.sourceFoldersModel.fireTableDataChanged();
        this.sourceFolders.getSelectionModel().clearSelection();
        for (i = 0; i < indeces.length; ++i) {
            this.sourceFolders.getSelectionModel().addSelectionInterval(indeces[i] + 1, indeces[i] + 1);
        }
    }

    private void upFolderActionPerformed(ActionEvent evt) {
        int i;
        int[] indeces = this.sourceFolders.getSelectedRows();
        if (indeces.length == 0) {
            return;
        }
        for (i = 0; i < indeces.length; ++i) {
            int fromIndex = this.calcRealSourceIndex(indeces[i], false);
            this.model.moveSourceFolder(fromIndex, fromIndex - 1);
        }
        this.sourceFoldersModel.fireTableDataChanged();
        this.sourceFolders.getSelectionModel().clearSelection();
        for (i = 0; i < indeces.length; ++i) {
            this.sourceFolders.getSelectionModel().addSelectionInterval(indeces[i] - 1, indeces[i] - 1);
        }
    }

    private void removeTestFolderActionPerformed(ActionEvent evt) {
        int[] indeces = this.testFolders.getSelectedRows();
        if (indeces.length == 0) {
            return;
        }
        for (int i = indeces.length - 1; i >= 0; --i) {
            String location = this.getItem((int)indeces[i], (boolean)true).location;
            this.model.removeSourceFolder(this.calcRealSourceIndex(indeces[i], true));
        }
        this.testFoldersModel.fireTableDataChanged();
        if (this.listener != null) {
            this.listener.stateChanged(null);
        }
        this.updateButtons();
    }

    private void addTestFolderActionPerformed(ActionEvent evt) {
        this.doAddFolderActionPerformed(evt, true);
    }

    private void sourceLevelItemStateChanged(ItemEvent evt) {
        if (this.sourceLevel.getSelectedIndex() != -1 && this.model != null) {
            String sl = this.getSourceLevelValue(this.sourceLevel.getSelectedIndex());
            if (sl == null) {
                sl = (String)this.sourceLevel.getSelectedItem();
            }
            this.model.setSourceLevel(sl);
        }
    }

    private void removeFolderActionPerformed(ActionEvent evt) {
        int[] indeces = this.sourceFolders.getSelectedRows();
        if (indeces.length == 0) {
            return;
        }
        for (int i = indeces.length - 1; i >= 0; --i) {
            String location = this.getItem((int)indeces[i], (boolean)false).location;
            this.model.removeSourceFolder(this.calcRealSourceIndex(indeces[i], false));
        }
        this.sourceFoldersModel.fireTableDataChanged();
        if (this.listener != null) {
            this.listener.stateChanged(null);
        }
        this.updateButtons();
    }

    private void addFolderActionPerformed(ActionEvent evt) {
        this.doAddFolderActionPerformed(evt, false);
    }

    private void doAddFolderActionPerformed(ActionEvent evt, boolean isTests) {
        File[] files;
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(1);
        if (this.model.getBaseFolder() != null) {
            files = this.model.getBaseFolder().listFiles();
            if (files != null && files.length > 0) {
                chooser.setSelectedFile(files[0]);
            } else {
                chooser.setSelectedFile(this.model.getBaseFolder());
            }
        }
        if (isTests) {
            chooser.setDialogTitle(NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"LBL_Browse_Test_Folder"));
        } else {
            chooser.setDialogTitle(NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"LBL_Browse_Source_Folder"));
        }
        chooser.setMultiSelectionEnabled(true);
        if (0 == chooser.showOpenDialog(this)) {
            files = chooser.getSelectedFiles();
            Set invalidRoots = SourceFoldersPanel.processRoots(this.model, files, isTests, this.isWizard);
            if (isTests) {
                this.testFoldersModel.fireTableDataChanged();
            } else {
                this.sourceFoldersModel.fireTableDataChanged();
            }
            if (this.listener != null) {
                this.listener.stateChanged(null);
            }
            this.updateButtons();
            if (invalidRoots.size() > 0) {
                this.showInvalidRootsWarning(invalidRoots);
            }
        }
    }

    static Set processRoots(ProjectModel model, File[] files, boolean isTests, boolean isWizard) {
        HashSet<File> invalidRoots = new HashSet<File>();
        for (int i = 0; i < files.length; ++i) {
            File sourceLoc = FileUtil.normalizeFile((File)files[i]);
            String location = Util.relativizeLocation((File)model.getBaseFolder(), (File)model.getNBProjectFolder(), (File)sourceLoc);
            Project thisProject = isWizard ? null : FileOwnerQuery.getOwner((URI)model.getNBProjectFolder().toURI());
            Project p = FileOwnerQuery.getOwner((URI)sourceLoc.toURI());
            if (!(p == null || thisProject != null && thisProject.equals(p) || SourceFoldersPanel.isParentOf(model.getNBProjectFolder(), sourceLoc) || SourceFoldersPanel.isParentOf(model.getBaseFolder(), sourceLoc))) {
                invalidRoots.add(sourceLoc);
                continue;
            }
            List sourceFolders = model.getSourceFolders();
            boolean nextRoot = false;
            Iterator it = sourceFolders.iterator();
            while (it.hasNext()) {
                JavaProjectGenerator.SourceFolder sf = (JavaProjectGenerator.SourceFolder)it.next();
                if (!location.equals(sf.location)) continue;
                if (isTests && !model.isTestSourceFolder(sf) || !isTests && model.isTestSourceFolder(sf)) {
                    invalidRoots.add(sourceLoc);
                }
                nextRoot = true;
                break;
            }
            if (nextRoot) continue;
            JavaProjectGenerator.SourceFolder sf = new JavaProjectGenerator.SourceFolder();
            sf.location = location;
            sf.type = "java";
            sf.style = "packages";
            sf.label = SourceFoldersPanel.getDefaultLabel(sf.location, isTests);
            model.addSourceFolder(sf, isTests);
        }
        return invalidRoots;
    }

    private static boolean isParentOf(File parent, File child) {
        while (child != null && !child.equals(parent)) {
            child = child.getParentFile();
        }
        return child != null && child.equals(parent);
    }

    private void showInvalidRootsWarning(Set invalidRoots) {
        JButton closeOption = new JButton(NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"CTL_SourceFolderPanel_Close"));
        closeOption.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"AD_SourceFolderPanel_Close"));
        WarningDlg warning = new WarningDlg(invalidRoots);
        String message = NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"MSG_InvalidRoot");
        JOptionPane optionPane = new JOptionPane(new Object[]{message, warning}, 2, 0, null, new Object[0], null);
        optionPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"AD_InvalidRootDlg"));
        DialogDescriptor dd = new DialogDescriptor((Object)optionPane, NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"TITLE_InvalidRoot"), true, new Object[]{closeOption}, (Object)closeOption, 0, null, null);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
    }

    static String getDefaultLabel(String location, boolean isTests) {
        if (location.equals(".") || "${project.dir}/".equals(location + "/")) {
            return isTests ? NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"LBL_default_test_packages") : NbBundle.getMessage((Class)SourceFoldersPanel.class, (String)"LBL_default_source_packages");
        }
        String relloc = location;
        if (relloc.startsWith("${project.dir}/")) {
            relloc = relloc.substring("${project.dir}/".length());
        }
        return relloc.replace('/', File.separatorChar);
    }

    public static String getLocationDisplayName(PropertyEvaluator evaluator, File base, String val) {
        File f = Util.resolveFile((PropertyEvaluator)evaluator, (File)base, (String)val);
        if (f == null) {
            return val;
        }
        String location = f.getAbsolutePath();
        if (CollocationQuery.areCollocated((File)base, (File)f)) {
            location = PropertyUtils.relativizeFile((File)base, (File)f).replace('/', File.separatorChar);
        }
        return location;
    }

    private JavaProjectGenerator.SourceFolder getItem(int index, boolean tests) {
        return this.model.getSourceFolder(this.calcRealSourceIndex(index, tests));
    }

    private int calcRealSourceIndex(int index, boolean tests) {
        int realIndex = 0;
        for (int i = 0; i < this.model.getSourceFoldersCount(); ++i) {
            JavaProjectGenerator.SourceFolder sf = this.model.getSourceFolder(i);
            boolean isTest = this.model.isTestSourceFolder(sf);
            if (tests && !isTest || !tests && isTest) continue;
            if (index == realIndex) {
                return i;
            }
            ++realIndex;
        }
        throw new ArrayIndexOutOfBoundsException("index=" + index + " tests=" + tests + " realIndex=" + realIndex);
    }

    public boolean hasSomeSourceFolder() {
        return this.model.getSourceFoldersCount() > 0;
    }

    public void setModel(ProjectModel model, AntProjectHelper projectHelper) {
        this.model = model;
        this.projectHelper = projectHelper;
        this.updateSourceLevelCombo(model.getSourceLevel());
        this.updateButtons();
        this.sourceFoldersModel.fireTableDataChanged();
        if (!this.isWizard) {
            this.projectFolder.setText(FileUtil.getFileDisplayName((FileObject)projectHelper.getProjectDirectory()));
            this.contentFolder.setText(model.getBaseFolder().getAbsolutePath());
            FileObject fo = SourceFoldersPanel.getAntScript(projectHelper, model.getEvaluator());
            if (fo != null) {
                this.buildScript.setText(FileUtil.getFileDisplayName((FileObject)fo));
            }
        }
    }

    private static FileObject getAntScript(AntProjectHelper helper, PropertyEvaluator ev) {
        String antScript = ev.getProperty("ant.script");
        if (antScript != null) {
            File f = helper.resolveFile(antScript);
            if (!f.exists()) {
                return null;
            }
            FileObject fo = FileUtil.toFileObject((File)f);
            return fo;
        }
        FileObject fo = helper.getProjectDirectory().getFileObject("build.xml");
        return fo;
    }

    private static class WarningDlg
    extends JPanel {
        public WarningDlg(Set invalidRoots) {
            this.initGui(invalidRoots);
        }

        private void initGui(Set invalidRoots) {
            this.setLayout(new GridBagLayout());
            JLabel label = new JLabel();
            label.setText(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$freeform$ui$SourceFoldersPanel == null ? (class$org$netbeans$modules$java$freeform$ui$SourceFoldersPanel = SourceFoldersPanel.class$("org.netbeans.modules.java.freeform.ui.SourceFoldersPanel")) : class$org$netbeans$modules$java$freeform$ui$SourceFoldersPanel), (String)"LBL_InvalidRoot"));
            label.setDisplayedMnemonic(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$freeform$ui$SourceFoldersPanel == null ? (class$org$netbeans$modules$java$freeform$ui$SourceFoldersPanel = SourceFoldersPanel.class$("org.netbeans.modules.java.freeform.ui.SourceFoldersPanel")) : class$org$netbeans$modules$java$freeform$ui$SourceFoldersPanel), (String)"MNE_InvalidRoot").charAt(0));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = -1;
            c.gridy = -1;
            c.gridwidth = 0;
            c.fill = 2;
            c.anchor = 18;
            c.weightx = 1.0;
            c.insets = new Insets(12, 0, 6, 0);
            ((GridBagLayout)this.getLayout()).setConstraints(label, c);
            this.add(label);
            JList<Object> roots = new JList<Object>(invalidRoots.toArray());
            roots.setCellRenderer(new InvalidRootRenderer(true));
            JScrollPane p = new JScrollPane(roots);
            c = new GridBagConstraints();
            c.gridx = -1;
            c.gridy = -1;
            c.gridwidth = 0;
            c.fill = 1;
            c.anchor = 18;
            c.weighty = 1.0;
            c.weightx = 1.0;
            c.insets = new Insets(0, 0, 12, 0);
            ((GridBagLayout)this.getLayout()).setConstraints(p, c);
            this.add(p);
            label.setLabelFor(roots);
            roots.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$freeform$ui$SourceFoldersPanel == null ? (class$org$netbeans$modules$java$freeform$ui$SourceFoldersPanel = SourceFoldersPanel.class$("org.netbeans.modules.java.freeform.ui.SourceFoldersPanel")) : class$org$netbeans$modules$java$freeform$ui$SourceFoldersPanel), (String)"AD_InvalidRoot"));
            JLabel label2 = new JLabel();
            label2.setText(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$freeform$ui$SourceFoldersPanel == null ? (class$org$netbeans$modules$java$freeform$ui$SourceFoldersPanel = SourceFoldersPanel.class$("org.netbeans.modules.java.freeform.ui.SourceFoldersPanel")) : class$org$netbeans$modules$java$freeform$ui$SourceFoldersPanel), (String)"MSG_InvalidRoot2"));
            c = new GridBagConstraints();
            c.gridx = -1;
            c.gridy = -1;
            c.gridwidth = 0;
            c.fill = 2;
            c.anchor = 18;
            c.weightx = 1.0;
            c.insets = new Insets(0, 0, 0, 0);
            ((GridBagLayout)this.getLayout()).setConstraints(label2, c);
            this.add(label2);
        }

        private static class InvalidRootRenderer
        extends DefaultListCellRenderer {
            private boolean projectConflict;

            public InvalidRootRenderer(boolean projectConflict) {
                this.projectConflict = projectConflict;
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Project p;
                File f = (File)value;
                String message = f.getAbsolutePath();
                if (this.projectConflict && (p = FileOwnerQuery.getOwner((URI)f.toURI())) != null) {
                    ProjectInformation pi = ProjectUtils.getInformation((Project)p);
                    String projectName = pi.getDisplayName();
                    message = MessageFormat.format(NbBundle.getMessage((Class)(class$org$netbeans$modules$java$freeform$ui$SourceFoldersPanel == null ? (class$org$netbeans$modules$java$freeform$ui$SourceFoldersPanel = SourceFoldersPanel.class$("org.netbeans.modules.java.freeform.ui.SourceFoldersPanel")) : class$org$netbeans$modules$java$freeform$ui$SourceFoldersPanel), (String)"TXT_RootOwnedByProject"), message, projectName);
                }
                return super.getListCellRendererComponent((JList<?>)list, message, index, isSelected, cellHasFocus);
            }
        }
    }

    private class ToolTipRenderer
    extends DefaultTableCellRenderer {
        private ToolTipRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JComponent) {
                ((JComponent)c).setToolTipText((String)value);
            }
            return c;
        }
    }

    private class SourcesModel
    extends AbstractTableModel {
        private boolean tests;

        public SourcesModel(boolean tests) {
            this.tests = tests;
        }

        public int getColumnCount() {
            return SourceFoldersPanel.this.isWizard ? 1 : 2;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return NbBundle.getMessage((Class)(class$org$netbeans$modules$java$freeform$ui$SourceFoldersPanel == null ? (class$org$netbeans$modules$java$freeform$ui$SourceFoldersPanel = SourceFoldersPanel.class$("org.netbeans.modules.java.freeform.ui.SourceFoldersPanel")) : class$org$netbeans$modules$java$freeform$ui$SourceFoldersPanel), (String)"LBL_SourceFoldersPanel_Package");
                }
            }
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$java$freeform$ui$SourceFoldersPanel == null ? (class$org$netbeans$modules$java$freeform$ui$SourceFoldersPanel = SourceFoldersPanel.class$("org.netbeans.modules.java.freeform.ui.SourceFoldersPanel")) : class$org$netbeans$modules$java$freeform$ui$SourceFoldersPanel), (String)"LBL_SourceFoldersPanel_Label");
        }

        public int getRowCount() {
            if (SourceFoldersPanel.this.model == null) {
                return 0;
            }
            int count = 0;
            for (int i = 0; i < SourceFoldersPanel.this.model.getSourceFoldersCount(); ++i) {
                JavaProjectGenerator.SourceFolder sf = SourceFoldersPanel.this.model.getSourceFolder(i);
                boolean isTest = SourceFoldersPanel.this.model.isTestSourceFolder(sf);
                if (this.tests && isTest) {
                    ++count;
                }
                if (this.tests || isTest) continue;
                ++count;
            }
            return count;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                String loc = ((SourceFoldersPanel)SourceFoldersPanel.this).getItem((int)rowIndex, (boolean)this.tests).location;
                loc = SourceFoldersPanel.getLocationDisplayName(SourceFoldersPanel.this.model.getEvaluator(), SourceFoldersPanel.this.model.getNBProjectFolder(), loc);
                return loc;
            }
            return ((SourceFoldersPanel)SourceFoldersPanel.this).getItem((int)rowIndex, (boolean)this.tests).label;
        }

        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }

        public Class getColumnClass(int column) {
            return class$java$lang$String == null ? (class$java$lang$String = SourceFoldersPanel.class$("java.lang.String")) : class$java$lang$String;
        }

        public void setValueAt(Object val, int rowIndex, int columnIndex) {
            JavaProjectGenerator.SourceFolder sf = SourceFoldersPanel.this.getItem(rowIndex, this.tests);
            sf.label = (String)val;
            if (sf.label.length() == 0) {
                sf.label = SourceFoldersPanel.getDefaultLabel(sf.location, this.tests);
            }
        }
    }

    public static class Panel
    implements ProjectPropertiesPanel {
        private SourceFoldersPanel panel;
        private ProjectModel model;
        private AntProjectHelper projectHelper;

        public Panel(ProjectModel model, AntProjectHelper projectHelper) {
            this.model = model;
            this.projectHelper = projectHelper;
        }

        public void storeValues() {
            ProjectModel.saveProject(this.projectHelper, this.model);
        }

        public String getDisplayName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$java$freeform$ui$ClasspathPanel == null ? (class$org$netbeans$modules$java$freeform$ui$ClasspathPanel = SourceFoldersPanel.class$("org.netbeans.modules.java.freeform.ui.ClasspathPanel")) : class$org$netbeans$modules$java$freeform$ui$ClasspathPanel), (String)"LBL_ProjectCustomizer_Category_Sources");
        }

        public JComponent getComponent() {
            if (this.panel == null) {
                this.panel = new SourceFoldersPanel(false);
                this.panel.setModel(this.model, this.projectHelper);
            }
            return this.panel;
        }

        public int getPreferredPosition() {
            return 100;
        }
    }
}

