/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion;

import java.util.Collection;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.modules.xml.text.api.XMLDefaultTokenContext;
import org.netbeans.modules.xml.text.completion.XMLCompletionQuery;
import org.netbeans.modules.xml.text.syntax.XMLKit;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;

public class XMLCompletionProvider
implements CompletionProvider {
    private static final boolean ENABLED = true;

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        int type = ((XMLSyntaxSupport)Utilities.getDocument((JTextComponent)component).getSyntaxSupport()).checkCompletion(component, typedText, false);
        if (type == 0) {
            return 1;
        }
        return 0;
    }

    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (queryType == 1) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new Query(), component);
        }
        return null;
    }

    private static XMLCompletionQuery.XMLCompletionResult queryImpl(JTextComponent component, int offset) {
        Class kitClass = Utilities.getKitClass((JTextComponent)component);
        if (kitClass != null) {
            ExtEditorUI eeui = (ExtEditorUI)Utilities.getEditorUI((JTextComponent)component);
            org.netbeans.editor.ext.Completion compl = ((XMLKit)Utilities.getKit((JTextComponent)component)).createCompletionForProvider(eeui);
            XMLSyntaxSupport support = (XMLSyntaxSupport)Utilities.getSyntaxSupport((JTextComponent)component);
            return (XMLCompletionQuery.XMLCompletionResult)compl.getQuery().query(component, offset, (SyntaxSupport)support);
        }
        return null;
    }

    private static void checkHideCompletion(BaseDocument doc, int caretOffset) {
        XMLSyntaxSupport sup = (XMLSyntaxSupport)doc.getSyntaxSupport().get(XMLSyntaxSupport.class);
        try {
            TokenItem ti = sup.getTokenChain(caretOffset <= 0 ? 0 : caretOffset - 1, caretOffset);
            if (ti != null && ti.getTokenID() == XMLDefaultTokenContext.TEXT && !ti.getImage().startsWith("<") && !ti.getImage().startsWith("&")) {
                XMLCompletionProvider.hideCompletion();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private static void hideCompletion() {
        Completion.get().hideCompletion();
    }

    private static abstract class AbstractQuery
    extends AsyncCompletionQuery {
        private AbstractQuery() {
        }

        protected void preQueryUpdate(JTextComponent component) {
            int caretOffset = component.getCaretPosition();
            Document doc = component.getDocument();
            XMLCompletionProvider.checkHideCompletion((BaseDocument)doc, caretOffset);
        }

        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            if (doc != null) {
                XMLCompletionProvider.checkHideCompletion((BaseDocument)doc, caretOffset);
            }
            this.doQuery(resultSet, doc, caretOffset);
            resultSet.finish();
        }

        abstract void doQuery(CompletionResultSet var1, Document var2, int var3);
    }

    static class Query
    extends AbstractQuery {
        private JTextComponent component;

        Query() {
        }

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
        }

        protected void doQuery(CompletionResultSet resultSet, Document doc, int caretOffset) {
            XMLCompletionQuery.XMLCompletionResult res = XMLCompletionProvider.queryImpl(this.component, caretOffset);
            if (res != null) {
                List results = res.getData();
                resultSet.addAllItems((Collection)results);
                resultSet.setTitle(res.getTitle());
                resultSet.setAnchorOffset(res.getSubstituteOffset());
            }
        }
    }
}

