/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.syntax;

import java.awt.Color;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.editor.Acceptor;
import org.netbeans.editor.AcceptorFactory;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.TokenCategory;
import org.netbeans.editor.TokenContext;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.modules.xml.text.api.XMLDefaultTokenContext;
import org.netbeans.modules.xml.text.syntax.DTDKit;
import org.netbeans.modules.xml.text.syntax.DTDTokenContext;
import org.netbeans.modules.xml.text.syntax.XMLKit;

public class XMLSettingsInitializer
extends Settings.AbstractInitializer {
    public static final String NAME = "xml-settings-initializer";

    public XMLSettingsInitializer() {
        super(NAME);
    }

    public void updateSettingsMap(Class kitClass, Map settingsMap) {
        if (kitClass == null) {
            return;
        }
        if (kitClass == BaseKit.class) {
            new XMLTokenColoringInitializer().updateSettingsMap(kitClass, settingsMap);
            new DTDTokenColoringInitializer().updateSettingsMap(kitClass, settingsMap);
        }
        if (kitClass == DTDKit.class) {
            settingsMap.put("abbrev-map", this.getDTDAbbrevMap());
            SettingsUtil.updateListSetting((Map)settingsMap, (String)"token-context-list", (Object[])new TokenContext[]{DTDTokenContext.context});
        }
        if (kitClass == XMLKit.class) {
            settingsMap.put("code-folding-enable", Boolean.TRUE);
            settingsMap.put("abbrev-map", this.getXMLAbbrevMap());
            SettingsUtil.updateListSetting((Map)settingsMap, (String)"token-context-list", (Object[])new TokenContext[]{XMLDefaultTokenContext.context});
            settingsMap.put("identifier-acceptor", this.getXMLIdentifierAcceptor());
        }
        if (kitClass == XMLKit.class || kitClass == DTDKit.class) {
            settingsMap.put("abbrev-reset-acceptor", new Acceptor(){

                public boolean accept(char ch) {
                    return AcceptorFactory.NON_JAVA_IDENTIFIER.accept(ch) && ch != '!' && ch != '?';
                }
            });
        }
    }

    Map getXMLAbbrevMap() {
        TreeMap<String, String> xmlAbbrevMap = new TreeMap<String, String>();
        xmlAbbrevMap.put("?xm", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        xmlAbbrevMap.put("!do", "<!DOCTYPE ");
        xmlAbbrevMap.put("!cd", "<![CDATA[|]]>");
        xmlAbbrevMap.put("!at", "<!ATTLIST |>");
        xmlAbbrevMap.put("!el", "<!ELEMENT |>");
        xmlAbbrevMap.put("!en", "<!ENTITY |>");
        xmlAbbrevMap.put("pu", "PUBLIC \"|\"");
        xmlAbbrevMap.put("sy", "SYSTEM \"|\"");
        return xmlAbbrevMap;
    }

    Map getDTDAbbrevMap() {
        TreeMap<String, String> dtdAbbrevMap = new TreeMap<String, String>();
        dtdAbbrevMap.put("!at", "<!ATTLIST |>");
        dtdAbbrevMap.put("!el", "<!ELEMENT |>");
        dtdAbbrevMap.put("!en", "<!ENTITY |>");
        dtdAbbrevMap.put("!no", "<!NOTATION |>");
        dtdAbbrevMap.put("cd", "CDATA");
        dtdAbbrevMap.put("em", "EMPTY");
        dtdAbbrevMap.put("en", "ENTITY");
        dtdAbbrevMap.put("ens", "ENTITIES");
        dtdAbbrevMap.put("fi", "#FIXED");
        dtdAbbrevMap.put("im", "#IMPLIED");
        dtdAbbrevMap.put("nm", "NMTOKEN");
        dtdAbbrevMap.put("nms", "NMTOKENS");
        dtdAbbrevMap.put("nn", "NOTATION");
        dtdAbbrevMap.put("pc", "#PCDATA");
        dtdAbbrevMap.put("pu", "PUBLIC \"|\"");
        dtdAbbrevMap.put("re", "#REQUIRED");
        dtdAbbrevMap.put("rf", "IDREF");
        dtdAbbrevMap.put("rfs", "IDREFS");
        dtdAbbrevMap.put("sy", "SYSTEM \"|\"");
        return dtdAbbrevMap;
    }

    Acceptor getXMLIdentifierAcceptor() {
        return new Acceptor(){

            public boolean accept(char ch) {
                switch (ch) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case '\"': 
                    case '&': 
                    case '\'': 
                    case '/': 
                    case '<': 
                    case '>': 
                    case '\\': {
                        return false;
                    }
                }
                return true;
            }
        };
    }

    static class DTDTokenColoringInitializer
    extends SettingsUtil.TokenColoringInitializer {
        public DTDTokenColoringInitializer() {
            super((TokenContext)DTDTokenContext.context);
        }

        public Object getTokenColoring(TokenContextPath tokenContextPath, TokenCategory tokenIDOrCategory, boolean printingSet) {
            return new Coloring(null, Color.BLACK, null);
        }
    }

    static class XMLTokenColoringInitializer
    extends SettingsUtil.TokenColoringInitializer {
        public XMLTokenColoringInitializer() {
            super((TokenContext)XMLDefaultTokenContext.context);
        }

        public Object getTokenColoring(TokenContextPath tokenContextPath, TokenCategory tokenIDOrCategory, boolean printingSet) {
            return new Coloring(null, Color.BLACK, null);
        }
    }
}

