/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css;

import java.io.IOException;
import java.text.DateFormat;
import java.text.Format;
import java.util.Date;
import java.util.HashMap;
import org.netbeans.modules.css.CSSObject;
import org.netbeans.modules.css.Util;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.UniFileLoader;
import org.openide.util.MapFormat;

public final class CSSLoader
extends UniFileLoader {
    private static final long serialVersionUID = -6638807099960633333L;
    private static final String CSS_EXT = "css";
    private static final String CSS_MIME = "text/css";

    public CSSLoader() {
        super("org.netbeans.modules.css.CSSObject");
    }

    protected void initialize() {
        super.initialize();
        ExtensionList ext = this.getExtensions();
        ext.addExtension(CSS_EXT);
        ext.addMimeType(CSS_MIME);
        this.setExtensions(ext);
    }

    protected String actionsContext() {
        return "Loaders/text/css/Actions/";
    }

    protected String defaultDisplayName() {
        return Util.THIS.getString("PROP_CSSLoader_Name");
    }

    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
        return new CSSObject(primaryFile, this);
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
        return new CSSFileEntry(obj, primaryFile);
    }

    public static class CSSFileEntry
    extends FileEntry.Format {
        private static final long serialVersionUID = 2833661760805697888L;

        CSSFileEntry(MultiDataObject obj, FileObject file) {
            super(obj, file);
        }

        protected Format createFormat(FileObject target, String n, String e) {
            HashMap<String, String> map = new HashMap<String, String>();
            Date now = new Date();
            map.put("NAME", n);
            map.put("DATE", DateFormat.getDateInstance(1).format(now));
            map.put("TIME", DateFormat.getTimeInstance(3).format(now));
            map.put("USER", System.getProperty("user.name"));
            MapFormat format = new MapFormat(map);
            format.setLeftBrace("__");
            format.setRightBrace("__");
            format.setExactMatch(false);
            return format;
        }
    }
}

