/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.netbeans.modules.openide.explorer.PsSettings;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;

public class PsSettingsImpl
extends PsSettings {
    private static final String FILE_NAME = "pssettings.36";
    private static final String KEY_VERSION = "version";
    private static final String VERSION = "1.0";
    private static Boolean log = null;
    private Reference settingsFile = null;

    public PsSettingsImpl() {
        PsSettingsImpl.log("Creating default instance of PsSettingsImpl");
    }

    public int getInt(String key, int defaultValue) {
        String sval = this.get(key, null);
        if (sval != null) {
            try {
                return Integer.decode(sval);
            }
            catch (NumberFormatException nfe) {
                ErrorManager.getDefault().notify(16, (Throwable)nfe);
            }
        }
        return defaultValue;
    }

    public void putInt(String key, int value) {
        PsSettingsImpl.log("Putting value " + value + " for " + key);
        try {
            String ival = Integer.toString(value);
            this.put(key, ival);
        }
        catch (NumberFormatException nfe) {
            ErrorManager.getDefault().notify(16, (Throwable)nfe);
        }
    }

    public void putBoolean(String key, boolean value) {
        PsSettingsImpl.log("Putting value " + value + " for " + key);
        String sval = value ? Boolean.TRUE.toString() : Boolean.FALSE.toString();
        this.put(key, sval);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        PsSettingsImpl.log("getBoolean value " + key);
        String sval = this.get(key, null);
        return sval != null ? Boolean.TRUE.toString().equals(sval) : defaultValue;
    }

    public void put(String key, String value) {
        PsSettingsImpl.log("put " + key + " as " + value);
        FileObject fo = this.getSettingsFile(true);
        if (fo != null) {
            try {
                fo.setAttribute(key, (Object)value);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify(16, (Throwable)ioe);
            }
        } else {
            PsSettingsImpl.log("  problem finding file object");
        }
    }

    public String get(String key, String defaultValue) {
        PsSettingsImpl.log("get " + key);
        FileObject fo = this.getSettingsFile(false);
        if (fo != null) {
            Object o = fo.getAttribute(key);
            PsSettingsImpl.log("  found " + o + " for " + key);
            if (o instanceof String) {
                return (String)o;
            }
            if (o != null) {
                ClassCastException cce = new ClassCastException(fo + " attribute " + key + " should be an instance of String, not " + o.getClass() + "(" + o + ")");
                ErrorManager.getDefault().notify(16, (Throwable)cce);
            }
        }
        return defaultValue;
    }

    private FileObject getSettingsFile(boolean create) {
        FileObject result = null;
        if (this.settingsFile != null) {
            result = (FileObject)this.settingsFile.get();
        }
        if (result == null && (result = this.findFileObject(create)) != null) {
            this.settingsFile = new WeakReference<FileObject>(result);
        }
        return result;
    }

    private FileObject findFileObject(boolean create) {
        try {
            FileSystem fs = Repository.getDefault().getDefaultFileSystem();
            FileObject result = fs.findResource(FILE_NAME);
            if (create && result == null) {
                result = fs.getRoot().createData(FILE_NAME);
                result.setAttribute(KEY_VERSION, (Object)VERSION);
            }
            return result;
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(16, (Throwable)ioe);
            return null;
        }
    }

    private static void log(String s) {
        if (log == null) {
            Boolean bl = log = ErrorManager.getDefault().getInstance(PsSettingsImpl.class.getName()).isLoggable(1) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (log.booleanValue()) {
            ErrorManager.getDefault().getInstance(PsSettingsImpl.class.getName()).log(s);
        }
    }
}

