/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.actions;

import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.core.IDESettings;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class HTMLViewAction
extends CallableSystemAction {
    public static final String MODE_NAME = "webbrowser";

    public HTMLViewAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected String iconResource() {
        return "org/netbeans/core/resources/actions/htmlView.gif";
    }

    public void performAction() {
        StatusDisplayer.getDefault().setStatusText(NbBundle.getBundle((Class)HTMLViewAction.class).getString("CTL_OpeningBrowser"));
        try {
            Workspace[] workspaces;
            TopComponent[] comps;
            boolean notFound = true;
            Mode mode = WindowManager.getDefault().findMode(MODE_NAME);
            if (mode != null && (comps = mode.getTopComponents()).length > 0) {
                comps[0].open();
                comps[0].requestActive();
                notFound = false;
            }
            if (notFound && (workspaces = WindowManager.getDefault().getWorkspaces()) != null) {
                for (int i = 0; i < workspaces.length; ++i) {
                    TopComponent[] comps2;
                    mode = workspaces[i].findMode(MODE_NAME);
                    if (mode == null || (comps2 = mode.getTopComponents()).length <= 0) continue;
                    comps2[0].open();
                    comps2[0].requestActive();
                    notFound = false;
                    break;
                }
            }
            if (notFound) {
                HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(HtmlBrowser.getHomePage()));
            }
        }
        catch (MalformedURLException e) {
            if (!HtmlBrowser.getHomePage().startsWith("http://")) {
                try {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://" + HtmlBrowser.getHomePage()));
                }
                catch (MalformedURLException e1) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(IDESettings.getRealHomeURL());
                }
            }
            HtmlBrowser.URLDisplayer.getDefault().showURL(IDESettings.getRealHomeURL());
        }
        StatusDisplayer.getDefault().setStatusText("");
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return NbBundle.getBundle((Class)HTMLViewAction.class).getString("HTMLView");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HTMLViewAction.class);
    }
}

