/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.filesystems;

import java.lang.ref.WeakReference;
import org.netbeans.core.filesystems.DefaultParser;
import org.netbeans.core.filesystems.MIMEComponent;
import org.netbeans.core.filesystems.Util;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

final class XMLMIMEComponent
extends DefaultParser
implements MIMEComponent {
    private short state = 0;
    private final Smell template = new Smell();
    private static final LocalSniffingParser local = new LocalSniffingParser();
    private static final short INIT = 0;
    private static final short IN_ROOT = 1;
    private static final short IN_DOCTYPE = 2;
    private static final short IN_ELEMENT = 3;
    private static final String ROOT = "xml-rule";
    private static final String PI = "pi";
    private static final String ELEMENT = "element";
    private static final String DOCTYPE = "doctype";
    private static final String PUBLIC_ID = "public-id";
    private static final String ID = "id";
    private static final String ATTR = "attr";
    private static final String NAME = "name";
    private static final String VALUE = "text";
    private static final String NS = "ns";
    private static final String TARGET = "target";
    static /* synthetic */ Class class$org$netbeans$core$filesystems$XMLMIMEComponent;

    XMLMIMEComponent() {
    }

    public boolean acceptFileObject(FileObject fo) {
        SniffingParser sniffer = (SniffingParser)local.get();
        Smell print = sniffer.sniff(fo);
        boolean res = this.template.match(print);
        return res;
    }

    public String toString() {
        return this.template.toString();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        switch (this.state) {
            case 0: {
                if (!ROOT.equals(qName)) {
                    this.error();
                }
                this.state = 1;
                break;
            }
            case 1: {
                if (PI.equals(qName)) {
                    String s = atts.getValue(TARGET);
                    if (s == null) {
                        this.error();
                    }
                    this.template.addPI(s);
                    break;
                }
                if (DOCTYPE.equals(qName)) {
                    String s = atts.getValue(PUBLIC_ID);
                    if (s == null) {
                        this.state = (short)2;
                        break;
                    }
                    this.template.addDoctype(s);
                    break;
                }
                if (ELEMENT.equals(qName)) {
                    String s = atts.getValue(NAME);
                    if (s == null) {
                        s = atts.getValue(NS);
                        if (s != null) {
                            this.template.addElementNS(s);
                        }
                    } else {
                        this.template.addElementName(s);
                        s = atts.getValue(NS);
                        if (s != null) {
                            this.template.addElementNS(s);
                        }
                    }
                    this.state = (short)3;
                    break;
                }
                this.error();
                break;
            }
            case 2: {
                String s;
                if (!PUBLIC_ID.equals(qName)) {
                    this.error();
                }
                if ((s = atts.getValue(ID)) == null) {
                    this.error();
                }
                this.template.addDoctype(s);
                break;
            }
            case 3: {
                if (ATTR.equals(qName)) {
                    String s = atts.getValue(NAME);
                    if (s == null) {
                        this.error();
                    }
                    this.template.addElementAtt(s, atts.getValue(VALUE));
                    break;
                }
                if (NS.equals(qName)) {
                    String s = atts.getValue(NAME);
                    if (s == null) {
                        this.error();
                    }
                    this.template.addElementNS(s);
                    break;
                }
                this.error();
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        switch (this.state) {
            case 3: {
                if (!ELEMENT.equals(qName)) break;
                this.state = 1;
                break;
            }
            case 2: {
                if (!DOCTYPE.equals(qName)) break;
                this.state = 1;
            }
        }
    }

    private static class Smell {
        private String[] doctypes = null;
        private String[] pis = null;
        private String root = null;
        private String[] nss = null;
        private String[] attns = null;
        private String[] attvs = null;

        Smell() {
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            buf.append("xml-check(");
            if (this.doctypes != null) {
                buf.append("doctypes:");
                for (i = 0; i < this.doctypes.length; ++i) {
                    buf.append(this.doctypes[i] + ", ");
                }
            }
            if (this.pis != null) {
                buf.append("PIs:");
                for (i = 0; i < this.pis.length; ++i) {
                    buf.append(this.pis[i] + ", ");
                }
            }
            if (this.root != null) {
                buf.append("root:" + this.root);
            }
            if (this.nss != null) {
                buf.append("root-namespaces:");
                for (i = 0; i < this.nss.length; ++i) {
                    buf.append(this.nss[i] + ", ");
                }
            }
            if (this.attns != null) {
                buf.append("attributes:");
                for (i = 0; i < this.attns.length; ++i) {
                    buf.append(this.attns[i] + "='" + this.attvs[i] + "'");
                }
            }
            buf.append(")");
            return buf.toString();
        }

        private void addDoctype(String s) {
            this.doctypes = this.doctypes == null ? new String[]{s} : Util.addString(this.doctypes, s);
        }

        private void addPI(String s) {
            this.pis = this.pis == null ? new String[]{s} : Util.addString(this.pis, s);
        }

        private void addElementNS(String s) {
            this.nss = this.nss == null ? new String[]{s} : Util.addString(this.nss, s);
        }

        private void addElementName(String name) {
            this.root = name;
        }

        private void addElementAtt(String name, String value) {
            if (this.attns == null) {
                this.attns = new String[]{name};
                this.attvs = new String[]{value};
            } else {
                this.attns = Util.addString(this.attns, name);
                this.attvs = Util.addString(this.attvs, value);
            }
        }

        public boolean match(Smell t) {
            if (t == null) {
                return false;
            }
            if (this.doctypes != null && t.doctypes != null && Util.contains(this.doctypes, t.doctypes[0])) {
                return true;
            }
            if (this.root != null && this.root.equals(t.root) ? (this.nss == null ? this.attMatch(t) : t.nss != null && Util.contains(this.nss, t.nss[0]) && this.attMatch(t)) : this.root == null && this.nss != null && t.nss != null && Util.contains(this.nss, t.nss[0]) && this.attMatch(t)) {
                return true;
            }
            if (this.pis != null && t.pis != null) {
                for (int i = 0; i < this.pis.length; ++i) {
                    for (int j = 0; j < t.pis.length; ++j) {
                        if (!this.pis[i].equals(t.pis[j])) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private boolean attMatch(Smell t) {
            if (this.attns == null) {
                return true;
            }
            if (t.attns == null) {
                return false;
            }
            for (int i = 0; i < this.attns.length; ++i) {
                int match = Util.indexOf(t.attns, this.attns[i]);
                if (match == -1) {
                    return false;
                }
                if (this.attvs[i] == null || this.attvs[i].equals(t.attvs[match])) continue;
                return false;
            }
            return true;
        }
    }

    private static class SniffingParser
    extends DefaultParser
    implements LexicalHandler {
        private FileObject lastFileObject = null;
        private Smell print = null;
        private static final SAXException STOP = new SAXException("STOP");

        SniffingParser() {
            super(null);
        }

        protected Smell sniff(FileObject fo) {
            if (fo == null) {
                return null;
            }
            if (fo.equals(this.lastFileObject)) {
                return this.print;
            }
            if (!fo.isValid()) {
                return null;
            }
            if (fo.getSize() == 0L) {
                return null;
            }
            this.print = new Smell();
            this.parse(fo);
            if (this.state == -1) {
                return null;
            }
            this.lastFileObject = fo;
            return this.print;
        }

        protected XMLReader createXMLReader() {
            XMLReader parser = null;
            try {
                parser = XMLUtil.createXMLReader((boolean)false, (boolean)true);
                try {
                    parser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
                }
                catch (SAXException sex) {
                    ErrorManager.getDefault().log(NbBundle.getMessage((Class)(class$org$netbeans$core$filesystems$XMLMIMEComponent == null ? (class$org$netbeans$core$filesystems$XMLMIMEComponent = XMLMIMEComponent.class$("org.netbeans.core.filesystems.XMLMIMEComponent")) : class$org$netbeans$core$filesystems$XMLMIMEComponent), (String)"W-003"));
                }
            }
            catch (SAXException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            return parser;
        }

        protected boolean isStopException(Exception e) {
            return STOP.getMessage().equals(e.getMessage());
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (namespaceURI != null) {
                this.print.addElementNS(namespaceURI);
            }
            if ("".equals(localName)) {
                localName = null;
            }
            this.print.addElementName(localName != null ? localName : qName);
            for (int i = 0; i < atts.getLength(); ++i) {
                this.print.addElementAtt(atts.getQName(i), atts.getValue(i));
            }
            throw STOP;
        }

        public void processingInstruction(String target, String data) throws SAXException {
            this.print.addPI(target);
        }

        public void startDTD(String root, String pID, String sID) throws SAXException {
            this.print.addDoctype(pID);
        }

        public void endDTD() {
        }

        public void startEntity(String name) {
        }

        public void endEntity(String name) {
        }

        public void startCDATA() {
        }

        public void endCDATA() {
        }

        public void comment(char[] ch, int start, int length) {
        }

        public void error(SAXParseException exception) throws SAXException {
            ErrorManager.getDefault().log(16, exception.getMessage());
            this.state = (short)-1;
            throw STOP;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            ErrorManager emgr = ErrorManager.getDefault().getInstance("org.netbeans.core.filesystems.XMLMIMEComponent");
            if (emgr.isLoggable(1)) {
                emgr.log(1, "[while parsing " + this.fo + "] " + exception.getSystemId() + ":" + exception.getLineNumber() + ":" + exception.getColumnNumber() + ": " + exception.getMessage());
            }
            this.state = (short)-1;
            throw STOP;
        }
    }

    private static class LocalSniffingParser
    extends ThreadLocal {
        private WeakReference wref = null;

        LocalSniffingParser() {
        }

        protected Object initialValue() {
            SniffingParser parser = new SniffingParser();
            this.wref = new WeakReference<SniffingParser>(parser);
            return this.wref;
        }

        public Object get() {
            WeakReference cache = (WeakReference)super.get();
            Object cached = cache.get();
            if (cached == null) {
                cached = new SniffingParser();
                this.wref = new WeakReference(cached);
                super.set(this.wref);
            }
            return cached;
        }

        public void set(Object data) {
        }
    }
}

