/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jmi.reflect.RefObject;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Parameter;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.j2ee.dd.api.ejb.AssemblyDescriptor;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.CmrField;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelation;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelationshipRole;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.dd.api.ejb.Query;
import org.netbeans.modules.j2ee.dd.api.ejb.RelationshipRoleSource;
import org.netbeans.modules.j2ee.dd.api.ejb.Relationships;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeAppProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.refactoring.EjbInterfaceType;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.WebModuleImplementation;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public class Utility {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.refactoring");
    public static final String ENTERPRISE_BEAN = "javax.ejb.EnterpriseBean";
    public static final String SESSION_BEAN = "javax.ejb.SessionBean";
    public static final String ENTITY_BEAN = "javax.ejb.EntityBean";
    public static final String MESSAGE_DRIVEN_BEAN = "javax.ejb.MessageDrivenBean";
    public static final String EJB_LOCAL_HOME = "javax.ejb.EJBLocalHome";
    public static final String EJB_HOME = "javax.ejb.EJBHome";
    public static final String EJB_LOCAL_OBJECT = "javax.ejb.EJBLocalObject";
    public static final String EJB_OBJECT = "javax.ejb.EJBObject";
    public static final String MESSAGE_LISTENER = "javax.jms.MessageListener";
    public static final String EJB_CREATE = "ejbCreate";
    public static final String EJB_ACTIVATE = "ejbActivate";
    public static final String EJB_PASSIVATE = "ejbPassivate";
    public static final String EJB_REMOVE = "ejbRemove";
    public static final String EJB_LOAD = "ejbLoad";
    public static final String EJB_STORE = "ejbStore";
    public static final String SET_SESSION_CONTEXT = "setSessionContext";
    public static final String SET_ENTITY_CONTEXT = "setEntityContext";
    public static final String SET_MSG_CONTEXT = "setMessageDrivenContext";
    public static final String UNSET_ENTITY_CONTEXT = "unsetEntityContext";
    public static final String ON_MESSAGE = "onMessage";
    public static final String[] NO_PARAMS = new String[0];
    public static final String[] SET_SESSION_CONTEXT_PARAMTYPENAMES = new String[]{"javax.ejb.SessionContext"};
    public static final String[] SET_ENTITY_CONTEXT_PARAMTYPENAMES = new String[]{"javax.ejb.EntityContext"};
    public static final String[] SET_MSG_CONTEXT_PARAMTYPENAMES = new String[]{"javax.ejb.MessageDrivenContext"};
    public static final String[] ON_MESSAGE_PARAMTYPENAMES = new String[]{"javax.jms.Message"};
    public static final String PREFIX_SET = "set";
    public static final String PREFIX_GET = "get";
    public static final String PREFIX_FIND = "find";
    public static final String PREFIX_EJBSELECT = "ejbSelect";
    public static final String PREFIX_EJBPOSTCREATE = "ejbPostCreate";
    public static final String PREFIX_EJBCREATE = "ejbCreate";
    public static final String PREFIX_CREATE = "create";
    public static final String PREFIX_EJBHOME = "ejbHome";
    public static final String PREFIX_EJBFIND = "ejbFind";
    private static final String PREFIX_POSTCREATE = "postCreate";

    public static List getTypedParams(List params) {
        if (params != null) {
            ArrayList<Type> typedParams = new ArrayList<Type>(params.size());
            for (int i = 0; i < params.size(); ++i) {
                Element param = (Element)params.get(i);
                Type type = param instanceof Parameter ? ((Parameter)param).getType() : (Type)param;
                typedParams.add(type);
            }
            return typedParams;
        }
        return Collections.EMPTY_LIST;
    }

    public static EnterpriseBeans getEnterpriseBeansFromDD(FileObject fo) {
        err.log(">Utility.getEnterpriseBeansFromDD (" + fo + ")");
        org.netbeans.modules.j2ee.api.ejbjar.EjbJar emod = org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJar((FileObject)fo);
        if (emod != null) {
            FileObject ejbJarFO = emod.getDeploymentDescriptor();
            EjbJar ejbJarDD = null;
            try {
                ejbJarDD = DDProvider.getDefault().getMergedDDRoot(emod.getMetadataUnit());
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (ejbJarDD != null && ejbJarDD.getStatus() != 2) {
                return ejbJarDD.getEnterpriseBeans();
            }
        }
        return null;
    }

    public static JavaClass getImplClassForHome(EnterpriseBeans eBeans, Class beanType, String homeClassName, boolean local) {
        Ejb[] ejbs;
        if (eBeans != null && (ejbs = eBeans.getEjbs()) != null) {
            for (int i = 0; i < ejbs.length; ++i) {
                JavaClass javaClass;
                EntityAndSession bean;
                Ejb ejb = ejbs[i];
                if (ejb == null || !beanType.isAssignableFrom(ejb.getClass()) || !homeClassName.equals(Utility.getHomeInterface(bean = (EntityAndSession)ejb, local)) || (javaClass = Utility.resolveRealClass(bean.getEjbClass())) == null) continue;
                return javaClass;
            }
        }
        return null;
    }

    public static Method getMethodInImplClassForHome(FileObject fo, Class beanType, String className, String methodName, List parameters, boolean local) {
        if (methodName == null || methodName.length() == 0) {
            return null;
        }
        JavaClass ejbImplClass = Utility.getImplClassForHome(Utility.getEnterpriseBeansFromDD(fo), beanType, className, local);
        if (ejbImplClass != null) {
            return ejbImplClass.getMethod(methodName, Utility.getTypedParams(parameters), false);
        }
        return null;
    }

    private static JavaClass getOtherHomeClassForHome(EnterpriseBeans eBeans, Class beanType, String homeClassName, boolean local) {
        Ejb[] ejbs;
        if (eBeans != null && (ejbs = eBeans.getEjbs()) != null) {
            for (int i = 0; i < ejbs.length; ++i) {
                JavaClass javaClass;
                EntityAndSession bean;
                Ejb ejb = ejbs[i];
                if (ejb == null || !beanType.isAssignableFrom(ejb.getClass()) || !homeClassName.equals(Utility.getHomeInterface(bean = (EntityAndSession)ejbs[i], !local)) || !Utility.isSubTypeOf((ClassDefinition)(javaClass = Utility.resolveRealClass(Utility.getHomeInterface(bean, local))), local ? EJB_LOCAL_HOME : EJB_HOME)) continue;
                return javaClass;
            }
        }
        return null;
    }

    public static Method getMethodInOtherHomeClassForHome(FileObject fo, Class beanType, String className, String methodName, List parameters, boolean local) {
        JavaClass ejbHomeClass = Utility.getOtherHomeClassForHome(Utility.getEnterpriseBeansFromDD(fo), beanType, className, local);
        if (ejbHomeClass != null) {
            return ejbHomeClass.getMethod(methodName, Utility.getTypedParams(parameters), false);
        }
        return null;
    }

    private static JavaClass getHomeClassForImpl(EnterpriseBeans eBeans, Class beanType, String implClassName, boolean local) {
        Ejb bean = EjbInterfaceType.BEAN_IMPL.getBean(eBeans, beanType, implClassName);
        if (bean != null) {
            EjbInterfaceType ejbInterfaceType = local ? EjbInterfaceType.LOCAL : EjbInterfaceType.LOCAL_HOME;
            return ejbInterfaceType.resolveClass(bean);
        }
        return null;
    }

    public static Method getMethodInHomeClassForImpl(FileObject fo, Class beanType, String className, String methodName, List parameters, boolean local) {
        if (methodName == null || methodName.length() == 0) {
            return null;
        }
        JavaClass ejbHomeClass = Utility.getHomeClassForImpl(Utility.getEnterpriseBeansFromDD(fo), beanType, className, local);
        if (ejbHomeClass != null) {
            return ejbHomeClass.getMethod(methodName, Utility.getTypedParams(parameters), false);
        }
        return null;
    }

    private static String getHomeInterface(EntityAndSession bean, boolean local) {
        return local ? bean.getLocalHome() : bean.getHome();
    }

    public static String addPrefix(String methodName, String prefix) {
        return prefix + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
    }

    public static String stripNonEmptyPrefix(String methodName, String prefix) {
        if ((methodName = Utility.stripPrefix(methodName, prefix)) != null && methodName.length() > 1 && Utility.isFirstUpperCase(methodName)) {
            return methodName.substring(0, 1).toLowerCase() + methodName.substring(1);
        }
        return null;
    }

    public static String stripPrefix(String methodName, String prefix) {
        if (methodName.startsWith(prefix)) {
            return methodName.substring(prefix.length());
        }
        return null;
    }

    public static String replacePrefix(String methodName, String oldPrefix, String newPrefix) {
        if (newPrefix == null) {
            return Utility.stripNonEmptyPrefix(methodName, oldPrefix);
        }
        if (methodName.startsWith(oldPrefix) && methodName.length() > oldPrefix.length()) {
            return newPrefix + methodName.substring(oldPrefix.length());
        }
        return null;
    }

    public static Method getImplFinderMethodForHomeFinderMethod(Method method, FileObject fo, String className, boolean local) {
        err.log(">Utility.getImplFinderMethodForHomeFinderMethod (" + method + ", " + fo + ", " + className + ", " + local + ")");
        return Utility.getMethodInImplClassForHome(fo, EntityAndSession.class, className, local, method, PREFIX_FIND, PREFIX_EJBFIND);
    }

    public static Method getImplCreateMethodForHomeCreateMethod(Method method, FileObject fo, String className, boolean local) {
        err.log(">Utility.getImplCreateMethodForHomeCreateMethod (" + method + ", " + fo + ", " + className + ", " + local + ")");
        String oldPrefix = PREFIX_CREATE;
        String newPrefix = "ejbCreate";
        Class<EntityAndSession> beanType = EntityAndSession.class;
        return Utility.getMethodInImplClassForHome(fo, beanType, className, local, method, oldPrefix, newPrefix);
    }

    public static Method getImplPostCreateMethodForHomeCreateMethod(Method method, FileObject fo, String className, boolean local) {
        err.log(">Utility.getImplPostCreateMethodForHomeCreateMethod (" + method + ", " + fo + ", " + className + ", " + local + ")");
        return Utility.getMethodInImplClassForHome(fo, EntityAndSession.class, className, local, method, PREFIX_EJBPOSTCREATE, PREFIX_CREATE);
    }

    public static Method getMethod(Method origMethod, String origPrefix, String prefix) {
        ClassDefinition jc = origMethod.getDeclaringClass();
        err.log("classdefinition classDefinition: " + jc);
        if (jc instanceof JavaClass) {
            String methodName = Utility.replacePrefix(origMethod.getName(), origPrefix, prefix);
            if (methodName == null || methodName.length() == 0) {
                return null;
            }
            return jc.getMethod(methodName, Utility.getTypedParams(origMethod.getParameters()), false);
        }
        return null;
    }

    public static Method getMethodInHomeClassForImpl(FileObject fo, Class beanType, String className, boolean local, Method origMethod, String origPrefix, String prefix) {
        String methodName = Utility.replacePrefix(origMethod.getName(), origPrefix, prefix);
        return Utility.getMethodInHomeClassForImpl(fo, beanType, className, methodName, origMethod.getParameters(), local);
    }

    public static Method getMethodInImplClassForHome(FileObject fo, Class beanType, String className, boolean local, Method origMethod, String origPrefix, String prefix) {
        String methodName = Utility.replacePrefix(origMethod.getName(), origPrefix, prefix);
        return Utility.getMethodInImplClassForHome(fo, beanType, className, methodName, origMethod.getParameters(), local);
    }

    public static Method getImplHomeMethodForHomeHomeMethod(Method method, FileObject fo, String className, boolean local) {
        err.log(">Utility.getImplHomeMethodForHomeHomeMethod (" + method + ", " + fo + ", " + className + ", " + local + ")");
        String implMethodName = Utility.addPrefix(method.getName(), PREFIX_EJBHOME);
        return Utility.getMethodInImplClassForHome(fo, EntityAndSession.class, className, implMethodName, method.getParameters(), local);
    }

    public static Method getHomeHomeMethodForHomeHomeMethod(Method method, FileObject fo, String className, boolean local) {
        err.log(">Utility.getHomeHomeMethodForHomeHomeMethod (" + method + ", " + fo + ", " + className + ", " + local + ")");
        String methodName = method.getName();
        return Utility.getMethodInOtherHomeClassForHome(fo, EntityAndSession.class, className, methodName, method.getParameters(), local);
    }

    public static Method getHomeFinderMethodForHomeFinderMethod(Method method, FileObject fo, String className, boolean local) {
        err.log(">Utility.getHomeFinderMethodForHomeFinderMethod (" + method + ", " + fo + ", " + className + ", " + local + ")");
        String methodName = method.getName();
        if (!methodName.startsWith(PREFIX_FIND)) {
            return null;
        }
        return Utility.getMethodInOtherHomeClassForHome(fo, EntityAndSession.class, className, methodName, method.getParameters(), local);
    }

    public static Method getHomeCreateMethodForHomeCreateMethod(Method method, FileObject fo, String className, boolean local) {
        err.log(">Utility.getHomeCreateMethodForHomeCreateMethod (" + method + ", " + fo + ", " + className + ", " + local + ")");
        String methodName = method.getName();
        if (!methodName.startsWith(PREFIX_CREATE)) {
            return null;
        }
        return Utility.getMethodInOtherHomeClassForHome(fo, EntityAndSession.class, className, methodName, method.getParameters(), local);
    }

    public static Method getHomeFinderMethodForImplFinderMethod(Method method, FileObject fo, String className, boolean local) {
        err.log(">Utility.getHomeFinderMethodForImplFinderMethod (" + method + ", " + fo + ", " + className + ", " + local + ")");
        return Utility.getMethodInHomeClassForImpl(fo, Entity.class, className, local, method, PREFIX_FIND, PREFIX_EJBFIND);
    }

    public static Method getHomeHomeMethodForEntityImplHomeMethod(Method method, FileObject fo, String className, boolean local) {
        err.log(">Utility.getHomeHomeMethodForEntityImplHomeMethod (" + method + ", " + fo + ", " + className + ", " + local + ")");
        String methodName = Utility.stripNonEmptyPrefix(method.getName(), PREFIX_EJBHOME);
        return Utility.getMethodInHomeClassForImpl(fo, Entity.class, className, methodName, method.getParameters(), local);
    }

    public static Method getHomeHomeMethodForSessionImplHomeMethod(Method method, FileObject fo, String className, boolean local) {
        err.log(">Utility.getHomeHomeMethodForSessionImplHomeMethod (" + method + ", " + fo + ", " + className + ", " + local + ")");
        String methodName = Utility.stripNonEmptyPrefix(method.getName(), PREFIX_EJBHOME);
        return Utility.getMethodInHomeClassForImpl(fo, Session.class, className, methodName, method.getParameters(), local);
    }

    public static Method getHomeCreateMethodForSessionImplCreateMethod(Method method, FileObject fo, String className, boolean local) {
        err.log(">Utility.getHomeCreateMethodForSessionImplCreateMethod (" + method + ", " + fo + ", " + className + ", " + local + ")");
        return Utility.getMethodInHomeClassForImpl(fo, Session.class, className, local, method, "ejbCreate", PREFIX_CREATE);
    }

    public static Method getHomeCreateMethodForEntityImplCreateMethod(Method method, FileObject fo, String className, boolean local) {
        err.log(">Utility.getHomeCreateMethodForEntityImplCreateMethod (" + method + ", " + fo + ", " + className + ", " + local + ")");
        String oldPrefix = "ejbCreate";
        String newPrefix = PREFIX_CREATE;
        Class<Entity> beanType = Entity.class;
        return Utility.getMethodInHomeClassForImpl(fo, beanType, className, local, method, oldPrefix, newPrefix);
    }

    public static Method getHomeCreateMethodForEntityImplPostCreateMethod(Method method, FileObject fo, String className, boolean local) {
        err.log(">Utility.getHomeCreateMethodForEntityImplPostCreateMethod (" + method + ", " + fo + ", " + className + ", " + local + ")");
        return Utility.getMethodInHomeClassForImpl(fo, Entity.class, className, local, method, PREFIX_EJBPOSTCREATE, PREFIX_CREATE);
    }

    public static Method getHomePostCreateMethodForEntityImplCreateMethod(Method method, FileObject fo, String className, boolean local) {
        err.log(">Utility.getHomePostCreateMethodForEntityImplCreateMethod (" + method + ", " + fo + ", " + className + ", " + local + ")");
        return Utility.getMethodInHomeClassForImpl(fo, Entity.class, className, local, method, "ejbCreate", PREFIX_POSTCREATE);
    }

    public static Method getImplPostCreateMethodForEntityImplCreateMethod(Method method) {
        return Utility.getMethod(method, "ejbCreate", PREFIX_EJBPOSTCREATE);
    }

    public static Method getImplCreateMethodForEntityImplPostCreateMethod(Method method) {
        String oldPrefix = PREFIX_EJBPOSTCREATE;
        String newPrefix = "ejbCreate";
        return Utility.getMethod(method, oldPrefix, newPrefix);
    }

    public static boolean isSignatureFromSessionBeanInterface(Method method) {
        return Utility.equalMethods(method, EJB_PASSIVATE, NO_PARAMS) || Utility.equalMethods(method, EJB_ACTIVATE, NO_PARAMS) || Utility.equalMethods(method, EJB_REMOVE, NO_PARAMS) || Utility.equalMethods(method, SET_SESSION_CONTEXT, SET_SESSION_CONTEXT_PARAMTYPENAMES);
    }

    public static boolean isSignatureFromEntityBeanInterface(Method method) {
        return Utility.equalMethods(method, EJB_PASSIVATE, NO_PARAMS) || Utility.equalMethods(method, EJB_ACTIVATE, NO_PARAMS) || Utility.equalMethods(method, EJB_REMOVE, NO_PARAMS) || Utility.equalMethods(method, EJB_LOAD, NO_PARAMS) || Utility.equalMethods(method, EJB_STORE, NO_PARAMS) || Utility.equalMethods(method, UNSET_ENTITY_CONTEXT, NO_PARAMS) || Utility.equalMethods(method, SET_ENTITY_CONTEXT, SET_ENTITY_CONTEXT_PARAMTYPENAMES);
    }

    public static boolean isSignatureFromMessageDrivenBeanInterface(Method method) {
        return Utility.equalMethods(method, "ejbCreate", NO_PARAMS) || Utility.equalMethods(method, EJB_REMOVE, NO_PARAMS) || Utility.equalMethods(method, SET_MSG_CONTEXT, SET_MSG_CONTEXT_PARAMTYPENAMES);
    }

    public static boolean isSignatureFromMessageListenerInterface(Method method) {
        return Utility.equalMethods(method, ON_MESSAGE, ON_MESSAGE_PARAMTYPENAMES);
    }

    public static EjbJar getEjbJar(org.netbeans.modules.j2ee.api.ejbjar.EjbJar emodule) {
        if (emodule != null) {
            FileObject ejbJarFO = emodule.getDeploymentDescriptor();
            try {
                return DDProvider.getDefault().getMergedDDRoot(emodule.getMetadataUnit());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Entity[] getEntityBeans(org.netbeans.modules.j2ee.api.ejbjar.EjbJar emodule) {
        EnterpriseBeans eBeans;
        EjbJar ejbJarDD = Utility.getEjbJar(emodule);
        if (ejbJarDD != null && (eBeans = ejbJarDD.getEnterpriseBeans()) != null) {
            return eBeans.getEntity();
        }
        return null;
    }

    public static EjbRelation[] getRelationships(org.netbeans.modules.j2ee.api.ejbjar.EjbJar emodule) {
        Relationships rels;
        EjbJar ejbJarDD = Utility.getEjbJar(emodule);
        if (ejbJarDD != null && (rels = ejbJarDD.getSingleRelationships()) != null) {
            return rels.getEjbRelation();
        }
        return null;
    }

    public static AssemblyDescriptor getAssemblyDescriptor(org.netbeans.modules.j2ee.api.ejbjar.EjbJar emodule) {
        EjbJar ejbJarDD = Utility.getEjbJar(emodule);
        if (ejbJarDD != null) {
            return ejbJarDD.getSingleAssemblyDescriptor();
        }
        return null;
    }

    public static String getEjbNameForClass(EjbJar ejbJarDD, ClassDefinition jc) {
        EnterpriseBeans eBeans = ejbJarDD.getEnterpriseBeans();
        if (eBeans != null) {
            Ejb[] ejbs = eBeans.getEjbs();
            for (int e = 0; e < ejbs.length; ++e) {
                Ejb ejb = ejbs[e];
                String ejbClass = ejb.getEjbClass();
                err.log("ejbclass: " + ejbClass);
                if (!ejbClass.equals(jc.getName())) continue;
                return ejb.getEjbName();
            }
        }
        return null;
    }

    public static Session[] getSessionBeans(org.netbeans.modules.j2ee.api.ejbjar.EjbJar emodule) {
        EnterpriseBeans eBeans;
        EjbJar ejbJarDD = Utility.getEjbJar(emodule);
        if (ejbJarDD != null && (eBeans = ejbJarDD.getEnterpriseBeans()) != null) {
            return eBeans.getSession();
        }
        return null;
    }

    public static boolean equalMethods(Method method, String name, String[] paramNames) {
        if (!name.equals(method.getName())) {
            return false;
        }
        if (method.getParameters().size() != paramNames.length) {
            return false;
        }
        Iterator it = method.getParameters().iterator();
        for (int i = 0; i < paramNames.length; ++i) {
            Parameter param = (Parameter)it.next();
            if (param.getType().getName().equals(paramNames[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equalMethods(Method method1, Method method2) {
        if (method1 == null || method2 == null) {
            return method1 == method2;
        }
        if (!method1.getName().equals(method2.getName())) {
            return false;
        }
        List parameters1 = method1.getParameters();
        List parameters2 = method2.getParameters();
        int n = parameters1.size();
        if (n != parameters2.size()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Parameter param1 = (Parameter)parameters1.get(i);
            Parameter param2 = (Parameter)parameters2.get(i);
            if (param1.getType().getName().equals(param2.getType().getName())) continue;
            return false;
        }
        return true;
    }

    public static void addProblemsToEnd(Problem[] where, Problem what) {
        where[0] = Utility.addProblemsToEnd(where[0], what);
    }

    public static Problem addProblemsToEnd(Problem where, Problem what) {
        if (where == null) {
            return what;
        }
        if (what != null) {
            Problem tail = where;
            while (tail.getNext() != null) {
                tail = tail.getNext();
            }
            tail.setNext(what);
        }
        return where;
    }

    public static Collection getRelevantEjbModules(Element element) {
        FileObject fo = JavaModel.getFileObject((Resource)element.getResource());
        return Utility.getRelevantEjbModules(fo);
    }

    public static Collection getRelevantEjbModules(RefObject refObject) {
        if (refObject instanceof Element) {
            return Utility.getRelevantEjbModules((Element)refObject);
        }
        return Collections.emptyList();
    }

    public static Collection getRelevantEjbModules(FileObject fo) {
        Project affectedProject = FileOwnerQuery.getOwner((FileObject)fo);
        ArrayList<org.netbeans.modules.j2ee.api.ejbjar.EjbJar> ejbmodules = new ArrayList<org.netbeans.modules.j2ee.api.ejbjar.EjbJar>();
        ArrayList<Project> projects = new ArrayList<Project>();
        if (affectedProject != null) {
            org.netbeans.modules.j2ee.api.ejbjar.EjbJar emod = org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJar((FileObject)affectedProject.getProjectDirectory());
            if (emod == null) {
                return Collections.EMPTY_SET;
            }
            projects.add(affectedProject);
            for (Project project : OpenProjects.getDefault().getOpenProjects()) {
                org.netbeans.modules.j2ee.api.ejbjar.EjbJar em;
                Set subprojects;
                Object obj;
                J2eeModuleProvider affectedPrjProvider;
                J2eeAppProvider j2eeApp;
                J2eeModuleProvider[] j2eeModules;
                Object isJ2eeApp = project.getLookup().lookup(J2eeAppProvider.class);
                if (isJ2eeApp != null && (j2eeModules = (j2eeApp = (J2eeAppProvider)isJ2eeApp).getChildModuleProviders()) != null && (affectedPrjProvider = (J2eeModuleProvider)affectedProject.getLookup().lookup(J2eeModuleProvider.class)) != null && Arrays.asList(j2eeModules).contains(affectedPrjProvider)) {
                    for (int k = 0; k < j2eeModules.length; ++k) {
                        FileObject srcRoot;
                        Project p;
                        FileObject[] sourceRoots = j2eeModules[k].getSourceRoots();
                        if (sourceRoots == null || sourceRoots.length <= 0 || (p = FileOwnerQuery.getOwner((FileObject)(srcRoot = sourceRoots[0]))) == null || projects.contains(p)) continue;
                        projects.add(p);
                    }
                }
                if ((obj = project.getLookup().lookup(SubprojectProvider.class)) == null || !(obj instanceof SubprojectProvider) || !(subprojects = ((SubprojectProvider)obj).getSubprojects()).contains(affectedProject) || (em = org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJar((FileObject)project.getProjectDirectory())) == null || projects.contains(project)) continue;
                projects.add(project);
            }
        }
        for (int j = 0; j < projects.size(); ++j) {
            Project prj = (Project)projects.get(j);
            org.netbeans.modules.j2ee.api.ejbjar.EjbJar ejb = org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJar((FileObject)prj.getProjectDirectory());
            if (ejb == null) continue;
            ejbmodules.add(ejb);
        }
        err.log("Affected ejb modules: " + ejbmodules);
        return ejbmodules;
    }

    public static Collection getRelevantWSModules(FileObject fo) {
        Project affectedProject = FileOwnerQuery.getOwner((FileObject)fo);
        ArrayList<WebServicesSupport> wsmodules = new ArrayList<WebServicesSupport>();
        ArrayList<Project> projects = new ArrayList<Project>();
        if (affectedProject != null) {
            WebServicesSupport wsmod = WebServicesSupport.getWebServicesSupport((FileObject)affectedProject.getProjectDirectory());
            if (wsmod == null) {
                return Collections.EMPTY_SET;
            }
            projects.add(affectedProject);
            for (Project project : OpenProjects.getDefault().getOpenProjects()) {
                WebServicesSupport ws;
                Set subprojects;
                Object obj;
                J2eeModuleProvider affectedPrjProvider;
                Object isJ2eeApp = project.getLookup().lookup(J2eeAppProvider.class);
                if (isJ2eeApp == null) continue;
                J2eeAppProvider j2eeApp = (J2eeAppProvider)isJ2eeApp;
                J2eeModuleProvider[] j2eeModules = j2eeApp.getChildModuleProviders();
                if (j2eeModules != null && (affectedPrjProvider = (J2eeModuleProvider)affectedProject.getLookup().lookup(J2eeModuleProvider.class)) != null && Arrays.asList(j2eeModules).contains(affectedPrjProvider)) {
                    for (int i = 0; i < j2eeModules.length; ++i) {
                        FileObject srcRoot;
                        Project p;
                        FileObject[] sourceRoots = j2eeModules[i].getSourceRoots();
                        if (sourceRoots == null || sourceRoots.length <= 0 || (p = FileOwnerQuery.getOwner((FileObject)(srcRoot = sourceRoots[0]))) == null || projects.contains(p)) continue;
                        projects.add(p);
                    }
                }
                if ((obj = project.getLookup().lookup(SubprojectProvider.class)) == null || !(obj instanceof SubprojectProvider) || !(subprojects = ((SubprojectProvider)obj).getSubprojects()).contains(affectedProject) || (ws = WebServicesSupport.getWebServicesSupport((FileObject)project.getProjectDirectory())) == null || projects.contains(project)) continue;
                projects.add(project);
            }
        }
        for (int j = 0; j < projects.size(); ++j) {
            Project prj = (Project)projects.get(j);
            WebServicesSupport websvc = WebServicesSupport.getWebServicesSupport((FileObject)prj.getProjectDirectory());
            wsmodules.add(websvc);
        }
        err.log("Affected ws modules: " + wsmodules);
        return wsmodules;
    }

    public static Collection getRelevantWebModules(Element e) {
        FileObject f;
        Resource r = e.getResource();
        if (r != null && (f = JavaModel.getFileObject((Resource)r)) != null) {
            Collection c = Utility.getRelevantWebModules(f);
            return c;
        }
        return Collections.EMPTY_LIST;
    }

    public static Collection getRelevantWebModules(FileObject fo) {
        ArrayList<WebModule> webmodules = new ArrayList<WebModule>();
        ArrayList<Project> projects = new ArrayList<Project>();
        if (fo == null) {
            ErrorManager.getDefault().log(1, "Passed null to getRelevantWebModules()");
            return webmodules;
        }
        Project affectedProject = FileOwnerQuery.getOwner((FileObject)fo);
        if (affectedProject != null) {
            WebModule wmod = WebModule.getWebModule((FileObject)affectedProject.getProjectDirectory());
            if (wmod == null) {
                return Collections.EMPTY_SET;
            }
            projects.add(affectedProject);
            Set globalPath = GlobalPathRegistry.getDefault().getSourceRoots();
            for (FileObject sourceRoot : globalPath) {
                WebModule wm;
                Set subprojects;
                Object obj;
                Project project = FileOwnerQuery.getOwner((FileObject)sourceRoot);
                if (project == null) continue;
                err.log("found this project: " + project);
                Object isJ2eeApp = project.getLookup().lookup(J2eeAppProvider.class);
                if (isJ2eeApp != null) {
                    J2eeModuleProvider affectedPrjProvider;
                    J2eeAppProvider j2eeApp = (J2eeAppProvider)isJ2eeApp;
                    err.log("j2eeapp: " + j2eeApp);
                    J2eeModuleProvider[] j2eeModules = j2eeApp.getChildModuleProviders();
                    err.log("j2ee modules: " + j2eeModules);
                    if (j2eeModules != null && (affectedPrjProvider = (J2eeModuleProvider)affectedProject.getLookup().lookup(J2eeModuleProvider.class)) != null && Arrays.asList(j2eeModules).contains(affectedPrjProvider)) {
                        for (int i = 0; i < j2eeModules.length; ++i) {
                            FileObject docBase;
                            Project p;
                            if (!(j2eeModules[i] instanceof WebModuleImplementation) || (p = FileOwnerQuery.getOwner((FileObject)(docBase = ((WebModuleImplementation)j2eeModules[i]).getDocumentBase()))) == null || projects.contains(p)) continue;
                            projects.add(p);
                        }
                    }
                }
                if ((obj = project.getLookup().lookup(SubprojectProvider.class)) == null || !(obj instanceof SubprojectProvider) || !(subprojects = ((SubprojectProvider)obj).getSubprojects()).contains(affectedProject) || (wm = WebModule.getWebModule((FileObject)project.getProjectDirectory())) == null || projects.contains(project)) continue;
                projects.add(project);
            }
        }
        for (int j = 0; j < projects.size(); ++j) {
            Project prj = (Project)projects.get(j);
            WebModule web = WebModule.getWebModule((FileObject)prj.getProjectDirectory());
            webmodules.add(web);
        }
        return webmodules;
    }

    public static boolean isCmpField(JavaClass jc, String fieldName) {
        if (jc != null && fieldName != null) {
            Collection emodules = Utility.getRelevantEjbModules((Element)jc);
            for (org.netbeans.modules.j2ee.api.ejbjar.EjbJar ejbJar : emodules) {
                Entity[] eBeans = Utility.getEntityBeans(ejbJar);
                if (eBeans == null) continue;
                for (int i = 0; i < eBeans.length; ++i) {
                    Entity ent = eBeans[i];
                    String ejbClass = ent.getEjbClass();
                    if (!jc.getName().equals(ejbClass)) continue;
                    CmpField[] cmpFields = ent.getCmpField();
                    if (cmpFields != null) {
                        for (int c = 0; c < cmpFields.length; ++c) {
                            CmpField cmpField = cmpFields[c];
                            if (!fieldName.equalsIgnoreCase(cmpField.getFieldName())) continue;
                            return true;
                        }
                    }
                    return false;
                }
            }
        }
        return false;
    }

    public static boolean isCmrField(JavaClass jc, String fieldName) {
        if (jc != null && fieldName != null) {
            Collection emodules = Utility.getRelevantEjbModules((Element)jc);
            for (org.netbeans.modules.j2ee.api.ejbjar.EjbJar ejbJar : emodules) {
                EjbRelation[] ejbRelations = Utility.getRelationships(ejbJar);
                if (ejbRelations == null) continue;
                String ejbName = Utility.getEntityEjbNameForClass(jc);
                for (int i = 0; i < ejbRelations.length; ++i) {
                    String cmrFieldName;
                    CmrField cmrField;
                    RelationshipRoleSource relSource;
                    String roleEjbName;
                    String cmrFieldName2;
                    CmrField cmrField2;
                    RelationshipRoleSource relSource2;
                    String roleEjbName2;
                    EjbRelation relation = ejbRelations[i];
                    if (relation == null) continue;
                    EjbRelationshipRole role = relation.getEjbRelationshipRole();
                    if (role != null && (roleEjbName2 = (relSource2 = role.getRelationshipRoleSource()).getEjbName()).equals(ejbName) && (cmrField2 = role.getCmrField()) != null && (cmrFieldName2 = cmrField2.getCmrFieldName()).equalsIgnoreCase(fieldName)) {
                        return true;
                    }
                    EjbRelationshipRole role2 = relation.getEjbRelationshipRole2();
                    if (role2 == null || !(roleEjbName = (relSource = role2.getRelationshipRoleSource()).getEjbName()).equals(ejbName) || (cmrField = role2.getCmrField()) == null || !(cmrFieldName = cmrField.getCmrFieldName()).equalsIgnoreCase(fieldName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String getEntityEjbNameForClass(JavaClass jc) {
        org.netbeans.modules.j2ee.api.ejbjar.EjbJar emod;
        Entity[] entityBeans;
        Project prj;
        FileObject fo;
        if (jc == null) {
            return null;
        }
        Resource res = jc.getResource();
        if (res != null && (fo = JavaModel.getFileObject((Resource)res)) != null && (prj = FileOwnerQuery.getOwner((FileObject)fo)) != null && (entityBeans = Utility.getEntityBeans(emod = org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJar((FileObject)prj.getProjectDirectory()))) != null) {
            for (int e = 0; e < entityBeans.length; ++e) {
                Entity entity = entityBeans[e];
                String ejbClass = entity.getEjbClass();
                err.log("ejbclass: " + ejbClass);
                if (!ejbClass.equals(jc.getName())) continue;
                return entity.getEjbName();
            }
        }
        return null;
    }

    public static String getClassName(String pkg, String simpleName) {
        return (pkg == null || pkg.length() == 0 ? "" : pkg + ".") + simpleName;
    }

    public static Ejb getEjb(EjbJar ejbJar, ClassDefinition classDefinition) {
        if (classDefinition == null) {
            return null;
        }
        EnterpriseBeans enterpriseBeans = ejbJar.getEnterpriseBeans();
        if (enterpriseBeans == null) {
            return null;
        }
        String className = classDefinition.getName();
        Ejb[] ejbs = enterpriseBeans.getEjbs();
        for (int i = 0; i < ejbs.length; ++i) {
            EntityAndSession entityAndSession;
            Ejb ejb = ejbs[i];
            if (className.equals(ejb.getEjbClass())) {
                return ejb;
            }
            if (!(ejb instanceof EntityAndSession) || !Utility.isSubTypeOf((entityAndSession = (EntityAndSession)ejb).getLocal(), classDefinition) && !Utility.isSubTypeOf(entityAndSession.getLocalHome(), classDefinition) && !Utility.isSubTypeOf(entityAndSession.getRemote(), classDefinition) && !Utility.isSubTypeOf(entityAndSession.getHome(), classDefinition)) continue;
            return ejb;
        }
        return null;
    }

    private static boolean isSubTypeOf(String thisClassName, ClassDefinition classDefinition) {
        return thisClassName != null && Utility.resolveClass(thisClassName).isSubTypeOf(classDefinition);
    }

    public static String getFieldName(Method method) {
        char c;
        String methodName = method.getName();
        if (methodName.length() > 3 && (methodName.startsWith(PREFIX_SET) || methodName.startsWith(PREFIX_GET)) && Character.isUpperCase(c = methodName.charAt(3))) {
            return Character.toLowerCase(c) + methodName.substring(4);
        }
        return null;
    }

    private static String getGetterName(String fieldName) {
        return PREFIX_GET + Utility.firstToUpperCase(fieldName);
    }

    private static String getSetterName(String fieldName) {
        return PREFIX_SET + Utility.firstToUpperCase(fieldName);
    }

    public static Method getGetterMethod(JavaClass javaClass, String fieldName) {
        if (javaClass == null) {
            return null;
        }
        return javaClass.getMethod(Utility.getGetterName(fieldName), Collections.EMPTY_LIST, true);
    }

    private static Method getSetterMethod(JavaClass javaClass, String fieldName, Type type) {
        if (javaClass == null) {
            return null;
        }
        return javaClass.getMethod(Utility.getSetterName(fieldName), Arrays.asList(type), true);
    }

    public static Collection getAccessMethods(Entity entity, String fieldName) {
        LinkedList<Method> accessMethods = new LinkedList<Method>();
        JavaClass javaClass = Utility.resolveClass(entity.getEjbClass());
        Method method = Utility.getGetterMethod(javaClass, fieldName);
        if (method != null) {
            accessMethods.add(method);
            Type type = method.getType();
            Utility.addToCollection(accessMethods, Utility.getSetterMethod(javaClass, fieldName, type));
            Utility.addAccessMethods(accessMethods, Utility.resolveClass(entity.getLocal()), fieldName, type);
            Utility.addAccessMethods(accessMethods, Utility.resolveClass(entity.getRemote()), fieldName, type);
        }
        return accessMethods;
    }

    private static void addAccessMethods(Collection accessMethods, JavaClass javaClass, String fieldName, Type type) {
        if (javaClass != null) {
            Utility.addToCollection(accessMethods, Utility.getGetterMethod(javaClass, fieldName));
            Utility.addToCollection(accessMethods, Utility.getSetterMethod(javaClass, fieldName, type));
        }
    }

    public static JavaClass resolveClass(String className) {
        return (JavaClass)Utility.resolveType(className);
    }

    private static Type resolveType(String typeName) {
        Type basicType;
        Type type = JavaModel.getDefaultExtent().getType().resolve(typeName);
        if (type instanceof UnresolvedClass && !((basicType = JavaModel.getDefaultExtent().getType().resolve("java.lang." + typeName)) instanceof UnresolvedClass)) {
            return basicType;
        }
        return type;
    }

    public static void addToCollection(Collection collection, Object object) {
        if (object != null) {
            collection.add(object);
        }
    }

    public static org.netbeans.modules.j2ee.api.ejbjar.EjbJar getApiEjbJar(Element element) {
        FileObject fileObject = JavaModel.getFileObject((Resource)element.getResource());
        if (fileObject != null) {
            return org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJar((FileObject)fileObject);
        }
        return null;
    }

    public static FileObject getEjbJarFileObject(Element element) {
        org.netbeans.modules.j2ee.api.ejbjar.EjbJar ejbJar;
        Project project;
        FileObject fileObject = JavaModel.getFileObject((Resource)element.getResource());
        if (fileObject != null && (project = FileOwnerQuery.getOwner((FileObject)fileObject)) != null && (ejbJar = org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJar((FileObject)project.getProjectDirectory())) != null) {
            return ejbJar.getDeploymentDescriptor();
        }
        return null;
    }

    public static EjbJar getEjbJar(FileObject fo) {
        if (fo != null) {
            try {
                return DDProvider.getDefault().getMergedDDRoot(org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJar((FileObject)fo).getMetadataUnit());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Method findMethod(ClassDefinition classDefinition, Method method, boolean includeSuperTypes) {
        return Utility.getMethod(classDefinition, method.getName(), method.getParameters(), includeSuperTypes);
    }

    public static Method getMethod(ClassDefinition classDefinition, String methodName, List parameters, boolean includeSuperTypes) {
        if (classDefinition == null || methodName == null) {
            return null;
        }
        return classDefinition.getMethod(methodName, Utility.getTypedParams(parameters), includeSuperTypes);
    }

    private static List getQueryMethodParams(Query query) {
        String[] methodParam = query.getQueryMethod().getMethodParams().getMethodParam();
        LinkedList<Type> params = new LinkedList<Type>();
        for (int i = 0; i < methodParam.length; ++i) {
            params.add(Utility.resolveType(methodParam[i]));
        }
        return params;
    }

    private static void addMethodToCollection(String className, Collection queryMethods, String methodName, List params) {
        JavaClass javaClass = Utility.resolveClass(className);
        Utility.addToCollection(queryMethods, Utility.getMethod((ClassDefinition)javaClass, methodName, params, false));
    }

    public static Collection getQueryMethods(Entity entity, Query query) {
        LinkedList queryMethods = new LinkedList();
        List params = Utility.getQueryMethodParams(query);
        String methodName = query.getQueryMethod().getMethodName();
        if (methodName.startsWith(PREFIX_EJBSELECT)) {
            Utility.addMethodToCollection(entity.getEjbClass(), queryMethods, methodName, params);
        } else if (methodName.startsWith(PREFIX_FIND)) {
            Utility.addMethodToCollection(entity.getLocalHome(), queryMethods, methodName, params);
            Utility.addMethodToCollection(entity.getHome(), queryMethods, methodName, params);
        }
        return queryMethods;
    }

    public static JavaClass resolveRealClass(String className) {
        JavaClass javaClass = Utility.resolveClass(className);
        return javaClass instanceof UnresolvedClass ? null : javaClass;
    }

    public static boolean isSubTypeOf(ClassDefinition classDefinition, String className) {
        if (classDefinition == null) {
            return false;
        }
        JavaClass javaClass = Utility.resolveClass(className);
        if (javaClass instanceof UnresolvedClass) {
            Iterator it = classDefinition.getInterfaces().iterator();
            while (it.hasNext()) {
                if (!className.equals(((JavaClass)it.next()).getName())) continue;
                return true;
            }
            return false;
        }
        return classDefinition.isSubTypeOf((ClassDefinition)javaClass);
    }

    public static boolean isFirstUpperCase(String s) {
        return s.length() != 0 && Character.isUpperCase(s.charAt(0));
    }

    public static boolean isFirstLowerCase(String s) {
        return s.length() != 0 && Character.isLowerCase(s.charAt(0));
    }

    public static String firstToUpperCase(String s) {
        return s.length() == 0 ? s : Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String firstToLowerCase(String s) {
        return s.length() == 0 ? s : Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static String renameClass(String originalFullyQualifiedName, String newName) {
        if (Utility.isEmpty(originalFullyQualifiedName) || Utility.isEmpty(newName)) {
            throw new IllegalArgumentException("Old and new name of the class must be given.");
        }
        int lastDot = originalFullyQualifiedName.lastIndexOf(46);
        return lastDot <= 0 ? newName : originalFullyQualifiedName.substring(0, lastDot + 1) + newName;
    }

    public static String unqualify(String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(".");
        return lastDot < 0 ? qualifiedName : qualifiedName.substring(lastDot + 1);
    }

    public static boolean isEmpty(String str) {
        return str == null || "".equals(str.trim());
    }

    public static String getPropertyName(String getter) {
        if (!getter.startsWith(PREFIX_GET)) {
            return getter;
        }
        String sub = getter.substring(3);
        char c = sub.charAt(0);
        if (!Character.isUpperCase(c)) {
            return getter;
        }
        return Character.toLowerCase(c) + sub.substring(1);
    }

    public static boolean isEjb30(Project project) {
        if (project == null) {
            return false;
        }
        try {
            org.netbeans.modules.j2ee.api.ejbjar.EjbJar[] modules = org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJars((Project)project);
            if (modules != null && modules.length > 0) {
                return "3.0".equals(DDProvider.getDefault().getMergedDDRoot(modules[0].getMetadataUnit()).getVersion().toString());
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return false;
    }

    public static boolean isEjb30(RefObject refObject) {
        if (!(refObject instanceof Element)) {
            return false;
        }
        Element element = (Element)refObject;
        FileObject fo = JavaModel.getFileObject((Resource)element.getResource());
        return Utility.isEjb30(FileOwnerQuery.getOwner((FileObject)fo));
    }

    public static boolean hasEjbJar(Collection ejbModules) {
        for (Object elem : ejbModules) {
            org.netbeans.modules.j2ee.api.ejbjar.EjbJar em = (org.netbeans.modules.j2ee.api.ejbjar.EjbJar)elem;
            FileObject ejbJarFO = em.getDeploymentDescriptor();
            if (ejbJarFO == null) continue;
            return true;
        }
        return false;
    }

    public static boolean hasEjbJar(RefObject refObject) {
        return Utility.hasEjbJar(Utility.getRelevantEjbModules(refObject));
    }
}

