/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.refactoring.safedelete;

import java.text.MessageFormat;
import java.util.List;
import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.StringLiteral;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.refactoring.EntityAnnotationReference;
import org.netbeans.modules.j2ee.refactoring.EntityAssociationResolver;
import org.netbeans.modules.j2ee.refactoring.J2EERefactoring;
import org.netbeans.modules.j2ee.refactoring.PersistenceRefactoringUtil;
import org.netbeans.modules.j2ee.refactoring.rename.AbstractRenameRefactoringElement;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class EntitySafeDeleteRefactoring
implements J2EERefactoring {
    private JavaClass javaClass;
    private Feature property;
    private SafeDeleteRefactoring safeDeleteRefactoring;

    public EntitySafeDeleteRefactoring(JavaClass javaClass, Feature property, SafeDeleteRefactoring safeDeleteRefactoring) {
        this.javaClass = javaClass;
        this.property = property;
        this.safeDeleteRefactoring = safeDeleteRefactoring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        if (!PersistenceRefactoringUtil.isEntity((AnnotableElement)this.javaClass)) {
            return null;
        }
        JMIUtils.beginJmiTransaction();
        boolean rollback = true;
        try {
            List<JavaClass> allEntities = PersistenceRefactoringUtil.getEntitiesInProject(this.javaClass);
            EntityAssociationResolver resolver = new EntityAssociationResolver(this.javaClass, allEntities);
            List<EntityAnnotationReference> references = resolver.getMappedByReferences(this.property);
            for (EntityAnnotationReference elem : references) {
                Resource res = elem.getReferring().getResource();
                FileObject fo = JavaModel.getFileObject((Resource)res);
                EntitySafeDeleteRefactoringElement refactoringElem = new EntitySafeDeleteRefactoringElement(elem, fo);
                refactoringElementsBag.add((AbstractRefactoring)this.safeDeleteRefactoring, (RefactoringElementImplementation)refactoringElem);
            }
            rollback = false;
        }
        finally {
            JMIUtils.endJmiTransaction((boolean)rollback);
        }
        return null;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    private static class EntitySafeDeleteRefactoringElement
    extends AbstractRenameRefactoringElement
    implements ExternalChange {
        private EntityAnnotationReference reference;

        public EntitySafeDeleteRefactoringElement(EntityAnnotationReference reference, FileObject parentFile) {
            this.parentFile = parentFile;
            this.reference = reference;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.reference.getAnnotation().getType().getName(), this.reference.getReferringProperty().getName()};
            return MessageFormat.format(NbBundle.getMessage(EntitySafeDeleteRefactoring.class, (String)"TXT_EntitySafeDeleteAnnotation"), args);
        }

        public void performExternalChange() {
        }

        public void undoExternalChange() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void performChange() {
            JMIUtils.beginJmiTransaction((boolean)true);
            boolean rollback = true;
            try {
                this.reference.getReferringProperty().getAnnotations().remove(this.reference.getAnnotation());
                rollback = false;
            }
            finally {
                JMIUtils.endJmiTransaction((boolean)rollback);
            }
        }

        private String getStringValue(AttributeValue attributeValue) {
            return ((StringLiteral)attributeValue.getValue()).getValue();
        }
    }
}

