/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.ui.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.api.sql.execute.SQLExecution;
import org.netbeans.modules.db.sql.editor.ui.actions.SQLExecutionBaseAction;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class ConnectionAction
extends SQLExecutionBaseAction {
    static /* synthetic */ Class class$org$netbeans$modules$db$sql$editor$ui$actions$ConnectionAction;
    static /* synthetic */ Class class$org$netbeans$api$db$explorer$ConnectionListener;

    protected String getDisplayName(SQLExecution sqlExecution) {
        return null;
    }

    protected void actionPerformed(SQLExecution sqlExecution) {
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ConnectionContextAwareDelegate(this, actionContext);
    }

    private static final class DatabaseConnectionRenderer
    extends DefaultListCellRenderer {
        private DatabaseConnectionRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object displayName = null;
            String tooltipText = null;
            if (value instanceof DatabaseConnection) {
                DatabaseConnection dbconn = (DatabaseConnection)value;
                tooltipText = dbconn.getDisplayName();
                displayName = tooltipText;
            } else {
                displayName = value;
            }
            JLabel component = (JLabel)super.getListCellRendererComponent((JList<?>)list, displayName, index, isSelected, cellHasFocus);
            component.setToolTipText(tooltipText);
            return component;
        }
    }

    private static final class DatabaseConnectionModel
    extends AbstractListModel
    implements ComboBoxModel,
    ConnectionListener,
    PropertyChangeListener {
        private ConnectionListener listener = (ConnectionListener)WeakListeners.create((Class)(class$org$netbeans$api$db$explorer$ConnectionListener == null ? (class$org$netbeans$api$db$explorer$ConnectionListener = ConnectionAction.class$("org.netbeans.api.db.explorer.ConnectionListener")) : class$org$netbeans$api$db$explorer$ConnectionListener), (EventListener)this, (Object)ConnectionManager.getDefault());
        private List connectionList;
        private SQLExecution sqlExecution;

        public DatabaseConnectionModel() {
            ConnectionManager.getDefault().addConnectionListener(this.listener);
            this.connectionList = new ArrayList();
            this.connectionList.addAll(Arrays.asList(ConnectionManager.getDefault().getConnections()));
        }

        public Object getElementAt(int index) {
            return this.connectionList.get(index);
        }

        public int getSize() {
            return this.connectionList.size();
        }

        public void setSelectedItem(Object object) {
            if (this.sqlExecution != null) {
                this.sqlExecution.setDatabaseConnection((DatabaseConnection)object);
            }
        }

        public Object getSelectedItem() {
            return this.sqlExecution != null ? this.sqlExecution.getDatabaseConnection() : null;
        }

        public void setSQLExecution(SQLExecution sqlExecution) {
            if (this.sqlExecution != null) {
                this.sqlExecution.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.sqlExecution = sqlExecution;
            if (this.sqlExecution != null) {
                this.sqlExecution.addPropertyChangeListener((PropertyChangeListener)this);
            }
            this.fireContentsChanged(this, 0, 0);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (propertyName == null || propertyName.equals("databaseConnection")) {
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        DatabaseConnectionModel.this.fireContentsChanged(this, 0, 0);
                    }
                });
            }
        }

        public void connectionsChanged() {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    DatabaseConnectionModel.this.connectionList.clear();
                    DatabaseConnectionModel.this.connectionList.addAll(Arrays.asList(ConnectionManager.getDefault().getConnections()));
                    DatabaseConnection selectedItem = (DatabaseConnection)DatabaseConnectionModel.this.getSelectedItem();
                    if (selectedItem != null && !DatabaseConnectionModel.this.connectionList.contains(selectedItem)) {
                        DatabaseConnectionModel.this.setSelectedItem(null);
                    }
                    DatabaseConnectionModel.this.fireContentsChanged(this, 0, DatabaseConnectionModel.this.connectionList.size());
                }
            });
        }
    }

    private static final class ToolbarPresenter
    extends JPanel {
        private JComboBox combo;
        private JLabel comboLabel;
        private DatabaseConnectionModel model;

        public ToolbarPresenter() {
            this.initComponents();
        }

        public Dimension getMinimumSize() {
            Dimension dim = super.getMinimumSize();
            return new Dimension(0, dim.height);
        }

        public void setSQLExecution(SQLExecution sqlExecution) {
            this.model.setSQLExecution(sqlExecution);
        }

        private void initComponents() {
            this.setLayout(new BorderLayout(4, 0));
            this.setBorder(new EmptyBorder(0, 2, 0, 8));
            this.setOpaque(false);
            this.combo = new JComboBox();
            this.combo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    DatabaseConnection dbconn = (DatabaseConnection)ToolbarPresenter.this.combo.getSelectedItem();
                    ToolbarPresenter.this.combo.setToolTipText(dbconn != null ? dbconn.getDisplayName() : null);
                }
            });
            this.combo.setOpaque(false);
            this.model = new DatabaseConnectionModel();
            this.combo.setModel(this.model);
            this.combo.setRenderer(new DatabaseConnectionRenderer());
            this.add((Component)this.combo, "Center");
            this.comboLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.comboLabel, (String)NbBundle.getMessage((Class)(class$org$netbeans$modules$db$sql$editor$ui$actions$ConnectionAction == null ? (class$org$netbeans$modules$db$sql$editor$ui$actions$ConnectionAction = ConnectionAction.class$("org.netbeans.modules.db.sql.editor.ui.actions.ConnectionAction")) : class$org$netbeans$modules$db$sql$editor$ui$actions$ConnectionAction), (String)"LBL_ConnectionAction"));
            this.comboLabel.setOpaque(false);
            this.comboLabel.setLabelFor(this.combo);
            this.add((Component)this.comboLabel, "West");
        }

        public void setEnabled(boolean enabled) {
            this.combo.setEnabled(enabled);
            super.setEnabled(enabled);
        }
    }

    private static final class ConnectionContextAwareDelegate
    extends SQLExecutionBaseAction.ContextAwareDelegate {
        private ToolbarPresenter toolbarPresenter;

        public ConnectionContextAwareDelegate(ConnectionAction parent, Lookup actionContext) {
            super(parent, actionContext);
        }

        public Component getToolbarPresenter() {
            this.toolbarPresenter = new ToolbarPresenter();
            this.toolbarPresenter.setSQLExecution(this.getSQLExecution());
            return this.toolbarPresenter;
        }

        public void setEnabled(boolean enabled) {
            if (this.toolbarPresenter != null) {
                this.toolbarPresenter.setEnabled(enabled);
            }
            super.setEnabled(enabled);
        }

        protected void setSQLExecution(final SQLExecution sqlExecution) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    if (ConnectionContextAwareDelegate.this.toolbarPresenter != null) {
                        ConnectionContextAwareDelegate.this.toolbarPresenter.setSQLExecution(sqlExecution);
                    }
                }
            });
            super.setSQLExecution(sqlExecution);
        }
    }
}

