/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import org.netbeans.core.windows.view.Controller;
import org.netbeans.core.windows.view.ui.MainWindow;
import org.openide.util.NbBundle;

public class EditorAreaFrame
extends JFrame {
    private Component desktop;
    private Controller controller;
    private long frametimestamp = 0L;
    private long timeStamp = 0L;
    private long mainWindowStamp = 0L;

    public EditorAreaFrame() {
        super(NbBundle.getMessage((Class)EditorAreaFrame.class, (String)"LBL_EditorAreaFrameTitle"));
        this.setIconImage(MainWindow.createIDEImage());
    }

    public void setWindowActivationListener(Controller control) {
        this.controller = control;
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent evt) {
                if (EditorAreaFrame.this.frametimestamp != 0L && System.currentTimeMillis() > EditorAreaFrame.this.frametimestamp + 500L) {
                    EditorAreaFrame.this.controller.userActivatedEditorWindow();
                }
            }

            public void windowOpened(WindowEvent event) {
                EditorAreaFrame.this.frametimestamp = System.currentTimeMillis();
            }
        });
    }

    public void toFront() {
        this.frametimestamp = System.currentTimeMillis();
        super.toFront();
    }

    public void setVisible(boolean visible) {
        this.frametimestamp = System.currentTimeMillis();
        super.setVisible(visible);
    }

    public void setDesktop(Component component) {
        if (this.desktop == component) {
            return;
        }
        if (this.desktop != null) {
            this.getContentPane().remove(this.desktop);
        }
        this.desktop = component;
        if (component != null) {
            this.getContentPane().add(component);
        }
    }

    public void setUserStamp(long stamp) {
        this.timeStamp = stamp;
    }

    public long getUserStamp() {
        return this.timeStamp;
    }

    public void setMainWindowStamp(long stamp) {
        this.mainWindowStamp = stamp;
    }

    public long getMainWindowStamp() {
        return this.mainWindowStamp;
    }
}

