/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.spi.project.FileOwnerQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class UpdateTrackingFileOwnerQuery
implements FileOwnerQueryImplementation {
    public Project getOwner(URI file) {
        if (!ModuleList.existKnownEntries()) {
            return null;
        }
        if (file.getScheme().equals("file")) {
            return this.getOwner(new File(file));
        }
        return null;
    }

    public Project getOwner(FileObject file) {
        if (!ModuleList.existKnownEntries()) {
            return null;
        }
        File f = FileUtil.toFile((FileObject)file);
        if (f != null) {
            return this.getOwner(f);
        }
        return null;
    }

    private Project getOwner(File file) {
        Set entries = ModuleList.getKnownEntries(file);
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            FileObject sourcedirFO;
            File sourcedir = ((ModuleEntry)it.next()).getSourceLocation();
            if (sourcedir == null || (sourcedirFO = FileUtil.toFileObject((File)sourcedir)) == null) continue;
            try {
                Project p = ProjectManager.getDefault().findProject(sourcedirFO);
                if (p == null) continue;
                return p;
            }
            catch (IOException e) {
                Util.err.notify(1, (Throwable)e);
            }
        }
        return null;
    }
}

