/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.spi.jaxws.client;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.ClientAlreadyExistsExeption;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelerFactory;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.spi.jaxws.client.JAXWSClientSupportImpl;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public abstract class ProjectJAXWSClientSupport
implements JAXWSClientSupportImpl {
    Project project;
    private FileObject clientArtifactsFolder;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ProjectJAXWSClientSupport(Project project) {
        this.project = project;
    }

    public void removeServiceClient(String serviceName) {
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null && jaxWsModel.removeClient(serviceName)) {
            this.writeJaxWsModel(jaxWsModel);
        }
    }

    public String getWsdlUrl(String serviceName) {
        Client client;
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null && (client = jaxWsModel.findClientByName(serviceName)) != null) {
            return client.getWsdlUrl();
        }
        return null;
    }

    public String addServiceClient(String clientName, String wsdlUrl, String packageName, boolean isJsr109) {
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        String finalClientName = clientName;
        boolean clientAdded = false;
        if (jaxWsModel != null) {
            NotifyDescriptor.Message desc;
            String mes;
            Client client = null;
            finalClientName = this.findProperClientName(clientName, jaxWsModel);
            this.clientArtifactsFolder = this.project.getProjectDirectory().getFileObject("build/generated/wsimport/client");
            if (this.clientArtifactsFolder != null) {
                this.clientArtifactsFolder.getChildren(true);
            }
            FileObject localWsdl = null;
            try {
                localWsdl = WSUtils.retrieveResource((FileObject)this.getLocalWsdlFolderForClient(finalClientName, true), (URI)new URI(wsdlUrl));
            }
            catch (URISyntaxException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                mes = NbBundle.getMessage((Class)ProjectJAXWSClientSupport.class, (String)"ERR_IncorrectURI", (Object)wsdlUrl);
                desc = new NotifyDescriptor.Message((Object)mes, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            }
            catch (UnknownHostException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                mes = NbBundle.getMessage((Class)ProjectJAXWSClientSupport.class, (String)"ERR_UnknownHost", (Object)ex.getMessage());
                desc = new NotifyDescriptor.Message((Object)mes, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                mes = NbBundle.getMessage((Class)ProjectJAXWSClientSupport.class, (String)"ERR_WsdlRetrieverFailure", (Object)wsdlUrl);
                desc = new NotifyDescriptor.Message((Object)mes, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            }
            if (localWsdl != null) {
                Boolean value = jaxWsModel.getJsr109();
                if ((value == null || Boolean.TRUE.equals(value)) && !isJsr109) {
                    jaxWsModel.setJsr109(Boolean.FALSE);
                } else if (Boolean.FALSE.equals(value) && isJsr109) {
                    jaxWsModel.setJsr109(Boolean.TRUE);
                }
                try {
                    client = jaxWsModel.addClient(finalClientName, wsdlUrl, packageName);
                }
                catch (ClientAlreadyExistsExeption ex) {
                    // empty catch block
                }
                FileObject xmlResorcesFo = this.getLocalWsdlFolderForClient(finalClientName, false);
                String localWsdlUrl = FileUtil.getRelativePath((FileObject)xmlResorcesFo, (FileObject)localWsdl);
                client.setLocalWsdlFile(localWsdlUrl);
                FileObject catalog = this.getCatalogFileObject();
                if (catalog != null) {
                    client.setCatalogFile("catalog.xml");
                }
                this.writeJaxWsModel(jaxWsModel);
                clientAdded = true;
                try {
                    final WsdlModeler modeler = WsdlModelerFactory.getDefault().getWsdlModeler(localWsdl.getURL());
                    if (modeler != null) {
                        modeler.setPackageName(packageName);
                        modeler.generateWsdlModel(new WsdlModelListener(){

                            public void modelCreated(WsdlModel model) {
                                if (model == null) {
                                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new WsImportFailedMessage(modeler.getCreationException()));
                                }
                            }
                        });
                    }
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().log(ex.getLocalizedMessage());
                }
            }
            if (clientAdded) {
                if (!isJsr109) {
                    try {
                        this.addJaxWs20Library();
                    }
                    catch (Exception e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
                FileObject buildImplFo = this.project.getProjectDirectory().getFileObject("nbproject/build-impl.xml");
                try {
                    ExecutorTask wsimportTask = ActionUtils.runTarget((FileObject)buildImplFo, (String[])new String[]{"wsimport-client-" + finalClientName}, null);
                    if (wsimportTask.result() == 0) {
                        FileObject clientArtifactsFolder1;
                        if (this.clientArtifactsFolder == null) {
                            this.clientArtifactsFolder = this.project.getProjectDirectory().getFileObject("build/generated/wsimport/client");
                        }
                        if (this.clientArtifactsFolder != null && (clientArtifactsFolder1 = this.clientArtifactsFolder.getFileObject(packageName.replace('.', '/'))) != null) {
                            wsimportTask = ActionUtils.runTarget((FileObject)buildImplFo, (String[])new String[]{"wsimport-client-compile"}, null);
                        }
                    }
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().log(ex.getLocalizedMessage());
                }
                catch (IllegalArgumentException ex) {
                    ErrorManager.getDefault().log(ex.getLocalizedMessage());
                }
                return finalClientName;
            }
        }
        return null;
    }

    private String findProperClientName(String name, JaxWsModel jaxWsModel) {
        String firstName;
        String string = name.length() == 0 ? NbBundle.getMessage((Class)ProjectJAXWSClientSupport.class, (String)"LBL_defaultClientName") : (firstName = name);
        if (jaxWsModel.findClientByName(firstName) == null) {
            return firstName;
        }
        int i = 1;
        String finalName;
        while (jaxWsModel.findClientByName(finalName = firstName + "_" + i) != null) {
            ++i;
        }
        return finalName;
    }

    private void writeJaxWsModel(final JaxWsModel jaxWsModel) {
        try {
            final FileObject jaxWsFo = this.project.getProjectDirectory().getFileObject("nbproject/jax-ws.xml");
            jaxWsFo.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    FileLock lock = null;
                    OutputStream os = null;
                    try {
                        lock = jaxWsFo.lock();
                        os = jaxWsFo.getOutputStream(lock);
                        jaxWsModel.write(os);
                        os.close();
                    }
                    catch (IOException ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                    finally {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
            });
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    public List getServiceClients() {
        ArrayList<Client> jaxWsClients = new ArrayList<Client>();
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null) {
            Client[] clients = jaxWsModel.getClients();
            for (int i = 0; i < clients.length; ++i) {
                jaxWsClients.add(clients[i]);
            }
        }
        return jaxWsClients;
    }

    public FileObject getLocalWsdlFolderForClient(String clientName, boolean createFolder) {
        return this.getArtifactsFolder(clientName, createFolder, true);
    }

    public FileObject getBindingsFolderForClient(String clientName, boolean createFolder) {
        return this.getArtifactsFolder(clientName, createFolder, false);
    }

    private FileObject getArtifactsFolder(String clientName, boolean createFolder, boolean forWsdl) {
        String folderName = forWsdl ? "wsdl" : "bindings";
        FileObject root = this.getXmlArtifactsRoot();
        if (!$assertionsDisabled && root == null) {
            throw new AssertionError();
        }
        FileObject wsdlLocalFolder = root.getFileObject("xml-resources/web-service-references/" + clientName + "/" + folderName);
        if (wsdlLocalFolder == null && createFolder) {
            try {
                FileObject serviceLocalFolder;
                FileObject servicesLocalFolder;
                FileObject xmlLocalFolder = root.getFileObject("xml-resources");
                if (xmlLocalFolder == null) {
                    xmlLocalFolder = root.createFolder("xml-resources");
                }
                if ((servicesLocalFolder = xmlLocalFolder.getFileObject("web-service-references")) == null) {
                    servicesLocalFolder = xmlLocalFolder.createFolder("web-service-references");
                }
                if ((serviceLocalFolder = servicesLocalFolder.getFileObject(clientName)) == null) {
                    serviceLocalFolder = servicesLocalFolder.createFolder(clientName);
                }
                if ((wsdlLocalFolder = serviceLocalFolder.getFileObject(folderName)) == null) {
                    wsdlLocalFolder = serviceLocalFolder.createFolder(folderName);
                }
            }
            catch (IOException ex) {
                return null;
            }
        }
        return wsdlLocalFolder;
    }

    protected FileObject getXmlArtifactsRoot() {
        return this.project.getProjectDirectory();
    }

    private FileObject getCatalogFileObject() {
        return this.project.getProjectDirectory().getFileObject("catalog.xml");
    }

    public URL getCatalog() {
        try {
            FileObject catalog = this.getCatalogFileObject();
            return catalog == null ? null : catalog.getURL();
        }
        catch (FileStateInvalidException ex) {
            return null;
        }
    }

    protected abstract void addJaxWs20Library() throws Exception;

    public abstract FileObject getWsdlFolder(boolean var1) throws IOException;

    public String getServiceRefName(Node clientNode) {
        WsdlService service = (WsdlService)clientNode.getLookup().lookup(WsdlService.class);
        String serviceName = service.getName();
        return "service/" + serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject getWsdlFolderForClient(String name) throws IOException {
        FileObject clientWsdlFolder;
        FileObject globalWsdlFolder = this.getWsdlFolder(true);
        FileObject oldWsdlFolder = globalWsdlFolder.getFileObject("client/" + name);
        if (oldWsdlFolder != null) {
            FileLock lock = oldWsdlFolder.lock();
            try {
                oldWsdlFolder.delete(lock);
            }
            finally {
                lock.releaseLock();
            }
        }
        if ((clientWsdlFolder = globalWsdlFolder.getFileObject("client")) == null) {
            clientWsdlFolder = globalWsdlFolder.createFolder("client");
        }
        return clientWsdlFolder.createFolder(name);
    }

    static {
        $assertionsDisabled = !ProjectJAXWSClientSupport.class.desiredAssertionStatus();
    }

    private class WsImportFailedMessage
    extends NotifyDescriptor.Message {
        public WsImportFailedMessage(Throwable ex) {
            super((Object)NbBundle.getMessage((Class)(class$org$netbeans$modules$websvc$spi$jaxws$client$ProjectJAXWSClientSupport == null ? (class$org$netbeans$modules$websvc$spi$jaxws$client$ProjectJAXWSClientSupport = ProjectJAXWSClientSupport.class$("org.netbeans.modules.websvc.spi.jaxws.client.ProjectJAXWSClientSupport")) : class$org$netbeans$modules$websvc$spi$jaxws$client$ProjectJAXWSClientSupport), (String)"TXT_CannotGenerateClient", (Object)ex.getLocalizedMessage()), 0);
        }
    }
}

