/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.remoting.impl;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ResourceBundle;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shale.remoting.impl.AbstractResourceProcessor;

public class WebResourceProcessor
extends AbstractResourceProcessor {
    private ResourceBundle bundle = ResourceBundle.getBundle("org.apache.shale.remoting.Bundle");
    private transient Log log = null;

    protected URL getResourceURL(FacesContext context, String resourceId) {
        String resourceIdUpper = resourceId.toUpperCase();
        if (resourceIdUpper.startsWith("/WEB-INF") || resourceIdUpper.startsWith("/META-INF")) {
            if (this.log().isWarnEnabled()) {
                this.log().warn((Object)this.bundle.getString("resource.refuse"));
                this.log().warn((Object)resourceId);
            }
            return null;
        }
        if (resourceIdUpper.endsWith(".JSP") || resourceIdUpper.endsWith(".JSPF")) {
            if (this.log().isWarnEnabled()) {
                this.log().warn((Object)this.bundle.getString("resource.refuse"));
                this.log().warn((Object)resourceId);
            }
            return null;
        }
        Object ctxt = context.getExternalContext().getContext();
        try {
            Method method = ctxt.getClass().getMethod("getResource", String.class);
            URL url = (URL)method.invoke(ctxt, resourceId);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("getResource(" + resourceId + ") --> " + url));
            }
            return url;
        }
        catch (Exception e) {
            if (this.log().isErrorEnabled()) {
                this.log().error((Object)this.bundle.getString("resource.exception"), (Throwable)e);
                this.log().error((Object)resourceId);
            }
            return null;
        }
    }

    private Log log() {
        if (this.log == null) {
            this.log = LogFactory.getLog((Class)WebResourceProcessor.class);
        }
        return this.log;
    }
}

