/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WsClientUpToDate
extends Task {
    private String _property;
    private String _value;
    private File _sourceWsdlFile;
    private File _sourceConfigFile;
    private File _targetGenDir;
    private File _targetConfigFile;
    private String _targetPackage;

    public void setProperty(String property) {
        this._property = property;
    }

    public void setValue(String value) {
        this._value = value;
    }

    private String getValue() {
        return this._value != null ? this._value : "false";
    }

    public void setSourceWsdl(File file) {
        this._sourceWsdlFile = file;
    }

    public void setSourceConfig(File file) {
        this._sourceConfigFile = file;
    }

    public void setTargetDir(File file) {
        this._targetGenDir = file;
    }

    public void setTargetConfig(File file) {
        this._targetConfigFile = file;
    }

    public void setTargetPackage(String targetPackage) {
        this._targetPackage = targetPackage;
    }

    public boolean eval() {
        File targetClientDir;
        if (!this._sourceWsdlFile.exists()) {
            throw new BuildException(this._sourceWsdlFile.getAbsolutePath() + " not found.");
        }
        if (this._sourceConfigFile == null) {
            String cfgNameExt = this.getBaseName(this._sourceWsdlFile) + "-config.xml";
            this._sourceConfigFile = new File(this._sourceWsdlFile.getParentFile(), cfgNameExt);
        }
        if (!this._sourceConfigFile.exists()) {
            throw new BuildException(this._sourceConfigFile.getAbsolutePath() + " not found.");
        }
        if (!this._targetGenDir.exists()) {
            this.log("The target generation directory \"" + this._targetGenDir.getAbsolutePath() + "\" does not exist.", 3);
            return false;
        }
        if (!this._targetGenDir.isDirectory()) {
            throw new BuildException("property targetdir must be a directory.");
        }
        if (this._targetConfigFile == null) {
            this._targetConfigFile = new File(this._targetGenDir, "wsdl" + File.separator + this._sourceConfigFile.getName());
        }
        if (!this._targetConfigFile.exists()) {
            this.log("The target config file \"" + this._targetConfigFile.getAbsolutePath() + "\" does not exist.", 3);
            return false;
        }
        if (this._targetConfigFile.lastModified() < this._sourceConfigFile.lastModified()) {
            this.log("Config file \"" + this._sourceConfigFile.getAbsolutePath() + " is out of date.", 3);
            return false;
        }
        if (this._targetPackage == null) {
            this._targetPackage = this.getClientPackage(this._sourceConfigFile);
        }
        if (!(targetClientDir = new File(this._targetGenDir, this.convertPackage(this._targetPackage))).exists()) {
            this.log("The target client source directory \"" + targetClientDir.getAbsolutePath() + "\" does not exist.", 3);
            return false;
        }
        if (!targetClientDir.isDirectory()) {
            this.log("The target client source directory \"" + targetClientDir.getAbsolutePath() + "\" should be a directory.", 3);
            return false;
        }
        List clientSources = this.getClientSources(targetClientDir, this._sourceWsdlFile);
        boolean uptodate = clientSources.size() > 0;
        Iterator iter = clientSources.iterator();
        while (uptodate && iter.hasNext()) {
            File target = (File)iter.next();
            if (!target.exists()) {
                this.log("Expected target client file \"" + target.getAbsolutePath() + "\" not found.", 3);
                uptodate = false;
                continue;
            }
            uptodate = uptodate && target.lastModified() >= this._sourceWsdlFile.lastModified();
        }
        return uptodate;
    }

    public void execute() throws BuildException {
        if (this._property == null) {
            throw new BuildException("property attribute is required.", this.getLocation());
        }
        if (this._sourceWsdlFile == null) {
            throw new BuildException("sourcewsdl attribute is required.", this.getLocation());
        }
        if (this._targetGenDir == null) {
            throw new BuildException("targetdir attribute is required.", this.getLocation());
        }
        boolean upToDate = this.eval();
        if (upToDate) {
            this.getProject().setNewProperty(this._property, this.getValue());
            this.log("Generated client for " + this._sourceWsdlFile.getAbsolutePath() + " is up-to-date.", 3);
        }
    }

    protected String getBaseName(File f) {
        String name = f.getName();
        int i = name.lastIndexOf(46);
        if (i > -1) {
            name = name.substring(0, i);
        }
        return name;
    }

    protected String convertPackage(String p) {
        StringBuffer path = new StringBuffer(p.length());
        String[] dirs = p.split("\\.");
        for (int i = 0; i < dirs.length; ++i) {
            if (i > 0) {
                path.append(File.separator);
            }
            path.append(dirs[i]);
        }
        return path.toString();
    }

    protected List getClientSources(File clientDir, File wsdlFile) {
        ArrayList<File> result = new ArrayList<File>();
        List serviceNames = this.getServiceNames(wsdlFile);
        for (String sn : serviceNames) {
            result.add(new File(clientDir, sn + ".java"));
        }
        return result;
    }

    protected String getClientPackage(File configFile) {
        String result = "";
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser saxParser = factory.newSAXParser();
            ConfigParser handler = new ConfigParser();
            saxParser.parse(configFile, (DefaultHandler)handler);
            result = handler.getPackageName();
        }
        catch (ParserConfigurationException ex) {
        }
        catch (SAXException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private List getServiceNames(File wsdlFile) {
        List result = Collections.EMPTY_LIST;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser saxParser = factory.newSAXParser();
            WsdlParser handler = new WsdlParser();
            saxParser.parse(wsdlFile, (DefaultHandler)handler);
            result = handler.getServiceNameList();
        }
        catch (ParserConfigurationException ex) {
        }
        catch (SAXException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private static final class ConfigParser
    extends DefaultHandler {
        private String packageName = null;

        private ConfigParser() {
        }

        public void startElement(String uri, String localname, String qname, Attributes attributes) throws SAXException {
            String elementName = localname;
            if ("".equals(elementName)) {
                elementName = qname;
            }
            if ("wsdl".equals(elementName)) {
                this.packageName = attributes.getValue("packageName");
            }
        }

        public String getPackageName() {
            return this.packageName;
        }
    }

    private static final class WsdlParser
    extends DefaultHandler {
        private static final String W3C_WSDL_SCHEMA = "http://schemas.xmlsoap.org/wsdl";
        private static final String W3C_WSDL_SCHEMA_SLASH = "http://schemas.xmlsoap.org/wsdl/";
        private ArrayList serviceNameList = new ArrayList();

        private WsdlParser() {
        }

        public void startElement(String uri, String localname, String qname, Attributes attributes) throws SAXException {
            if ((W3C_WSDL_SCHEMA.equals(uri) || W3C_WSDL_SCHEMA_SLASH.equals(uri)) && "service".equals(localname)) {
                this.serviceNameList.add(attributes.getValue("name"));
            }
        }

        public List getServiceNameList() {
            return this.serviceNameList;
        }
    }
}

