/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.Lines;
import org.netbeans.core.output2.OutWriter;
import org.openide.ErrorManager;
import org.openide.util.Mutex;

class OutputDocument
implements Document,
Element,
ChangeListener,
ActionListener,
Runnable {
    private List dlisteners = new ArrayList();
    private volatile Timer timer = null;
    private OutWriter writer;
    private char[] reusableSubrange = new char[256];
    private volatile DO lastEvent = null;
    private int lastPostedLine = -1;
    private int lastFiredLine = -1;
    private boolean updatingTimerState = false;
    private long lastFireTime = 0L;
    static /* synthetic */ Class class$org$netbeans$core$output2$OutputDocument;

    OutputDocument(OutWriter writer) {
        if (Controller.log) {
            Controller.log("Creating a Document for " + writer);
        }
        this.writer = writer;
        this.getLines().addChangeListener(this);
    }

    public void dispose() {
        if (Controller.log) {
            Controller.log("Disposing document and backing storage for " + this.getLines().readLock());
        }
        this.disposeQuietly();
        this.writer.dispose();
        this.writer = null;
    }

    public void disposeQuietly() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        this.dlisteners.clear();
        this.lastEvent = null;
        this.getLines().removeChangeListener(this);
    }

    public synchronized void addDocumentListener(DocumentListener documentListener) {
        this.dlisteners.add(documentListener);
        this.lastEvent = null;
    }

    public void addUndoableEditListener(UndoableEditListener l) {
    }

    public Position createPosition(int offset) throws BadLocationException {
        if (offset < 0 || offset > this.getLines().getCharCount()) {
            throw new BadLocationException("Bad position", offset);
        }
        return new ODPosition(offset);
    }

    public Element getDefaultRootElement() {
        return this;
    }

    public Position getEndPosition() {
        return new ODEndPosition();
    }

    public int getLength() {
        return this.getLines().getCharCount();
    }

    public Object getProperty(Object obj) {
        return null;
    }

    public Element[] getRootElements() {
        return new Element[]{this};
    }

    public Position getStartPosition() {
        return new ODStartPosition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(int offset, int length) throws BadLocationException {
        String result1;
        if (offset < 0 || offset > this.getLines().getCharCount() || length < 0) {
            throw new BadLocationException("Bad: " + offset + "," + length, offset);
        }
        if (length == 0) {
            return "";
        }
        Object object = this.getLines().readLock();
        synchronized (object) {
            result1 = this.getLines().getText(offset, offset + length);
        }
        String result = result1;
        return result;
    }

    public void getText(int offset, int length, Segment txt) throws BadLocationException {
        if (length < 0) {
            txt.array = new char[0];
            txt.offset = 0;
            txt.count = 0;
            return;
        }
        if (offset < 0) {
            throw new BadLocationException("Negative offset", offset);
        }
        if (this.getLines().getLineCount() == 0) {
            txt.array = new char[]{'\n'};
            txt.offset = 0;
            txt.count = 1;
            return;
        }
        if (length > this.reusableSubrange.length) {
            this.reusableSubrange = new char[length];
        }
        try {
            char[] chars = this.getLines().getText(offset, offset + length, this.reusableSubrange);
            txt.array = chars;
            txt.offset = 0;
            txt.count = Math.min(length, chars.length);
        }
        catch (OutOfMemoryError error) {
            OutWriter.lowDiskSpace = true;
            this.writer.dispose();
            ErrorManager.getDefault().log(1, "OOME while reading output.  Cleaning up.");
            ErrorManager.getDefault().notify(1, (Throwable)error);
        }
    }

    public void insertString(int param, String str, AttributeSet attributeSet) throws BadLocationException {
        throw new UnsupportedOperationException();
    }

    public void putProperty(Object obj, Object obj1) {
    }

    public void remove(int param, int param1) throws BadLocationException {
        throw new UnsupportedOperationException("Read only buffer");
    }

    public synchronized void removeDocumentListener(DocumentListener documentListener) {
        this.dlisteners.remove(documentListener);
        this.lastEvent = null;
        if (this.dlisteners.isEmpty() && this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    public Lines getLines() {
        return this.writer != null ? this.writer.getLines() : null;
    }

    public int getLineStart(int line) {
        return this.getLines().getLineCount() > 0 ? this.getLines().getLineStart(line) : 0;
    }

    public int getLineEnd(int lineIndex) {
        if (this.getLines().getLineCount() == 0) {
            return 0;
        }
        int endOffset = lineIndex >= this.getLines().getLineCount() - 1 ? this.getLines().getCharCount() : this.getLines().getLineStart(lineIndex + 1);
        return endOffset;
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
    }

    public void render(Runnable runnable) {
        this.getElementCount();
        runnable.run();
    }

    public AttributeSet getAttributes() {
        return SimpleAttributeSet.EMPTY;
    }

    public Document getDocument() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getElement(int index) {
        if (this.getLines().getLineCount() == 0) {
            return new EmptyElement(this);
        }
        Object object = this.getLines().readLock();
        synchronized (object) {
            if (index > this.lastPostedLine) {
                this.lastPostedLine = index;
            }
        }
        return new ODElement(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getElementCount() {
        int result;
        Object object = this.getLines().readLock();
        synchronized (object) {
            this.lastPostedLine = result = this.getLines().getLineCount();
        }
        if (result == 0) {
            result = 1;
        }
        return result;
    }

    public int getElementIndex(int offset) {
        return this.getLines().getLineAt(offset);
    }

    public int getEndOffset() {
        return this.getLength();
    }

    public String getName() {
        return "foo";
    }

    public Element getParentElement() {
        return null;
    }

    public int getStartOffset() {
        return 0;
    }

    public boolean isLeaf() {
        return this.getLines().getLineCount() == 0;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (Controller.verbose) {
            Controller.log(changeEvent != null ? "Document got change event from writer" : "Document timer polling");
        }
        if (this.dlisteners.isEmpty()) {
            if (Controller.verbose) {
                Controller.log("listeners empty, not firing");
            }
            return;
        }
        if (this.getLines().checkDirty(true)) {
            int lineCount;
            if (this.lastEvent != null && !this.lastEvent.isConsumed()) {
                if (Controller.verbose) {
                    Controller.log("Last event not consumed, not firing");
                }
                return;
            }
            boolean noPostedLine = this.lastPostedLine == -1;
            this.lastPostedLine = lineCount = this.getLines().getLineCount();
            if (Controller.verbose) {
                Controller.log("Document may fire event - last fired getLine=" + this.lastFiredLine + " getLine count now " + lineCount);
            }
            if (this.lastFiredLine != this.lastPostedLine || noPostedLine) {
                this.lastEvent = new DO(Math.max(0, this.lastFiredLine), noPostedLine);
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        if (Controller.verbose) {
                            Controller.log("Firing document event on EQ with start index " + OutputDocument.this.lastEvent.start);
                        }
                        OutputDocument.this.fireDocumentEvent(OutputDocument.this.lastEvent);
                    }
                });
                this.lastFiredLine = this.lastPostedLine;
            } else if (Controller.verbose) {
                Controller.log("Line count is still " + lineCount + " - not firing");
            }
        } else if (Controller.verbose) {
            Controller.log("Writer says it is not dirty, firing no change");
        }
        this.updateTimerState();
    }

    private synchronized void updateTimerState() {
        if (this.updatingTimerState) {
            return;
        }
        this.updatingTimerState = true;
        long newTime = System.currentTimeMillis();
        if (this.timer == null && this.getLines().isGrowing()) {
            if (Controller.log) {
                Controller.log("Starting timer");
            }
            this.timer = new Timer(50, this);
            this.timer.setRepeats(true);
            this.timer.start();
        } else if (!this.getLines().isGrowing()) {
            if (this.timer != null) {
                this.timer.stop();
            }
            if (this.getLines().checkDirty(false) && this.timer != null) {
                Mutex.EVENT.readAccess((Runnable)this);
            }
            this.timer = null;
        } else if (this.lastFireTime != 0L && this.timer != null && newTime - this.lastFireTime > 15000L) {
            this.timer.setDelay(10000);
        }
        if (this.timer != null && this.timer.getDelay() < 350) {
            this.timer.setDelay(this.timer.getDelay() + 20);
            if (Controller.verbose) {
                Controller.log("Decreased timer interval to " + this.timer.getDelay());
            }
        }
        this.lastFireTime = newTime;
        this.updatingTimerState = false;
    }

    public void run() {
        this.stateChanged(null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.getLines().isGrowing()) {
            this.updateTimerState();
        }
        this.stateChanged(null);
    }

    private void fireDocumentEvent(DocumentEvent de) {
        Iterator i = new ArrayList(this.dlisteners).iterator();
        while (i.hasNext()) {
            DocumentListener dl = (DocumentListener)i.next();
            dl.insertUpdate(de);
        }
    }

    public String toString() {
        return "OD@" + System.identityHashCode(this) + " for " + this.getLines().readLock();
    }

    private class DO
    implements DocumentEvent,
    DocumentEvent.ElementChange {
        private int start;
        private int offset = -1;
        private int length = -1;
        private int lineCount = -1;
        private boolean consumed = false;
        private boolean initial = false;
        private int first = -1;
        static final /* synthetic */ boolean $assertionsDisabled;

        DO(int start, boolean initial) {
            this.start = start;
            this.initial = initial;
            if (start < 0) {
                throw new IllegalArgumentException("Illogical start: " + start);
            }
        }

        private void calc() {
            if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                throw new AssertionError((Object)"Should be accessed from AWT only or we have a synchronization problem");
            }
            if (!this.consumed) {
                this.consumed = true;
                if (Controller.verbose) {
                    Controller.log("EVENT CONSUMED: " + this.start);
                }
                int charsWritten = OutputDocument.this.getLines().getCharCount();
                if (this.initial) {
                    this.first = 0;
                    this.offset = 0;
                    this.lineCount = OutputDocument.this.getLines().getLineCount();
                    this.length = charsWritten;
                } else {
                    this.first = this.start;
                    if (this.first == OutputDocument.this.getLines().getLineCount()) {
                        throw new IllegalStateException("Out of bounds");
                    }
                    this.offset = OutputDocument.this.getLines().getLineStart(this.first);
                    this.lineCount = OutputDocument.this.getLines().getLineCount() - this.first;
                    this.length = charsWritten - this.offset;
                }
            }
        }

        public boolean isConsumed() {
            return this.consumed;
        }

        public String toString() {
            boolean wasConsumed = this.isConsumed();
            this.calc();
            return "Event: start=" + this.start + " first=" + this.first + " linecount=" + this.lineCount + " offset=" + this.offset + " length=" + this.length + " consumed=" + wasConsumed;
        }

        public DocumentEvent.ElementChange getChange(Element element) {
            if (element == OutputDocument.this) {
                return this;
            }
            return null;
        }

        public Document getDocument() {
            return OutputDocument.this;
        }

        public int getLength() {
            this.calc();
            return this.length;
        }

        public int getOffset() {
            this.calc();
            return this.offset;
        }

        public DocumentEvent.EventType getType() {
            return this.start == 0 ? DocumentEvent.EventType.CHANGE : DocumentEvent.EventType.INSERT;
        }

        public Element[] getChildrenAdded() {
            this.calc();
            Element[] e = new Element[this.lineCount];
            if (e.length == 0) {
                return new Element[]{new EmptyElement(OutputDocument.this)};
            }
            for (int i = 0; i < this.lineCount; ++i) {
                e[i] = new ODElement(this.first + i);
                if (this.first + i < OutputDocument.this.getLines().getLineCount()) continue;
                throw new IllegalStateException("UGH!!!");
            }
            return e;
        }

        public Element[] getChildrenRemoved() {
            if (this.start == 0) {
                return new Element[]{new EmptyElement(OutputDocument.this)};
            }
            return new Element[0];
        }

        public Element getElement() {
            return OutputDocument.this;
        }

        public int getIndex() {
            this.calc();
            return this.start;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$core$output2$OutputDocument == null ? (class$org$netbeans$core$output2$OutputDocument = OutputDocument.class$("org.netbeans.core.output2.OutputDocument")) : class$org$netbeans$core$output2$OutputDocument).desiredAssertionStatus();
        }
    }

    private static class EmptyElement
    implements Element {
        private final OutputDocument doc;

        EmptyElement(OutputDocument doc) {
            this.doc = doc;
        }

        public AttributeSet getAttributes() {
            return SimpleAttributeSet.EMPTY;
        }

        public Document getDocument() {
            return this.doc;
        }

        public Element getElement(int param) {
            return null;
        }

        public int getElementCount() {
            return 0;
        }

        public int getElementIndex(int param) {
            return 0;
        }

        public int getEndOffset() {
            return 0;
        }

        public String getName() {
            return "empty";
        }

        public Element getParentElement() {
            return this.doc;
        }

        public int getStartOffset() {
            return 0;
        }

        public boolean isLeaf() {
            return true;
        }
    }

    final class ODElement
    implements Element {
        private int lineIndex;
        private int startOffset = -1;
        private int endOffset = -1;
        static final /* synthetic */ boolean $assertionsDisabled;

        ODElement(int lineIndex) {
            this.lineIndex = lineIndex;
        }

        public int hashCode() {
            return this.lineIndex;
        }

        public boolean equals(Object o) {
            return o instanceof ODElement && ((ODElement)o).lineIndex == this.lineIndex && ((ODElement)o).getDocument() == this.getDocument();
        }

        public AttributeSet getAttributes() {
            return SimpleAttributeSet.EMPTY;
        }

        public Document getDocument() {
            return OutputDocument.this;
        }

        public Element getElement(int param) {
            return null;
        }

        public int getElementCount() {
            return 0;
        }

        public int getElementIndex(int param) {
            return -1;
        }

        public int getEndOffset() {
            this.calc();
            return this.endOffset;
        }

        public String getName() {
            return null;
        }

        public Element getParentElement() {
            return OutputDocument.this;
        }

        public int getStartOffset() {
            this.calc();
            return this.startOffset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void calc() {
            Object object = OutputDocument.this.getLines().readLock();
            synchronized (object) {
                if (this.startOffset == -1) {
                    this.startOffset = OutputDocument.this.getLines().getLineCount() > 0 ? OutputDocument.this.getLines().getLineStart(this.lineIndex) : 0;
                    this.endOffset = this.lineIndex >= OutputDocument.this.getLines().getLineCount() - 1 ? OutputDocument.this.getLines().getCharCount() : OutputDocument.this.getLines().getLineStart(this.lineIndex + 1);
                    if (!$assertionsDisabled && this.endOffset < this.getStartOffset()) {
                        throw new AssertionError((Object)("Illogical getLine #" + this.lineIndex + " with lines " + OutputDocument.this.getLines() + " or writer has been reset"));
                    }
                }
            }
        }

        public boolean isLeaf() {
            return true;
        }

        public String toString() {
            try {
                return OutputDocument.this.getText(this.getStartOffset(), this.getEndOffset() - this.getStartOffset());
            }
            catch (BadLocationException ble) {
                ErrorManager.getDefault().notify((Throwable)ble);
                return "";
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$core$output2$OutputDocument == null ? (class$org$netbeans$core$output2$OutputDocument = OutputDocument.class$("org.netbeans.core.output2.OutputDocument")) : class$org$netbeans$core$output2$OutputDocument).desiredAssertionStatus();
        }
    }

    final class ODStartPosition
    implements Position {
        ODStartPosition() {
        }

        public int getOffset() {
            return 0;
        }

        private Document doc() {
            return OutputDocument.this;
        }

        public boolean equals(Object o) {
            return o instanceof ODStartPosition && ((ODStartPosition)o).doc() == this.doc();
        }

        public int hashCode() {
            return 2190481;
        }
    }

    final class ODEndPosition
    implements Position {
        ODEndPosition() {
        }

        public int getOffset() {
            int result = OutputDocument.this.getLines().getCharCount();
            return result;
        }

        private Document doc() {
            return OutputDocument.this;
        }

        public boolean equals(Object o) {
            return o instanceof ODEndPosition && ((ODEndPosition)o).doc() == this.doc();
        }

        public int hashCode() {
            return -2390481;
        }
    }

    static final class ODPosition
    implements Position {
        private int offset;

        ODPosition(int offset) {
            this.offset = offset;
        }

        public int getOffset() {
            return this.offset;
        }

        public int hashCode() {
            return this.offset * 11;
        }

        public boolean equals(Object o) {
            return o instanceof ODPosition && ((ODPosition)o).getOffset() == this.offset;
        }
    }
}

